/* # site_url: http://ferme-de-chassagne.local */;
/* # home_url: http://ferme-de-chassagne.local */;
/* # content_url: http://ferme-de-chassagne.local/wp-content */;
/* # upload_url: http://ferme-de-chassagne.local/wp-content/uploads */;
/* # table_prefix: wp_ */;


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `wp_cky_cookies`
--

DROP TABLE IF EXISTS `wp_cky_cookies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_cky_cookies` (
  `cookie_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `duration` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `category` bigint(20) NOT NULL,
  `type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `discovered` int(11) NOT NULL DEFAULT '0',
  `url_pattern` varchar(190) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`cookie_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_cky_cookies`
--

LOCK TABLES `wp_cky_cookies` WRITE;
/*!40000 ALTER TABLE `wp_cky_cookies` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_cky_cookies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_e_events`
--

DROP TABLE IF EXISTS `wp_e_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_e_events`
--

LOCK TABLES `wp_e_events` WRITE;
/*!40000 ALTER TABLE `wp_e_events` DISABLE KEYS */;
INSERT INTO `wp_e_events` VALUES (1,'{"event":"modal load","version":"","details":"{\\"placement\\":\\"Onboarding wizard\\",\\"step\\":\\"account\\",\\"user_state\\":\\"anon\\"}","ts":"2024-06-09T13:34:16.759-02:00"}','2024-06-09 13:34:17');
/*!40000 ALTER TABLE `wp_e_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_cky_cookie_categories`
--

DROP TABLE IF EXISTS `wp_cky_cookie_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_cky_cookie_categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `prior_consent` int(11) NOT NULL DEFAULT '0',
  `visibility` int(11) NOT NULL DEFAULT '1',
  `priority` int(11) NOT NULL DEFAULT '0',
  `sell_personal_data` int(11) NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_cky_cookie_categories`
--

LOCK TABLES `wp_cky_cookie_categories` WRITE;
/*!40000 ALTER TABLE `wp_cky_cookie_categories` DISABLE KEYS */;
INSERT INTO `wp_cky_cookie_categories` VALUES (1,'{"en":"Necessary"}','necessary','{"en":"<p>Necessary cookies are required to enable the basic features of this site, such as providing secure log-in or adjusting your consent preferences. These cookies do not store any personally identifiable data.<\\/p>"}',1,1,0,1,'[]','0000-00-00 00:00:00','2024-06-24 21:54:44');
INSERT INTO `wp_cky_cookie_categories` VALUES (2,'{"en":"Functional"}','functional','{"en":"<p>Functional cookies help perform certain functionalities like sharing the content of the website on social media platforms, collecting feedback, and other third-party features.<\\/p>"}',0,1,0,1,'[]','0000-00-00 00:00:00','2024-06-24 21:54:44');
INSERT INTO `wp_cky_cookie_categories` VALUES (3,'{"en":"Analytics"}','analytics','{"en":"<p>Analytical cookies are used to understand how visitors interact with the website. These cookies help provide information on metrics such as the number of visitors, bounce rate, traffic source, etc.<\\/p>"}',0,1,0,1,'[]','0000-00-00 00:00:00','2024-06-24 21:54:44');
INSERT INTO `wp_cky_cookie_categories` VALUES (4,'{"en":"Performance"}','performance','{"en":"<p>Performance cookies are used to understand and analyze the key performance indexes of the website which helps in delivering a better user experience for the visitors.<\\/p>"}',0,1,0,1,'[]','0000-00-00 00:00:00','2024-06-24 21:54:44');
INSERT INTO `wp_cky_cookie_categories` VALUES (5,'{"en":"Advertisement"}','advertisement','{"en":"<p>Advertisement cookies are used to provide visitors with customized advertisements based on the pages you visited previously and to analyze the effectiveness of the ad campaigns.<\\/p>"}',0,1,0,1,'[]','0000-00-00 00:00:00','2024-06-24 21:54:44');
/*!40000 ALTER TABLE `wp_cky_cookie_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_links`
--

DROP TABLE IF EXISTS `wp_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_links`
--

LOCK TABLES `wp_links` WRITE;
/*!40000 ALTER TABLE `wp_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_term_relationships`
--

DROP TABLE IF EXISTS `wp_term_relationships`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_term_relationships`
--

LOCK TABLES `wp_term_relationships` WRITE;
/*!40000 ALTER TABLE `wp_term_relationships` DISABLE KEYS */;
INSERT INTO `wp_term_relationships` VALUES (1,1,0);
INSERT INTO `wp_term_relationships` VALUES (21,2,0);
INSERT INTO `wp_term_relationships` VALUES (22,2,0);
INSERT INTO `wp_term_relationships` VALUES (23,2,0);
INSERT INTO `wp_term_relationships` VALUES (24,2,0);
INSERT INTO `wp_term_relationships` VALUES (25,2,0);
INSERT INTO `wp_term_relationships` VALUES (26,2,0);
INSERT INTO `wp_term_relationships` VALUES (27,2,0);
INSERT INTO `wp_term_relationships` VALUES (40,2,0);
INSERT INTO `wp_term_relationships` VALUES (41,2,0);
/*!40000 ALTER TABLE `wp_term_relationships` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_yoast_migrations`
--

DROP TABLE IF EXISTS `wp_yoast_migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_yoast_migrations`
--

LOCK TABLES `wp_yoast_migrations` WRITE;
/*!40000 ALTER TABLE `wp_yoast_migrations` DISABLE KEYS */;
INSERT INTO `wp_yoast_migrations` VALUES (1,'20171228151840');
INSERT INTO `wp_yoast_migrations` VALUES (2,'20171228151841');
INSERT INTO `wp_yoast_migrations` VALUES (3,'20190529075038');
INSERT INTO `wp_yoast_migrations` VALUES (4,'20191011111109');
INSERT INTO `wp_yoast_migrations` VALUES (5,'20200408101900');
INSERT INTO `wp_yoast_migrations` VALUES (6,'20200420073606');
INSERT INTO `wp_yoast_migrations` VALUES (7,'20200428123747');
INSERT INTO `wp_yoast_migrations` VALUES (8,'20200428194858');
INSERT INTO `wp_yoast_migrations` VALUES (9,'20200429105310');
INSERT INTO `wp_yoast_migrations` VALUES (10,'20200430075614');
INSERT INTO `wp_yoast_migrations` VALUES (11,'20200430150130');
INSERT INTO `wp_yoast_migrations` VALUES (12,'20200507054848');
INSERT INTO `wp_yoast_migrations` VALUES (13,'20200513133401');
INSERT INTO `wp_yoast_migrations` VALUES (14,'20200609154515');
INSERT INTO `wp_yoast_migrations` VALUES (15,'20200616130143');
INSERT INTO `wp_yoast_migrations` VALUES (16,'20200617122511');
INSERT INTO `wp_yoast_migrations` VALUES (17,'20200702141921');
INSERT INTO `wp_yoast_migrations` VALUES (18,'20200728095334');
INSERT INTO `wp_yoast_migrations` VALUES (19,'20201202144329');
INSERT INTO `wp_yoast_migrations` VALUES (20,'20201216124002');
INSERT INTO `wp_yoast_migrations` VALUES (21,'20201216141134');
INSERT INTO `wp_yoast_migrations` VALUES (22,'20210817092415');
INSERT INTO `wp_yoast_migrations` VALUES (23,'20211020091404');
INSERT INTO `wp_yoast_migrations` VALUES (24,'20230417083836');
/*!40000 ALTER TABLE `wp_yoast_migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_cky_banners`
--

DROP TABLE IF EXISTS `wp_cky_banners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_cky_banners` (
  `banner_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT '0',
  `settings` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `banner_default` int(11) NOT NULL DEFAULT '0',
  `contents` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`banner_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_cky_banners`
--

LOCK TABLES `wp_cky_banners` WRITE;
/*!40000 ALTER TABLE `wp_cky_banners` DISABLE KEYS */;
INSERT INTO `wp_cky_banners` VALUES (1,'GDPR','gdpr-1',1,'{"settings":{"id":"banner-1","type":"box","preferenceCenterType":"popup","position":"bottom-left","versionID":"6.0.0","applicableLaw":"gdpr","languages":{"default":"en","selected":["en"]},"templateGroup":"default","customHtml":{"status":false},"theme":"light","consentExpiry":{"status":true,"value":"365"},"ruleSet":[{"code":"ALL","regions":[]}]},"behaviours":{"reloadBannerOnAccept":{"status":false},"loadAnalyticsByDefault":{"status":false},"animations":{"onLoad":"animate","onHide":"sticky"},"legacyFunctions":{"accept":{"action":"acceptClose","newTab":false},"reject":{"action":"rejectClose","newTab":false},"idle":{"action":"acceptClose","delay":"1000"},"navigation":{"action":"acceptClose"},"pageScroll":{"action":"acceptClose"}},"respectGPC":{"status":false}},"config":{"notice":{"status":true,"tag":"notice","type":"container","styles":{"background-color":"#FFFFFF","border-color":"#f4f4f4"},"elements":{"title":{"type":"text","tag":"title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"description","status":true,"styles":{"color":"#212121"}},"brandLogo":{"status":false,"tag":"brand-logo","meta":{"url":"#"}},"buttons":{"status":true,"tag":"notice-buttons","type":"container","elements":{"accept":{"status":true,"tag":"accept-button","type":"button","styles":{"color":"#FFFFFF","background-color":"#1863DC","border-color":"#1863DC"}},"reject":{"status":true,"tag":"reject-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}},"settings":{"status":true,"tag":"settings-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}},"readMore":{"status":false,"tag":"readmore-button","type":"link","meta":{"noFollow":true,"newTab":true},"styles":{"color":"#1863DC","background-color":"transparent","border-color":"transparent"}},"donotSell":{"status":false,"tag":"donotsell-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"transparent"}}}},"closeButton":{"status":false,"tag":"close-button"}}},"categoryPreview":{"status":false,"type":"container","tag":"detail-category-preview","elements":{"title":{"type":"text","tag":"detail-category-preview-title","status":true,"styles":{"color":"#212121"}},"toggle":{"status":true,"tag":"detail-category-preview-toggle","type":"toggle","states":{"active":{"styles":{"background-color":"#1863DC"}},"inactive":{"styles":{"background-color":"#D0D5D2"}}}},"buttons":{"status":true,"tag":"detail-category-preview-buttons","elements":{"save":{"status":true,"tag":"detail-category-preview-save-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}}}}}},"preferenceCenter":{"status":true,"tag":"detail","type":"container","styles":{"color":"#212121","background-color":"#FFFFFF","border-color":"#f4f4f4"},"elements":{"title":{"type":"text","tag":"detail-title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"detail-description","status":true,"styles":{"color":"#212121"}},"closeButton":{"status":true,"type":"button","tag":"detail-close"},"categories":{"status":true,"tag":"detail-categories","type":"container","elements":{"title":{"type":"text","tag":"detail-category-title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"detail-category-description","status":true,"styles":{"color":"#212121"}},"toggle":{"status":true,"tag":"detail-category-toggle","type":"toggle","states":{"active":{"styles":{"background-color":"#1863DC"}},"inactive":{"styles":{"background-color":"#D0D5D2"}}}}}},"buttons":{"status":true,"tag":"detail-buttons","type":"container","elements":{"accept":{"status":true,"tag":"detail-accept-button","type":"button","styles":{"color":"#FFFFFF","background-color":"#1863DC","border-color":"#1863DC"}},"reject":{"status":true,"tag":"detail-reject-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}},"save":{"status":true,"tag":"detail-save-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}}}},"poweredBy":{"status":true,"tag":"detail-powered-by","styles":{"background-color":"#EDEDED","color":"#293C5B"}}}},"optoutPopup":{"status":false,"tag":"optout-popup","type":"container","styles":{"color":"#212121","background-color":"#FFFFFF","border-color":"#F4F4F4"},"elements":{"title":{"type":"text","tag":"optout-title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"optout-description","status":true,"styles":{"color":"#212121"}},"optOption":{"status":true,"tag":"optout-option","type":"container","elements":{"toggle":{"status":true,"tag":"optout-option-toggle","type":"toggle","states":{"active":{"styles":{"background-color":"#1863dc"}},"inactive":{"styles":{"background-color":"#FFFFFF"}}}},"title":{"type":"text","tag":"optout-option-title","status":true,"styles":{"color":"#212121"}}}},"gpcOption":{"type":"container","tag":"optout-gpc-option","status":false,"elements":{"description":{"type":"text","tag":"optout-gpc-option-description","status":true,"styles":{"color":"#212121"}}}},"poweredBy":{"status":true,"tag":"optout-powered-by","styles":{"background-color":"#EDEDED","color":"#293C5B"}},"buttons":{"status":true,"tag":"optout-buttons","type":"container","elements":{"confirm":{"status":true,"tag":"optout-confirm-button","type":"button","styles":{"color":"#f4f4f4","background-color":"#1863dc","border-color":"#1863dc"}},"cancel":{"status":true,"tag":"optout-cancel-button","type":"button","styles":{"color":"#858585","background-color":"#FFFFFF","border-color":"#dedfe0"}}}},"closeButton":{"status":true,"tag":"optout-close","type":"button"}}},"auditTable":{"status":true,"tag":"audit-table","type":"table","meta":{"headers":["id","duration","description"]},"styles":{"color":"#212121","background-color":"#f4f4f4","border-color":"#ebebeb"}},"revisitConsent":{"status":true,"tag":"revisit-consent","position":"bottom-left","meta":{"url":"#"},"styles":{"background-color":"#0056A7"},"elements":{"title":{"type":"text","tag":"revisit-consent-title","status":true,"styles":{"color":"#0056a7"}}}},"videoPlaceholder":{"status":true,"tag":"video-placeholder","styles":{"background-color":"#000000","border-color":"#000000"},"elements":{"title":{"type":"text","tag":"placeholder-title","status":true,"styles":{"color":"#ffffff"}}}}},"meta":{"customCSS":"","customHTML":""}}',1,'{"en":{"notice":{"elements":{"title":"We value your privacy","description":"<p>We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking \\"Accept All\\", you consent to our use of cookies.<\\/p>","privacyLink":"","buttons":{"elements":{"accept":"Accept All","reject":"Reject All","settings":"Customize","readMore":"Cookie Policy","donotSell":"Do Not Sell or Share My Personal Information"}},"closeButton":"Close"}},"categoryPreview":{"elements":{"buttons":{"elements":{"save":"Save My Preferences"}}}},"preferenceCenter":{"elements":{"title":"Customize Consent Preferences","description":"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.<\\/p><p>The cookies that are categorized as \\"Necessary\\" are stored on your browser as they are essential for enabling the basic functionalities of the site. <\\/p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.<\\/p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.<\\/p>","showMore":"Show more","showLess":"Show less","category":{"elements":{"alwaysEnabled":"Always Active","enable":"Enable","disable":"Disable"}},"buttons":{"elements":{"accept":"Accept All","save":"Save My Preferences","reject":"Reject All"}},"closeButton":"Close"}},"optoutPopup":{"elements":{"title":"Opt-out Preferences","description":"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \\"Do Not Sell or Share My Personal Information\\" and clicking the \\"Save My Preferences\\" button. Once you opt out, you can opt in again at any time by unchecking \\"Do Not Sell or Share My Personal Information\\" and clicking the \\"Save My Preferences\\" button.<\\/p>","optOption":{"elements":{"title":"Do Not Sell or Share My Personal Information","enable":"Enable","disable":"Disable"}},"gpcOption":{"elements":{"description":"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control<\\/b> signal from your browser and, therefore, you cannot change this setting.<\\/p>"}},"showLess":"Show less","showMore":"Show more","buttons":{"elements":{"cancel":"Cancel","confirm":"Save My Preferences"}},"closeButton":"Close"}},"revisitConsent":{"elements":{"title":"Consent Preferences"}},"auditTable":{"elements":{"headers":{"elements":{"id":"Cookie","duration":"Duration","description":"Description"}},"message":"No cookies to display."}},"videoPlaceholder":{"elements":{"title":"Please accept cookies to access this content"}}}}','2024-06-24 21:54:44','2024-06-24 21:54:44');
INSERT INTO `wp_cky_banners` VALUES (2,'CCPA','ccpa-2',0,'{"settings":{"id":"banner-1","type":"box","preferenceCenterType":"popup","position":"bottom-left","versionID":"6.0.0","applicableLaw":"ccpa","languages":{"default":"en","selected":["en"]},"templateGroup":"default","customHtml":{"status":false},"theme":"light","consentExpiry":{"status":true,"value":"365"},"ruleSet":[{"code":"ALL","regions":[]}]},"behaviours":{"reloadBannerOnAccept":{"status":false},"loadAnalyticsByDefault":{"status":false},"animations":{"onLoad":"animate","onHide":"sticky"},"legacyFunctions":{"accept":{"action":"acceptClose","newTab":false},"reject":{"action":"rejectClose","newTab":false},"idle":{"action":"acceptClose","delay":"1000"},"navigation":{"action":"acceptClose"},"pageScroll":{"action":"acceptClose"}},"respectGPC":{"status":false}},"config":{"notice":{"status":true,"tag":"notice","type":"container","styles":{"background-color":"#FFFFFF","border-color":"#f4f4f4"},"elements":{"title":{"type":"text","tag":"title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"description","status":true,"styles":{"color":"#212121"}},"brandLogo":{"status":false,"tag":"brand-logo","meta":{"url":"#"}},"buttons":{"status":true,"tag":"notice-buttons","type":"container","elements":{"accept":{"status":false,"tag":"accept-button","type":"button","styles":{"color":"#FFFFFF","background-color":"#1863DC","border-color":"#1863DC"}},"reject":{"status":false,"tag":"reject-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}},"settings":{"status":false,"tag":"settings-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}},"readMore":{"status":false,"tag":"readmore-button","type":"link","meta":{"noFollow":true,"newTab":true},"styles":{"color":"#1863DC","background-color":"transparent","border-color":"transparent"}},"donotSell":{"status":true,"tag":"donotsell-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"transparent"}}}},"closeButton":{"status":true,"tag":"close-button"}}},"categoryPreview":{"status":false,"type":"container","tag":"detail-category-preview","elements":{"title":{"type":"text","tag":"detail-category-preview-title","status":true,"styles":{"color":"#212121"}},"toggle":{"status":true,"tag":"detail-category-preview-toggle","type":"toggle","states":{"active":{"styles":{"background-color":"#1863DC"}},"inactive":{"styles":{"background-color":"#D0D5D2"}}}},"buttons":{"status":true,"tag":"detail-category-preview-buttons","elements":{"save":{"status":true,"tag":"detail-category-preview-save-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}}}}}},"preferenceCenter":{"status":false,"tag":"detail","type":"container","styles":{"color":"#212121","background-color":"#FFFFFF","border-color":"#f4f4f4"},"elements":{"title":{"type":"text","tag":"detail-title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"detail-description","status":true,"styles":{"color":"#212121"}},"closeButton":{"status":true,"type":"button","tag":"detail-close"},"categories":{"status":true,"tag":"detail-categories","type":"container","elements":{"title":{"type":"text","tag":"detail-category-title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"detail-category-description","status":true,"styles":{"color":"#212121"}},"toggle":{"status":true,"tag":"detail-category-toggle","type":"toggle","states":{"active":{"styles":{"background-color":"#1863DC"}},"inactive":{"styles":{"background-color":"#D0D5D2"}}}}}},"buttons":{"status":true,"tag":"detail-buttons","type":"container","elements":{"accept":{"status":true,"tag":"detail-accept-button","type":"button","styles":{"color":"#FFFFFF","background-color":"#1863DC","border-color":"#1863DC"}},"reject":{"status":true,"tag":"detail-reject-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}},"save":{"status":true,"tag":"detail-save-button","type":"button","styles":{"color":"#1863DC","background-color":"transparent","border-color":"#1863DC"}}}},"poweredBy":{"status":true,"tag":"detail-powered-by","styles":{"background-color":"#EDEDED","color":"#293C5B"}}}},"optoutPopup":{"status":true,"tag":"optout-popup","type":"container","styles":{"color":"#212121","background-color":"#FFFFFF","border-color":"#F4F4F4"},"elements":{"title":{"type":"text","tag":"optout-title","status":true,"styles":{"color":"#212121"}},"description":{"type":"text","tag":"optout-description","status":true,"styles":{"color":"#212121"}},"optOption":{"status":true,"tag":"optout-option","type":"container","elements":{"toggle":{"status":true,"tag":"optout-option-toggle","type":"toggle","states":{"active":{"styles":{"background-color":"#1863dc"}},"inactive":{"styles":{"background-color":"#FFFFFF"}}}},"title":{"type":"text","tag":"optout-option-title","status":true,"styles":{"color":"#212121"}}}},"gpcOption":{"type":"container","tag":"optout-gpc-option","status":false,"elements":{"description":{"type":"text","tag":"optout-gpc-option-description","status":true,"styles":{"color":"#212121"}}}},"poweredBy":{"status":true,"tag":"optout-powered-by","styles":{"background-color":"#EDEDED","color":"#293C5B"}},"buttons":{"status":true,"tag":"optout-buttons","type":"container","elements":{"confirm":{"status":true,"tag":"optout-confirm-button","type":"button","styles":{"color":"#f4f4f4","background-color":"#1863dc","border-color":"#1863dc"}},"cancel":{"status":true,"tag":"optout-cancel-button","type":"button","styles":{"color":"#858585","background-color":"#FFFFFF","border-color":"#dedfe0"}}}},"closeButton":{"status":true,"tag":"optout-close","type":"button"}}},"auditTable":{"status":false,"tag":"audit-table","type":"table","meta":{"headers":["id","duration","description"]},"styles":{"color":"#212121","background-color":"#f4f4f4","border-color":"#ebebeb"}},"revisitConsent":{"status":true,"tag":"revisit-consent","position":"bottom-left","meta":{"url":"#"},"styles":{"background-color":"#0056A7"},"elements":{"title":{"type":"text","tag":"revisit-consent-title","status":true,"styles":{"color":"#0056a7"}}}},"videoPlaceholder":{"status":true,"tag":"video-placeholder","styles":{"background-color":"#000000","border-color":"#000000"},"elements":{"title":{"type":"text","tag":"placeholder-title","status":true,"styles":{"color":"#ffffff"}}}}},"meta":{"customCSS":"","customHTML":""}}',0,'{"en":{"notice":{"elements":{"title":"We value your privacy","description":"<p>This website or its third-party tools process personal data. You can opt out of the sale of your personal information by clicking on the \\"Do Not Sell or Share My Personal Information\\" link.<\\/p>","privacyLink":"","buttons":{"elements":{"accept":"Accept All","reject":"Reject All","settings":"Customize","readMore":"Cookie Policy","donotSell":"Do Not Sell or Share My Personal Information"}},"closeButton":"Close"}},"categoryPreview":{"elements":{"buttons":{"elements":{"save":"Save My Preferences"}}}},"preferenceCenter":{"elements":{"title":"Customize Consent Preferences","description":"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.<\\/p><p>The cookies that are categorized as \\"Necessary\\" are stored on your browser as they are essential for enabling the basic functionalities of the site. <\\/p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.<\\/p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.<\\/p>","showMore":"Show more","showLess":"Show less","category":{"elements":{"alwaysEnabled":"Always Active","enable":"Enable","disable":"Disable"}},"buttons":{"elements":{"accept":"Accept All","save":"Save My Preferences","reject":"Reject All"}},"closeButton":"Close"}},"optoutPopup":{"elements":{"title":"Opt-out Preferences","description":"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \\"Do Not Sell or Share My Personal Information\\" and clicking the \\"Save My Preferences\\" button. Once you opt out, you can opt in again at any time by unchecking \\"Do Not Sell or Share My Personal Information\\" and clicking the \\"Save My Preferences\\" button.<\\/p>","optOption":{"elements":{"title":"Do Not Sell or Share My Personal Information","enable":"Enable","disable":"Disable"}},"gpcOption":{"elements":{"description":"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control<\\/b> signal from your browser and, therefore, you cannot change this setting.<\\/p>"}},"showLess":"Show less","showMore":"Show more","buttons":{"elements":{"cancel":"Cancel","confirm":"Save My Preferences"}},"closeButton":"Close"}},"revisitConsent":{"elements":{"title":"Consent Preferences"}},"auditTable":{"elements":{"headers":{"elements":{"id":"Cookie","duration":"Duration","description":"Description"}},"message":"No cookies to display."}},"videoPlaceholder":{"elements":{"title":"Please accept cookies to access this content"}}}}','2024-06-24 21:54:44','2024-06-24 21:54:44');
/*!40000 ALTER TABLE `wp_cky_banners` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_commentmeta`
--

DROP TABLE IF EXISTS `wp_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_commentmeta`
--

LOCK TABLES `wp_commentmeta` WRITE;
/*!40000 ALTER TABLE `wp_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_term_taxonomy`
--

DROP TABLE IF EXISTS `wp_term_taxonomy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_term_taxonomy`
--

LOCK TABLES `wp_term_taxonomy` WRITE;
/*!40000 ALTER TABLE `wp_term_taxonomy` DISABLE KEYS */;
INSERT INTO `wp_term_taxonomy` VALUES (1,1,'category','',0,1);
INSERT INTO `wp_term_taxonomy` VALUES (2,2,'nav_menu','',0,9);
/*!40000 ALTER TABLE `wp_term_taxonomy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_termmeta`
--

DROP TABLE IF EXISTS `wp_termmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_termmeta`
--

LOCK TABLES `wp_termmeta` WRITE;
/*!40000 ALTER TABLE `wp_termmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_termmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_terms`
--

DROP TABLE IF EXISTS `wp_terms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_terms`
--

LOCK TABLES `wp_terms` WRITE;
/*!40000 ALTER TABLE `wp_terms` DISABLE KEYS */;
INSERT INTO `wp_terms` VALUES (1,'Uncategorized','uncategorized',0);
INSERT INTO `wp_terms` VALUES (2,'Ferme de Chassagne','ferme-de-chassagne',0);
/*!40000 ALTER TABLE `wp_terms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_usermeta`
--

DROP TABLE IF EXISTS `wp_usermeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_usermeta`
--

LOCK TABLES `wp_usermeta` WRITE;
/*!40000 ALTER TABLE `wp_usermeta` DISABLE KEYS */;
INSERT INTO `wp_usermeta` VALUES (1,1,'nickname','Fermedechassagnemathias');
INSERT INTO `wp_usermeta` VALUES (2,1,'first_name','');
INSERT INTO `wp_usermeta` VALUES (3,1,'last_name','');
INSERT INTO `wp_usermeta` VALUES (4,1,'description','');
INSERT INTO `wp_usermeta` VALUES (5,1,'rich_editing','true');
INSERT INTO `wp_usermeta` VALUES (6,1,'syntax_highlighting','true');
INSERT INTO `wp_usermeta` VALUES (7,1,'comment_shortcuts','false');
INSERT INTO `wp_usermeta` VALUES (8,1,'admin_color','fresh');
INSERT INTO `wp_usermeta` VALUES (9,1,'use_ssl','0');
INSERT INTO `wp_usermeta` VALUES (10,1,'show_admin_bar_front','true');
INSERT INTO `wp_usermeta` VALUES (11,1,'locale','');
INSERT INTO `wp_usermeta` VALUES (12,1,'wp_capabilities','a:1:{s:13:"administrator";b:1;}');
INSERT INTO `wp_usermeta` VALUES (13,1,'wp_user_level','10');
INSERT INTO `wp_usermeta` VALUES (14,1,'dismissed_wp_pointers','');
INSERT INTO `wp_usermeta` VALUES (15,1,'show_welcome_panel','1');
INSERT INTO `wp_usermeta` VALUES (16,1,'session_tokens','a:1:{s:64:"78d461bf346064cc2728efcbb2fae982b7ebb50512cc5f89df55bc042c92edf7";a:4:{s:10:"expiration";i:1724318466;s:2:"ip";s:9:"127.0.0.1";s:2:"ua";s:80:"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:129.0) Gecko/20100101 Firefox/129.0";s:5:"login";i:1724145666;}}');
INSERT INTO `wp_usermeta` VALUES (17,1,'wp_dashboard_quick_press_last_post_id','891');
INSERT INTO `wp_usermeta` VALUES (18,1,'wp_persisted_preferences','a:4:{s:14:"core/edit-post";a:2:{s:26:"isComplementaryAreaVisible";b:1;s:12:"welcomeGuide";b:0;}s:9:"_modified";s:24:"2024-06-24T21:56:03.871Z";s:22:"core/customize-widgets";a:1:{s:12:"welcomeGuide";b:0;}s:4:"core";a:1:{s:10:"openPanels";a:2:{i:0;s:11:"post-status";i:1;s:24:"yoast-seo/document-panel";}}}');
INSERT INTO `wp_usermeta` VALUES (19,1,'managenav-menuscolumnshidden','a:5:{i:0;s:11:"link-target";i:1;s:11:"css-classes";i:2;s:3:"xfn";i:3;s:11:"description";i:4;s:15:"title-attribute";}');
INSERT INTO `wp_usermeta` VALUES (20,1,'metaboxhidden_nav-menus','a:3:{i:0;s:28:"add-post-type-e-landing-page";i:1;s:12:"add-post_tag";i:2;s:15:"add-post_format";}');
INSERT INTO `wp_usermeta` VALUES (21,1,'elementor_admin_notices','a:1:{s:20:"design_not_appearing";a:2:{s:9:"is_viewed";b:0;s:4:"meta";a:1:{s:7:"version";s:6:"3.23.4";}}}');
INSERT INTO `wp_usermeta` VALUES (22,1,'nav_menu_recently_edited','2');
INSERT INTO `wp_usermeta` VALUES (23,1,'elementor_introduction','a:6:{s:27:"ai-get-started-announcement";b:1;s:16:"favorites-notice";b:1;s:20:"globals_introduction";b:1;s:7:"exit_to";b:1;s:18:"yoast-introduction";b:1;s:36:"ai_promotion_introduction_media-edit";b:1;}');
INSERT INTO `wp_usermeta` VALUES (24,1,'wp_user-settings','libraryContent=browse&editor=tinymce');
INSERT INTO `wp_usermeta` VALUES (25,1,'wp_user-settings-time','1721312256');
INSERT INTO `wp_usermeta` VALUES (26,1,'elementor_dismissed_editor_notices','a:1:{i:0;s:20:"image_optimizer_hint";}');
INSERT INTO `wp_usermeta` VALUES (27,1,'header-footer-elementor-rating','delayed-notice');
INSERT INTO `wp_usermeta` VALUES (28,1,'bsf-optin-notice','notice-dismissed');
INSERT INTO `wp_usermeta` VALUES (29,1,'community-events-location','a:1:{s:2:"ip";s:9:"127.0.0.0";}');
/*!40000 ALTER TABLE `wp_usermeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_yoast_primary_term`
--

DROP TABLE IF EXISTS `wp_yoast_primary_term`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_yoast_primary_term`
--

LOCK TABLES `wp_yoast_primary_term` WRITE;
/*!40000 ALTER TABLE `wp_yoast_primary_term` DISABLE KEYS */;
/*!40000 ALTER TABLE `wp_yoast_primary_term` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_yoast_seo_links`
--

DROP TABLE IF EXISTS `wp_yoast_seo_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=271 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_yoast_seo_links`
--

LOCK TABLES `wp_yoast_seo_links` WRITE;
/*!40000 ALTER TABLE `wp_yoast_seo_links` DISABLE KEYS */;
INSERT INTO `wp_yoast_seo_links` VALUES (32,'http://ferme-de-chassagne.local/notre-ferme/',7,9,'internal',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (33,'http://ferme-de-chassagne.local/ou-nous-retrouver/',7,17,'internal',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (34,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Design_sans_titre_16_-removebg-preview-qpvw6cbkv7o8hasft1ic4sbh3b9g52ldiwbwokgfrw.png',7,NULL,'image-in',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (35,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Triage-e1718793888943.jpg',7,75,'image-in',4,NULL,581,1024,141294,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (36,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-2-1-e1718797760866.png',7,100,'image-in',4,NULL,428,1920,7100,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (37,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre21.png',7,111,'image-in',4,NULL,1080,1080,2086941,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (38,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre22.png',7,112,'image-in',4,NULL,1080,1080,2556731,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (39,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-2-e1718797670381.png',7,83,'image-in',4,NULL,454,1920,6502,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (40,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/3.png',7,132,'image-in',4,NULL,1080,1080,59180,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (41,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/4.png',7,133,'image-in',4,NULL,1080,1080,44141,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (42,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/5.png',7,134,'image-in',4,NULL,1080,1080,68513,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (43,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/6.png',7,135,'image-in',4,NULL,1080,1080,56463,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (44,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/7.png',7,136,'image-in',4,NULL,1080,1080,45635,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (45,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/8.png',7,137,'image-in',4,NULL,1080,1080,65339,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (46,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/9.png',7,138,'image-in',4,NULL,1080,1080,68219,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (47,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/10.png',7,139,'image-in',4,NULL,1080,1080,66953,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (48,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Camping-a-la-ferme_Villefagnan-scaled-qpwc1ywu5qampwa2mo915lj0lmsicw4clwtrzmvkrw.jpg',7,NULL,'image-in',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (49,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Copie-de-camping010908_petanque3-scaled-qpwc21qcq8ehoq5z67gwv2tedselzzfjmas8fgre98.jpg',7,NULL,'image-in',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (50,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/SCN3384-scaled-qpwc1v5hee5hfgfj8mmivmh683b1i3pf9e7u2j15gs.jpg',7,NULL,'image-in',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (51,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Copie-de-SCN4500-scaled-qpwc25hphkjmz60ik93f51v8rbw2urugyte6ckltkc.jpg',7,NULL,'image-in',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (52,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Copie-de-SCN4497-1-scaled-qq552vijsdpaqyeb9yqhvl9ypi16eokcejsvsguj8s.jpg',7,NULL,'image-in',4,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (53,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/right_11042702.png',7,165,'image-in',4,NULL,512,512,8947,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (63,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Copie-de-SCN4497-scaled-e1718983382212.jpg',9,184,'image-in',5,NULL,861,2560,483553,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (64,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping5-Photoroom-1024x576.png',9,523,'image-in',5,NULL,720,1280,37878,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (65,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-331-e1718987078163.png',9,509,'image-in',5,NULL,649,480,9592,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (66,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/8-2.png',9,508,'image-in',5,NULL,1080,1080,1895369,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (67,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/4-2-1024x1024.png',9,514,'image-in',5,NULL,1080,1080,1417150,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (68,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-33.png',9,516,'image-in',5,NULL,595,476,16272,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (69,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/6-2-1024x1024.png',9,513,'image-in',5,NULL,1080,1080,1875775,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (70,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/9-1-1024x1024.png',9,521,'image-in',5,NULL,1080,1080,1853836,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (71,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/5-2-1024x1024.png',9,522,'image-in',5,NULL,1080,1080,1297996,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (85,'http://ferme-de-chassagne.local/tarifs/',13,36,'internal',6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (86,'http://ferme-de-chassagne.local/nous-contacter/',13,38,'internal',6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (87,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13_edited.png',13,317,'image-in',6,NULL,568,922,75289,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (88,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13-1024x576.png',13,318,'image-in',6,NULL,1080,1920,52136,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (89,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-21-e1718902304938.png',13,362,'image-in',6,NULL,135,1080,2125,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (90,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre24.png',13,309,'image-in',6,NULL,1080,1080,60295,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (91,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre25.png',13,310,'image-in',6,NULL,1080,1080,73117,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (92,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre26.png',13,311,'image-in',6,NULL,1080,1080,59620,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (93,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-2-2-e1718899991158.png',13,364,'image-in',6,NULL,151,1080,2153,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (94,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping6.png',13,527,'image-in',6,NULL,1080,1920,3236079,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (95,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/2017-07-07-1-qpy4t4iorkedjhl3xpo7hh7nqtzzx0ltnhyez2s0lc.jpg',13,NULL,'image-in',6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (96,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Copie-de-SCN3383-scaled-qpy4st8mhjyxo61hrksonk24m7jlcnd1ly4lj03kz0.jpg',13,NULL,'image-in',6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (97,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/sanitetcuis2_avril-2006-1-qpy5jhvoi8hz9na3y41eftn7q00pvbapy0utzsj8bw.jpg',13,NULL,'image-in',6,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (105,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre32-1-e1719233922436.png',17,545,'image-in',7,NULL,761,1920,2837779,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (106,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping5-Photoroom-1024x576.png',17,523,'image-in',7,NULL,720,1280,37878,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (107,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Ajouter-un-titre.png',17,554,'image-in',7,NULL,800,1920,2299566,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (108,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Ajouter-un-titre1.png',17,553,'image-in',7,NULL,800,1920,3317056,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (109,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Ajouter-un-titre3.png',17,552,'image-in',7,NULL,800,1920,3433557,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (110,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Ajouter-un-titre4.png',17,551,'image-in',7,NULL,800,1920,1729872,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (111,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Ajouter-un-titre5.png',17,550,'image-in',7,NULL,800,1920,3112331,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (114,'http://ferme-de-chassagne.local/nous-contacter/',36,38,'internal',8,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (117,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/v881-mynt-99-removebg-preview.png',38,569,'image-in',9,NULL,500,500,75313,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (148,'http://ferme-de-chassagne.local/tarifs/',19,NULL,'internal',11,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (149,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13_edited.png',19,317,'image-in',11,NULL,568,922,75289,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (150,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13-1024x576.png',19,318,'image-in',11,NULL,1080,1920,52136,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (151,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-21-e1718902304938.png',19,362,'image-in',11,NULL,135,1080,2125,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (152,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre29.png',19,433,'image-in',11,NULL,1080,1080,69095,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (153,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre28.png',19,434,'image-in',11,NULL,1080,1080,52819,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (154,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre31.png',19,431,'image-in',11,NULL,1080,1080,51418,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (155,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre30.png',19,432,'image-in',11,NULL,1080,1080,49404,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (156,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-2-1-e1718797760866.png',19,100,'image-in',11,NULL,428,1920,7100,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (157,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/18.png',19,439,'image-in',11,NULL,1080,1080,1871090,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (158,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/19.png',19,440,'image-in',11,NULL,1080,1080,1872627,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (159,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/21.png',19,442,'image-in',11,NULL,1080,1080,2187042,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (160,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/20.png',19,441,'image-in',11,NULL,1080,1080,1634455,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (161,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/22.png',19,443,'image-in',11,NULL,1080,1080,2343750,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (162,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/23.png',19,444,'image-in',11,NULL,1080,1080,2484659,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (163,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/24.png',19,445,'image-in',11,NULL,1080,1080,2030403,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (164,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/25.png',19,446,'image-in',11,NULL,1080,1080,2265133,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (165,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/26.png',19,447,'image-in',11,NULL,1080,1080,2257033,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (166,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/27.png',19,448,'image-in',11,NULL,1080,1080,1666559,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (167,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-2-e1718797670381.png',19,83,'image-in',11,NULL,454,1920,6502,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (171,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping7.png',13,707,'image-in',6,NULL,1920,1080,151013,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (172,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/2.png',17,717,'image-in',7,NULL,1920,1080,2957407,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (173,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/3-1.png',17,718,'image-in',7,NULL,1920,1080,4116123,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (174,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/4-3.png',17,719,'image-in',7,NULL,1920,1080,3827304,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (175,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/5-3.png',17,720,'image-in',7,NULL,1920,1080,2158582,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (176,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/6-3.png',17,721,'image-in',7,NULL,1920,1080,3253681,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (179,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping8.png',36,725,'image-in',8,NULL,1920,1080,3283590,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (181,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Gite-du-Puits-Web-1.jpg',7,734,'image-in',4,NULL,510,680,189422,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (192,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Mezzanine-Web-3.jpg',19,751,'image-in',11,NULL,510,680,87423,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (195,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;.&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&hellip;&he',36,478,'image-in',8,NULL,1783,1920,5598648,NULL,NULL);
INSERT INTO `wp_yoast_seo_links` VALUES (197,'mailto:contact@campingdechassagne.fr',38,NULL,'external',9,NULL,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `wp_yoast_seo_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_users`
--

DROP TABLE IF EXISTS `wp_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_users`
--

LOCK TABLES `wp_users` WRITE;
/*!40000 ALTER TABLE `wp_users` DISABLE KEYS */;
INSERT INTO `wp_users` VALUES (1,'Fermedechassagnemathias','$P$BrESn5sx3HYSBJqdvLXTiZe3Ne9tst1','fermedechassagnemathias','dev-email@wpengine.local','http://ferme-de-chassagne.local','2024-06-09 11:20:12','',0,'Fermedechassagnemathias');
/*!40000 ALTER TABLE `wp_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_yoast_indexable_hierarchy`
--

DROP TABLE IF EXISTS `wp_yoast_indexable_hierarchy`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_yoast_indexable_hierarchy`
--

LOCK TABLES `wp_yoast_indexable_hierarchy` WRITE;
/*!40000 ALTER TABLE `wp_yoast_indexable_hierarchy` DISABLE KEYS */;
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES (1,0,0,1);
INSERT INTO `wp_yoast_indexable_hierarchy` VALUES (2,0,0,1);
/*!40000 ALTER TABLE `wp_yoast_indexable_hierarchy` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_comments`
--

DROP TABLE IF EXISTS `wp_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_comments`
--

LOCK TABLES `wp_comments` WRITE;
/*!40000 ALTER TABLE `wp_comments` DISABLE KEYS */;
INSERT INTO `wp_comments` VALUES (1,1,'A WordPress Commenter','wapuu@wordpress.example','https://wordpress.org/','','2024-06-09 11:20:12','2024-06-09 11:20:12','Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href="https://en.gravatar.com/">Gravatar</a>.',0,'1','','comment',0,0);
/*!40000 ALTER TABLE `wp_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_yoast_indexable`
--

DROP TABLE IF EXISTS `wp_yoast_indexable`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_yoast_indexable`
--

LOCK TABLES `wp_yoast_indexable` WRITE;
/*!40000 ALTER TABLE `wp_yoast_indexable` DISABLE KEYS */;
INSERT INTO `wp_yoast_indexable` VALUES (1,'http://ferme-de-chassagne.local/author/fermedechassagnemathias/','63:80fc56c6c6dd48ee9721333316fb0fef',1,'user',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,'https://1.gravatar.com/avatar/729ae85bf62b9917e93538db2f2688ca?s=500&d=mm&r=g',NULL,NULL,'gravatar-image',NULL,NULL,'https://1.gravatar.com/avatar/729ae85bf62b9917e93538db2f2688ca?s=500&d=mm&r=g',NULL,'gravatar-image',NULL,NULL,NULL,NULL,'2024-06-24 21:56:04','2024-06-28 09:19:15',1,NULL,NULL,NULL,NULL,0,NULL,2,'2024-06-28 09:19:15','2024-06-09 11:20:12',NULL);
INSERT INTO `wp_yoast_indexable` VALUES (2,'http://ferme-de-chassagne.local/mentions-legales-camping-de-chassagne/','70:bd02e3810ea1d34fb546c257e7b61334',627,'post','page',1,0,'%%title%% - Camping de Chassagne','Découvrez les mentions légales du Camping de Chassagne. Consultez tous les détails importants pour votre séjour dans la nature','Mentions légales','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,30,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,NULL,'2024-06-24 21:56:32','2024-06-28 09:19:15',1,NULL,NULL,NULL,NULL,0,2,2,'2024-06-28 09:19:15','2024-06-24 21:56:32',0);
INSERT INTO `wp_yoast_indexable` VALUES (4,NULL,NULL,7,'post','page',1,0,'Accueil - Camping de Chassagne','Découvrez le camping de Chassagne, un endroit paisible en pleine nature. Profitez de nos grands emplacements pour des vacances mémorables en famille ou entre amis','Accueil','publish',NULL,0,NULL,NULL,NULL,'Camping de Chassagne',56,90,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Design_sans_titre_16_-removebg-preview-qpvw6cbkv7o8hasft1ic4sbh3b9g52ldiwbwokgfrw.png',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/elementor/thumbs/Design_sans_titre_16_-removebg-preview-qpvw6cbkv7o8hasft1ic4sbh3b9g52ldiwbwokgfrw.png',NULL,'first-content-image',NULL,2,NULL,NULL,'2024-06-24 22:40:22','2024-06-26 11:16:42',1,NULL,NULL,NULL,NULL,0,7,0,'2024-06-25 13:33:44','2024-06-09 11:34:50',0);
INSERT INTO `wp_yoast_indexable` VALUES (5,NULL,NULL,9,'post','page',1,0,'Activités - A la ferme','Découvrez les activités à la ferme du Camping de Chassagne : explorez notre marché local, rejoignez l\'atelier boulangerie, amusez-vous avec les mini-jeux, détendez-vous à la piscine et participez à la moisson.','À la ferme','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,60,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Copie-de-SCN4497-scaled-e1718983382212.jpg',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Copie-de-SCN4497-scaled-e1718983382212.jpg',NULL,'first-content-image',NULL,0,NULL,NULL,'2024-06-24 22:43:57','2024-06-26 11:16:42',1,NULL,NULL,NULL,NULL,0,6,0,'2024-06-25 13:26:11','2024-06-09 11:35:41',0);
INSERT INTO `wp_yoast_indexable` VALUES (6,NULL,NULL,13,'post','page',1,0,NULL,'Venez camper au Camping de Chassagne ! Installez votre tente ou caravane sur nos emplacements spacieux, profitez de la piscine et partagez des moments conviviaux autour d\'un apéro. Réservez dès maintenant !','Camping','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,90,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13_edited.png',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13_edited.png',NULL,'first-content-image',NULL,2,NULL,NULL,'2024-06-24 22:45:30','2024-06-26 11:16:42',1,NULL,NULL,NULL,NULL,0,4,0,'2024-06-25 13:43:02','2024-06-09 11:36:03',0);
INSERT INTO `wp_yoast_indexable` VALUES (7,NULL,NULL,17,'post','page',1,0,'Activités dans le coin - Camping de Chassagne','Découvrez les activités près du Camping de Chassagne : visitez un moulin, faites du canoë-kayak et profitez d\'une balade à vélo.','Dans le coin','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre32-1-e1719233922436.png',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Design-sans-titre32-1-e1719233922436.png',NULL,'first-content-image',NULL,0,NULL,NULL,'2024-06-24 22:55:26','2024-06-26 11:16:42',1,NULL,NULL,NULL,NULL,0,4,0,'2024-06-25 11:14:35','2024-06-09 11:36:57',0);
INSERT INTO `wp_yoast_indexable` VALUES (8,NULL,NULL,36,'post','page',1,0,'%%title%% %%page%% %%sep%% Camping de Chassagne','Découvrez nos tarifs attractifs pour les emplacements de tentes et caravanes au Camping de Chassagne.','Tarifs','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping8.png',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Les-avantages-de-notre-camping8.png',NULL,'first-content-image',NULL,1,NULL,NULL,'2024-06-24 22:58:30','2024-06-26 11:16:42',1,NULL,NULL,NULL,NULL,0,1,0,'2024-06-25 12:59:16','2024-06-19 07:44:01',0);
INSERT INTO `wp_yoast_indexable` VALUES (9,NULL,NULL,38,'post','page',1,0,'%%title%% %%page%% %%sep%% Camping de Chassagne','Découvrez comment nous contacter et trouvez notre adresse au Camping de Chassagne. Préparez votre séjour dans notre cadre naturel.','Nous contacter','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,90,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/v881-mynt-99-removebg-preview.png',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/v881-mynt-99-removebg-preview.png',NULL,'first-content-image',NULL,0,NULL,NULL,'2024-06-24 23:00:32','2024-06-26 11:16:42',1,NULL,NULL,NULL,NULL,0,1,0,'2024-06-25 13:50:32','2024-06-19 07:44:13',0);
INSERT INTO `wp_yoast_indexable` VALUES (11,'http://ferme-de-chassagne.local/contact/','40:d053db72231004d2c84a674b943fe0a0',19,'post','page',1,0,NULL,NULL,'Gîtes','publish',NULL,0,NULL,NULL,NULL,NULL,NULL,90,0,NULL,0,NULL,NULL,NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13_edited.png',NULL,NULL,'first-content-image',NULL,NULL,'http://ferme-de-chassagne.local/wp-content/uploads/2024/06/Camping-13_edited.png',NULL,'first-content-image',NULL,1,NULL,NULL,'2024-06-25 00:08:37','2024-06-27 14:24:18',1,NULL,NULL,NULL,NULL,0,8,2,'2024-06-27 14:24:18','2024-06-09 11:37:51',0);
/*!40000 ALTER TABLE `wp_yoast_indexable` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wp_options`
--

DROP TABLE IF EXISTS `wp_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1496 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wp_options`
--

LOCK TABLES `wp_options` WRITE;
/*!40000 ALTER TABLE `wp_options` DISABLE KEYS */;
INSERT INTO `wp_options` VALUES (1,'siteurl','http://ferme-de-chassagne.local','yes');
INSERT INTO `wp_options` VALUES (2,'home','http://ferme-de-chassagne.local','yes');
INSERT INTO `wp_options` VALUES (3,'blogname','Camping de Chassagne','yes');
INSERT INTO `wp_options` VALUES (4,'blogdescription','','yes');
INSERT INTO `wp_options` VALUES (5,'users_can_register','0','yes');
INSERT INTO `wp_options` VALUES (6,'admin_email','dev-email@wpengine.local','yes');
INSERT INTO `wp_options` VALUES (7,'start_of_week','1','yes');
INSERT INTO `wp_options` VALUES (8,'use_balanceTags','0','yes');
INSERT INTO `wp_options` VALUES (9,'use_smilies','1','yes');
INSERT INTO `wp_options` VALUES (10,'require_name_email','1','yes');
INSERT INTO `wp_options` VALUES (11,'comments_notify','1','yes');
INSERT INTO `wp_options` VALUES (12,'posts_per_rss','10','yes');
INSERT INTO `wp_options` VALUES (13,'rss_use_excerpt','0','yes');
INSERT INTO `wp_options` VALUES (14,'mailserver_url','mail.example.com','yes');
INSERT INTO `wp_options` VALUES (15,'mailserver_login','login@example.com','yes');
INSERT INTO `wp_options` VALUES (16,'mailserver_pass','password','yes');
INSERT INTO `wp_options` VALUES (17,'mailserver_port','110','yes');
INSERT INTO `wp_options` VALUES (18,'default_category','1','yes');
INSERT INTO `wp_options` VALUES (19,'default_comment_status','open','yes');
INSERT INTO `wp_options` VALUES (20,'default_ping_status','open','yes');
INSERT INTO `wp_options` VALUES (21,'default_pingback_flag','1','yes');
INSERT INTO `wp_options` VALUES (22,'posts_per_page','10','yes');
INSERT INTO `wp_options` VALUES (23,'date_format','F j, Y','yes');
INSERT INTO `wp_options` VALUES (24,'time_format','g:i a','yes');
INSERT INTO `wp_options` VALUES (25,'links_updated_date_format','F j, Y g:i a','yes');
INSERT INTO `wp_options` VALUES (26,'comment_moderation','0','yes');
INSERT INTO `wp_options` VALUES (27,'moderation_notify','1','yes');
INSERT INTO `wp_options` VALUES (28,'permalink_structure','/%postname%/','yes');
INSERT INTO `wp_options` VALUES (29,'rewrite_rules','a:128:{s:11:"^wp-json/?$";s:22:"index.php?rest_route=/";s:14:"^wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:21:"^index.php/wp-json/?$";s:22:"index.php?rest_route=/";s:24:"^index.php/wp-json/(.*)?";s:33:"index.php?rest_route=/$matches[1]";s:17:"^wp-sitemap\\.xml$";s:23:"index.php?sitemap=index";s:17:"^wp-sitemap\\.xsl$";s:36:"index.php?sitemap-stylesheet=sitemap";s:23:"^wp-sitemap-index\\.xsl$";s:34:"index.php?sitemap-stylesheet=index";s:48:"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$";s:75:"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]";s:34:"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$";s:47:"index.php?sitemap=$matches[1]&paged=$matches[2]";s:47:"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:42:"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$";s:52:"index.php?category_name=$matches[1]&feed=$matches[2]";s:23:"category/(.+?)/embed/?$";s:46:"index.php?category_name=$matches[1]&embed=true";s:35:"category/(.+?)/page/?([0-9]{1,})/?$";s:53:"index.php?category_name=$matches[1]&paged=$matches[2]";s:17:"category/(.+?)/?$";s:35:"index.php?category_name=$matches[1]";s:44:"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:39:"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?tag=$matches[1]&feed=$matches[2]";s:20:"tag/([^/]+)/embed/?$";s:36:"index.php?tag=$matches[1]&embed=true";s:32:"tag/([^/]+)/page/?([0-9]{1,})/?$";s:43:"index.php?tag=$matches[1]&paged=$matches[2]";s:14:"tag/([^/]+)/?$";s:25:"index.php?tag=$matches[1]";s:45:"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:40:"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?post_format=$matches[1]&feed=$matches[2]";s:21:"type/([^/]+)/embed/?$";s:44:"index.php?post_format=$matches[1]&embed=true";s:33:"type/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?post_format=$matches[1]&paged=$matches[2]";s:15:"type/([^/]+)/?$";s:33:"index.php?post_format=$matches[1]";s:42:"e-landing-page/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:52:"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:72:"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:67:"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:67:"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:48:"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:31:"e-landing-page/([^/]+)/embed/?$";s:47:"index.php?e-landing-page=$matches[1]&embed=true";s:35:"e-landing-page/([^/]+)/trackback/?$";s:41:"index.php?e-landing-page=$matches[1]&tb=1";s:43:"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$";s:54:"index.php?e-landing-page=$matches[1]&paged=$matches[2]";s:50:"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$";s:54:"index.php?e-landing-page=$matches[1]&cpage=$matches[2]";s:39:"e-landing-page/([^/]+)(?:/([0-9]+))?/?$";s:53:"index.php?e-landing-page=$matches[1]&page=$matches[2]";s:31:"e-landing-page/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:41:"e-landing-page/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:61:"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:56:"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:37:"e-landing-page/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:40:"elementor-hf/[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:50:"elementor-hf/[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:70:"elementor-hf/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"elementor-hf/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:65:"elementor-hf/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:46:"elementor-hf/[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:29:"elementor-hf/([^/]+)/embed/?$";s:45:"index.php?elementor-hf=$matches[1]&embed=true";s:33:"elementor-hf/([^/]+)/trackback/?$";s:39:"index.php?elementor-hf=$matches[1]&tb=1";s:41:"elementor-hf/([^/]+)/page/?([0-9]{1,})/?$";s:52:"index.php?elementor-hf=$matches[1]&paged=$matches[2]";s:48:"elementor-hf/([^/]+)/comment-page-([0-9]{1,})/?$";s:52:"index.php?elementor-hf=$matches[1]&cpage=$matches[2]";s:37:"elementor-hf/([^/]+)(?:/([0-9]+))?/?$";s:51:"index.php?elementor-hf=$matches[1]&page=$matches[2]";s:29:"elementor-hf/[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:39:"elementor-hf/[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:59:"elementor-hf/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"elementor-hf/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:54:"elementor-hf/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:35:"elementor-hf/[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:12:"robots\\.txt$";s:18:"index.php?robots=1";s:13:"favicon\\.ico$";s:19:"index.php?favicon=1";s:48:".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$";s:18:"index.php?feed=old";s:20:".*wp-app\\.php(/.*)?$";s:19:"index.php?error=403";s:18:".*wp-register.php$";s:23:"index.php?register=true";s:32:"feed/(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:27:"(feed|rdf|rss|rss2|atom)/?$";s:27:"index.php?&feed=$matches[1]";s:8:"embed/?$";s:21:"index.php?&embed=true";s:20:"page/?([0-9]{1,})/?$";s:28:"index.php?&paged=$matches[1]";s:27:"comment-page-([0-9]{1,})/?$";s:38:"index.php?&page_id=7&cpage=$matches[1]";s:41:"comments/feed/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:36:"comments/(feed|rdf|rss|rss2|atom)/?$";s:42:"index.php?&feed=$matches[1]&withcomments=1";s:17:"comments/embed/?$";s:21:"index.php?&embed=true";s:44:"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:39:"search/(.+)/(feed|rdf|rss|rss2|atom)/?$";s:40:"index.php?s=$matches[1]&feed=$matches[2]";s:20:"search/(.+)/embed/?$";s:34:"index.php?s=$matches[1]&embed=true";s:32:"search/(.+)/page/?([0-9]{1,})/?$";s:41:"index.php?s=$matches[1]&paged=$matches[2]";s:14:"search/(.+)/?$";s:23:"index.php?s=$matches[1]";s:47:"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:42:"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:50:"index.php?author_name=$matches[1]&feed=$matches[2]";s:23:"author/([^/]+)/embed/?$";s:44:"index.php?author_name=$matches[1]&embed=true";s:35:"author/([^/]+)/page/?([0-9]{1,})/?$";s:51:"index.php?author_name=$matches[1]&paged=$matches[2]";s:17:"author/([^/]+)/?$";s:33:"index.php?author_name=$matches[1]";s:69:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:64:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:80:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]";s:45:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$";s:74:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true";s:57:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:81:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]";s:39:"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$";s:63:"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]";s:56:"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:51:"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$";s:64:"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]";s:32:"([0-9]{4})/([0-9]{1,2})/embed/?$";s:58:"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true";s:44:"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$";s:65:"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]";s:26:"([0-9]{4})/([0-9]{1,2})/?$";s:47:"index.php?year=$matches[1]&monthnum=$matches[2]";s:43:"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:38:"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?year=$matches[1]&feed=$matches[2]";s:19:"([0-9]{4})/embed/?$";s:37:"index.php?year=$matches[1]&embed=true";s:31:"([0-9]{4})/page/?([0-9]{1,})/?$";s:44:"index.php?year=$matches[1]&paged=$matches[2]";s:13:"([0-9]{4})/?$";s:26:"index.php?year=$matches[1]";s:27:".?.+?/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:".?.+?/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:".?.+?/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"(.?.+?)/embed/?$";s:41:"index.php?pagename=$matches[1]&embed=true";s:20:"(.?.+?)/trackback/?$";s:35:"index.php?pagename=$matches[1]&tb=1";s:40:"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:35:"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$";s:47:"index.php?pagename=$matches[1]&feed=$matches[2]";s:28:"(.?.+?)/page/?([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&paged=$matches[2]";s:35:"(.?.+?)/comment-page-([0-9]{1,})/?$";s:48:"index.php?pagename=$matches[1]&cpage=$matches[2]";s:24:"(.?.+?)(?:/([0-9]+))?/?$";s:47:"index.php?pagename=$matches[1]&page=$matches[2]";s:27:"[^/]+/attachment/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:37:"[^/]+/attachment/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:57:"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:52:"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:33:"[^/]+/attachment/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";s:16:"([^/]+)/embed/?$";s:37:"index.php?name=$matches[1]&embed=true";s:20:"([^/]+)/trackback/?$";s:31:"index.php?name=$matches[1]&tb=1";s:40:"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:35:"([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:43:"index.php?name=$matches[1]&feed=$matches[2]";s:28:"([^/]+)/page/?([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&paged=$matches[2]";s:35:"([^/]+)/comment-page-([0-9]{1,})/?$";s:44:"index.php?name=$matches[1]&cpage=$matches[2]";s:24:"([^/]+)(?:/([0-9]+))?/?$";s:43:"index.php?name=$matches[1]&page=$matches[2]";s:16:"[^/]+/([^/]+)/?$";s:32:"index.php?attachment=$matches[1]";s:26:"[^/]+/([^/]+)/trackback/?$";s:37:"index.php?attachment=$matches[1]&tb=1";s:46:"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$";s:49:"index.php?attachment=$matches[1]&feed=$matches[2]";s:41:"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$";s:50:"index.php?attachment=$matches[1]&cpage=$matches[2]";s:22:"[^/]+/([^/]+)/embed/?$";s:43:"index.php?attachment=$matches[1]&embed=true";}','yes');
INSERT INTO `wp_options` VALUES (30,'hack_file','0','yes');
INSERT INTO `wp_options` VALUES (31,'blog_charset','UTF-8','yes');
INSERT INTO `wp_options` VALUES (32,'moderation_keys','','no');
INSERT INTO `wp_options` VALUES (33,'active_plugins','a:9:{i:0;s:23:"elementor/elementor.php";i:1;s:31:"elements-plus/elements-plus.php";i:2;s:25:"gtranslate/gtranslate.php";i:3;s:51:"header-footer-elementor/header-footer-elementor.php";i:4;s:27:"ocean-extra/ocean-extra.php";i:5;s:27:"updraftplus/updraftplus.php";i:6;s:24:"wordpress-seo/wp-seo.php";i:7;s:35:"wp-fastest-cache/wpFastestCache.php";i:8;s:47:"wpvivid-backuprestore/wpvivid-backuprestore.php";}','yes');
INSERT INTO `wp_options` VALUES (34,'category_base','','yes');
INSERT INTO `wp_options` VALUES (35,'ping_sites','http://rpc.pingomatic.com/','yes');
INSERT INTO `wp_options` VALUES (36,'comment_max_links','2','yes');
INSERT INTO `wp_options` VALUES (37,'gmt_offset','0','yes');
INSERT INTO `wp_options` VALUES (38,'default_email_category','1','yes');
INSERT INTO `wp_options` VALUES (39,'recently_edited','','no');
INSERT INTO `wp_options` VALUES (40,'template','oceanwp','yes');
INSERT INTO `wp_options` VALUES (41,'stylesheet','oceanwp','yes');
INSERT INTO `wp_options` VALUES (42,'comment_registration','0','yes');
INSERT INTO `wp_options` VALUES (43,'html_type','text/html','yes');
INSERT INTO `wp_options` VALUES (44,'use_trackback','0','yes');
INSERT INTO `wp_options` VALUES (45,'default_role','subscriber','yes');
INSERT INTO `wp_options` VALUES (46,'db_version','57155','yes');
INSERT INTO `wp_options` VALUES (47,'uploads_use_yearmonth_folders','1','yes');
INSERT INTO `wp_options` VALUES (48,'upload_path','','yes');
INSERT INTO `wp_options` VALUES (49,'blog_public','1','yes');
INSERT INTO `wp_options` VALUES (50,'default_link_category','2','yes');
INSERT INTO `wp_options` VALUES (51,'show_on_front','page','yes');
INSERT INTO `wp_options` VALUES (52,'tag_base','','yes');
INSERT INTO `wp_options` VALUES (53,'show_avatars','1','yes');
INSERT INTO `wp_options` VALUES (54,'avatar_rating','G','yes');
INSERT INTO `wp_options` VALUES (55,'upload_url_path','','yes');
INSERT INTO `wp_options` VALUES (56,'thumbnail_size_w','150','yes');
INSERT INTO `wp_options` VALUES (57,'thumbnail_size_h','150','yes');
INSERT INTO `wp_options` VALUES (58,'thumbnail_crop','1','yes');
INSERT INTO `wp_options` VALUES (59,'medium_size_w','300','yes');
INSERT INTO `wp_options` VALUES (60,'medium_size_h','300','yes');
INSERT INTO `wp_options` VALUES (61,'avatar_default','mystery','yes');
INSERT INTO `wp_options` VALUES (62,'large_size_w','1024','yes');
INSERT INTO `wp_options` VALUES (63,'large_size_h','1024','yes');
INSERT INTO `wp_options` VALUES (64,'image_default_link_type','none','yes');
INSERT INTO `wp_options` VALUES (65,'image_default_size','','yes');
INSERT INTO `wp_options` VALUES (66,'image_default_align','','yes');
INSERT INTO `wp_options` VALUES (67,'close_comments_for_old_posts','0','yes');
INSERT INTO `wp_options` VALUES (68,'close_comments_days_old','14','yes');
INSERT INTO `wp_options` VALUES (69,'thread_comments','1','yes');
INSERT INTO `wp_options` VALUES (70,'thread_comments_depth','5','yes');
INSERT INTO `wp_options` VALUES (71,'page_comments','0','yes');
INSERT INTO `wp_options` VALUES (72,'comments_per_page','50','yes');
INSERT INTO `wp_options` VALUES (73,'default_comments_page','newest','yes');
INSERT INTO `wp_options` VALUES (74,'comment_order','asc','yes');
INSERT INTO `wp_options` VALUES (75,'sticky_posts','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (76,'widget_categories','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (77,'widget_text','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (78,'widget_rss','a:2:{i:1;a:0:{}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (79,'uninstall_plugins','a:2:{s:23:"elementor/elementor.php";a:2:{i:0;s:21:"Elementor\\Maintenance";i:1;s:9:"uninstall";}s:24:"wordpress-seo/wp-seo.php";s:14:"__return_false";}','no');
INSERT INTO `wp_options` VALUES (80,'timezone_string','','yes');
INSERT INTO `wp_options` VALUES (81,'page_for_posts','0','yes');
INSERT INTO `wp_options` VALUES (82,'page_on_front','7','yes');
INSERT INTO `wp_options` VALUES (83,'default_post_format','0','yes');
INSERT INTO `wp_options` VALUES (84,'link_manager_enabled','0','yes');
INSERT INTO `wp_options` VALUES (85,'finished_splitting_shared_terms','1','yes');
INSERT INTO `wp_options` VALUES (86,'site_icon','856','yes');
INSERT INTO `wp_options` VALUES (87,'medium_large_size_w','768','yes');
INSERT INTO `wp_options` VALUES (88,'medium_large_size_h','0','yes');
INSERT INTO `wp_options` VALUES (89,'wp_page_for_privacy_policy','3','yes');
INSERT INTO `wp_options` VALUES (90,'show_comments_cookies_opt_in','1','yes');
INSERT INTO `wp_options` VALUES (91,'admin_email_lifespan','1733484012','yes');
INSERT INTO `wp_options` VALUES (92,'disallowed_keys','','no');
INSERT INTO `wp_options` VALUES (93,'comment_previously_approved','1','yes');
INSERT INTO `wp_options` VALUES (94,'auto_plugin_theme_update_emails','a:0:{}','no');
INSERT INTO `wp_options` VALUES (95,'auto_update_core_dev','enabled','yes');
INSERT INTO `wp_options` VALUES (96,'auto_update_core_minor','enabled','yes');
INSERT INTO `wp_options` VALUES (97,'auto_update_core_major','enabled','yes');
INSERT INTO `wp_options` VALUES (98,'wp_force_deactivated_plugins','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (99,'wp_attachment_pages_enabled','0','yes');
INSERT INTO `wp_options` VALUES (100,'initial_db_version','57155','yes');
INSERT INTO `wp_options` VALUES (101,'wp_user_roles','a:7:{s:13:"administrator";a:2:{s:4:"name";s:13:"Administrator";s:12:"capabilities";a:62:{s:13:"switch_themes";b:1;s:11:"edit_themes";b:1;s:16:"activate_plugins";b:1;s:12:"edit_plugins";b:1;s:10:"edit_users";b:1;s:10:"edit_files";b:1;s:14:"manage_options";b:1;s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:6:"import";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:8:"level_10";b:1;s:7:"level_9";b:1;s:7:"level_8";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:12:"delete_users";b:1;s:12:"create_users";b:1;s:17:"unfiltered_upload";b:1;s:14:"edit_dashboard";b:1;s:14:"update_plugins";b:1;s:14:"delete_plugins";b:1;s:15:"install_plugins";b:1;s:13:"update_themes";b:1;s:14:"install_themes";b:1;s:11:"update_core";b:1;s:10:"list_users";b:1;s:12:"remove_users";b:1;s:13:"promote_users";b:1;s:18:"edit_theme_options";b:1;s:13:"delete_themes";b:1;s:6:"export";b:1;s:20:"wpseo_manage_options";b:1;}}s:6:"editor";a:2:{s:4:"name";s:6:"Editor";s:12:"capabilities";a:36:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:15:"wpseo_bulk_edit";b:1;s:28:"wpseo_edit_advanced_metadata";b:1;}}s:6:"author";a:2:{s:4:"name";s:6:"Author";s:12:"capabilities";a:10:{s:12:"upload_files";b:1;s:10:"edit_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:4:"read";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;s:22:"delete_published_posts";b:1;}}s:11:"contributor";a:2:{s:4:"name";s:11:"Contributor";s:12:"capabilities";a:5:{s:10:"edit_posts";b:1;s:4:"read";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:12:"delete_posts";b:1;}}s:10:"subscriber";a:2:{s:4:"name";s:10:"Subscriber";s:12:"capabilities";a:2:{s:4:"read";b:1;s:7:"level_0";b:1;}}s:13:"wpseo_manager";a:2:{s:4:"name";s:11:"SEO Manager";s:12:"capabilities";a:38:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:15:"wpseo_bulk_edit";b:1;s:28:"wpseo_edit_advanced_metadata";b:1;s:20:"wpseo_manage_options";b:1;s:23:"view_site_health_checks";b:1;}}s:12:"wpseo_editor";a:2:{s:4:"name";s:10:"SEO Editor";s:12:"capabilities";a:36:{s:17:"moderate_comments";b:1;s:17:"manage_categories";b:1;s:12:"manage_links";b:1;s:12:"upload_files";b:1;s:15:"unfiltered_html";b:1;s:10:"edit_posts";b:1;s:17:"edit_others_posts";b:1;s:20:"edit_published_posts";b:1;s:13:"publish_posts";b:1;s:10:"edit_pages";b:1;s:4:"read";b:1;s:7:"level_7";b:1;s:7:"level_6";b:1;s:7:"level_5";b:1;s:7:"level_4";b:1;s:7:"level_3";b:1;s:7:"level_2";b:1;s:7:"level_1";b:1;s:7:"level_0";b:1;s:17:"edit_others_pages";b:1;s:20:"edit_published_pages";b:1;s:13:"publish_pages";b:1;s:12:"delete_pages";b:1;s:19:"delete_others_pages";b:1;s:22:"delete_published_pages";b:1;s:12:"delete_posts";b:1;s:19:"delete_others_posts";b:1;s:22:"delete_published_posts";b:1;s:20:"delete_private_posts";b:1;s:18:"edit_private_posts";b:1;s:18:"read_private_posts";b:1;s:20:"delete_private_pages";b:1;s:18:"edit_private_pages";b:1;s:18:"read_private_pages";b:1;s:15:"wpseo_bulk_edit";b:1;s:28:"wpseo_edit_advanced_metadata";b:1;}}}','yes');
INSERT INTO `wp_options` VALUES (102,'fresh_site','0','yes');
INSERT INTO `wp_options` VALUES (103,'user_count','1','no');
INSERT INTO `wp_options` VALUES (104,'widget_block','a:6:{i:2;a:1:{s:7:"content";s:19:"<!-- wp:search /-->";}i:3;a:1:{s:7:"content";s:154:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->";}i:4;a:1:{s:7:"content";s:227:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {"displayAvatar":false,"displayDate":false,"displayExcerpt":false} /--></div><!-- /wp:group -->";}i:5;a:1:{s:7:"content";s:146:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->";}i:6;a:1:{s:7:"content";s:150:"<!-- wp:group --><div class="wp-block-group"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->";}s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (105,'sidebars_widgets','a:9:{s:19:"wp_inactive_widgets";a:0:{}s:7:"sidebar";a:0:{}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}s:14:"search_sidebar";a:0:{}s:10:"footer-one";a:0:{}s:10:"footer-two";a:0:{}s:12:"footer-three";a:0:{}s:11:"footer-four";a:0:{}s:13:"array_version";i:3;}','yes');
INSERT INTO `wp_options` VALUES (106,'cron','a:13:{i:1724145953;a:1:{s:33:"wpvivid_clean_backup_record_event";a:1:{s:32:"a8cf63fecab3eb3edf6760bc02f258a6";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;b:0;}}}}i:1724146013;a:1:{s:28:"wpvivid_task_monitor_event_2";a:1:{s:32:"71761df60de008e56831850874cffd51";a:2:{s:8:"schedule";b:0;s:4:"args";a:1:{i:0;s:21:"wpvivid-66c460e53f97e";}}}}i:1724146795;a:1:{s:33:"updraftplus_clean_temporary_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}}i:1724149213;a:1:{s:34:"wp_privacy_delete_old_export_files";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"hourly";s:4:"args";a:0:{}s:8:"interval";i:3600;}}}i:1724152813;a:4:{s:16:"wp_version_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:17:"wp_update_plugins";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:16:"wp_update_themes";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:32:"recovery_mode_clean_expired_keys";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1724153074;a:3:{s:21:"wp_update_user_counts";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:10:"twicedaily";s:4:"args";a:0:{}s:8:"interval";i:43200;}}s:19:"wp_scheduled_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:25:"delete_expired_transients";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1724153075;a:1:{s:30:"wp_scheduled_auto_draft_delete";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1724153656;a:1:{s:28:"elementor/tracker/send_event";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1724190048;a:2:{s:13:"wpseo-reindex";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}s:31:"wpseo_permalink_structure_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:5:"daily";s:4:"args";a:0:{}s:8:"interval";i:86400;}}}i:1724449418;a:2:{s:14:"updraft_backup";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:7:"monthly";s:4:"args";a:0:{}s:8:"interval";i:2592000;}}s:23:"updraft_backup_database";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:7:"monthly";s:4:"args";a:0:{}s:8:"interval";i:2592000;}}}i:1724585100;a:1:{s:30:"wp_delete_temp_updater_backups";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}i:1724671213;a:1:{s:30:"wp_site_health_scheduled_check";a:1:{s:32:"40cd750bba9870f18aada2478b24840a";a:3:{s:8:"schedule";s:6:"weekly";s:4:"args";a:0:{}s:8:"interval";i:604800;}}}s:7:"version";i:2;}','yes');
INSERT INTO `wp_options` VALUES (107,'widget_pages','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (108,'widget_calendar','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (109,'widget_archives','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (110,'widget_media_audio','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (111,'widget_media_image','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (112,'widget_media_gallery','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (113,'widget_media_video','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (114,'widget_meta','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (115,'widget_search','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (116,'widget_recent-posts','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (117,'widget_recent-comments','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (118,'widget_tag_cloud','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (119,'widget_nav_menu','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (120,'widget_custom_html','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (121,'_transient_wp_core_block_css_files','a:2:{s:7:"version";s:5:"6.5.4";s:5:"files";a:500:{i:0;s:23:"archives/editor-rtl.css";i:1;s:27:"archives/editor-rtl.min.css";i:2;s:19:"archives/editor.css";i:3;s:23:"archives/editor.min.css";i:4;s:22:"archives/style-rtl.css";i:5;s:26:"archives/style-rtl.min.css";i:6;s:18:"archives/style.css";i:7;s:22:"archives/style.min.css";i:8;s:20:"audio/editor-rtl.css";i:9;s:24:"audio/editor-rtl.min.css";i:10;s:16:"audio/editor.css";i:11;s:20:"audio/editor.min.css";i:12;s:19:"audio/style-rtl.css";i:13;s:23:"audio/style-rtl.min.css";i:14;s:15:"audio/style.css";i:15;s:19:"audio/style.min.css";i:16;s:19:"audio/theme-rtl.css";i:17;s:23:"audio/theme-rtl.min.css";i:18;s:15:"audio/theme.css";i:19;s:19:"audio/theme.min.css";i:20;s:21:"avatar/editor-rtl.css";i:21;s:25:"avatar/editor-rtl.min.css";i:22;s:17:"avatar/editor.css";i:23;s:21:"avatar/editor.min.css";i:24;s:20:"avatar/style-rtl.css";i:25;s:24:"avatar/style-rtl.min.css";i:26;s:16:"avatar/style.css";i:27;s:20:"avatar/style.min.css";i:28;s:20:"block/editor-rtl.css";i:29;s:24:"block/editor-rtl.min.css";i:30;s:16:"block/editor.css";i:31;s:20:"block/editor.min.css";i:32;s:21:"button/editor-rtl.css";i:33;s:25:"button/editor-rtl.min.css";i:34;s:17:"button/editor.css";i:35;s:21:"button/editor.min.css";i:36;s:20:"button/style-rtl.css";i:37;s:24:"button/style-rtl.min.css";i:38;s:16:"button/style.css";i:39;s:20:"button/style.min.css";i:40;s:22:"buttons/editor-rtl.css";i:41;s:26:"buttons/editor-rtl.min.css";i:42;s:18:"buttons/editor.css";i:43;s:22:"buttons/editor.min.css";i:44;s:21:"buttons/style-rtl.css";i:45;s:25:"buttons/style-rtl.min.css";i:46;s:17:"buttons/style.css";i:47;s:21:"buttons/style.min.css";i:48;s:22:"calendar/style-rtl.css";i:49;s:26:"calendar/style-rtl.min.css";i:50;s:18:"calendar/style.css";i:51;s:22:"calendar/style.min.css";i:52;s:25:"categories/editor-rtl.css";i:53;s:29:"categories/editor-rtl.min.css";i:54;s:21:"categories/editor.css";i:55;s:25:"categories/editor.min.css";i:56;s:24:"categories/style-rtl.css";i:57;s:28:"categories/style-rtl.min.css";i:58;s:20:"categories/style.css";i:59;s:24:"categories/style.min.css";i:60;s:19:"code/editor-rtl.css";i:61;s:23:"code/editor-rtl.min.css";i:62;s:15:"code/editor.css";i:63;s:19:"code/editor.min.css";i:64;s:18:"code/style-rtl.css";i:65;s:22:"code/style-rtl.min.css";i:66;s:14:"code/style.css";i:67;s:18:"code/style.min.css";i:68;s:18:"code/theme-rtl.css";i:69;s:22:"code/theme-rtl.min.css";i:70;s:14:"code/theme.css";i:71;s:18:"code/theme.min.css";i:72;s:22:"columns/editor-rtl.css";i:73;s:26:"columns/editor-rtl.min.css";i:74;s:18:"columns/editor.css";i:75;s:22:"columns/editor.min.css";i:76;s:21:"columns/style-rtl.css";i:77;s:25:"columns/style-rtl.min.css";i:78;s:17:"columns/style.css";i:79;s:21:"columns/style.min.css";i:80;s:29:"comment-content/style-rtl.css";i:81;s:33:"comment-content/style-rtl.min.css";i:82;s:25:"comment-content/style.css";i:83;s:29:"comment-content/style.min.css";i:84;s:30:"comment-template/style-rtl.css";i:85;s:34:"comment-template/style-rtl.min.css";i:86;s:26:"comment-template/style.css";i:87;s:30:"comment-template/style.min.css";i:88;s:42:"comments-pagination-numbers/editor-rtl.css";i:89;s:46:"comments-pagination-numbers/editor-rtl.min.css";i:90;s:38:"comments-pagination-numbers/editor.css";i:91;s:42:"comments-pagination-numbers/editor.min.css";i:92;s:34:"comments-pagination/editor-rtl.css";i:93;s:38:"comments-pagination/editor-rtl.min.css";i:94;s:30:"comments-pagination/editor.css";i:95;s:34:"comments-pagination/editor.min.css";i:96;s:33:"comments-pagination/style-rtl.css";i:97;s:37:"comments-pagination/style-rtl.min.css";i:98;s:29:"comments-pagination/style.css";i:99;s:33:"comments-pagination/style.min.css";i:100;s:29:"comments-title/editor-rtl.css";i:101;s:33:"comments-title/editor-rtl.min.css";i:102;s:25:"comments-title/editor.css";i:103;s:29:"comments-title/editor.min.css";i:104;s:23:"comments/editor-rtl.css";i:105;s:27:"comments/editor-rtl.min.css";i:106;s:19:"comments/editor.css";i:107;s:23:"comments/editor.min.css";i:108;s:22:"comments/style-rtl.css";i:109;s:26:"comments/style-rtl.min.css";i:110;s:18:"comments/style.css";i:111;s:22:"comments/style.min.css";i:112;s:20:"cover/editor-rtl.css";i:113;s:24:"cover/editor-rtl.min.css";i:114;s:16:"cover/editor.css";i:115;s:20:"cover/editor.min.css";i:116;s:19:"cover/style-rtl.css";i:117;s:23:"cover/style-rtl.min.css";i:118;s:15:"cover/style.css";i:119;s:19:"cover/style.min.css";i:120;s:22:"details/editor-rtl.css";i:121;s:26:"details/editor-rtl.min.css";i:122;s:18:"details/editor.css";i:123;s:22:"details/editor.min.css";i:124;s:21:"details/style-rtl.css";i:125;s:25:"details/style-rtl.min.css";i:126;s:17:"details/style.css";i:127;s:21:"details/style.min.css";i:128;s:20:"embed/editor-rtl.css";i:129;s:24:"embed/editor-rtl.min.css";i:130;s:16:"embed/editor.css";i:131;s:20:"embed/editor.min.css";i:132;s:19:"embed/style-rtl.css";i:133;s:23:"embed/style-rtl.min.css";i:134;s:15:"embed/style.css";i:135;s:19:"embed/style.min.css";i:136;s:19:"embed/theme-rtl.css";i:137;s:23:"embed/theme-rtl.min.css";i:138;s:15:"embed/theme.css";i:139;s:19:"embed/theme.min.css";i:140;s:19:"file/editor-rtl.css";i:141;s:23:"file/editor-rtl.min.css";i:142;s:15:"file/editor.css";i:143;s:19:"file/editor.min.css";i:144;s:18:"file/style-rtl.css";i:145;s:22:"file/style-rtl.min.css";i:146;s:14:"file/style.css";i:147;s:18:"file/style.min.css";i:148;s:23:"footnotes/style-rtl.css";i:149;s:27:"footnotes/style-rtl.min.css";i:150;s:19:"footnotes/style.css";i:151;s:23:"footnotes/style.min.css";i:152;s:23:"freeform/editor-rtl.css";i:153;s:27:"freeform/editor-rtl.min.css";i:154;s:19:"freeform/editor.css";i:155;s:23:"freeform/editor.min.css";i:156;s:22:"gallery/editor-rtl.css";i:157;s:26:"gallery/editor-rtl.min.css";i:158;s:18:"gallery/editor.css";i:159;s:22:"gallery/editor.min.css";i:160;s:21:"gallery/style-rtl.css";i:161;s:25:"gallery/style-rtl.min.css";i:162;s:17:"gallery/style.css";i:163;s:21:"gallery/style.min.css";i:164;s:21:"gallery/theme-rtl.css";i:165;s:25:"gallery/theme-rtl.min.css";i:166;s:17:"gallery/theme.css";i:167;s:21:"gallery/theme.min.css";i:168;s:20:"group/editor-rtl.css";i:169;s:24:"group/editor-rtl.min.css";i:170;s:16:"group/editor.css";i:171;s:20:"group/editor.min.css";i:172;s:19:"group/style-rtl.css";i:173;s:23:"group/style-rtl.min.css";i:174;s:15:"group/style.css";i:175;s:19:"group/style.min.css";i:176;s:19:"group/theme-rtl.css";i:177;s:23:"group/theme-rtl.min.css";i:178;s:15:"group/theme.css";i:179;s:19:"group/theme.min.css";i:180;s:21:"heading/style-rtl.css";i:181;s:25:"heading/style-rtl.min.css";i:182;s:17:"heading/style.css";i:183;s:21:"heading/style.min.css";i:184;s:19:"html/editor-rtl.css";i:185;s:23:"html/editor-rtl.min.css";i:186;s:15:"html/editor.css";i:187;s:19:"html/editor.min.css";i:188;s:20:"image/editor-rtl.css";i:189;s:24:"image/editor-rtl.min.css";i:190;s:16:"image/editor.css";i:191;s:20:"image/editor.min.css";i:192;s:19:"image/style-rtl.css";i:193;s:23:"image/style-rtl.min.css";i:194;s:15:"image/style.css";i:195;s:19:"image/style.min.css";i:196;s:19:"image/theme-rtl.css";i:197;s:23:"image/theme-rtl.min.css";i:198;s:15:"image/theme.css";i:199;s:19:"image/theme.min.css";i:200;s:29:"latest-comments/style-rtl.css";i:201;s:33:"latest-comments/style-rtl.min.css";i:202;s:25:"latest-comments/style.css";i:203;s:29:"latest-comments/style.min.css";i:204;s:27:"latest-posts/editor-rtl.css";i:205;s:31:"latest-posts/editor-rtl.min.css";i:206;s:23:"latest-posts/editor.css";i:207;s:27:"latest-posts/editor.min.css";i:208;s:26:"latest-posts/style-rtl.css";i:209;s:30:"latest-posts/style-rtl.min.css";i:210;s:22:"latest-posts/style.css";i:211;s:26:"latest-posts/style.min.css";i:212;s:18:"list/style-rtl.css";i:213;s:22:"list/style-rtl.min.css";i:214;s:14:"list/style.css";i:215;s:18:"list/style.min.css";i:216;s:25:"media-text/editor-rtl.css";i:217;s:29:"media-text/editor-rtl.min.css";i:218;s:21:"media-text/editor.css";i:219;s:25:"media-text/editor.min.css";i:220;s:24:"media-text/style-rtl.css";i:221;s:28:"media-text/style-rtl.min.css";i:222;s:20:"media-text/style.css";i:223;s:24:"media-text/style.min.css";i:224;s:19:"more/editor-rtl.css";i:225;s:23:"more/editor-rtl.min.css";i:226;s:15:"more/editor.css";i:227;s:19:"more/editor.min.css";i:228;s:30:"navigation-link/editor-rtl.css";i:229;s:34:"navigation-link/editor-rtl.min.css";i:230;s:26:"navigation-link/editor.css";i:231;s:30:"navigation-link/editor.min.css";i:232;s:29:"navigation-link/style-rtl.css";i:233;s:33:"navigation-link/style-rtl.min.css";i:234;s:25:"navigation-link/style.css";i:235;s:29:"navigation-link/style.min.css";i:236;s:33:"navigation-submenu/editor-rtl.css";i:237;s:37:"navigation-submenu/editor-rtl.min.css";i:238;s:29:"navigation-submenu/editor.css";i:239;s:33:"navigation-submenu/editor.min.css";i:240;s:25:"navigation/editor-rtl.css";i:241;s:29:"navigation/editor-rtl.min.css";i:242;s:21:"navigation/editor.css";i:243;s:25:"navigation/editor.min.css";i:244;s:24:"navigation/style-rtl.css";i:245;s:28:"navigation/style-rtl.min.css";i:246;s:20:"navigation/style.css";i:247;s:24:"navigation/style.min.css";i:248;s:23:"nextpage/editor-rtl.css";i:249;s:27:"nextpage/editor-rtl.min.css";i:250;s:19:"nextpage/editor.css";i:251;s:23:"nextpage/editor.min.css";i:252;s:24:"page-list/editor-rtl.css";i:253;s:28:"page-list/editor-rtl.min.css";i:254;s:20:"page-list/editor.css";i:255;s:24:"page-list/editor.min.css";i:256;s:23:"page-list/style-rtl.css";i:257;s:27:"page-list/style-rtl.min.css";i:258;s:19:"page-list/style.css";i:259;s:23:"page-list/style.min.css";i:260;s:24:"paragraph/editor-rtl.css";i:261;s:28:"paragraph/editor-rtl.min.css";i:262;s:20:"paragraph/editor.css";i:263;s:24:"paragraph/editor.min.css";i:264;s:23:"paragraph/style-rtl.css";i:265;s:27:"paragraph/style-rtl.min.css";i:266;s:19:"paragraph/style.css";i:267;s:23:"paragraph/style.min.css";i:268;s:25:"post-author/style-rtl.css";i:269;s:29:"post-author/style-rtl.min.css";i:270;s:21:"post-author/style.css";i:271;s:25:"post-author/style.min.css";i:272;s:33:"post-comments-form/editor-rtl.css";i:273;s:37:"post-comments-form/editor-rtl.min.css";i:274;s:29:"post-comments-form/editor.css";i:275;s:33:"post-comments-form/editor.min.css";i:276;s:32:"post-comments-form/style-rtl.css";i:277;s:36:"post-comments-form/style-rtl.min.css";i:278;s:28:"post-comments-form/style.css";i:279;s:32:"post-comments-form/style.min.css";i:280;s:27:"post-content/editor-rtl.css";i:281;s:31:"post-content/editor-rtl.min.css";i:282;s:23:"post-content/editor.css";i:283;s:27:"post-content/editor.min.css";i:284;s:23:"post-date/style-rtl.css";i:285;s:27:"post-date/style-rtl.min.css";i:286;s:19:"post-date/style.css";i:287;s:23:"post-date/style.min.css";i:288;s:27:"post-excerpt/editor-rtl.css";i:289;s:31:"post-excerpt/editor-rtl.min.css";i:290;s:23:"post-excerpt/editor.css";i:291;s:27:"post-excerpt/editor.min.css";i:292;s:26:"post-excerpt/style-rtl.css";i:293;s:30:"post-excerpt/style-rtl.min.css";i:294;s:22:"post-excerpt/style.css";i:295;s:26:"post-excerpt/style.min.css";i:296;s:34:"post-featured-image/editor-rtl.css";i:297;s:38:"post-featured-image/editor-rtl.min.css";i:298;s:30:"post-featured-image/editor.css";i:299;s:34:"post-featured-image/editor.min.css";i:300;s:33:"post-featured-image/style-rtl.css";i:301;s:37:"post-featured-image/style-rtl.min.css";i:302;s:29:"post-featured-image/style.css";i:303;s:33:"post-featured-image/style.min.css";i:304;s:34:"post-navigation-link/style-rtl.css";i:305;s:38:"post-navigation-link/style-rtl.min.css";i:306;s:30:"post-navigation-link/style.css";i:307;s:34:"post-navigation-link/style.min.css";i:308;s:28:"post-template/editor-rtl.css";i:309;s:32:"post-template/editor-rtl.min.css";i:310;s:24:"post-template/editor.css";i:311;s:28:"post-template/editor.min.css";i:312;s:27:"post-template/style-rtl.css";i:313;s:31:"post-template/style-rtl.min.css";i:314;s:23:"post-template/style.css";i:315;s:27:"post-template/style.min.css";i:316;s:24:"post-terms/style-rtl.css";i:317;s:28:"post-terms/style-rtl.min.css";i:318;s:20:"post-terms/style.css";i:319;s:24:"post-terms/style.min.css";i:320;s:24:"post-title/style-rtl.css";i:321;s:28:"post-title/style-rtl.min.css";i:322;s:20:"post-title/style.css";i:323;s:24:"post-title/style.min.css";i:324;s:26:"preformatted/style-rtl.css";i:325;s:30:"preformatted/style-rtl.min.css";i:326;s:22:"preformatted/style.css";i:327;s:26:"preformatted/style.min.css";i:328;s:24:"pullquote/editor-rtl.css";i:329;s:28:"pullquote/editor-rtl.min.css";i:330;s:20:"pullquote/editor.css";i:331;s:24:"pullquote/editor.min.css";i:332;s:23:"pullquote/style-rtl.css";i:333;s:27:"pullquote/style-rtl.min.css";i:334;s:19:"pullquote/style.css";i:335;s:23:"pullquote/style.min.css";i:336;s:23:"pullquote/theme-rtl.css";i:337;s:27:"pullquote/theme-rtl.min.css";i:338;s:19:"pullquote/theme.css";i:339;s:23:"pullquote/theme.min.css";i:340;s:39:"query-pagination-numbers/editor-rtl.css";i:341;s:43:"query-pagination-numbers/editor-rtl.min.css";i:342;s:35:"query-pagination-numbers/editor.css";i:343;s:39:"query-pagination-numbers/editor.min.css";i:344;s:31:"query-pagination/editor-rtl.css";i:345;s:35:"query-pagination/editor-rtl.min.css";i:346;s:27:"query-pagination/editor.css";i:347;s:31:"query-pagination/editor.min.css";i:348;s:30:"query-pagination/style-rtl.css";i:349;s:34:"query-pagination/style-rtl.min.css";i:350;s:26:"query-pagination/style.css";i:351;s:30:"query-pagination/style.min.css";i:352;s:25:"query-title/style-rtl.css";i:353;s:29:"query-title/style-rtl.min.css";i:354;s:21:"query-title/style.css";i:355;s:25:"query-title/style.min.css";i:356;s:20:"query/editor-rtl.css";i:357;s:24:"query/editor-rtl.min.css";i:358;s:16:"query/editor.css";i:359;s:20:"query/editor.min.css";i:360;s:19:"quote/style-rtl.css";i:361;s:23:"quote/style-rtl.min.css";i:362;s:15:"quote/style.css";i:363;s:19:"quote/style.min.css";i:364;s:19:"quote/theme-rtl.css";i:365;s:23:"quote/theme-rtl.min.css";i:366;s:15:"quote/theme.css";i:367;s:19:"quote/theme.min.css";i:368;s:23:"read-more/style-rtl.css";i:369;s:27:"read-more/style-rtl.min.css";i:370;s:19:"read-more/style.css";i:371;s:23:"read-more/style.min.css";i:372;s:18:"rss/editor-rtl.css";i:373;s:22:"rss/editor-rtl.min.css";i:374;s:14:"rss/editor.css";i:375;s:18:"rss/editor.min.css";i:376;s:17:"rss/style-rtl.css";i:377;s:21:"rss/style-rtl.min.css";i:378;s:13:"rss/style.css";i:379;s:17:"rss/style.min.css";i:380;s:21:"search/editor-rtl.css";i:381;s:25:"search/editor-rtl.min.css";i:382;s:17:"search/editor.css";i:383;s:21:"search/editor.min.css";i:384;s:20:"search/style-rtl.css";i:385;s:24:"search/style-rtl.min.css";i:386;s:16:"search/style.css";i:387;s:20:"search/style.min.css";i:388;s:20:"search/theme-rtl.css";i:389;s:24:"search/theme-rtl.min.css";i:390;s:16:"search/theme.css";i:391;s:20:"search/theme.min.css";i:392;s:24:"separator/editor-rtl.css";i:393;s:28:"separator/editor-rtl.min.css";i:394;s:20:"separator/editor.css";i:395;s:24:"separator/editor.min.css";i:396;s:23:"separator/style-rtl.css";i:397;s:27:"separator/style-rtl.min.css";i:398;s:19:"separator/style.css";i:399;s:23:"separator/style.min.css";i:400;s:23:"separator/theme-rtl.css";i:401;s:27:"separator/theme-rtl.min.css";i:402;s:19:"separator/theme.css";i:403;s:23:"separator/theme.min.css";i:404;s:24:"shortcode/editor-rtl.css";i:405;s:28:"shortcode/editor-rtl.min.css";i:406;s:20:"shortcode/editor.css";i:407;s:24:"shortcode/editor.min.css";i:408;s:24:"site-logo/editor-rtl.css";i:409;s:28:"site-logo/editor-rtl.min.css";i:410;s:20:"site-logo/editor.css";i:411;s:24:"site-logo/editor.min.css";i:412;s:23:"site-logo/style-rtl.css";i:413;s:27:"site-logo/style-rtl.min.css";i:414;s:19:"site-logo/style.css";i:415;s:23:"site-logo/style.min.css";i:416;s:27:"site-tagline/editor-rtl.css";i:417;s:31:"site-tagline/editor-rtl.min.css";i:418;s:23:"site-tagline/editor.css";i:419;s:27:"site-tagline/editor.min.css";i:420;s:25:"site-title/editor-rtl.css";i:421;s:29:"site-title/editor-rtl.min.css";i:422;s:21:"site-title/editor.css";i:423;s:25:"site-title/editor.min.css";i:424;s:24:"site-title/style-rtl.css";i:425;s:28:"site-title/style-rtl.min.css";i:426;s:20:"site-title/style.css";i:427;s:24:"site-title/style.min.css";i:428;s:26:"social-link/editor-rtl.css";i:429;s:30:"social-link/editor-rtl.min.css";i:430;s:22:"social-link/editor.css";i:431;s:26:"social-link/editor.min.css";i:432;s:27:"social-links/editor-rtl.css";i:433;s:31:"social-links/editor-rtl.min.css";i:434;s:23:"social-links/editor.css";i:435;s:27:"social-links/editor.min.css";i:436;s:26:"social-links/style-rtl.css";i:437;s:30:"social-links/style-rtl.min.css";i:438;s:22:"social-links/style.css";i:439;s:26:"social-links/style.min.css";i:440;s:21:"spacer/editor-rtl.css";i:441;s:25:"spacer/editor-rtl.min.css";i:442;s:17:"spacer/editor.css";i:443;s:21:"spacer/editor.min.css";i:444;s:20:"spacer/style-rtl.css";i:445;s:24:"spacer/style-rtl.min.css";i:446;s:16:"spacer/style.css";i:447;s:20:"spacer/style.min.css";i:448;s:20:"table/editor-rtl.css";i:449;s:24:"table/editor-rtl.min.css";i:450;s:16:"table/editor.css";i:451;s:20:"table/editor.min.css";i:452;s:19:"table/style-rtl.css";i:453;s:23:"table/style-rtl.min.css";i:454;s:15:"table/style.css";i:455;s:19:"table/style.min.css";i:456;s:19:"table/theme-rtl.css";i:457;s:23:"table/theme-rtl.min.css";i:458;s:15:"table/theme.css";i:459;s:19:"table/theme.min.css";i:460;s:23:"tag-cloud/style-rtl.css";i:461;s:27:"tag-cloud/style-rtl.min.css";i:462;s:19:"tag-cloud/style.css";i:463;s:23:"tag-cloud/style.min.css";i:464;s:28:"template-part/editor-rtl.css";i:465;s:32:"template-part/editor-rtl.min.css";i:466;s:24:"template-part/editor.css";i:467;s:28:"template-part/editor.min.css";i:468;s:27:"template-part/theme-rtl.css";i:469;s:31:"template-part/theme-rtl.min.css";i:470;s:23:"template-part/theme.css";i:471;s:27:"template-part/theme.min.css";i:472;s:30:"term-description/style-rtl.css";i:473;s:34:"term-description/style-rtl.min.css";i:474;s:26:"term-description/style.css";i:475;s:30:"term-description/style.min.css";i:476;s:27:"text-columns/editor-rtl.css";i:477;s:31:"text-columns/editor-rtl.min.css";i:478;s:23:"text-columns/editor.css";i:479;s:27:"text-columns/editor.min.css";i:480;s:26:"text-columns/style-rtl.css";i:481;s:30:"text-columns/style-rtl.min.css";i:482;s:22:"text-columns/style.css";i:483;s:26:"text-columns/style.min.css";i:484;s:19:"verse/style-rtl.css";i:485;s:23:"verse/style-rtl.min.css";i:486;s:15:"verse/style.css";i:487;s:19:"verse/style.min.css";i:488;s:20:"video/editor-rtl.css";i:489;s:24:"video/editor-rtl.min.css";i:490;s:16:"video/editor.css";i:491;s:20:"video/editor.min.css";i:492;s:19:"video/style-rtl.css";i:493;s:23:"video/style-rtl.min.css";i:494;s:15:"video/style.css";i:495;s:19:"video/style.min.css";i:496;s:19:"video/theme-rtl.css";i:497;s:23:"video/theme-rtl.min.css";i:498;s:15:"video/theme.css";i:499;s:19:"video/theme.min.css";}}','yes');
INSERT INTO `wp_options` VALUES (123,'recovery_keys','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (130,'theme_mods_twentytwentyfour','a:2:{s:18:"custom_css_post_id";i:-1;s:16:"sidebars_widgets";a:2:{s:4:"time";i:1717932307;s:4:"data";a:3:{s:19:"wp_inactive_widgets";a:0:{}s:9:"sidebar-1";a:3:{i:0;s:7:"block-2";i:1;s:7:"block-3";i:2;s:7:"block-4";}s:9:"sidebar-2";a:2:{i:0;s:7:"block-5";i:1;s:7:"block-6";}}}}','no');
INSERT INTO `wp_options` VALUES (149,'can_compress_scripts','1','yes');
INSERT INTO `wp_options` VALUES (153,'current_theme','OceanWP','yes');
INSERT INTO `wp_options` VALUES (154,'theme_mods_oceanwp','a:47:{i:0;b:0;s:18:"nav_menu_locations";a:1:{s:9:"main_menu";i:2;}s:18:"custom_css_post_id";i:-1;s:19:"ocean_menu_position";s:10:"right-menu";s:33:"ocean_menu_link_active_background";s:7:"#8b0000";s:30:"ocean_dropdown_menu_background";s:7:"#8B0000";s:38:"ocean_search_dropdown_input_background";s:0:"";s:21:"ocean_menu_link_color";s:7:"#ffffff";s:27:"ocean_menu_link_color_hover";s:7:"#ffffff";s:28:"ocean_menu_link_color_active";s:7:"#ffffff";s:30:"ocean_dropdown_menu_link_color";s:7:"#ffffff";s:27:"ocean_dropdown_menu_borders";s:0:"";s:34:"ocean_dropdown_menu_link_bg_active";s:0:"";s:30:"ocean_dropdown_menu_top_border";s:7:"#ffffff";s:26:"ocean_menu_link_background";s:7:"#8b0000";s:32:"ocean_dropdown_category_title_bg";s:0:"";s:36:"ocean_dropdown_menu_link_color_hover";s:7:"#8b0000";s:33:"ocean_search_dropdown_input_color";s:7:"#ffffff";s:35:"ocean_dropdown_category_title_color";s:7:"#ffffff";s:32:"ocean_menu_link_hover_background";s:0:"";s:35:"ocean_dropdown_category_links_color";s:7:"#ffffff";s:41:"ocean_dropdown_category_links_hover_color";s:7:"#ffffff";s:23:"ocean_header_background";s:7:"#8b0000";s:30:"ocean_has_header_border_bottom";b:0;s:18:"ocean_header_style";s:7:"minimal";s:19:"ocean_header_height";s:3:"126";s:20:"ocean_dropdown_width";s:3:"180";s:15:"menu_typography";a:3:{s:9:"font-size";s:4:"17px";s:11:"font-family";s:7:"Poppins";s:11:"font-weight";s:3:"500";}s:24:"ocean_page_single_layout";s:10:"full-width";s:23:"ocean_page_header_style";s:6:"hidden";s:11:"custom_logo";i:840;s:20:"ocean_logo_max_width";i:105;s:21:"ocean_logo_max_height";i:331;s:24:"menu_dropdown_typography";a:1:{s:11:"font-family";s:7:"Poppins";}s:13:"ocean_top_bar";b:0;s:23:"ocean_menu_search_style";s:8:"disabled";s:17:"ocean_menu_social";b:0;s:33:"ocean_mobile_menu_sidr_background";s:7:"#8b0000";s:30:"ocean_mobile_menu_sidr_borders";s:7:"#ffffff";s:24:"ocean_mobile_menu_search";b:0;s:23:"ocean_mobile_menu_links";s:7:"#ffffff";s:29:"ocean_mobile_menu_links_hover";s:7:"#ffffff";s:43:"ocean_mobile_menu_sidr_dropdowns_background";s:7:"#8b0000";s:42:"ocean_mobile_menu_sidr_search_border_color";s:7:"#ffffff";s:48:"ocean_mobile_menu_sidr_search_border_color_focus";s:7:"#ffffff";s:23:"ocean_menu_links_effect";s:3:"one";s:34:"ocean_menu_links_effect_blue_color";s:7:"#ffffff";}','yes');
INSERT INTO `wp_options` VALUES (155,'theme_switched','','yes');
INSERT INTO `wp_options` VALUES (161,'finished_updating_comment_type','1','yes');
INSERT INTO `wp_options` VALUES (162,'_site_transient_wp_plugin_dependencies_plugin_data','a:0:{}','no');
INSERT INTO `wp_options` VALUES (163,'recently_activated','a:1:{s:57:"google-language-translator/google-language-translator.php";i:1721314166;}','yes');
INSERT INTO `wp_options` VALUES (168,'elementor_active_kit','6','yes');
INSERT INTO `wp_options` VALUES (169,'elementor_font_display','swap','yes');
INSERT INTO `wp_options` VALUES (172,'elementor_version','3.23.4','yes');
INSERT INTO `wp_options` VALUES (173,'elementor_install_history','a:7:{s:6:"3.21.8";i:1717932856;s:6:"3.22.1";i:1718709521;s:6:"3.22.2";i:1719266052;s:6:"3.22.3";i:1719564419;s:6:"3.23.1";i:1721068480;s:6:"3.23.2";i:1721832347;s:6:"3.23.4";i:1724145717;}','yes');
INSERT INTO `wp_options` VALUES (174,'elementor_events_db_version','1.0.0','no');
INSERT INTO `wp_options` VALUES (176,'elementor_onboarded','1','yes');
INSERT INTO `wp_options` VALUES (177,'_elementor_installed_time','1717932860','yes');
INSERT INTO `wp_options` VALUES (178,'elementor_remote_info_library','a:3:{s:10:"types_data";a:4:{s:5:"block";a:2:{s:10:"categories";a:28:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:8:"Benefits";i:4;s:14:"call to action";i:5;s:7:"clients";i:6;s:7:"contact";i:7;s:4:"Data";i:8;s:3:"faq";i:9;s:8:"features";i:10;s:6:"footer";i:11;s:7:"Gallery";i:12;s:6:"header";i:13;s:4:"hero";i:14;s:11:"Link in Bio";i:15;s:9:"portfolio";i:16;s:7:"pricing";i:17;s:15:"product archive";i:18;s:5:"Quote";i:19;s:15:"Service Details";i:20;s:8:"services";i:21;s:11:"single page";i:22;s:11:"single post";i:23;s:14:"single product";i:24;s:5:"stats";i:25;s:9:"subscribe";i:26;s:4:"team";i:27;s:12:"testimonials";}s:4:"sets";a:5:{i:0;s:11:"Boxing Club";i:1;s:19:"Business Consultant";i:2;s:16:"Marketing Agency";i:3;s:9:"Wireframe";i:4;s:15:"Workshop Center";}}s:5:"popup";a:1:{s:10:"categories";a:6:{i:0;s:10:"bottom bar";i:1;s:7:"classic";i:2;s:6:"fly-in";i:3;s:11:"full screen";i:4;s:9:"hello bar";i:5;s:8:"slide-in";}}s:2:"lp";a:1:{s:10:"categories";a:15:{i:0;s:8:"Business";i:1;s:16:"Coming Soon Page";i:2;s:9:"eCommerce";i:3;s:9:"Education";i:4;s:6:"Events";i:5;s:18:"Health and Fitness";i:6;s:3:"NFT";i:7;s:14:"Online Service";i:8;s:7:"Product";i:9;s:11:"Real Estate";i:10;s:18:"Social Involvement";i:11;s:14:"Thank You Page";i:12;s:6:"Travel";i:13;s:18:"Under Construction";i:14;s:9:"Wireframe";}}s:2:"lb";a:1:{s:10:"categories";a:2:{i:0;s:4:"post";i:1;s:7:"product";}}}s:10:"categories";a:28:{i:0;s:8:"404 page";i:1;s:5:"about";i:2;s:7:"archive";i:3;s:8:"Benefits";i:4;s:14:"call to action";i:5;s:7:"clients";i:6;s:7:"contact";i:7;s:4:"Data";i:8;s:3:"faq";i:9;s:8:"features";i:10;s:6:"footer";i:11;s:7:"Gallery";i:12;s:6:"header";i:13;s:4:"hero";i:14;s:11:"Link in Bio";i:15;s:9:"portfolio";i:16;s:7:"pricing";i:17;s:15:"product archive";i:18;s:5:"Quote";i:19;s:15:"Service Details";i:20;s:8:"services";i:21;s:11:"single page";i:22;s:11:"single post";i:23;s:14:"single product";i:24;s:5:"stats";i:25;s:9:"subscribe";i:26;s:4:"team";i:27;s:12:"testimonials";}s:9:"templates";a:823:{i:0;a:19:{s:4:"tmpl";i:1280;s:2:"id";i:22403;s:5:"title";s:40:"Hello Bar | Subscribe | Aesthetic Clinic";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg";s:12:"tmpl_created";i:1647354307;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:48:"["Barbershop","Business","Discount","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:1;a:19:{s:4:"tmpl";i:1281;s:2:"id";i:22410;s:5:"title";s:32:"Fly-In | Discount | Hair Stylist";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg";s:12:"tmpl_created";i:1647354614;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:32:"["Barbershop","Discount","Hair"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:2;a:19:{s:4:"tmpl";i:1285;s:2:"id";i:22440;s:5:"title";s:32:"Classic | Subscribe | Shoe Store";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg";s:12:"tmpl_created";i:1647418620;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:37:"["Ecommerce","Marketing","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:3;a:19:{s:4:"tmpl";i:1286;s:2:"id";i:22446;s:5:"title";s:37:"Full Screen | Subscribe | Denim Store";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg";s:12:"tmpl_created";i:1647419614;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:35:"["Ecommerce","Fashion","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:4;a:19:{s:4:"tmpl";i:1287;s:2:"id";i:22452;s:5:"title";s:37:"Fly-In | Subscribe | Pizza Restaurant";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg";s:12:"tmpl_created";i:1647420733;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:19:"["Business","Food"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:5;a:19:{s:4:"tmpl";i:1288;s:2:"id";i:22458;s:5:"title";s:38:"Full Screen | Subscribe | Fashion Shop";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg";s:12:"tmpl_created";i:1647426379;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:31:"["Ecommerce","Fashion","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:6;a:19:{s:4:"tmpl";i:1289;s:2:"id";i:22464;s:5:"title";s:32:"Fly-In | Contact | Makeup Studio";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg";s:12:"tmpl_created";i:1647427026;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:22:"["Business","Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:7;a:19:{s:4:"tmpl";i:1290;s:2:"id";i:22470;s:5:"title";s:32:"Fly-In | Contact | Design Studio";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg";s:12:"tmpl_created";i:1647428250;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:39:"["Business","Contact","Digital Agency"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:8;a:19:{s:4:"tmpl";i:1291;s:2:"id";i:22480;s:5:"title";s:27:"Classic | CTA | MasterClass";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg";s:12:"tmpl_created";i:1647428474;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["cta","Magazine","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:9;a:19:{s:4:"tmpl";i:1292;s:2:"id";i:22489;s:5:"title";s:29:"Classic | CTA | Music Concert";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg";s:12:"tmpl_created";i:1647429738;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["cta","Landing Pages","Magazine"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:10;a:19:{s:4:"tmpl";i:1293;s:2:"id";i:22495;s:5:"title";s:27:"Classic | CTA | Music Album";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg";s:12:"tmpl_created";i:1647430056;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Ba","Landing Pages","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:11;a:19:{s:4:"tmpl";i:1294;s:2:"id";i:22501;s:5:"title";s:37:"Fly-In | CTA | Photography Exhibition";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg";s:12:"tmpl_created";i:1647430512;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:33:"["cta","Photography","Portfolio"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:12;a:19:{s:4:"tmpl";i:1295;s:2:"id";i:22507;s:5:"title";s:34:"Classic | CTA | Clothing Shop Sale";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg";s:12:"tmpl_created";i:1647430774;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:35:"["Ecommerce","Fashion","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:13;a:19:{s:4:"tmpl";i:1296;s:2:"id";i:22486;s:5:"title";s:30:"Classic | CTA | Shop Promotion";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg";s:12:"tmpl_created";i:1647430951;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["cta","Magazine","Photography"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:14;a:19:{s:4:"tmpl";i:1297;s:2:"id";i:22516;s:5:"title";s:32:"Fly-In | CTA | Glasses Shop Sale";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg";s:12:"tmpl_created";i:1647431136;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:30:"["Business","cta","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:15;a:19:{s:4:"tmpl";i:1298;s:2:"id";i:22522;s:5:"title";s:30:"Fly-In | Discount | Skate Shop";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg";s:12:"tmpl_created";i:1647434058;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:32:"["Discount","Ecommerce","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:16;a:19:{s:4:"tmpl";i:1299;s:2:"id";i:22532;s:5:"title";s:43:"Classic | Subscription | Basketball Academy";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg";s:12:"tmpl_created";i:1647434608;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:33:"["Education","Marketing","Sport"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:17;a:19:{s:4:"tmpl";i:1300;s:2:"id";i:22543;s:5:"title";s:38:"Classic | Discount | Veterinary Clinic";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg";s:12:"tmpl_created";i:1647435581;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["Discount","Pets"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:18;a:19:{s:4:"tmpl";i:1301;s:2:"id";i:22553;s:5:"title";s:39:"Classic | Contact | Business Consulting";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg";s:12:"tmpl_created";i:1647439935;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:22:"["Business","Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:19;a:19:{s:4:"tmpl";i:1302;s:2:"id";i:22562;s:5:"title";s:28:"Classic | Contact | Handyman";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg";s:12:"tmpl_created";i:1647440333;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:33:"["Business","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:20;a:19:{s:4:"tmpl";i:1303;s:2:"id";i:22573;s:5:"title";s:40:"Classic | Discount | Online Fashion Shop";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg";s:12:"tmpl_created";i:1647462549;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Discount","Ecommerce","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:21;a:19:{s:4:"tmpl";i:1304;s:2:"id";i:22583;s:5:"title";s:36:"Fly-In | Discount | Personal Trainer";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg";s:12:"tmpl_created";i:1647503781;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:31:"["Discount","Sport","Training"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:22;a:19:{s:4:"tmpl";i:1305;s:2:"id";i:22592;s:5:"title";s:41:"Classic | Contact | Illustrator Portfolio";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg";s:12:"tmpl_created";i:1647504218;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:49:"["Contact","Creative Portfolio","Digital Agency"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:23;a:19:{s:4:"tmpl";i:1306;s:2:"id";i:22602;s:5:"title";s:46:"Bottom Bar | Discount | Handmade Ceramics Shop";s:9:"thumbnail";s:91:"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg";s:12:"tmpl_created";i:1647507007;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:48:"["Business","cta","Ecommerce","Interior Design"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:24;a:19:{s:4:"tmpl";i:1307;s:2:"id";i:22612;s:5:"title";s:51:"Classic | Contact | Classic Car Restoration Company";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg";s:12:"tmpl_created";i:1647507310;s:6:"author";s:9:"Elementor";s:3:"url";s:153:"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Booking","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:25;a:19:{s:4:"tmpl";i:1308;s:2:"id";i:22621;s:5:"title";s:30:"Classic | Booking | Life Coach";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg";s:12:"tmpl_created";i:1647508596;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:33:"["Booking","Business","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:26;a:19:{s:4:"tmpl";i:1309;s:2:"id";i:22632;s:5:"title";s:42:"Classic |  Subscription | Merchandise Shop";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg";s:12:"tmpl_created";i:1647509196;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Ecommerce","Marketing","Shop"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:27;a:19:{s:4:"tmpl";i:1310;s:2:"id";i:22643;s:5:"title";s:48:"Fly-In | Contact | Non-Governmental Organization";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg";s:12:"tmpl_created";i:1647509528;s:6:"author";s:9:"Elementor";s:3:"url";s:150:"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:28;a:19:{s:4:"tmpl";i:1311;s:2:"id";i:22654;s:5:"title";s:35:"Hello Bar | Contact | Family Doctor";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg";s:12:"tmpl_created";i:1647509732;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:31:"["Contact","Health","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:29;a:19:{s:4:"tmpl";i:1312;s:2:"id";i:22663;s:5:"title";s:36:"Classic | Subscription | Sports Blog";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg";s:12:"tmpl_created";i:1647509908;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:16:"["Blog","Sport"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:30;a:19:{s:4:"tmpl";i:1313;s:2:"id";i:22673;s:5:"title";s:30:"Hello Bar | Booking | Event DJ";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg";s:12:"tmpl_created";i:1647510160;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:31:"["Booking","Events","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:31;a:19:{s:4:"tmpl";i:1314;s:2:"id";i:22684;s:5:"title";s:36:"Fly-In | Discount | Cleaning Company";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg";s:12:"tmpl_created";i:1647510546;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:31:"["Discount","Offer","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:32;a:19:{s:4:"tmpl";i:1315;s:2:"id";i:22693;s:5:"title";s:28:"Fly-In | Contact | Carpenter";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg";s:12:"tmpl_created";i:1647511972;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:22:"["Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:33;a:19:{s:4:"tmpl";i:1316;s:2:"id";i:22703;s:5:"title";s:31:"Classic | Booking | Yoga Studio";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg";s:12:"tmpl_created";i:1647512209;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:30:"["Booking","Contact","Health"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:34;a:19:{s:4:"tmpl";i:1317;s:2:"id";i:22714;s:5:"title";s:37:"Classic | Discount | Pet Care Company";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg";s:12:"tmpl_created";i:1647513031;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:17:"["Offer","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:35;a:19:{s:4:"tmpl";i:1318;s:2:"id";i:22725;s:5:"title";s:38:"Fly-In | Discount | Online Coffee Shop";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg";s:12:"tmpl_created";i:1647513325;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:29:"["Food","Offer","Restaurant"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:36;a:19:{s:4:"tmpl";i:1319;s:2:"id";i:22737;s:5:"title";s:44:"Fly-In | CTA | Moving &#038; Storage Company";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg";s:12:"tmpl_created";i:1647520956;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:37;a:19:{s:4:"tmpl";i:1320;s:2:"id";i:22749;s:5:"title";s:47:"Classic | Contact | Industrial Design Portfolio";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg";s:12:"tmpl_created";i:1647528116;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:40:"["Contact","Interior Design","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:38;a:19:{s:4:"tmpl";i:1321;s:2:"id";i:22759;s:5:"title";s:25:"Classic | Contact | Drone";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg";s:12:"tmpl_created";i:1647528899;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:22:"["Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:39;a:19:{s:4:"tmpl";i:1322;s:2:"id";i:22768;s:5:"title";s:46:"Full Screen | Menu | Fashion Stylist Portfolio";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg";s:12:"tmpl_created";i:1647529434;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:31:"["Fashion","Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:40;a:19:{s:4:"tmpl";i:1323;s:2:"id";i:22780;s:5:"title";s:31:"Fly-In | CTA | Landscape Design";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg";s:12:"tmpl_created";i:1647530337;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:18:"["cta","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:41;a:19:{s:4:"tmpl";i:1324;s:2:"id";i:22790;s:5:"title";s:48:"Bottom Bar  | Contact | Architecture Photography";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg";s:12:"tmpl_created";i:1647532358;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:26:"["Architecture","Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:42;a:19:{s:4:"tmpl";i:1325;s:2:"id";i:22800;s:5:"title";s:41:"Fly-In  | CTA | Speech-Language Therapist";s:9:"thumbnail";s:103:"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg";s:12:"tmpl_created";i:1647532720;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:25:"["cta","Psychotherapist"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:43;a:19:{s:4:"tmpl";i:1326;s:2:"id";i:22812;s:5:"title";s:35:"Full Screen | Verification | Winery";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg";s:12:"tmpl_created";i:1647761384;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:24:"["Alert","Verification"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:44;a:19:{s:4:"tmpl";i:1327;s:2:"id";i:22822;s:5:"title";s:36:"Fly-In | Subscription | Nutritionist";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg";s:12:"tmpl_created";i:1647762620;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:28:"["Food","Health","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:45;a:19:{s:4:"tmpl";i:1328;s:2:"id";i:22833;s:5:"title";s:40:"Classic | Subscription | App &#038; SaaS";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg";s:12:"tmpl_created";i:1647762955;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:14:"["App","SaaS"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:46;a:19:{s:4:"tmpl";i:1329;s:2:"id";i:22844;s:5:"title";s:41:"Bottom Bar | Discount | Handmade Cupcakes";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg";s:12:"tmpl_created";i:1647763350;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:21:"["Food","Restaurant"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:47;a:19:{s:4:"tmpl";i:1330;s:2:"id";i:22855;s:5:"title";s:40:"Bottom Bar | Subscription | Fashion Blog";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg";s:12:"tmpl_created";i:1647763907;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:30:"["Blog","Fashion","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:48;a:19:{s:4:"tmpl";i:1331;s:2:"id";i:22866;s:5:"title";s:28:"Fly-In | CTA | Private Tutor";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg";s:12:"tmpl_created";i:1647764062;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:49;a:19:{s:4:"tmpl";i:1332;s:2:"id";i:22876;s:5:"title";s:30:"Classic | CTA | Tennis Academy";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg";s:12:"tmpl_created";i:1647765192;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:50;a:19:{s:4:"tmpl";i:1333;s:2:"id";i:22887;s:5:"title";s:31:"Fly-In | CTA | Shared Workspace";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg";s:12:"tmpl_created";i:1647765419;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:18:"["Business","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:51;a:19:{s:4:"tmpl";i:1334;s:2:"id";i:22899;s:5:"title";s:30:"Bottom Bar | CTA | Art Gallery";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg";s:12:"tmpl_created";i:1647765652;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:13:"["Art","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:52;a:19:{s:4:"tmpl";i:1335;s:2:"id";i:22910;s:5:"title";s:44:"Fly-In | Subscription | Hiking Tours Company";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg";s:12:"tmpl_created";i:1647765835;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:29:"["Subscribe","Travel","Trip"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:53;a:19:{s:4:"tmpl";i:1336;s:2:"id";i:22921;s:5:"title";s:26:"Classic | CTA | Music Band";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg";s:12:"tmpl_created";i:1647769462;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:21:"["Marketing","Music"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:54;a:19:{s:4:"tmpl";i:1337;s:2:"id";i:22935;s:5:"title";s:35:"Classic | CTA | Computer Technician";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg";s:12:"tmpl_created";i:1647769843;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:18:"["cta","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:55;a:19:{s:4:"tmpl";i:1338;s:2:"id";i:22945;s:5:"title";s:37:"Classic | Discount | Delivery Company";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg";s:12:"tmpl_created";i:1647770834;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["Discount","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:56;a:19:{s:4:"tmpl";i:1339;s:2:"id";i:22959;s:5:"title";s:29:"Classic | Discount | Eco Shop";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg";s:12:"tmpl_created";i:1647771211;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:24:"["Discount","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:57;a:19:{s:4:"tmpl";i:1340;s:2:"id";i:22972;s:5:"title";s:54:"Fly-In | Subscription | Health &#038; Mindfulness Blog";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg";s:12:"tmpl_created";i:1647771461;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:21:"["Health","Magazine"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:58;a:19:{s:4:"tmpl";i:1341;s:2:"id";i:22982;s:5:"title";s:31:"Full Screen | Menu | Art Museum";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg";s:12:"tmpl_created";i:1647771938;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:59;a:19:{s:4:"tmpl";i:1342;s:2:"id";i:22992;s:5:"title";s:40:"Classic | Discount | Urban Clothing Shop";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg";s:12:"tmpl_created";i:1647773067;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Discount","Ecommerce","Fashion"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:60;a:19:{s:4:"tmpl";i:1343;s:2:"id";i:23004;s:5:"title";s:60:"Full Screen | Menu | Digital &#038; Technology Design School";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg";s:12:"tmpl_created";i:1647773366;s:6:"author";s:9:"Elementor";s:3:"url";s:155:"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:61;a:19:{s:4:"tmpl";i:1344;s:2:"id";i:23015;s:5:"title";s:62:"Bottom Bar | Contact | Digital &#038; Technology Design School";s:9:"thumbnail";s:93:"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg";s:12:"tmpl_created";i:1647773492;s:6:"author";s:9:"Elementor";s:3:"url";s:157:"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:23:"["Contact","Portfolio"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:62;a:19:{s:4:"tmpl";i:1345;s:2:"id";i:23025;s:5:"title";s:32:"Full Screen | Menu | Flower Shop";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg";s:12:"tmpl_created";i:1647773820;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:63;a:19:{s:4:"tmpl";i:1346;s:2:"id";i:23037;s:5:"title";s:36:"Classic | Subscription | Flower Shop";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg";s:12:"tmpl_created";i:1647773949;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:24:"["Discount","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:64;a:19:{s:4:"tmpl";i:1347;s:2:"id";i:23056;s:5:"title";s:48:"Classic | Discount | Health &#038; Fitness eBook";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg";s:12:"tmpl_created";i:1647774468;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["Contact","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:65;a:19:{s:4:"tmpl";i:1348;s:2:"id";i:23067;s:5:"title";s:37:"Fly-In | Menu | Baby Sleep Consultant";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg";s:12:"tmpl_created";i:1647778954;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:66;a:19:{s:4:"tmpl";i:1349;s:2:"id";i:23077;s:5:"title";s:46:"Classic | Subscription | Baby Sleep Consultant";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg";s:12:"tmpl_created";i:1647779074;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:12:"["Discount"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:67;a:19:{s:4:"tmpl";i:1350;s:2:"id";i:23090;s:5:"title";s:33:"Full Screen | Menu | Luxury Hotel";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg";s:12:"tmpl_created";i:1647779390;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:68;a:19:{s:4:"tmpl";i:1351;s:2:"id";i:23100;s:5:"title";s:31:"Fly-In | Booking | Luxury Hotel";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg";s:12:"tmpl_created";i:1647779500;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:20:"["Booking","Travel"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:69;a:19:{s:4:"tmpl";i:1352;s:2:"id";i:23109;s:5:"title";s:38:"Full Screen | Menu | Design Conference";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg";s:12:"tmpl_created";i:1647779675;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:70;a:19:{s:4:"tmpl";i:1353;s:2:"id";i:23120;s:5:"title";s:41:"Full Screen | Booking | Design Conference";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg";s:12:"tmpl_created";i:1647779793;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:35:"["Booking","Conference","Creative"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:71;a:19:{s:4:"tmpl";i:1354;s:2:"id";i:23129;s:5:"title";s:29:"Slide-In | Menu | VR Headsets";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg";s:12:"tmpl_created";i:1647781211;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:72;a:19:{s:4:"tmpl";i:1355;s:2:"id";i:23139;s:5:"title";s:31:"Classic | Contact | VR Headsets";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg";s:12:"tmpl_created";i:1647781384;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:73;a:19:{s:4:"tmpl";i:1356;s:2:"id";i:23149;s:5:"title";s:38:"Slide-In | Menu | Portrait Photography";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg";s:12:"tmpl_created";i:1647782336;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:74;a:19:{s:4:"tmpl";i:1357;s:2:"id";i:23159;s:5:"title";s:47:"Hello Bar | Subscription | Portrait Photography";s:9:"thumbnail";s:97:"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg";s:12:"tmpl_created";i:1647782478;s:6:"author";s:9:"Elementor";s:3:"url";s:149:"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:34:"["Blog","Photography","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:75;a:19:{s:4:"tmpl";i:1358;s:2:"id";i:23169;s:5:"title";s:32:"Full Screen | Menu | English Pub";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg";s:12:"tmpl_created";i:1647782664;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:76;a:19:{s:4:"tmpl";i:1359;s:2:"id";i:23179;s:5:"title";s:32:"Classic | Discount | English Pub";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg";s:12:"tmpl_created";i:1647782796;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:20:"["Discount","Offer"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:77;a:19:{s:4:"tmpl";i:1360;s:2:"id";i:23189;s:5:"title";s:27:"Full Screen | Menu | Singer";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg";s:12:"tmpl_created";i:1647783070;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:29:"["Fullscreen","menu","Music"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:78;a:19:{s:4:"tmpl";i:1361;s:2:"id";i:23200;s:5:"title";s:31:"Classic | Subscription | Singer";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg";s:12:"tmpl_created";i:1647783249;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:21:"["Music","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:79;a:19:{s:4:"tmpl";i:1362;s:2:"id";i:23210;s:5:"title";s:38:"Full Screen | Menu | Virtual Assistant";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg";s:12:"tmpl_created";i:1647784292;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:80;a:19:{s:4:"tmpl";i:1363;s:2:"id";i:23223;s:5:"title";s:39:"Hello Bar | Contact | Virtual Assistant";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg";s:12:"tmpl_created";i:1647784616;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:37:"["Contact","Psychologist","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:81;a:19:{s:4:"tmpl";i:1364;s:2:"id";i:23234;s:5:"title";s:32:"Slide-In  | Menu | Personal Chef";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg";s:12:"tmpl_created";i:1647798194;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:8:"["menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:82;a:19:{s:4:"tmpl";i:1365;s:2:"id";i:23244;s:5:"title";s:29:"Classic | CTA | Personal Chef";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg";s:12:"tmpl_created";i:1647798297;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:24:"["Booking","Chef","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:83;a:19:{s:4:"tmpl";i:1366;s:2:"id";i:23254;s:5:"title";s:31:"Full Screen | Menu | Food Truck";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg";s:12:"tmpl_created";i:1647798447;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:84;a:19:{s:4:"tmpl";i:1367;s:2:"id";i:23265;s:5:"title";s:30:"Fly-In | Discount | Food Truck";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg";s:12:"tmpl_created";i:1647798657;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:20:"["Discount","Offer"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:85;a:19:{s:4:"tmpl";i:1369;s:2:"id";i:23323;s:5:"title";s:28:"Classic | CTA | Black Friday";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg";s:12:"tmpl_created";i:1647855505;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:86;a:19:{s:4:"tmpl";i:1370;s:2:"id";i:23329;s:5:"title";s:29:"Slide-In | CTA | Black Friday";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg";s:12:"tmpl_created";i:1647855865;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:87;a:19:{s:4:"tmpl";i:1371;s:2:"id";i:23335;s:5:"title";s:31:"Slide-In | CTA | Black Friday 1";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg";s:12:"tmpl_created";i:1647856357;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:88;a:19:{s:4:"tmpl";i:1372;s:2:"id";i:23341;s:5:"title";s:30:"Classic | CTA | Black Friday 2";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg";s:12:"tmpl_created";i:1647856493;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:89;a:19:{s:4:"tmpl";i:1373;s:2:"id";i:23347;s:5:"title";s:30:"Classic | CTA | Black Friday 3";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg";s:12:"tmpl_created";i:1647856891;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:90;a:19:{s:4:"tmpl";i:1374;s:2:"id";i:23354;s:5:"title";s:30:"Classic | CTA | Black Friday 4";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg";s:12:"tmpl_created";i:1647856996;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Black Friday","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:91;a:19:{s:4:"tmpl";i:1375;s:2:"id";i:23394;s:5:"title";s:27:"Classic | CTA | Halloween 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg";s:12:"tmpl_created";i:1647857351;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:31:"["cta","Ecommerce","Halloween"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:92;a:19:{s:4:"tmpl";i:1376;s:2:"id";i:23401;s:5:"title";s:33:"Slide-In | Discount | Halloween 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg";s:12:"tmpl_created";i:1647857567;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:36:"["Discount","Ecommerce","Halloween"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:93;a:19:{s:4:"tmpl";i:1377;s:2:"id";i:23407;s:5:"title";s:33:"Slide-In | Discount | Halloween 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg";s:12:"tmpl_created";i:1647857814;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:36:"["Discount","Ecommerce","Halloween"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:94;a:19:{s:4:"tmpl";i:1378;s:2:"id";i:23416;s:5:"title";s:31:"Fly-In | Discount | Halloween 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg";s:12:"tmpl_created";i:1647858024;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:44:"["Discount","Ecommerce","Halloween","Offer"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:95;a:19:{s:4:"tmpl";i:1379;s:2:"id";i:23422;s:5:"title";s:36:"Classic | Subscription | Halloween 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg";s:12:"tmpl_created";i:1647858246;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:48:"["Discount","Ecommerce","Halloween","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:96;a:19:{s:4:"tmpl";i:1380;s:2:"id";i:23471;s:5:"title";s:28:"Slide-In | CTA | Christmas 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg";s:12:"tmpl_created";i:1647859193;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:19:"["Christmas","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:97;a:19:{s:4:"tmpl";i:1381;s:2:"id";i:23477;s:5:"title";s:28:"Slide-In | CTA | Christmas 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg";s:12:"tmpl_created";i:1647859838;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:19:"["Christmas","cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:98;a:19:{s:4:"tmpl";i:1382;s:2:"id";i:23483;s:5:"title";s:26:"Fly-In | CTA | Christmas 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg";s:12:"tmpl_created";i:1647860157;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:31:"["Christmas","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:99;a:19:{s:4:"tmpl";i:1383;s:2:"id";i:23489;s:5:"title";s:33:"Slide-In | Discount | Christmas 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg";s:12:"tmpl_created";i:1647860302;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:31:"["Christmas","cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:100;a:19:{s:4:"tmpl";i:1384;s:2:"id";i:23496;s:5:"title";s:32:"Classic | Discount | Christmas 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg";s:12:"tmpl_created";i:1647860454;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Christmas","Offer","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:101;a:19:{s:4:"tmpl";i:1385;s:2:"id";i:23523;s:5:"title";s:30:"Classic | CTA | Valentines Day";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg";s:12:"tmpl_created";i:1647860912;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["cta","Valentine\'s Day"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:102;a:19:{s:4:"tmpl";i:1386;s:2:"id";i:23529;s:5:"title";s:39:"Hello Bar | Discount | Valentines Day 2";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg";s:12:"tmpl_created";i:1647861064;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:30:"["Discount","Valentine\'s Day"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:103;a:19:{s:4:"tmpl";i:1387;s:2:"id";i:23536;s:5:"title";s:32:"Classic | CTA | Valentines Day 3";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg";s:12:"tmpl_created";i:1647861536;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["cta","Valentine\'s Day"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:104;a:19:{s:4:"tmpl";i:1388;s:2:"id";i:23586;s:5:"title";s:51:"Fly-In | Subscribe | Health &#038; Wellness Company";s:9:"thumbnail";s:103:"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg";s:12:"tmpl_created";i:1647862008;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:24:"["Business","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:105;a:19:{s:4:"tmpl";i:1389;s:2:"id";i:23592;s:5:"title";s:34:"Classic | Subscribe | Tech Company";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg";s:12:"tmpl_created";i:1647866706;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["Marketing","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:106;a:19:{s:4:"tmpl";i:1390;s:2:"id";i:23598;s:5:"title";s:36:"Classic | Contact Us | Fight Classes";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg";s:12:"tmpl_created";i:1647866869;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["Contact","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:107;a:19:{s:4:"tmpl";i:1391;s:2:"id";i:23611;s:5:"title";s:31:"Classic | CTA | Mochi Shop Sale";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg";s:12:"tmpl_created";i:1647867750;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:23:"["cta","Offer","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:108;a:19:{s:4:"tmpl";i:1392;s:2:"id";i:23618;s:5:"title";s:28:"Classic | CTA | Fashion Shop";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg";s:12:"tmpl_created";i:1647868251;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["cta","Ecommerce"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:109;a:19:{s:4:"tmpl";i:1393;s:2:"id";i:23624;s:5:"title";s:29:"Fly-In | Login | Tech Company";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg";s:12:"tmpl_created";i:1647868704;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:9:"["Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:110;a:19:{s:4:"tmpl";i:1394;s:2:"id";i:23630;s:5:"title";s:36:"Fly-In | Verification | Liquor Store";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg";s:12:"tmpl_created";i:1647870308;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:16:"["Verification"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:111;a:19:{s:4:"tmpl";i:1395;s:2:"id";i:23636;s:5:"title";s:39:"Hello Bar | Subscribe | Online Magazine";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg";s:12:"tmpl_created";i:1647870465;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:20:"["Blog","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:112;a:19:{s:4:"tmpl";i:1396;s:2:"id";i:23642;s:5:"title";s:27:"Fly-In | Login | Health Spa";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg";s:12:"tmpl_created";i:1647872427;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:20:"["Login","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:113;a:19:{s:4:"tmpl";i:1397;s:2:"id";i:23648;s:5:"title";s:33:"Fly-In | Verification | Wine Shop";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg";s:12:"tmpl_created";i:1647872627;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:16:"["Verification"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:114;a:19:{s:4:"tmpl";i:1421;s:2:"id";i:24235;s:5:"title";s:24:"Ladydog Club &#8211; NFT";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg";s:12:"tmpl_created";i:1651525072;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:115;a:19:{s:4:"tmpl";i:1422;s:2:"id";i:24166;s:5:"title";s:15:"Dot &#8211; NFT";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg";s:12:"tmpl_created";i:1651525117;s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:116;a:19:{s:4:"tmpl";i:1423;s:2:"id";i:24191;s:5:"title";s:28:"Cosmic Neighbors &#8211; NFT";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg";s:12:"tmpl_created";i:1651525124;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:117;a:19:{s:4:"tmpl";i:1424;s:2:"id";i:24255;s:5:"title";s:30:"Happy Food Friends &#8211; NFT";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg";s:12:"tmpl_created";i:1651525475;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:3:"NFT";s:4:"tags";s:100:"["Art","Author","Business","Creative","Design","Gallery","Landing Pages","NFT","Products","Virtual"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:118;a:19:{s:4:"tmpl";i:1443;s:2:"id";i:24599;s:5:"title";s:27:"Wireframe &#8211; Courses 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg";s:12:"tmpl_created";i:1653989626;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:180:"["About","Academy","Booking","Business","Course Online","Features","Footer","Landing Pages","Online Service","Professional","School","Services","Subscribe","Teacher","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:119;a:19:{s:4:"tmpl";i:1444;s:2:"id";i:24614;s:5:"title";s:28:"Wireframe &#8211; Services 1";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg";s:12:"tmpl_created";i:1653990084;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:139:"["About","Business","Contact","Features","Footer","Form","Header","Landing Pages","Online Service","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:120;a:19:{s:4:"tmpl";i:1445;s:2:"id";i:24629;s:5:"title";s:28:"Wireframe &#8211; Services 2";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg";s:12:"tmpl_created";i:1653990132;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:123:"["About","Business","Contact","Features","Footer","Form","Gallery","Landing Pages","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:121;a:19:{s:4:"tmpl";i:1446;s:2:"id";i:24644;s:5:"title";s:27:"Wireframe &#8211; Webinar 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg";s:12:"tmpl_created";i:1653990164;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:177:"["About","Academy","Booking","Conference","Course Online","Education","Features","Footer","Form","Landing Pages","Online Event","Online Service","Subscribe","Virtual","Webinar"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:122;a:19:{s:4:"tmpl";i:1447;s:2:"id";i:24655;s:5:"title";s:28:"Wireframe &#8211; Services 3";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg";s:12:"tmpl_created";i:1653990198;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:143:"["About","Agency","Business","Contact","Footer","Form","Gallery","Landing Pages","Portfolio","Professional","Project","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:123;a:19:{s:4:"tmpl";i:1448;s:2:"id";i:24677;s:5:"title";s:28:"Wireframe &#8211; Services 4";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg";s:12:"tmpl_created";i:1653990233;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:102:"["About","Business","Contact","Footer","Form","Landing Pages","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:124;a:19:{s:4:"tmpl";i:1449;s:2:"id";i:24687;s:5:"title";s:28:"Wireframe &#8211; Products 1";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg";s:12:"tmpl_created";i:1653990273;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:128:"["About","Booking","Business","Clients","Ecommerce","Features","Footer","Landing Pages","Products","Sales","Shop","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:125;a:19:{s:4:"tmpl";i:1450;s:2:"id";i:24706;s:5:"title";s:28:"Wireframe &#8211; Services 5";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg";s:12:"tmpl_created";i:1653990322;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Wireframe";s:4:"tags";s:149:"["About","Booking","Consulting","Contact","Doctor","Footer","Form","Header","Landing Pages","Online Service","Professional","Services","Testimonial"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:126;a:19:{s:4:"tmpl";i:1451;s:2:"id";i:23604;s:5:"title";s:38:"Classic | Subscribe | Nail Polish Shop";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg";s:12:"tmpl_created";i:1660205114;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:20:"["Blog","Subscribe"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:127;a:19:{s:4:"tmpl";i:1452;s:2:"id";i:23047;s:5:"title";s:46:"Fly-In | Contact | Health &#038; Fitness eBook";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg";s:12:"tmpl_created";i:1660205149;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:28:"["Contact","Ebook","Health"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:128;a:19:{s:4:"tmpl";i:1199;s:2:"id";i:18839;s:5:"title";s:27:"Hello Bar | CTA | eCommerce";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png";s:12:"tmpl_created";i:1621870603;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:41:"["Ecommerce","Online Shop","Sale","Shop"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:129;a:19:{s:4:"tmpl";i:1247;s:2:"id";i:21907;s:5:"title";s:50:"Fly-In | Team Details  | Electronic Music Festival";s:9:"thumbnail";s:104:"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg";s:12:"tmpl_created";i:1646660881;s:6:"author";s:9:"Elementor";s:3:"url";s:157:"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:130;a:19:{s:4:"tmpl";i:1253;s:2:"id";i:22162;s:5:"title";s:46:"Full Screen | Menu | Electronic Music Festival";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg";s:12:"tmpl_created";i:1647272934;s:6:"author";s:9:"Elementor";s:3:"url";s:154:"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:21:"["Fullscreen","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:131;a:19:{s:4:"tmpl";i:1254;s:2:"id";i:22172;s:5:"title";s:45:"Classic | Discount | Health &#038; Beauty Spa";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg";s:12:"tmpl_created";i:1647273547;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:36:"["Hair","Health","Sales","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:132;a:19:{s:4:"tmpl";i:1255;s:2:"id";i:22183;s:5:"title";s:44:"Hello Bar | CTA | Environmental Organization";s:9:"thumbnail";s:104:"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg";s:12:"tmpl_created";i:1647274384;s:6:"author";s:9:"Elementor";s:3:"url";s:152:"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:133;a:19:{s:4:"tmpl";i:1256;s:2:"id";i:22195;s:5:"title";s:39:"Classic | Discount | Italian Restaurant";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg";s:12:"tmpl_created";i:1647329432;s:6:"author";s:9:"Elementor";s:3:"url";s:147:"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:22:"["Restaurant","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:134;a:19:{s:4:"tmpl";i:1257;s:2:"id";i:22210;s:5:"title";s:45:"Bottom Bar | Discount | Technology Conference";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg";s:12:"tmpl_created";i:1647330423;s:6:"author";s:9:"Elementor";s:3:"url";s:153:"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:38:"["Conference","Sales","Save the Date"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:135;a:19:{s:4:"tmpl";i:1258;s:2:"id";i:22221;s:5:"title";s:32:"Hello Bar | Menu | Tattoo Studio";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg";s:12:"tmpl_created";i:1647330705;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:17:"["Header","menu"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:136;a:19:{s:4:"tmpl";i:1259;s:2:"id";i:22231;s:5:"title";s:37:"Full Screen | Booking | Tattoo Studio";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg";s:12:"tmpl_created";i:1647331823;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:32:"["Booking","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:137;a:19:{s:4:"tmpl";i:1260;s:2:"id";i:22251;s:5:"title";s:34:"Classic | Discount | Dental Clinic";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg";s:12:"tmpl_created";i:1647332171;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:30:"["Health","Marketing","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:138;a:19:{s:4:"tmpl";i:1261;s:2:"id";i:22261;s:5:"title";s:34:"Slide-In | Contact | Makeup Artist";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg";s:12:"tmpl_created";i:1647333946;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:33:"["Business","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:139;a:19:{s:4:"tmpl";i:1262;s:2:"id";i:22271;s:5:"title";s:24:"Fly-In | CTA | Headphone";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg";s:12:"tmpl_created";i:1647334784;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:41:"["cta","Ecommerce","Marketing","Product"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:140;a:19:{s:4:"tmpl";i:1263;s:2:"id";i:22277;s:5:"title";s:29:"Classic | CTA | Online Course";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg";s:12:"tmpl_created";i:1647337110;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:35:"["Course Online","cta","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:141;a:19:{s:4:"tmpl";i:1264;s:2:"id";i:22283;s:5:"title";s:40:"Bottom Bar | Contact | Virtual Assistant";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg";s:12:"tmpl_created";i:1647337517;s:6:"author";s:9:"Elementor";s:3:"url";s:148:"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:10:"bottom bar";s:4:"tags";s:33:"["Business","Contact","Services"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:142;a:19:{s:4:"tmpl";i:1265;s:2:"id";i:22289;s:5:"title";s:32:"Fly-In | Contact | Private Tutor";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg";s:12:"tmpl_created";i:1647337676;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:4:"free";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:27:"["Contact","Course Online"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:143;a:19:{s:4:"tmpl";i:1266;s:2:"id";i:22295;s:5:"title";s:31:"Classic |  Login | Login Travel";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg";s:12:"tmpl_created";i:1647339467;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"classic";s:4:"tags";s:9:"["Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:144;a:19:{s:4:"tmpl";i:1267;s:2:"id";i:22301;s:5:"title";s:36:"Full Screen | Login | Login Business";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg";s:12:"tmpl_created";i:1647339782;s:6:"author";s:9:"Elementor";s:3:"url";s:144:"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:16:"["Login","SaaS"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:145;a:19:{s:4:"tmpl";i:1268;s:2:"id";i:22307;s:5:"title";s:28:"Classic | Login | Login Blog";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg";s:12:"tmpl_created";i:1647339986;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:16:"["Blog","Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:146;a:19:{s:4:"tmpl";i:1269;s:2:"id";i:22313;s:5:"title";s:31:"Classic | Login | Login Fashion";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg";s:12:"tmpl_created";i:1647340204;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["Fashion","Login"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:147;a:19:{s:4:"tmpl";i:1270;s:2:"id";i:22319;s:5:"title";s:40:"Classic |  Login | Login Design Platform";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg";s:12:"tmpl_created";i:1647340531;s:6:"author";s:9:"Elementor";s:3:"url";s:147:"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:25:"["Design","Login","SaaS"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:148;a:19:{s:4:"tmpl";i:1271;s:2:"id";i:22325;s:5:"title";s:36:"Fly-In | Contact | Digital Marketing";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg";s:12:"tmpl_created";i:1647340770;s:6:"author";s:9:"Elementor";s:3:"url";s:144:"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:51:"["Business","Contact","Digital Agency","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:149;a:19:{s:4:"tmpl";i:1272;s:2:"id";i:22331;s:5:"title";s:36:"Fly-In | CTA | Dog Cat Food Delivery";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg";s:12:"tmpl_created";i:1647341069;s:6:"author";s:9:"Elementor";s:3:"url";s:144:"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:33:"["cta","Delivery Service","Pets"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:150;a:19:{s:4:"tmpl";i:1273;s:2:"id";i:22337;s:5:"title";s:37:"Full Screen | Contact | Design Studio";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg";s:12:"tmpl_created";i:1647341370;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:39:"["Business","Contact","Digital Agency"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:151;a:19:{s:4:"tmpl";i:1274;s:2:"id";i:22343;s:5:"title";s:44:"Classic | Contact | Support Product Platform";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg";s:12:"tmpl_created";i:1647341972;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:21:"["Contact","Support"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:152;a:19:{s:4:"tmpl";i:1275;s:2:"id";i:22371;s:5:"title";s:38:"Full Screen | Contact | Small Business";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg";s:12:"tmpl_created";i:1647342508;s:6:"author";s:9:"Elementor";s:3:"url";s:140:"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:40:"["Business","Contact","Interior Design"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:153;a:19:{s:4:"tmpl";i:1276;s:2:"id";i:22377;s:5:"title";s:31:"Classic | Contact | Online Shop";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg";s:12:"tmpl_created";i:1647352786;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:154;a:19:{s:4:"tmpl";i:1277;s:2:"id";i:22383;s:5:"title";s:40:"Classic | Booking | Children Optometrist";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg";s:12:"tmpl_created";i:1647352963;s:6:"author";s:9:"Elementor";s:3:"url";s:142:"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:53:"["Booking","Business","Contact","Education","Health"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:155;a:19:{s:4:"tmpl";i:1278;s:2:"id";i:22389;s:5:"title";s:28:"Fly-In | Contact | Open Week";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg";s:12:"tmpl_created";i:1647353281;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:34:"["Business","Contact","Marketing"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:156;a:19:{s:4:"tmpl";i:1279;s:2:"id";i:22397;s:5:"title";s:43:"Full Screen | CTA | Plant Pots Online Store";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg";s:12:"tmpl_created";i:1647353429;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:33:"["Ecommerce","Marketing","Sales"]";s:10:"menu_order";i:0;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:157;a:19:{s:4:"tmpl";i:1054;s:2:"id";i:15414;s:5:"title";s:32:"Classic | Contact | Dance Studio";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg";s:12:"tmpl_created";i:1603180596;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:762;s:11:"trend_index";i:650;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:158;a:19:{s:4:"tmpl";i:1398;s:2:"id";i:23687;s:5:"title";s:32:"Pizza Promotion &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg";s:12:"tmpl_created";i:1649670575;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:92:"["Business","Cooking","Delivery","Discount","Fast Food","Food","Landing Pages","Restaurant"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:159;a:19:{s:4:"tmpl";i:1400;s:2:"id";i:23751;s:5:"title";s:33:"Baby Sleep Webinar &#8211; Events";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg";s:12:"tmpl_created";i:1649676065;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:227:"["Baby","Booking","Business","Children","Course Online","Education","Events","Health","Landing Pages","Life Coach","Lifestyle","Online Event","Online Service","Parenting","Professional","Remote","Services","Training","Webinar"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:160;a:19:{s:4:"tmpl";i:1401;s:2:"id";i:23776;s:5:"title";s:34:"Ski Hotel Promotion &#8211; Travel";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg";s:12:"tmpl_created";i:1649691720;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Travel";s:4:"tags";s:118:"["Accommodation","Booking","Discount. Landing Pages","Lifestyle","Luxury","Services","Spa","Travel","Trip","Vacation"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:161;a:19:{s:4:"tmpl";i:1402;s:2:"id";i:23804;s:5:"title";s:30:"Cake Delivery &#8211; Business";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg";s:12:"tmpl_created";i:1649692909;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:101:"["Bakery","Business","Cake","Cooking","Delivery","Discount","Food","Landing Pages","Products","Shop"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:162;a:19:{s:4:"tmpl";i:1403;s:2:"id";i:23832;s:5:"title";s:32:"Furniture Store &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg";s:12:"tmpl_created";i:1649694812;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:232:"["Architecture","Art","Business","Construction","Coupon","Creative","Decor","Designer","Discount","Fashion","Furniture Design","Home","House","Interior Design","Landing Pages","Lifestyle","Products","Professional","Services","Shop"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:163;a:19:{s:4:"tmpl";i:1404;s:2:"id";i:23746;s:5:"title";s:22:"Nails &#8211; Business";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg";s:12:"tmpl_created";i:1649704635;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:173:"["Art","Beauty","Business","Colorful","Cosmetics","Creative","Design","Discount","Fashion","Girly","Landing Pages","Lifestyle","Manicure","Modern","Professional","Services"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:164;a:19:{s:4:"tmpl";i:1405;s:2:"id";i:23846;s:5:"title";s:29:"Music Festival &#8211; Events";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg";s:12:"tmpl_created";i:1649707763;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:6:"Events";s:4:"tags";s:128:"["Author","Booking","Business","Creative","Discount","Events","Landing Pages","Music","Online","Online Event","Party","Virtual"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:165;a:19:{s:4:"tmpl";i:1406;s:2:"id";i:23872;s:5:"title";s:40:"Fashion Styling Course &#8211; Education";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg";s:12:"tmpl_created";i:1649708569;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Education";s:4:"tags";s:173:"["Aesthetic","Art","Beauty","Business","Course Online","Creative","Discount","Education","Fashion","Landing Pages","Lifestyle","Online","Online Service","Stylist","Virtual"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:166;a:19:{s:4:"tmpl";i:1407;s:2:"id";i:23897;s:5:"title";s:33:"Bags Online Shop &#8211; Business";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg";s:12:"tmpl_created";i:1649709513;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:170:"["Art","Bag","Business","Creative","Design","Discount","Fashion","Landing Pages","Lifestyle","Luxury","Modern","Online","Online Shop","Products","Sales","Shop","Stylist"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:167;a:19:{s:4:"tmpl";i:1408;s:2:"id";i:23932;s:5:"title";s:32:"Cooking Academy &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg";s:12:"tmpl_created";i:1649710216;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:145:"["Academy","Booking","Business","Chef","Cooking","Education","Food","Free Trial","Landing Pages","Professional","School","Teacher","Testimonial"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:168;a:19:{s:4:"tmpl";i:1409;s:2:"id";i:23970;s:5:"title";s:45:"Ophthalmology Medical Clinic &#8211; Business";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg";s:12:"tmpl_created";i:1649711096;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:165:"["About","Business","Care","Consulting","Eye","Free Trial","Glasses","Health","Landing Pages","Lifestyle","Medical","Modern","Optometrist","Professional","Services"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:169;a:19:{s:4:"tmpl";i:1425;s:2:"id";i:24331;s:5:"title";s:24:"Wireframe &#8211; Home 1";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg";s:12:"tmpl_created";i:1653988363;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:102:"["Business","Contact","Features","Footer","Header","Homepage","Professional","Services","Testimonial"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:170;a:19:{s:4:"tmpl";i:1218;s:2:"id";i:20792;s:5:"title";s:26:"Luxury Car &#8211; Product";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg";s:12:"tmpl_created";i:1636903770;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"Product";s:4:"tags";s:54:"["car","Ecommerce","Landing Pages","Luxury","Product"]";s:10:"menu_order";i:1;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:171;a:19:{s:4:"tmpl";i:1428;s:2:"id";i:24398;s:5:"title";s:25:"Wireframe &#8211; About 1";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg";s:12:"tmpl_created";i:1653988534;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:83:"["About","Business","Contact","Features","Footer","Professional","Services","Team"]";s:10:"menu_order";i:2;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:172;a:19:{s:4:"tmpl";i:991;s:2:"id";i:13413;s:5:"title";s:33:"Classic | Contact | Online Course";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg";s:12:"tmpl_created";i:1587474761;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:2;s:16:"popularity_index";i:530;s:11:"trend_index";i:369;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:173;a:19:{s:4:"tmpl";i:1053;s:2:"id";i:15272;s:5:"title";s:32:"Classic | Contact | Psychologist";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png";s:12:"tmpl_created";i:1600170487;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:578;s:11:"trend_index";i:312;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:174;a:19:{s:4:"tmpl";i:899;s:2:"id";i:11839;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png";s:12:"tmpl_created";i:1569430015;s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:43:"["creative portfolio","header","portfolio"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:189;s:11:"trend_index";i:20;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:175;a:19:{s:4:"tmpl";i:1433;s:2:"id";i:24477;s:5:"title";s:27:"Wireframe &#8211; Gallery 2";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg";s:12:"tmpl_created";i:1653988835;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:82:"["Business","Contact","Design","Footer","Gallery","Header","Portfolio","Services"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:176;a:19:{s:4:"tmpl";i:1205;s:2:"id";i:20233;s:5:"title";s:32:"Art Magazine &#8211; Coming Soon";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1633881371;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:48:"["Art","Coming Soon","Landing Pages","Magazine"]";s:10:"menu_order";i:3;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:177;a:19:{s:4:"tmpl";i:1214;s:2:"id";i:20539;s:5:"title";s:31:"Design Blog &#8211; Coming Soon";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1634022706;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:47:"["Blog","Coming Soon","Design","Landing Pages"]";s:10:"menu_order";i:4;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:178;a:19:{s:4:"tmpl";i:1224;s:2:"id";i:21013;s:5:"title";s:24:"Restaurant &#8211; About";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg";s:12:"tmpl_created";i:1638795588;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:36:"["About","Chef","Food","Restaurant"]";s:10:"menu_order";i:4;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:179;a:19:{s:4:"tmpl";i:992;s:2:"id";i:13402;s:5:"title";s:29:"Classic | CTA | Online Course";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg";s:12:"tmpl_created";i:1587474772;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:4;s:16:"popularity_index";i:619;s:11:"trend_index";i:582;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:180;a:19:{s:4:"tmpl";i:1206;s:2:"id";i:20254;s:5:"title";s:41:"Digital Marketing Agency &#8211; Business";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg";s:12:"tmpl_created";i:1633882427;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:65:"["Agency","Business","Digital Agency","Landing Pages","Services"]";s:10:"menu_order";i:5;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:181;a:19:{s:4:"tmpl";i:1235;s:2:"id";i:21281;s:5:"title";s:25:"Law Firm &#8211; Services";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg";s:12:"tmpl_created";i:1638819128;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Consulting","Law","Law Firm","Services","Testimonial"]";s:10:"menu_order";i:5;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:182;a:19:{s:4:"tmpl";i:1017;s:2:"id";i:14111;s:5:"title";s:36:"Classic | Japanese restaurant | Sale";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg";s:12:"tmpl_created";i:1592300400;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:5;s:16:"popularity_index";i:717;s:11:"trend_index";i:697;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:183;a:19:{s:4:"tmpl";i:1213;s:2:"id";i:20509;s:5:"title";s:40:"Dogs Adoption &#8211; Social Involvement";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg";s:12:"tmpl_created";i:1634022353;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Social Involvement";s:4:"tags";s:49:"["Adoption","Involvement","Landing Pages","Pets"]";s:10:"menu_order";i:6;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:184;a:19:{s:4:"tmpl";i:1233;s:2:"id";i:21205;s:5:"title";s:29:"Photographer &#8211; Projects";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg";s:12:"tmpl_created";i:1638818372;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:43:"["Black and white","Photography","Project"]";s:10:"menu_order";i:6;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:185;a:19:{s:4:"tmpl";i:993;s:2:"id";i:13422;s:5:"title";s:30:"Classic | Menu | Online Course";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg";s:12:"tmpl_created";i:1587474782;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"classic";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:6;s:16:"popularity_index";i:516;s:11:"trend_index";i:432;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:186;a:19:{s:4:"tmpl";i:925;s:2:"id";i:12540;s:5:"title";s:33:"Classic | Menu | Travel and tours";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png";s:12:"tmpl_created";i:1575960267;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:7;s:16:"popularity_index";i:690;s:11:"trend_index";i:714;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:187;a:19:{s:4:"tmpl";i:1208;s:2:"id";i:20361;s:5:"title";s:51:"Exercise &#038; Fitness Equipment &#8211; eCommerce";s:9:"thumbnail";s:97:"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg";s:12:"tmpl_created";i:1633883766;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:50:"["Fitness","Health","Landing Pages","Online Shop"]";s:10:"menu_order";i:7;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:188;a:19:{s:4:"tmpl";i:1239;s:2:"id";i:21373;s:5:"title";s:28:"Photographer &#8211; Gallery";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg";s:12:"tmpl_created";i:1638821177;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Gallery","Photography","Portfolio","Project","Travel"]";s:10:"menu_order";i:7;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:189;a:19:{s:4:"tmpl";i:1426;s:2:"id";i:24348;s:5:"title";s:24:"Wireframe &#8211; Home 2";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg";s:12:"tmpl_created";i:1653988444;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:102:"["Business","Contact","Features","Footer","Header","Homepage","Professional","Services","Testimonial"]";s:10:"menu_order";i:8;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:190;a:19:{s:4:"tmpl";i:958;s:2:"id";i:13129;s:5:"title";s:28:"Classic | Menu | Photography";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png";s:12:"tmpl_created";i:1582092645;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:8;s:16:"popularity_index";i:646;s:11:"trend_index";i:521;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:191;a:19:{s:4:"tmpl";i:1427;s:2:"id";i:24366;s:5:"title";s:24:"Wireframe &#8211; Home 3";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg";s:12:"tmpl_created";i:1653988491;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:102:"["Business","Contact","Features","Footer","Header","Homepage","Professional","Services","Testimonial"]";s:10:"menu_order";i:9;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:192;a:19:{s:4:"tmpl";i:1207;s:2:"id";i:20299;s:5:"title";s:51:"Interior Design Consultation &#8211; Online Service";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg";s:12:"tmpl_created";i:1633882989;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:65:"["Consulting","Interior Design","Landing Pages","Online Service"]";s:10:"menu_order";i:9;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:193;a:19:{s:4:"tmpl";i:952;s:2:"id";i:12726;s:5:"title";s:52:"Classic | Newsletter | Subscribe | Magazine and Blog";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png";s:12:"tmpl_created";i:1579061019;s:6:"author";s:9:"Elementor";s:3:"url";s:152:"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:9;s:16:"popularity_index";i:357;s:11:"trend_index";i:281;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:194;a:19:{s:4:"tmpl";i:883;s:2:"id";i:11468;s:5:"title";s:20:"Classic | Sale | Gym";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png";s:12:"tmpl_created";i:1567393182;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:2:"[]";s:10:"menu_order";i:10;s:16:"popularity_index";i:696;s:11:"trend_index";i:740;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:195;a:19:{s:4:"tmpl";i:1216;s:2:"id";i:20623;s:5:"title";s:57:"Luxurious Camping Accommodation For Events &#8211; Events";s:9:"thumbnail";s:113:"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg";s:12:"tmpl_created";i:1634041681;s:6:"author";s:9:"Elementor";s:3:"url";s:151:"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:43:"["Event","Events","Landing Pages","Travel"]";s:10:"menu_order";i:10;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:196;a:19:{s:4:"tmpl";i:1219;s:2:"id";i:20886;s:5:"title";s:28:"Online Training &#8211; Home";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg";s:12:"tmpl_created";i:1638784769;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Fitness","Online","Sport","Training"]";s:10:"menu_order";i:10;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:197;a:19:{s:4:"tmpl";i:1065;s:2:"id";i:15570;s:5:"title";s:33:"Classic | Subscribe | Travel Blog";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg";s:12:"tmpl_created";i:1606215555;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:11;s:16:"popularity_index";i:709;s:11:"trend_index";i:459;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:198;a:19:{s:4:"tmpl";i:1431;s:2:"id";i:24437;s:5:"title";s:25:"Wireframe &#8211; About 4";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg";s:12:"tmpl_created";i:1653988733;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:74:"["About","Business","Contact","Features","Footer","Header","Professional"]";s:10:"menu_order";i:11;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:199;a:19:{s:4:"tmpl";i:1210;s:2:"id";i:20414;s:5:"title";s:45:"Online English Courses &#8211; Online Service";s:9:"thumbnail";s:93:"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg";s:12:"tmpl_created";i:1633884482;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:50:"["Course Online","Landing Pages","Online Service"]";s:10:"menu_order";i:11;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:200;a:19:{s:4:"tmpl";i:1132;s:2:"id";i:16553;s:5:"title";s:31:"Fly-In | Contact | Beauty Salon";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg";s:12:"tmpl_created";i:1608622602;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:12;s:16:"popularity_index";i:691;s:11:"trend_index";i:428;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:201;a:19:{s:4:"tmpl";i:1441;s:2:"id";i:24574;s:5:"title";s:27:"Wireframe &#8211; Contact 5";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg";s:12:"tmpl_created";i:1653989135;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:88:"["Business","Contact","Footer","Form","Google Maps","Header","Professional","Subscribe"]";s:10:"menu_order";i:12;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:202;a:19:{s:4:"tmpl";i:1217;s:2:"id";i:20333;s:5:"title";s:40:"Plant Pots Online Shop &#8211; eCommerce";s:9:"thumbnail";s:93:"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg";s:12:"tmpl_created";i:1634042184;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:50:"["Ecommerce","Landing Pages","Online Shop","Shop"]";s:10:"menu_order";i:12;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:203;a:19:{s:4:"tmpl";i:1211;s:2:"id";i:20447;s:5:"title";s:33:"Shared Workspace &#8211; Business";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg";s:12:"tmpl_created";i:1633884934;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:28:"["Business","Landing Pages"]";s:10:"menu_order";i:13;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:204;a:19:{s:4:"tmpl";i:1237;s:2:"id";i:21313;s:5:"title";s:34:"Spa &#038; Beauty &#8211; Services";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg";s:12:"tmpl_created";i:1638819709;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:55:"["Beauty","Hair","Health","Services","Spa","Treatment"]";s:10:"menu_order";i:13;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:205;a:19:{s:4:"tmpl";i:1004;s:2:"id";i:13538;s:5:"title";s:32:"Fly-In | Newsletter | Barbershop";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg";s:12:"tmpl_created";i:1589893364;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:13;s:16:"popularity_index";i:710;s:11:"trend_index";i:667;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:206;a:19:{s:4:"tmpl";i:924;s:2:"id";i:12550;s:5:"title";s:32:"Fly-in | Sale | Travel and Tours";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png";s:12:"tmpl_created";i:1575960263;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:14;s:16:"popularity_index";i:754;s:11:"trend_index";i:791;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:207;a:19:{s:4:"tmpl";i:1212;s:2:"id";i:20479;s:5:"title";s:49:"Teeth Straightening &#8211; Health &#038; Fitness";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg";s:12:"tmpl_created";i:1633886115;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:46:"["Business","Dental","Health","Landing Pages"]";s:10:"menu_order";i:14;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:208;a:19:{s:4:"tmpl";i:1234;s:2:"id";i:21234;s:5:"title";s:34:"Insurance Company &#8211; Services";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg";s:12:"tmpl_created";i:1638818688;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:51:"["Faq","Form","Insurance","Services","Testimonial"]";s:10:"menu_order";i:14;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:209;a:19:{s:4:"tmpl";i:1035;s:2:"id";i:15062;s:5:"title";s:35:"Fly-In | Sign up | Flooring Company";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png";s:12:"tmpl_created";i:1597739629;s:6:"author";s:9:"Elementor";s:3:"url";s:137:"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"fly-in";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:15;s:16:"popularity_index";i:625;s:11:"trend_index";i:309;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:210;a:19:{s:4:"tmpl";i:1209;s:2:"id";i:20394;s:5:"title";s:30:"Time Management &#8211; Events";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg";s:12:"tmpl_created";i:1633884077;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:17:"["Landing Pages"]";s:10:"menu_order";i:15;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:211;a:19:{s:4:"tmpl";i:1229;s:2:"id";i:21118;s:5:"title";s:28:"Contact &#8211; Plants Store";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg";s:12:"tmpl_created";i:1638802472;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:40:"["Contact","Info","Plant","Testimonial"]";s:10:"menu_order";i:15;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:212;a:19:{s:4:"tmpl";i:893;s:2:"id";i:11822;s:5:"title";s:30:"Full Screen | Menu | Portfolio";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png";s:12:"tmpl_created";i:1569429896;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:2:"[]";s:10:"menu_order";i:16;s:16:"popularity_index";i:654;s:11:"trend_index";i:626;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:213;a:19:{s:4:"tmpl";i:1203;s:2:"id";i:18591;s:5:"title";s:28:"Coffee Sale &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png";s:12:"tmpl_created";i:1633877319;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:33:"["Coffee","Landing Pages","Sale"]";s:10:"menu_order";i:16;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:214;a:19:{s:4:"tmpl";i:1231;s:2:"id";i:21184;s:5:"title";s:28:"Dental Care &#8211; Services";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg";s:12:"tmpl_created";i:1638807148;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:45:"["Dental","Medical","Services","Testimonial"]";s:10:"menu_order";i:16;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:215;a:19:{s:4:"tmpl";i:1064;s:2:"id";i:15580;s:5:"title";s:31:"Fullscreen | Menu | Travel Blog";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg";s:12:"tmpl_created";i:1606215358;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"full screen";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:17;s:16:"popularity_index";i:673;s:11:"trend_index";i:348;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:216;a:19:{s:4:"tmpl";i:1133;s:2:"id";i:16645;s:5:"title";s:28:"Headphones &#8211; eCommerce";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png";s:12:"tmpl_created";i:1609944115;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:39:"["Ecommerce","Landing Pages","Product"]";s:10:"menu_order";i:17;s:16:"popularity_index";i:633;s:11:"trend_index";i:87;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:217;a:19:{s:4:"tmpl";i:1442;s:2:"id";i:24584;s:5:"title";s:27:"Wireframe &#8211; Pricing 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg";s:12:"tmpl_created";i:1653989152;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:146:"["Booking","Business","Clients","Contact","Faq","Features","Footer","Online Service","Pricing","Products","Professional","Services","Testimonial"]";s:10:"menu_order";i:17;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:218;a:19:{s:4:"tmpl";i:1138;s:2:"id";i:16762;s:5:"title";s:25:"Conference &#8211; Events";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png";s:12:"tmpl_created";i:1610455119;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:6:"Events";s:4:"tags";s:60:"["Conference","Convention","Event","Events","Landing Pages"]";s:10:"menu_order";i:18;s:16:"popularity_index";i:705;s:11:"trend_index";i:216;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:219;a:19:{s:4:"tmpl";i:1438;s:2:"id";i:24539;s:5:"title";s:27:"Wireframe &#8211; Contact 2";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg";s:12:"tmpl_created";i:1653989019;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:69:"["Business","Contact","Footer","Google Maps","Header","Professional"]";s:10:"menu_order";i:18;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:220;a:19:{s:4:"tmpl";i:981;s:2:"id";i:13281;s:5:"title";s:37:"Hello Bar | Contact | Interior Design";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png";s:12:"tmpl_created";i:1586148801;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:19:"["Interior Design"]";s:10:"menu_order";i:18;s:16:"popularity_index";i:763;s:11:"trend_index";i:679;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:221;a:19:{s:4:"tmpl";i:1052;s:2:"id";i:15259;s:5:"title";s:31:"Hello Bar | Menu | Psychologist";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png";s:12:"tmpl_created";i:1600170209;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"hello bar";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:19;s:16:"popularity_index";i:739;s:11:"trend_index";i:583;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:222;a:19:{s:4:"tmpl";i:1434;s:2:"id";i:24494;s:5:"title";s:28:"Wireframe &#8211; Services 1";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg";s:12:"tmpl_created";i:1653988874;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:53:"["Business","Faq","Footer","Professional","Services"]";s:10:"menu_order";i:19;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:223;a:19:{s:4:"tmpl";i:1194;s:2:"id";i:18701;s:5:"title";s:32:"Digital Course &#8211; eCommerce";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg";s:12:"tmpl_created";i:1618995134;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:57:"["Course Online","Ecommerce","Landing Pages","Marketing"]";s:10:"menu_order";i:19;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:224;a:19:{s:4:"tmpl";i:1192;s:2:"id";i:18612;s:5:"title";s:34:"Bag Product Sale &#8211; eCommerce";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg";s:12:"tmpl_created";i:1618395406;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:61:"["Bag","Ecommerce","Landing Pages","Product","Sale","Travel"]";s:10:"menu_order";i:20;s:16:"popularity_index";i:875;s:11:"trend_index";i:605;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:225;a:19:{s:4:"tmpl";i:1227;s:2:"id";i:21083;s:5:"title";s:26:"Conference &#8211; Contact";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg";s:12:"tmpl_created";i:1638799208;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:44:"["Conference","Contact","Form","Info","Map"]";s:10:"menu_order";i:20;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:226;a:19:{s:4:"tmpl";i:1193;s:2:"id";i:18644;s:5:"title";s:37:"Camera Product Sale &#8211; eCommerce";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg";s:12:"tmpl_created";i:1618396388;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:59:"["Camera","Ecommerce","Landing Pages","Photography","Sale"]";s:10:"menu_order";i:21;s:16:"popularity_index";i:873;s:11:"trend_index";i:535;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:227;a:19:{s:4:"tmpl";i:951;s:2:"id";i:12736;s:5:"title";s:41:"Slide In | Contact Us | Magazine and Blog";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png";s:12:"tmpl_created";i:1579060978;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:21;s:16:"popularity_index";i:734;s:11:"trend_index";i:686;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:228;a:19:{s:4:"tmpl";i:1222;s:2:"id";i:20960;s:5:"title";s:26:"Travel Agency &#8211; Home";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg";s:12:"tmpl_created";i:1638788432;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:53:"["Adventures","Experience","Explore","Travel","Trip"]";s:10:"menu_order";i:21;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:229;a:19:{s:4:"tmpl";i:1196;s:2:"id";i:18815;s:5:"title";s:25:"Car Wash &#8211; Business";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png";s:12:"tmpl_created";i:1621336431;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:45:"["Business","car","Discount","Landing Pages"]";s:10:"menu_order";i:22;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:230;a:19:{s:4:"tmpl";i:1242;s:2:"id";i:21473;s:5:"title";s:40:"Architecture Photography &#8211; Gallery";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg";s:12:"tmpl_created";i:1638822115;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:52:"["Architecture","Gallery","Photography","Portfolio"]";s:10:"menu_order";i:22;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:231;a:19:{s:4:"tmpl";i:1015;s:2:"id";i:14067;s:5:"title";s:37:"Slide In | Japanese restaurant | Menu";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg";s:12:"tmpl_created";i:1592290352;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:22;s:16:"popularity_index";i:650;s:11:"trend_index";i:565;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:232;a:19:{s:4:"tmpl";i:923;s:2:"id";i:12229;s:5:"title";s:33:"Slide In | Law Firm | Information";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2019/11/popup.png";s:12:"tmpl_created";i:1572847842;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:23;s:16:"popularity_index";i:547;s:11:"trend_index";i:413;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:233;a:19:{s:4:"tmpl";i:1198;s:2:"id";i:18824;s:5:"title";s:33:"Design School &#8211; Coming Soon";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png";s:12:"tmpl_created";i:1621336756;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:49:"["Coming Soon","Design","Landing Pages","School"]";s:10:"menu_order";i:23;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:234;a:19:{s:4:"tmpl";i:1236;s:2:"id";i:21259;s:5:"title";s:28:"3D Designer &#8211; Projects";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg";s:12:"tmpl_created";i:1638819185;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:69:"["3D","Creative Portfolio","Design","Designer","Portfolio","Project"]";s:10:"menu_order";i:23;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:235;a:19:{s:4:"tmpl";i:1028;s:2:"id";i:14827;s:5:"title";s:39:"Slide-In | Contact | Luxury Real Estate";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png";s:12:"tmpl_created";i:1595323523;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:24;s:16:"popularity_index";i:559;s:11:"trend_index";i:284;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:236;a:19:{s:4:"tmpl";i:1197;s:2:"id";i:18819;s:5:"title";s:27:"Dog Walker &#8211; Business";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png";s:12:"tmpl_created";i:1621336601;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:41:"["Business","Dog","Landing Pages","Pets"]";s:10:"menu_order";i:24;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:237;a:19:{s:4:"tmpl";i:1238;s:2:"id";i:21349;s:5:"title";s:29:"Architecture &#8211; Projects";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg";s:12:"tmpl_created";i:1638820870;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:70:"["Architecture","Creative","Creative Portfolio","Portfolio","Project"]";s:10:"menu_order";i:24;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:238;a:19:{s:4:"tmpl";i:1034;s:2:"id";i:15075;s:5:"title";s:34:"Slide-In | Menu | Flooring Company";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png";s:12:"tmpl_created";i:1597739605;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"slide-in";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:25;s:16:"popularity_index";i:383;s:11:"trend_index";i:162;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:239;a:19:{s:4:"tmpl";i:1414;s:2:"id";i:24079;s:5:"title";s:32:"Fashion Shop &#8211; Coming Soon";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg";s:12:"tmpl_created";i:1650988089;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:88:"["Aesthetic","Business","Coming Soon","Ecommerce","Girly","Lifestyle","Products","Shop"]";s:10:"menu_order";i:25;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:240;a:19:{s:4:"tmpl";i:1195;s:2:"id";i:18761;s:5:"title";s:33:"Fashion Store &#8211; Coming Soon";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png";s:12:"tmpl_created";i:1621336146;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:56:"["Coming Soon","Fashion","Landing Pages","Shop","store"]";s:10:"menu_order";i:25;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:241;a:19:{s:4:"tmpl";i:1153;s:2:"id";i:17060;s:5:"title";s:36:"Private Tutor &#8211; Online Service";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png";s:12:"tmpl_created";i:1610631042;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:64:"["Education","Landing Pages","Online Service","Teacher","Tutor"]";s:10:"menu_order";i:26;s:16:"popularity_index";i:780;s:11:"trend_index";i:628;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:242;a:19:{s:4:"tmpl";i:1430;s:2:"id";i:24434;s:5:"title";s:25:"Wireframe &#8211; About 3";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg";s:12:"tmpl_created";i:1653988697;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:76:"["About","Business","Contact","Faq","Footer","Header","Professional","Team"]";s:10:"menu_order";i:26;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:243;a:19:{s:4:"tmpl";i:1158;s:2:"id";i:17232;s:5:"title";s:33:"Life Coach &#8211; Online Service";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png";s:12:"tmpl_created";i:1610902793;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:38:"["Coach","Landing Pages","Life Coach"]";s:10:"menu_order";i:27;s:16:"popularity_index";i:787;s:11:"trend_index";i:751;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:244;a:19:{s:4:"tmpl";i:1436;s:2:"id";i:24515;s:5:"title";s:28:"Wireframe &#8211; Services 3";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg";s:12:"tmpl_created";i:1653988946;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:66:"["Business","Contact","Footer","Header","Professional","Services"]";s:10:"menu_order";i:27;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:245;a:19:{s:4:"tmpl";i:875;s:2:"id";i:11241;s:5:"title";s:36:"Classic | Digital Agency | Marketing";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg";s:12:"tmpl_created";i:1564643043;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"popup";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"classic";s:4:"tags";s:2:"[]";s:10:"menu_order";i:28;s:16:"popularity_index";i:362;s:11:"trend_index";i:315;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:246;a:19:{s:4:"tmpl";i:1146;s:2:"id";i:16932;s:5:"title";s:35:"Finance Consulting &#8211; Business";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png";s:12:"tmpl_created";i:1610532170;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:80:"["Advisor","Business","Consulting","Finance","Investment","Landing Pages","Tax"]";s:10:"menu_order";i:28;s:16:"popularity_index";i:790;s:11:"trend_index";i:630;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:247;a:19:{s:4:"tmpl";i:1429;s:2:"id";i:24421;s:5:"title";s:25:"Wireframe &#8211; About 2";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg";s:12:"tmpl_created";i:1653988579;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:87:"["About","Business","Contact","Faq","Features","Footer","Header","Professional","Team"]";s:10:"menu_order";i:28;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:248;a:19:{s:4:"tmpl";i:674;s:2:"id";i:8505;s:5:"title";s:11:"404 page 01";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg";s:12:"tmpl_created";i:1526415501;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:28;s:16:"popularity_index";i:533;s:11:"trend_index";i:222;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:249;a:19:{s:4:"tmpl";i:1136;s:2:"id";i:16721;s:5:"title";s:35:"Dental &#8211; Health &amp; Fitness";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg";s:12:"tmpl_created";i:1610448567;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:44:"["Dental","Doctor","Health","Landing Pages"]";s:10:"menu_order";i:29;s:16:"popularity_index";i:801;s:11:"trend_index";i:655;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:250;a:19:{s:4:"tmpl";i:1417;s:2:"id";i:24116;s:5:"title";s:32:"Tech Company &#8211; Coming Soon";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg";s:12:"tmpl_created";i:1650989265;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:87:"["Business","Coding","Coming Soon","Computer","Developer","IT","Services","Technology"]";s:10:"menu_order";i:29;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:251;a:19:{s:4:"tmpl";i:675;s:2:"id";i:8511;s:5:"title";s:11:"404 page 02";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg";s:12:"tmpl_created";i:1526415528;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:29;s:16:"popularity_index";i:347;s:11:"trend_index";i:155;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:252;a:19:{s:4:"tmpl";i:1161;s:2:"id";i:17269;s:5:"title";s:34:"Electronics Sale &#8211; eCommerce";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png";s:12:"tmpl_created";i:1610903298;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:29:"["Ecommerce","Landing Pages"]";s:10:"menu_order";i:30;s:16:"popularity_index";i:800;s:11:"trend_index";i:556;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:253;a:19:{s:4:"tmpl";i:1220;s:2:"id";i:20908;s:5:"title";s:42:"Packing &#038; Moving Company &#8211; Home";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg";s:12:"tmpl_created";i:1638786127;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Movers","Moving","Storge"]";s:10:"menu_order";i:30;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:254;a:19:{s:4:"tmpl";i:1152;s:2:"id";i:17032;s:5:"title";s:42:"Donate Computer &#8211; Social Involvement";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png";s:12:"tmpl_created";i:1610630585;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:18:"Social Involvement";s:4:"tags";s:67:"["Computer","Donate","Donation","Kids","Landing Pages","Nonprofit"]";s:10:"menu_order";i:31;s:16:"popularity_index";i:718;s:11:"trend_index";i:278;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:255;a:19:{s:4:"tmpl";i:672;s:2:"id";i:8512;s:5:"title";s:11:"404 page 03";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg";s:12:"tmpl_created";i:1526415449;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:31;s:16:"popularity_index";i:450;s:11:"trend_index";i:375;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:256;a:19:{s:4:"tmpl";i:1245;s:2:"id";i:21546;s:5:"title";s:28:"Interior Design &#8211; Home";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg";s:12:"tmpl_created";i:1639046269;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:68:"["Design","Form","Furniture Design","Interior Design","Testimonial"]";s:10:"menu_order";i:31;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:257;a:19:{s:4:"tmpl";i:1135;s:2:"id";i:16684;s:5:"title";s:34:"SaaS HR Management &#8211; Product";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png";s:12:"tmpl_created";i:1609945486;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"Product";s:4:"tags";s:39:"["HR","Landing Pages","Product","SaaS"]";s:10:"menu_order";i:32;s:16:"popularity_index";i:708;s:11:"trend_index";i:292;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:258;a:19:{s:4:"tmpl";i:671;s:2:"id";i:8513;s:5:"title";s:11:"404 page 04";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg";s:12:"tmpl_created";i:1526415417;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:32;s:16:"popularity_index";i:420;s:11:"trend_index";i:176;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:259;a:19:{s:4:"tmpl";i:1249;s:2:"id";i:22137;s:5:"title";s:31:"Design Blog &#8211; Coming Soon";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1647177194;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:47:"["Blog","Coming Soon","Design","Landing Pages"]";s:10:"menu_order";i:32;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:260;a:19:{s:4:"tmpl";i:1134;s:2:"id";i:16660;s:5:"title";s:37:"Medical center &#8211; Online service";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png";s:12:"tmpl_created";i:1609945122;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:44:"["Landing Pages","Medical","Online Service"]";s:10:"menu_order";i:33;s:16:"popularity_index";i:750;s:11:"trend_index";i:332;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:261;a:19:{s:4:"tmpl";i:1226;s:2:"id";i:21069;s:5:"title";s:21:"Hotel &#8211; Contact";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg";s:12:"tmpl_created";i:1638798545;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:36:"["Contact","from","Info","Vacation"]";s:10:"menu_order";i:33;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:262;a:19:{s:4:"tmpl";i:1150;s:2:"id";i:17001;s:5:"title";s:36:"Parental Counseling &#8211; Business";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png";s:12:"tmpl_created";i:1610534999;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:99:"["Advisor","Business","Coach","Counseling","Landing Pages","Online Service","Parental","Parenting"]";s:10:"menu_order";i:34;s:16:"popularity_index";i:817;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:263;a:19:{s:4:"tmpl";i:1432;s:2:"id";i:24461;s:5:"title";s:27:"Wireframe &#8211; Gallery 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg";s:12:"tmpl_created";i:1653988784;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:82:"["Business","Contact","Design","Footer","Gallery","Header","Portfolio","Services"]";s:10:"menu_order";i:34;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:264;a:19:{s:4:"tmpl";i:676;s:2:"id";i:8514;s:5:"title";s:11:"404 Page 05";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg";s:12:"tmpl_created";i:1526415558;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:34;s:16:"popularity_index";i:419;s:11:"trend_index";i:220;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:265;a:19:{s:4:"tmpl";i:1137;s:2:"id";i:16742;s:5:"title";s:31:"Online Course &#8211; Education";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png";s:12:"tmpl_created";i:1610454122;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Education";s:4:"tags";s:55:"["Academy","Course Online","Education","Landing Pages"]";s:10:"menu_order";i:35;s:16:"popularity_index";i:777;s:11:"trend_index";i:776;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:266;a:19:{s:4:"tmpl";i:668;s:2:"id";i:8523;s:5:"title";s:11:"404 page 06";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg";s:12:"tmpl_created";i:1526415291;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:35;s:16:"popularity_index";i:298;s:11:"trend_index";i:268;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:267;a:19:{s:4:"tmpl";i:1440;s:2:"id";i:24563;s:5:"title";s:27:"Wireframe &#8211; Contact 4";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg";s:12:"tmpl_created";i:1653989095;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:84:"["Business","Contact","Footer","Form","Gallery","Header","Professional","Subscribe"]";s:10:"menu_order";i:35;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:268;a:19:{s:4:"tmpl";i:1162;s:2:"id";i:17284;s:5:"title";s:38:"Dietitian &#8211; Health &amp; Fitness";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png";s:12:"tmpl_created";i:1610903484;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:39:"["Fitness","Health","landscape design"]";s:10:"menu_order";i:36;s:16:"popularity_index";i:814;s:11:"trend_index";i:800;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:269;a:19:{s:4:"tmpl";i:1439;s:2:"id";i:24553;s:5:"title";s:27:"Wireframe &#8211; Contact 3";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg";s:12:"tmpl_created";i:1653989057;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:67:"["Business","Contact","Footer","Form","Professional","Testimonial"]";s:10:"menu_order";i:36;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:270;a:19:{s:4:"tmpl";i:1144;s:2:"id";i:16897;s:5:"title";s:30:"Personal Chef &#8211; Business";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png";s:12:"tmpl_created";i:1610466247;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:53:"["Business","Chef","Food","Landing Pages","Services"]";s:10:"menu_order";i:37;s:16:"popularity_index";i:795;s:11:"trend_index";i:617;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:271;a:19:{s:4:"tmpl";i:1435;s:2:"id";i:24504;s:5:"title";s:28:"Wireframe &#8211; Services 2";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg";s:12:"tmpl_created";i:1653988910;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:80:"["Business","Contact","Footer","Header","Professional","Services","Testimonial"]";s:10:"menu_order";i:37;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:272;a:19:{s:4:"tmpl";i:669;s:2:"id";i:8524;s:5:"title";s:11:"404 page 07";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg";s:12:"tmpl_created";i:1526415337;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:37;s:16:"popularity_index";i:303;s:11:"trend_index";i:171;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:273;a:19:{s:4:"tmpl";i:1147;s:2:"id";i:16946;s:5:"title";s:52:"Online Full-Stack Developer Course &#8211; Education";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png";s:12:"tmpl_created";i:1610532778;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"Education";s:4:"tags";s:76:"["Academy","Coding","Course Online","Developer","Education","Landing Pages"]";s:10:"menu_order";i:38;s:16:"popularity_index";i:805;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:274;a:19:{s:4:"tmpl";i:1437;s:2:"id";i:24528;s:5:"title";s:27:"Wireframe &#8211; Contact 1";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg";s:12:"tmpl_created";i:1653988981;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:76:"["Business","Contact","Footer","Form","Google Maps","Header","Professional"]";s:10:"menu_order";i:38;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:275;a:19:{s:4:"tmpl";i:1143;s:2:"id";i:16868;s:5:"title";s:40:"Virtual Assistant &#8211; Online Service";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png";s:12:"tmpl_created";i:1610465656;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:46:"["Assistant","Landing Pages","Online Service"]";s:10:"menu_order";i:39;s:16:"popularity_index";i:793;s:11:"trend_index";i:757;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:276;a:19:{s:4:"tmpl";i:673;s:2:"id";i:8526;s:5:"title";s:11:"404 page 09";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg";s:12:"tmpl_created";i:1526415474;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:39;s:16:"popularity_index";i:477;s:11:"trend_index";i:285;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:277;a:19:{s:4:"tmpl";i:1228;s:2:"id";i:21104;s:5:"title";s:26:"Restaurant &#8211; Contact";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg";s:12:"tmpl_created";i:1638800146;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:60:"["Contact","Food","Form","Google Maps","Info","Testimonial"]";s:10:"menu_order";i:39;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:278;a:19:{s:4:"tmpl";i:1140;s:2:"id";i:16812;s:5:"title";s:40:"Construction Project &#8211; Real Estate";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png";s:12:"tmpl_created";i:1610463582;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"Real Estate";s:4:"tags";s:59:"["Construction","Landing Pages","Real estate","Realestate"]";s:10:"menu_order";i:40;s:16:"popularity_index";i:796;s:11:"trend_index";i:724;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:279;a:19:{s:4:"tmpl";i:1244;s:2:"id";i:21393;s:5:"title";s:34:"Interior Designer &#8211; Projects";s:9:"thumbnail";s:99:"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg";s:12:"tmpl_created";i:1638823945;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:93:"["Creative","Creative Portfolio","Design","Designer","Interior Design","Portfolio","Project"]";s:10:"menu_order";i:40;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:280;a:19:{s:4:"tmpl";i:1148;s:2:"id";i:16960;s:5:"title";s:44:"Dog &amp; Cat Food Delivery &#8211; Business";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png";s:12:"tmpl_created";i:1610533581;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:71:"["Business","Cat","Delivery","Dog","Food","Landing Pages","Pet","Pets"]";s:10:"menu_order";i:41;s:16:"popularity_index";i:782;s:11:"trend_index";i:510;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:281;a:19:{s:4:"tmpl";i:670;s:2:"id";i:8525;s:5:"title";s:11:"404 page 08";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg";s:12:"tmpl_created";i:1526415374;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:41;s:16:"popularity_index";i:510;s:11:"trend_index";i:575;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:282;a:19:{s:4:"tmpl";i:1251;s:2:"id";i:22143;s:5:"title";s:33:"Fashion Store &#8211; Coming Soon";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png";s:12:"tmpl_created";i:1647177389;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Coming Soon","Fashion","Landing Pages","Shop","store"]";s:10:"menu_order";i:41;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:283;a:19:{s:4:"tmpl";i:1155;s:2:"id";i:17095;s:5:"title";s:36:"Mobile Pet Grooming &#8211; Business";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png";s:12:"tmpl_created";i:1610632115;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:38:"["Dog","Groom","Landing Pages","Pets"]";s:10:"menu_order";i:42;s:16:"popularity_index";i:786;s:11:"trend_index";i:731;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:284;a:19:{s:4:"tmpl";i:1241;s:2:"id";i:21451;s:5:"title";s:26:"Exhibition &#8211; Gallery";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg";s:12:"tmpl_created";i:1638821855;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:74:"["Art","Creative","Creative Portfolio","Exhibition","Gallery","Portfolio"]";s:10:"menu_order";i:42;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:285;a:19:{s:4:"tmpl";i:502;s:2:"id";i:5438;s:5:"title";s:7:"About 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png";s:12:"tmpl_created";i:1520443512;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:42;s:16:"popularity_index";i:147;s:11:"trend_index";i:9;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:286;a:19:{s:4:"tmpl";i:1159;s:2:"id";i:17245;s:5:"title";s:34:"Marketing Course &#8211; Education";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png";s:12:"tmpl_created";i:1610902958;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"Education";s:4:"tags";s:45:"["Course Online","Landing Pages","Marketing"]";s:10:"menu_order";i:43;s:16:"popularity_index";i:770;s:11:"trend_index";i:430;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:287;a:19:{s:4:"tmpl";i:1240;s:2:"id";i:21430;s:5:"title";s:30:"Travel Blogger &#8211; Gallery";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg";s:12:"tmpl_created";i:1638821592;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:43:"["Gallery","Photography","Slider","Travel"]";s:10:"menu_order";i:43;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:288;a:19:{s:4:"tmpl";i:1149;s:2:"id";i:16983;s:5:"title";s:41:"Pilates Instructor &#8211; Online Service";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png";s:12:"tmpl_created";i:1610534138;s:6:"author";s:9:"Elementor";s:3:"url";s:135:"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:70:"["Free Trial","Instructor","Landing Pages","Online Service","Pilates"]";s:10:"menu_order";i:44;s:16:"popularity_index";i:778;s:11:"trend_index";i:412;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:289;a:19:{s:4:"tmpl";i:1416;s:2:"id";i:24104;s:5:"title";s:33:"Ceramics Shop &#8211; Coming Soon";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg";s:12:"tmpl_created";i:1650988949;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:115:"["Art","Business","Coming Soon","Creative","Decor","Design","Furniture Design","Interior Design","Products","Shop"]";s:10:"menu_order";i:44;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:290;a:19:{s:4:"tmpl";i:557;s:2:"id";i:6135;s:5:"title";s:8:"About 10";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png";s:12:"tmpl_created";i:1520443663;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:45;s:16:"popularity_index";i:77;s:11:"trend_index";i:47;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:291;a:19:{s:4:"tmpl";i:1412;s:2:"id";i:24033;s:5:"title";s:37:"Dance Studio &#8211; Maintenance Mode";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg";s:12:"tmpl_created";i:1649881344;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:113:"["Academy","Business","Dance Studio","Form","Pilates","School","Sport","Teacher","Training","Under Construction"]";s:10:"menu_order";i:45;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:292;a:19:{s:4:"tmpl";i:1190;s:2:"id";i:18568;s:5:"title";s:32:"Flower Delivery &#8211; Business";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png";s:12:"tmpl_created";i:1617546716;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:37:"["Delivery","Flower","Landing Pages"]";s:10:"menu_order";i:45;s:16:"popularity_index";i:874;s:11:"trend_index";i:763;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:293;a:19:{s:4:"tmpl";i:1145;s:2:"id";i:16917;s:5:"title";s:22:"Webinar &#8211; Events";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg";s:12:"tmpl_created";i:1610466822;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:36:"["Events","Landing Pages","Webinar"]";s:10:"menu_order";i:46;s:16:"popularity_index";i:821;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:294;a:19:{s:4:"tmpl";i:1413;s:2:"id";i:24049;s:5:"title";s:33:"ECO Shop &#8211; Maintenance Mode";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg";s:12:"tmpl_created";i:1649882053;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:110:"["Aesthetic","Business","Creative","Decor","Health","Help","Lifestyle","Products","Shop","Under Construction"]";s:10:"menu_order";i:46;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:295;a:19:{s:4:"tmpl";i:497;s:2:"id";i:5397;s:5:"title";s:8:"About 11";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png";s:12:"tmpl_created";i:1520443503;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:46;s:16:"popularity_index";i:148;s:11:"trend_index";i:43;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:296;a:19:{s:4:"tmpl";i:1154;s:2:"id";i:17079;s:5:"title";s:42:"Calls Volunteer &#8211; Social Involvement";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png";s:12:"tmpl_created";i:1610631774;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Social Involvement";s:4:"tags";s:68:"["Care","Covid-19","Help","Involvement","Landing Pages","Volunteer"]";s:10:"menu_order";i:47;s:16:"popularity_index";i:854;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:297;a:19:{s:4:"tmpl";i:1419;s:2:"id";i:24136;s:5:"title";s:29:"Food Blog &#8211; Coming Soon";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg";s:12:"tmpl_created";i:1650990034;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:62:"["Blog","Business","Coming Soon","Cooking","Education","Food"]";s:10:"menu_order";i:47;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:298;a:19:{s:4:"tmpl";i:1142;s:2:"id";i:16836;s:5:"title";s:33:"Marketing Agency &#8211; Business";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg";s:12:"tmpl_created";i:1610464490;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:74:"["Agency","Business","Landing Pages","Marketing","Marketing Landing Page"]";s:10:"menu_order";i:48;s:16:"popularity_index";i:816;s:11:"trend_index";i:787;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:299;a:19:{s:4:"tmpl";i:1411;s:2:"id";i:24020;s:5:"title";s:35:"Mobile App &#8211; Maintenance Mode";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg";s:12:"tmpl_created";i:1649880955;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:77:"["App","Business","Coding","Computer","Launch","Mobile","Under Construction"]";s:10:"menu_order";i:48;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:300;a:19:{s:4:"tmpl";i:498;s:2:"id";i:5405;s:5:"title";s:8:"About 12";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png";s:12:"tmpl_created";i:1520443505;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:48;s:16:"popularity_index";i:216;s:11:"trend_index";i:50;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:301;a:19:{s:4:"tmpl";i:1139;s:2:"id";i:16785;s:5:"title";s:42:"Gym Promotion &#8211; Health &amp; Fitness";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg";s:12:"tmpl_created";i:1610455496;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:42:"["Fitness","Gym","Health","Landing Pages"]";s:10:"menu_order";i:49;s:16:"popularity_index";i:820;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:302;a:19:{s:4:"tmpl";i:1420;s:2:"id";i:24152;s:5:"title";s:32:"Perfume Shop &#8211; Coming Soon";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg";s:12:"tmpl_created";i:1650990353;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:68:"["Business","Coming Soon","Cosmetics","Lifestyle","Products","Shop"]";s:10:"menu_order";i:49;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:303;a:19:{s:4:"tmpl";i:1185;s:2:"id";i:18492;s:5:"title";s:34:"Bicycle Pre-Sale &#8211; eCommerce";s:9:"thumbnail";s:90:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png";s:12:"tmpl_created";i:1617535552;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:34:"["Bicycle","Landing Pages","Sale"]";s:10:"menu_order";i:50;s:16:"popularity_index";i:871;s:11:"trend_index";i:826;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:304;a:19:{s:4:"tmpl";i:1418;s:2:"id";i:24126;s:5:"title";s:28:"Skincare &#8211; Coming Soon";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg";s:12:"tmpl_created";i:1650989585;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:128:"["Aesthetic","Beauty","Beauty Salon","Business","Coming Soon","Cosmetics","Girly","Lifestyle","Services","Skincare","Treatment"]";s:10:"menu_order";i:51;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:305;a:19:{s:4:"tmpl";i:1181;s:2:"id";i:18349;s:5:"title";s:39:"Virtual try-on glasses &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png";s:12:"tmpl_created";i:1614772569;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:64:"["Fashion","Glasses","Landing Pages","Online Service","Virtual"]";s:10:"menu_order";i:51;s:16:"popularity_index";i:848;s:11:"trend_index";i:803;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:306;a:19:{s:4:"tmpl";i:500;s:2:"id";i:5421;s:5:"title";s:8:"About 13";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png";s:12:"tmpl_created";i:1520443509;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:51;s:16:"popularity_index";i:215;s:11:"trend_index";i:77;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:307;a:19:{s:4:"tmpl";i:513;s:2:"id";i:5533;s:5:"title";s:8:"About 15";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png";s:12:"tmpl_created";i:1520443534;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:52;s:16:"popularity_index";i:21;s:11:"trend_index";i:57;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:308;a:19:{s:4:"tmpl";i:1410;s:2:"id";i:24004;s:5:"title";s:33:"Skincare &#8211; Maintenance Mode";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg";s:12:"tmpl_created";i:1649880534;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:144:"["Aesthetic","Beauty","Beauty Salon","Business","Cosmetics","Girly","Lifestyle","Makeup","Services","Skincare","Treatment","Under Construction"]";s:10:"menu_order";i:52;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:309;a:19:{s:4:"tmpl";i:1172;s:2:"id";i:17458;s:5:"title";s:31:"Moving Company &#8211; Business";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png";s:12:"tmpl_created";i:1612727025;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:46:"["Business","Landing Pages","Movers","Moving"]";s:10:"menu_order";i:52;s:16:"popularity_index";i:826;s:11:"trend_index";i:767;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:310;a:19:{s:4:"tmpl";i:1415;s:2:"id";i:24092;s:5:"title";s:29:"Vase Shop &#8211; Coming Soon";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg";s:12:"tmpl_created";i:1650988613;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:115:"["Art","Business","Coming Soon","Creative","Decor","Design","Furniture Design","Interior Design","Products","Shop"]";s:10:"menu_order";i:53;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:311;a:19:{s:4:"tmpl";i:1186;s:2:"id";i:18517;s:5:"title";s:29:"Food Blog &#8211; Coming Soon";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png";s:12:"tmpl_created";i:1617539897;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:45:"["Blog","Coming Soon","Food","Landing Pages"]";s:10:"menu_order";i:53;s:16:"popularity_index";i:844;s:11:"trend_index";i:672;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:312;a:19:{s:4:"tmpl";i:1167;s:2:"id";i:17379;s:5:"title";s:33:"IT Service &#8211; Online Service";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png";s:12:"tmpl_created";i:1612713022;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:41:"["IT","Landing Pages","Remote","Support"]";s:10:"menu_order";i:54;s:16:"popularity_index";i:806;s:11:"trend_index";i:634;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:313;a:19:{s:4:"tmpl";i:1248;s:2:"id";i:22134;s:5:"title";s:32:"Art Magazine &#8211; Coming Soon";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg";s:12:"tmpl_created";i:1647176713;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:48:"["Art","Coming Soon","Landing Pages","Magazine"]";s:10:"menu_order";i:54;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:314;a:19:{s:4:"tmpl";i:512;s:2:"id";i:5525;s:5:"title";s:8:"About 14";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png";s:12:"tmpl_created";i:1520443532;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:55;s:16:"popularity_index";i:9;s:11:"trend_index";i:29;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:315;a:19:{s:4:"tmpl";i:1189;s:2:"id";i:18560;s:5:"title";s:52:"Finance Learning Platform &#8211; Under Construction";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png";s:12:"tmpl_created";i:1617542761;s:6:"author";s:9:"Elementor";s:3:"url";s:146:"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Under Construction";s:4:"tags";s:27:"["Finance","Landing Pages"]";s:10:"menu_order";i:55;s:16:"popularity_index";i:843;s:11:"trend_index";i:561;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:316;a:19:{s:4:"tmpl";i:1225;s:2:"id";i:21041;s:5:"title";s:41:"Business Consulting Company &#8211; About";s:9:"thumbnail";s:96:"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg";s:12:"tmpl_created";i:1638797560;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:51:"["Coach","Collaboration","Consulting","Life Coach"]";s:10:"menu_order";i:55;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:317;a:19:{s:4:"tmpl";i:1187;s:2:"id";i:18528;s:5:"title";s:36:"Home Decor Store &#8211; Coming Soon";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png";s:12:"tmpl_created";i:1617541784;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:57:"["Coming Soon","Decor","Interior Design","Landing Pages"]";s:10:"menu_order";i:56;s:16:"popularity_index";i:872;s:11:"trend_index";i:819;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:318;a:19:{s:4:"tmpl";i:1243;s:2:"id";i:21135;s:5:"title";s:28:"Construction &#8211; Service";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg";s:12:"tmpl_created";i:1638823202;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:48:"["Architecture","Construction","Faq","Services"]";s:10:"menu_order";i:56;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:319;a:19:{s:4:"tmpl";i:501;s:2:"id";i:5429;s:5:"title";s:8:"About 16";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png";s:12:"tmpl_created";i:1520443510;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:56;s:16:"popularity_index";i:59;s:11:"trend_index";i:8;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:320;a:19:{s:4:"tmpl";i:1174;s:2:"id";i:17504;s:5:"title";s:29:"Hair Stylist &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png";s:12:"tmpl_created";i:1612883014;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:59:"["Business","Hair","hairdresser","Landing Pages","Stylist"]";s:10:"menu_order";i:57;s:16:"popularity_index";i:840;s:11:"trend_index";i:806;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:321;a:19:{s:4:"tmpl";i:1223;s:2:"id";i:20981;s:5:"title";s:37:"Creative Digital Agency &#8211; About";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg";s:12:"tmpl_created";i:1638789303;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:51:"["About","Advisor","Creative","Creative Portfolio"]";s:10:"menu_order";i:57;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:322;a:19:{s:4:"tmpl";i:1184;s:2:"id";i:18449;s:5:"title";s:45:"Aesthetic Clinic &#8211; Health &amp; Fitness";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png";s:12:"tmpl_created";i:1616682181;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Health and Fitness";s:4:"tags";s:57:"["Aesthetic","Beauty","Fitness","Health","Landing Pages"]";s:10:"menu_order";i:58;s:16:"popularity_index";i:859;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:323;a:19:{s:4:"tmpl";i:1221;s:2:"id";i:20926;s:5:"title";s:33:"Doctors Online Consultation -Home";s:9:"thumbnail";s:95:"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg";s:12:"tmpl_created";i:1638787371;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:35:"["App","Health","Medical","Online"]";s:10:"menu_order";i:58;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:324;a:19:{s:4:"tmpl";i:505;s:2:"id";i:5464;s:5:"title";s:8:"About 17";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png";s:12:"tmpl_created";i:1520443518;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:58;s:16:"popularity_index";i:220;s:11:"trend_index";i:142;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:325;a:19:{s:4:"tmpl";i:1165;s:2:"id";i:17353;s:5:"title";s:44:"Online Cooking Course &#8211; Online Service";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png";s:12:"tmpl_created";i:1612705144;s:6:"author";s:9:"Elementor";s:3:"url";s:138:"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:50:"["Cooking","Course Online","Food","Landing Pages"]";s:10:"menu_order";i:59;s:16:"popularity_index";i:845;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:326;a:19:{s:4:"tmpl";i:1188;s:2:"id";i:18550;s:5:"title";s:39:"Online Store &#8211; Under Construction";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png";s:12:"tmpl_created";i:1617542506;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:18:"Under Construction";s:4:"tags";s:59:"["Landing Pages","Online Shop","Shop","Under Construction"]";s:10:"menu_order";i:60;s:16:"popularity_index";i:832;s:11:"trend_index";i:600;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:327;a:19:{s:4:"tmpl";i:1250;s:2:"id";i:22140;s:5:"title";s:33:"Design School &#8211; Coming Soon";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png";s:12:"tmpl_created";i:1647177317;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:49:"["Coming Soon","Design","Landing Pages","School"]";s:10:"menu_order";i:60;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:328;a:19:{s:4:"tmpl";i:510;s:2:"id";i:5504;s:5:"title";s:8:"About 18";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png";s:12:"tmpl_created";i:1520443528;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:60;s:16:"popularity_index";i:104;s:11:"trend_index";i:46;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:329;a:19:{s:4:"tmpl";i:1191;s:2:"id";i:18539;s:5:"title";s:40:"Travel Agency &#8211; Under Construction";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png";s:12:"tmpl_created";i:1617610273;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:18:"Under Construction";s:4:"tags";s:56:"["Agency","Landing Pages","Travel","Under Construction"]";s:10:"menu_order";i:61;s:16:"popularity_index";i:876;s:11:"trend_index";i:652;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:330;a:19:{s:4:"tmpl";i:1175;s:2:"id";i:18270;s:5:"title";s:24:"Open week &#8211; Events";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png";s:12:"tmpl_created";i:1614767186;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"Events";s:4:"tags";s:59:"["Education","Event","Events","Landing Pages","University"]";s:10:"menu_order";i:62;s:16:"popularity_index";i:831;s:11:"trend_index";i:673;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:331;a:19:{s:4:"tmpl";i:1177;s:2:"id";i:18300;s:5:"title";s:30:"Makeup Artist &#8211; Business";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png";s:12:"tmpl_created";i:1614768608;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:79:"["Beauty","Business","Course Online","Landing Pages","Makeup","Online Service"]";s:10:"menu_order";i:63;s:16:"popularity_index";i:861;s:11:"trend_index";i:783;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:332;a:19:{s:4:"tmpl";i:511;s:2:"id";i:5515;s:5:"title";s:8:"About 19";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png";s:12:"tmpl_created";i:1520443530;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:63;s:16:"popularity_index";i:268;s:11:"trend_index";i:161;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:333;a:19:{s:4:"tmpl";i:1179;s:2:"id";i:18329;s:5:"title";s:63:"Online Real Estate Investment Conference &#8211; Online Service";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/03/250x280-5.png";s:12:"tmpl_created";i:1614770404;s:6:"author";s:9:"Elementor";s:3:"url";s:157:"https://library.elementor.com/lp/online-real-estate-investment-conference-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Online Service";s:4:"tags";s:76:"["Conference","Event","Events","Landing Pages","Online Event","Real estate"]";s:10:"menu_order";i:64;s:16:"popularity_index";i:866;s:11:"trend_index";i:779;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:334;a:19:{s:4:"tmpl";i:506;s:2:"id";i:5472;s:5:"title";s:7:"About 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_7.png";s:12:"tmpl_created";i:1520443520;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:64;s:16:"popularity_index";i:210;s:11:"trend_index";i:116;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:335;a:19:{s:4:"tmpl";i:1183;s:2:"id";i:18391;s:5:"title";s:45:"Children&#8217;s Optometrist &#8211; Business";s:9:"thumbnail";s:94:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Childrens-Optometrist.png";s:12:"tmpl_created";i:1614773564;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/lp/childrens-optometrist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:85:"["Business","Children","Eye","Glasses","Health","Kids","Landing Pages","Optometrist"]";s:10:"menu_order";i:65;s:16:"popularity_index";i:877;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:336;a:19:{s:4:"tmpl";i:1182;s:2:"id";i:18366;s:5:"title";s:30:"Car Insurance &#8211; Business";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Car-Insurance.png";s:12:"tmpl_created";i:1614773263;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/car-insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:46:"["Business","car","Insurance","Landing Pages"]";s:10:"menu_order";i:66;s:16:"popularity_index";i:869;s:11:"trend_index";i:797;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:337;a:19:{s:4:"tmpl";i:1201;s:2:"id";i:19144;s:5:"title";s:25:"Birthday Party Invitation";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/06/250x280.png";s:12:"tmpl_created";i:1623848691;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/birthday-party-invitation/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:67:"["Birthday","Event","Landing Pages","Party","RSVD","Save the Date"]";s:10:"menu_order";i:66;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:338;a:19:{s:4:"tmpl";i:1124;s:2:"id";i:16473;s:5:"title";s:26:"Beauty Salon &#8211; About";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/12/about-1.jpg";s:12:"tmpl_created";i:1608622373;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/beauty-salon-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:67;s:16:"popularity_index";i:615;s:11:"trend_index";i:184;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:339;a:19:{s:4:"tmpl";i:1176;s:2:"id";i:18291;s:5:"title";s:47:"Grill Restaurant Food Delivery &#8211; Business";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Food-Delivery-LP.png";s:12:"tmpl_created";i:1614767830;s:6:"author";s:9:"Elementor";s:3:"url";s:141:"https://library.elementor.com/lp/grill-restaurant-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"Business";s:4:"tags";s:79:"["Delivery","Delivery Service","Fast Food","Food","Landing Pages","Restaurant"]";s:10:"menu_order";i:67;s:16:"popularity_index";i:819;s:11:"trend_index";i:685;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:340;a:19:{s:4:"tmpl";i:504;s:2:"id";i:5455;s:5:"title";s:8:"About 20";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_6.png";s:12:"tmpl_created";i:1520443516;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:67;s:16:"popularity_index";i:134;s:11:"trend_index";i:70;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:341;a:19:{s:4:"tmpl";i:1125;s:2:"id";i:16488;s:5:"title";s:28:"Beauty Salon &#8211; Contact";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/12/contact.jpg";s:12:"tmpl_created";i:1608622374;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/beauty-salon-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:68;s:16:"popularity_index";i:548;s:11:"trend_index";i:101;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:342;a:19:{s:4:"tmpl";i:1180;s:2:"id";i:18340;s:5:"title";s:30:"Restaurant &#8211; Coming Soon";s:9:"thumbnail";s:98:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Restuarant-Coming-Soon-LP.png";s:12:"tmpl_created";i:1614772183;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/lp/restaurant-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:16:"Coming Soon Page";s:4:"tags";s:51:"["Coming Soon","Food","Landing Pages","Restaurant"]";s:10:"menu_order";i:68;s:16:"popularity_index";i:810;s:11:"trend_index";i:809;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:343;a:19:{s:4:"tmpl";i:499;s:2:"id";i:5413;s:5:"title";s:8:"About 21";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2.png";s:12:"tmpl_created";i:1520443507;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/about-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:68;s:16:"popularity_index";i:83;s:11:"trend_index";i:52;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:344;a:19:{s:4:"tmpl";i:1126;s:2:"id";i:16496;s:5:"title";s:28:"Beauty Salon &#8211; Gallery";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/12/gallery-1.jpg";s:12:"tmpl_created";i:1608622379;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/beauty-salon-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:69;s:16:"popularity_index";i:491;s:11:"trend_index";i:90;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:345;a:19:{s:4:"tmpl";i:1173;s:2:"id";i:17480;s:5:"title";s:42:"At-home Massage Therapist &#8211; Business";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/02/At-Home-Massage-Therapist.jpg";s:12:"tmpl_created";i:1612879264;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/lp/at-home-massage-therapist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:60:"["Business","Health","Landing Pages","Services","Therapist"]";s:10:"menu_order";i:69;s:16:"popularity_index";i:856;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:346;a:19:{s:4:"tmpl";i:1127;s:2:"id";i:16457;s:5:"title";s:25:"Beauty Salon &#8211; Home";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/12/home-1.jpg";s:12:"tmpl_created";i:1608622383;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/beauty-salon-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:70;s:16:"popularity_index";i:408;s:11:"trend_index";i:56;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:347;a:19:{s:4:"tmpl";i:1178;s:2:"id";i:18317;s:5:"title";s:26:"Insurance &#8211; Business";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2021/03/Library-Pic-Life-Insirance.png";s:12:"tmpl_created";i:1614769488;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/lp/insurance-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"Business";s:4:"tags";s:61:"["Business","Family","Financial","Insurance","Landing Pages"]";s:10:"menu_order";i:70;s:16:"popularity_index";i:870;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:348;a:19:{s:4:"tmpl";i:1128;s:2:"id";i:16518;s:5:"title";s:29:"Beauty Salon &#8211; Services";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/12/services-1.jpg";s:12:"tmpl_created";i:1608622386;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/beauty-salon-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:23:"["Beauty Salon","Hair"]";s:10:"menu_order";i:71;s:16:"popularity_index";i:664;s:11:"trend_index";i:261;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:349;a:19:{s:4:"tmpl";i:1168;s:2:"id";i:17401;s:5:"title";s:40:"Conference Thank You Page &#8211; Events";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2021/02/250x280.png";s:12:"tmpl_created";i:1612724753;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/lp/conference-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:59:"["Conference","Event","Events","Landing Pages","Thank You"]";s:10:"menu_order";i:71;s:16:"popularity_index";i:799;s:11:"trend_index";i:540;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:350;a:19:{s:4:"tmpl";i:503;s:2:"id";i:5447;s:5:"title";s:7:"About 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_5.png";s:12:"tmpl_created";i:1520443514;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:71;s:16:"popularity_index";i:48;s:11:"trend_index";i:12;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:351;a:19:{s:4:"tmpl";i:1073;s:2:"id";i:15486;s:5:"title";s:25:"Travel Blog &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/11/About.jpg";s:12:"tmpl_created";i:1606215720;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/travel-blog-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:72;s:16:"popularity_index";i:608;s:11:"trend_index";i:343;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:352;a:19:{s:4:"tmpl";i:1166;s:2:"id";i:17368;s:5:"title";s:38:"Real Estate Agency &#8211; Real-Estate";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Real-Estate.png";s:12:"tmpl_created";i:1612711814;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/lp/real-estate-agency-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"Real Estate";s:4:"tags";s:73:"["Landing Pages","listing","Real estate","Realestate","realtor","realty"]";s:10:"menu_order";i:72;s:16:"popularity_index";i:858;s:11:"trend_index";i:777;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:353;a:19:{s:4:"tmpl";i:1074;s:2:"id";i:15478;s:5:"title";s:27:"Travel Blog &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/11/Contact-Us.jpg";s:12:"tmpl_created";i:1606215735;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/travel-blog-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:73;s:16:"popularity_index";i:687;s:11:"trend_index";i:564;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:354;a:19:{s:4:"tmpl";i:1170;s:2:"id";i:17423;s:5:"title";s:57:"Volunteer Calls Thank You Page &#8211; Social Involvement";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2021/02/Volunteer-Calls-TYP.jpg";s:12:"tmpl_created";i:1612726058;s:6:"author";s:9:"Elementor";s:3:"url";s:151:"https://library.elementor.com/lp/volunteer-calls-thank-you-page-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:62:"["Care","Involvement","Landing Pages","Thank You","Volunteer"]";s:10:"menu_order";i:73;s:16:"popularity_index";i:857;s:11:"trend_index";i:818;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:355;a:19:{s:4:"tmpl";i:507;s:2:"id";i:5480;s:5:"title";s:7:"About 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_7-1.png";s:12:"tmpl_created";i:1520443522;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-4-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:73;s:16:"popularity_index";i:428;s:11:"trend_index";i:303;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:356;a:19:{s:4:"tmpl";i:1075;s:2:"id";i:15467;s:5:"title";s:24:"Travel Blog &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/11/Home.jpg";s:12:"tmpl_created";i:1606215756;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/travel-blog-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:74;s:16:"popularity_index";i:567;s:11:"trend_index";i:224;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:357;a:19:{s:4:"tmpl";i:1169;s:2:"id";i:17409;s:5:"title";s:37:"Webinar Thank You Page &#8211; Events";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Webinar-TYP.png";s:12:"tmpl_created";i:1612725644;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/lp/webinar-thank-you-page-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:56:"["Event","Events","Landing Pages","Thank You","Webinar"]";s:10:"menu_order";i:74;s:16:"popularity_index";i:868;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:358;a:19:{s:4:"tmpl";i:1056;s:2:"id";i:15317;s:5:"title";s:25:"Dance Studio &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/10/Home.jpg";s:12:"tmpl_created";i:1603181291;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/dance-studio-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:75;s:16:"popularity_index";i:596;s:11:"trend_index";i:301;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:359;a:19:{s:4:"tmpl";i:545;s:2:"id";i:6027;s:5:"title";s:7:"About 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1-1.png";s:12:"tmpl_created";i:1520443639;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-5-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:75;s:16:"popularity_index";i:40;s:11:"trend_index";i:40;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:360;a:19:{s:4:"tmpl";i:1160;s:2:"id";i:17258;s:5:"title";s:32:"Beauty Product &#8211; eCommerce";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2021/01/Beauty-Product.png";s:12:"tmpl_created";i:1610903153;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/lp/beauty-product-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:38:"["Beauty","Ecommerce","Landing Pages"]";s:10:"menu_order";i:75;s:16:"popularity_index";i:797;s:11:"trend_index";i:703;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:361;a:19:{s:4:"tmpl";i:1057;s:2:"id";i:15334;s:5:"title";s:26:"Dance Studio &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/10/About.jpg";s:12:"tmpl_created";i:1603181364;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/dance-studio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:76;s:16:"popularity_index";i:626;s:11:"trend_index";i:373;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:362;a:19:{s:4:"tmpl";i:546;s:2:"id";i:6036;s:5:"title";s:7:"About 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1-1.png";s:12:"tmpl_created";i:1520443641;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/about-6-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:76;s:16:"popularity_index";i:90;s:11:"trend_index";i:123;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:363;a:19:{s:4:"tmpl";i:1171;s:2:"id";i:17435;s:5:"title";s:39:"Gym &#8211; App Service &#8211; Product";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2021/02/250x280-4.png";s:12:"tmpl_created";i:1612726462;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/lp/gym-app-service-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"Product";s:4:"tags";s:58:"["App","Fitness","Gym","Health","Landing Pages","Product"]";s:10:"menu_order";i:76;s:16:"popularity_index";i:767;s:11:"trend_index";i:577;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:364;a:19:{s:4:"tmpl";i:1058;s:2:"id";i:15349;s:5:"title";s:28:"Dance Studio &#8211; Classes";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/10/Classes.jpg";s:12:"tmpl_created";i:1603181425;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dance-studio-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:77;s:16:"popularity_index";i:629;s:11:"trend_index";i:458;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:365;a:19:{s:4:"tmpl";i:1156;s:2:"id";i:17111;s:5:"title";s:33:"Sunglasses Sale &#8211; eCommerce";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2021/01/Sunglasses-LP-Library-Pic.jpg";s:12:"tmpl_created";i:1610632408;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/sunglasses-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:59:"["Ecommerce","Fashion","Landing Pages","Sale","Sunglasses"]";s:10:"menu_order";i:77;s:16:"popularity_index";i:812;s:11:"trend_index";i:732;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:366;a:19:{s:4:"tmpl";i:1055;s:2:"id";i:15366;s:5:"title";s:29:"Dance Studio &#8211; Schedule";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2020/10/Classes-Schedule.jpg";s:12:"tmpl_created";i:1603181056;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/dance-studio-schedule/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:78;s:16:"popularity_index";i:698;s:11:"trend_index";i:602;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:367;a:19:{s:4:"tmpl";i:1157;s:2:"id";i:17223;s:5:"title";s:25:"Fashion &#8211; eCommerce";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2021/01/Commerce-Fashion.png";s:12:"tmpl_created";i:1610902553;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/lp/fashion-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:29:"["Ecommerce","Landing Pages"]";s:10:"menu_order";i:78;s:16:"popularity_index";i:808;s:11:"trend_index";i:745;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:368;a:19:{s:4:"tmpl";i:1059;s:2:"id";i:15373;s:5:"title";s:28:"Dance Studio &#8211; Pricing";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/10/Pricing.jpg";s:12:"tmpl_created";i:1603181678;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dance-studio-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:79;s:16:"popularity_index";i:731;s:11:"trend_index";i:661;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:369;a:19:{s:4:"tmpl";i:1151;s:2:"id";i:17017;s:5:"title";s:28:"Shoes Sale &#8211; eCommerce";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2021/01/Shoes-LP-Library-Pic.jpg";s:12:"tmpl_created";i:1610535361;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/lp/shoes-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"eCommerce";s:4:"tags";s:55:"["Discount","Ecommerce","Landing Pages","Sale","Shoes"]";s:10:"menu_order";i:79;s:16:"popularity_index";i:803;s:11:"trend_index";i:642;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:370;a:19:{s:4:"tmpl";i:508;s:2:"id";i:5488;s:5:"title";s:7:"About 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_8.png";s:12:"tmpl_created";i:1520443524;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:79;s:16:"popularity_index";i:307;s:11:"trend_index";i:169;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:371;a:19:{s:4:"tmpl";i:1060;s:2:"id";i:15384;s:5:"title";s:28:"Dance Studio &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/10/Contact-Us.jpg";s:12:"tmpl_created";i:1603181738;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/dance-studio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:16:"["Dance Studio"]";s:10:"menu_order";i:80;s:16:"popularity_index";i:741;s:11:"trend_index";i:721;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:372;a:19:{s:4:"tmpl";i:556;s:2:"id";i:6122;s:5:"title";s:7:"About 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_white_2-1.png";s:12:"tmpl_created";i:1520443661;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:80;s:16:"popularity_index";i:38;s:11:"trend_index";i:26;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:373;a:19:{s:4:"tmpl";i:1163;s:2:"id";i:17301;s:5:"title";s:53:"Personal Chef &#8211; Thank You Page &#8211; Business";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2021/01/TYP-Personal-Chef.jpg";s:12:"tmpl_created";i:1610903622;s:6:"author";s:9:"Elementor";s:3:"url";s:139:"https://library.elementor.com/lp/personal-chef-thank-you-page-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:43:"["Chef","Food","Landing Pages","Thank You"]";s:10:"menu_order";i:80;s:16:"popularity_index";i:823;s:11:"trend_index";i:754;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:374;a:19:{s:4:"tmpl";i:1042;s:2:"id";i:15158;s:5:"title";s:26:"Psychologist &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/09/About.jpg";s:12:"tmpl_created";i:1600157561;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/psychologist-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:81;s:16:"popularity_index";i:618;s:11:"trend_index";i:426;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:375;a:19:{s:4:"tmpl";i:1164;s:2:"id";i:17313;s:5:"title";s:60:"Development Course  &#8211; Thank You Page &#8211; Education";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2021/01/Dev-Course-TYP-.png";s:12:"tmpl_created";i:1610903776;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/lp/development-course-thank-you-page-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"Thank You Page";s:4:"tags";s:57:"["Course Online","Education","Landing Pages","Thank You"]";s:10:"menu_order";i:81;s:16:"popularity_index";i:834;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:376;a:19:{s:4:"tmpl";i:1045;s:2:"id";i:15197;s:5:"title";s:28:"Psychologist &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/09/Contact-Us.jpg";s:12:"tmpl_created";i:1600160499;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/psychologist-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:82;s:16:"popularity_index";i:666;s:11:"trend_index";i:558;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:377;a:19:{s:4:"tmpl";i:509;s:2:"id";i:5496;s:5:"title";s:7:"About 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/about_black_8-1.png";s:12:"tmpl_created";i:1520443526;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/about-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"about";s:4:"tags";s:9:"["About"]";s:10:"menu_order";i:82;s:16:"popularity_index";i:523;s:11:"trend_index";i:453;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:378;a:19:{s:4:"tmpl";i:1041;s:2:"id";i:15142;s:5:"title";s:25:"Psychologist &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/09/Home.jpg";s:12:"tmpl_created";i:1600156308;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/psychologist-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:83;s:16:"popularity_index";i:464;s:11:"trend_index";i:297;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:379;a:19:{s:4:"tmpl";i:1044;s:2:"id";i:15188;s:5:"title";s:28:"Psychologist &#8211; Pricing";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/09/Pricing.jpg";s:12:"tmpl_created";i:1600159731;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/psychologist-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:84;s:16:"popularity_index";i:732;s:11:"trend_index";i:537;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:380;a:19:{s:4:"tmpl";i:684;s:2:"id";i:8961;s:5:"title";s:9:"archive 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.1.jpg";s:12:"tmpl_created";i:1528639909;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:84;s:16:"popularity_index";i:79;s:11:"trend_index";i:15;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:381;a:19:{s:4:"tmpl";i:1043;s:2:"id";i:15167;s:5:"title";s:29:"Psychologist &#8211; Services";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/09/Services.jpg";s:12:"tmpl_created";i:1600158206;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/psychologist-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:85;s:16:"popularity_index";i:606;s:11:"trend_index";i:379;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:382;a:19:{s:4:"tmpl";i:1036;s:2:"id";i:14932;s:5:"title";s:30:"Flooring Company &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/08/About.png";s:12:"tmpl_created";i:1597740110;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/flooring-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:86;s:16:"popularity_index";i:488;s:11:"trend_index";i:319;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:383;a:19:{s:4:"tmpl";i:685;s:2:"id";i:8969;s:5:"title";s:9:"archive 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.2.jpg";s:12:"tmpl_created";i:1528700014;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:86;s:16:"popularity_index";i:250;s:11:"trend_index";i:124;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:384;a:19:{s:4:"tmpl";i:1037;s:2:"id";i:14998;s:5:"title";s:32:"Flooring Company &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/08/Contact-Us.png";s:12:"tmpl_created";i:1597740222;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/flooring-company-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:87;s:16:"popularity_index";i:553;s:11:"trend_index";i:380;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:385;a:19:{s:4:"tmpl";i:1038;s:2:"id";i:14965;s:5:"title";s:32:"Flooring Company &#8211; Gallery";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/08/Gallery.png";s:12:"tmpl_created";i:1597740353;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/flooring-company-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:88;s:16:"popularity_index";i:371;s:11:"trend_index";i:291;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:386;a:19:{s:4:"tmpl";i:686;s:2:"id";i:8973;s:5:"title";s:9:"archive 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.3.jpg";s:12:"tmpl_created";i:1528700205;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:88;s:16:"popularity_index";i:176;s:11:"trend_index";i:54;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:387;a:19:{s:4:"tmpl";i:1282;s:2:"id";i:22417;s:5:"title";s:52:"Finance Learning Platform &#8211; Under Construction";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png";s:12:"tmpl_created";i:1647354987;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Finance","Landing Pages"]";s:10:"menu_order";i:89;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:388;a:19:{s:4:"tmpl";i:1040;s:2:"id";i:14947;s:5:"title";s:33:"Flooring company &#8211; Services";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/08/Services.png";s:12:"tmpl_created";i:1597740551;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/flooring-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:90;s:16:"popularity_index";i:538;s:11:"trend_index";i:392;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:389;a:19:{s:4:"tmpl";i:1039;s:2:"id";i:14901;s:5:"title";s:29:"Flooring Company &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/08/Home.png";s:12:"tmpl_created";i:1597740474;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/flooring-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:91;s:16:"popularity_index";i:387;s:11:"trend_index";i:185;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:390;a:19:{s:4:"tmpl";i:687;s:2:"id";i:8977;s:5:"title";s:9:"archive 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.4.jpg";s:12:"tmpl_created";i:1528700326;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:91;s:16:"popularity_index";i:354;s:11:"trend_index";i:396;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:391;a:19:{s:4:"tmpl";i:1252;s:2:"id";i:22146;s:5:"title";s:36:"Home Decor Store &#8211; Coming Soon";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png";s:12:"tmpl_created";i:1647177514;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:57:"["Coming Soon","Decor","Interior Design","Landing Pages"]";s:10:"menu_order";i:92;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:392;a:19:{s:4:"tmpl";i:688;s:2:"id";i:8981;s:5:"title";s:9:"archive 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.5.jpg";s:12:"tmpl_created";i:1528700484;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:93;s:16:"popularity_index";i:333;s:11:"trend_index";i:195;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:393;a:19:{s:4:"tmpl";i:1021;s:2:"id";i:14737;s:5:"title";s:32:"Luxury Real Estate &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/07/About.png";s:12:"tmpl_created";i:1595313527;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/luxury-real-estate-about-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:93;s:16:"popularity_index";i:150;s:11:"trend_index";i:447;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:394;a:19:{s:4:"tmpl";i:689;s:2:"id";i:8985;s:5:"title";s:9:"archive 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.6.jpg";s:12:"tmpl_created";i:1528700612;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:94;s:16:"popularity_index";i:204;s:11:"trend_index";i:95;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:395;a:19:{s:4:"tmpl";i:1020;s:2:"id";i:14756;s:5:"title";s:34:"Luxury Real Estate &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/07/Contact-Us.png";s:12:"tmpl_created";i:1595313519;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/luxury-real-estate-contact-us-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:94;s:16:"popularity_index";i:610;s:11:"trend_index";i:569;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:396;a:19:{s:4:"tmpl";i:1019;s:2:"id";i:14716;s:5:"title";s:31:"Luxury Real Estate &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/07/Home.png";s:12:"tmpl_created";i:1595313512;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/luxury-real-estate-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:95;s:16:"popularity_index";i:394;s:11:"trend_index";i:165;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:397;a:19:{s:4:"tmpl";i:690;s:2:"id";i:8989;s:5:"title";s:9:"archive 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.7.jpg";s:12:"tmpl_created";i:1528701063;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:96;s:16:"popularity_index";i:208;s:11:"trend_index";i:111;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:398;a:19:{s:4:"tmpl";i:1018;s:2:"id";i:14763;s:5:"title";s:31:"Luxury Real Estate &#8211; News";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/07/news-Archive.png";s:12:"tmpl_created";i:1595313273;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/luxury-real-estate-news-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:96;s:16:"popularity_index";i:404;s:11:"trend_index";i:167;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:399;a:19:{s:4:"tmpl";i:1283;s:2:"id";i:22423;s:5:"title";s:39:"Online Store &#8211; Under Construction";s:9:"thumbnail";s:85:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png";s:12:"tmpl_created";i:1647355154;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:59:"["Landing Pages","Online Shop","Shop","Under Construction"]";s:10:"menu_order";i:97;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:400;a:19:{s:4:"tmpl";i:691;s:2:"id";i:8996;s:5:"title";s:9:"archive 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.8.jpg";s:12:"tmpl_created";i:1528701290;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:98;s:16:"popularity_index";i:227;s:11:"trend_index";i:153;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:401;a:19:{s:4:"tmpl";i:1010;s:2:"id";i:13960;s:5:"title";s:32:"Japanese restaurant &#8211; Home";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/06/Home-Page.jpg";s:12:"tmpl_created";i:1592289775;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/japanese-restaurant-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:98;s:16:"popularity_index";i:537;s:11:"trend_index";i:287;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:402;a:19:{s:4:"tmpl";i:1284;s:2:"id";i:22428;s:5:"title";s:40:"Travel Agency &#8211; Under Construction";s:9:"thumbnail";s:88:"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png";s:12:"tmpl_created";i:1647355339;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:56:"["Agency","Landing Pages","Travel","Under Construction"]";s:10:"menu_order";i:99;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:403;a:19:{s:4:"tmpl";i:692;s:2:"id";i:9001;s:5:"title";s:9:"archive 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/06/Archive_350.9.jpg";s:12:"tmpl_created";i:1528701433;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/archive-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:100;s:16:"popularity_index";i:265;s:11:"trend_index";i:208;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:404;a:19:{s:4:"tmpl";i:1007;s:2:"id";i:13993;s:5:"title";s:45:"Japanese restaurant &#8211; Chef&#8217;s Menu";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2020/06/Chef_s-Menu-Page.jpg";s:12:"tmpl_created";i:1592289691;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/japanese-restaurant-chefs-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:100;s:16:"popularity_index";i:651;s:11:"trend_index";i:675;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:405;a:19:{s:4:"tmpl";i:1006;s:2:"id";i:14012;s:5:"title";s:36:"Japanese restaurant &#8211; Bar Menu";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2020/06/Bar-Menu-Page.jpg";s:12:"tmpl_created";i:1592289665;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/japanese-restaurant-bar-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:101;s:16:"popularity_index";i:735;s:11:"trend_index";i:829;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:406;a:19:{s:4:"tmpl";i:1005;s:2:"id";i:13917;s:5:"title";s:33:"Japanese restaurant &#8211; About";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/06/About-Page.jpg";s:12:"tmpl_created";i:1592289629;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/japanese-restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:102;s:16:"popularity_index";i:640;s:11:"trend_index";i:389;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:407;a:19:{s:4:"tmpl";i:997;s:2:"id";i:13528;s:5:"title";s:22:"Barbershop &#8211; 404";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/05/404-Page.jpg";s:12:"tmpl_created";i:1589893152;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/barbershop-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:34:"["404","Barber Shop","Barbershop"]";s:10:"menu_order";i:103;s:16:"popularity_index";i:768;s:11:"trend_index";i:681;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:408;a:19:{s:4:"tmpl";i:1009;s:2:"id";i:13937;s:5:"title";s:35:"Japanese restaurant &#8211; Gallery";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/06/Gallery-Page.jpg";s:12:"tmpl_created";i:1592289748;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/japanese-restaurant-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:103;s:16:"popularity_index";i:648;s:11:"trend_index";i:551;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:409;a:19:{s:4:"tmpl";i:1008;s:2:"id";i:14030;s:5:"title";s:34:"Japanese restaurant &#8211; Events";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/06/Events-Page.jpg";s:12:"tmpl_created";i:1592289713;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/japanese-restaurant-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:104;s:16:"popularity_index";i:723;s:11:"trend_index";i:711;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:410;a:19:{s:4:"tmpl";i:998;s:2:"id";i:13518;s:5:"title";s:26:"Barbershop &#8211; Archive";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/05/Blog-Page.jpg";s:12:"tmpl_created";i:1589893157;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/barbershop-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:105;s:16:"popularity_index";i:737;s:11:"trend_index";i:523;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:411;a:19:{s:4:"tmpl";i:1016;s:2:"id";i:13984;s:5:"title";s:40:"Japanese restaurant &#8211; Reservations";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/06/reservations.jpg";s:12:"tmpl_created";i:1592294757;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/japanese-restaurant-reservations/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:32:"["Food","Japanese","Restaurant"]";s:10:"menu_order";i:105;s:16:"popularity_index";i:715;s:11:"trend_index";i:727;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:412;a:19:{s:4:"tmpl";i:999;s:2:"id";i:13479;s:5:"title";s:23:"Barbershop &#8211; Home";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/05/Home-Page.jpg";s:12:"tmpl_created";i:1589893275;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/barbershop-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:106;s:16:"popularity_index";i:683;s:11:"trend_index";i:832;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:413;a:19:{s:4:"tmpl";i:996;s:2:"id";i:13604;s:5:"title";s:25:"Barbershop &#8211; Footer";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/05/Footer-Small.jpg";s:12:"tmpl_created";i:1589893147;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/barbershop-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:37:"["Barber Shop","Barbershop","Footer"]";s:10:"menu_order";i:107;s:16:"popularity_index";i:555;s:11:"trend_index";i:267;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:414;a:19:{s:4:"tmpl";i:1000;s:2:"id";i:13503;s:5:"title";s:24:"Barbershop &#8211; About";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/05/About-Page.jpg";s:12:"tmpl_created";i:1589893289;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/barbershop-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:107;s:16:"popularity_index";i:744;s:11:"trend_index";i:739;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:415;a:19:{s:4:"tmpl";i:995;s:2:"id";i:13612;s:5:"title";s:25:"Barbershop &#8211; Header";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2020/06/barber-shop-header.jpg";s:12:"tmpl_created";i:1589893142;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/barbershop-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:37:"["Barber Shop","Barbershop","Header"]";s:10:"menu_order";i:108;s:16:"popularity_index";i:343;s:11:"trend_index";i:137;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:416;a:19:{s:4:"tmpl";i:1001;s:2:"id";i:13548;s:5:"title";s:27:"Barbershop &#8211; Services";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2020/05/Services-Page.jpg";s:12:"tmpl_created";i:1589893298;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/barbershop-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:108;s:16:"popularity_index";i:761;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:417;a:19:{s:4:"tmpl";i:1002;s:2:"id";i:13560;s:5:"title";s:26:"Barbershop &#8211; Gallery";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/05/Gallery-Page.jpg";s:12:"tmpl_created";i:1589893307;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/barbershop-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:109;s:16:"popularity_index";i:756;s:11:"trend_index";i:822;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:418;a:19:{s:4:"tmpl";i:1003;s:2:"id";i:13587;s:5:"title";s:26:"Barbershop &#8211; Contact";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/05/Contact-Us-Page.jpg";s:12:"tmpl_created";i:1589893315;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/barbershop-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:110;s:16:"popularity_index";i:753;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:419;a:19:{s:4:"tmpl";i:982;s:2:"id";i:13307;s:5:"title";s:26:"Online Course &#8211; Home";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/04/Home.jpg";s:12:"tmpl_created";i:1587474541;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/online-course-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:111;s:16:"popularity_index";i:230;s:11:"trend_index";i:125;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:420;a:19:{s:4:"tmpl";i:994;s:2:"id";i:13621;s:5:"title";s:30:"Barbershop &#8211; Single Post";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/05/Single-Page.jpg";s:12:"tmpl_created";i:1589893137;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/barbershop-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:28:"["Barber Shop","Barbershop"]";s:10:"menu_order";i:111;s:16:"popularity_index";i:736;s:11:"trend_index";i:580;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:421;a:19:{s:4:"tmpl";i:1131;s:2:"id";i:16527;s:5:"title";s:24:"Beauty Salon &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/12/404.jpg";s:12:"tmpl_created";i:1608622517;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/beauty-salon-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:29:"["404","Beauty Salon","Hair"]";s:10:"menu_order";i:112;s:16:"popularity_index";i:742;s:11:"trend_index";i:563;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:422;a:19:{s:4:"tmpl";i:983;s:2:"id";i:13328;s:5:"title";s:27:"Online Course &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/04/About.jpg";s:12:"tmpl_created";i:1587474558;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/online-course-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:112;s:16:"popularity_index";i:508;s:11:"trend_index";i:429;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:423;a:19:{s:4:"tmpl";i:984;s:2:"id";i:13338;s:5:"title";s:33:"Online Course &#8211; Course Page";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/Course-Page.png";s:12:"tmpl_created";i:1587474574;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/online-course-course-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:113;s:16:"popularity_index";i:337;s:11:"trend_index";i:310;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:424;a:19:{s:4:"tmpl";i:985;s:2:"id";i:13352;s:5:"title";s:29:"Online Course &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.jpg";s:12:"tmpl_created";i:1587474591;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/online-course-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:114;s:16:"popularity_index";i:565;s:11:"trend_index";i:533;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:425;a:19:{s:4:"tmpl";i:1130;s:2:"id";i:16535;s:5:"title";s:27:"Beauty Salon &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/12/Footer.jpg";s:12:"tmpl_created";i:1608622498;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/beauty-salon-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:32:"["Beauty Salon","Footer","Hair"]";s:10:"menu_order";i:115;s:16:"popularity_index";i:524;s:11:"trend_index";i:126;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:426;a:19:{s:4:"tmpl";i:971;s:2:"id";i:13187;s:5:"title";s:33:"Interior Design &#8211; Home Page";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/04/Home.png";s:12:"tmpl_created";i:1586148661;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/interior-design-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:115;s:16:"popularity_index";i:331;s:11:"trend_index";i:264;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:427;a:19:{s:4:"tmpl";i:1453;s:2:"id";i:16346;s:5:"title";s:33:"Your New Home &#8211; Real Estate";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2017/03/lp3-l.png";s:12:"tmpl_created";i:1660205402;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/lp/your-new-home-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:2:"lp";s:11:"access_tier";s:4:"free";s:7:"subtype";s:11:"Real Estate";s:4:"tags";s:31:"["Landing Pages","Real estate"]";s:10:"menu_order";i:116;s:16:"popularity_index";i:-1;s:11:"trend_index";i:-1;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:428;a:19:{s:4:"tmpl";i:972;s:2:"id";i:13199;s:5:"title";s:29:"Interior Design &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/04/About.png";s:12:"tmpl_created";i:1586148666;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/interior-design-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:116;s:16:"popularity_index";i:316;s:11:"trend_index";i:334;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:429;a:19:{s:4:"tmpl";i:1129;s:2:"id";i:16545;s:5:"title";s:27:"Beauty Salon &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/12/Header.jpg";s:12:"tmpl_created";i:1608622495;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/beauty-salon-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:32:"["Beauty Salon","Hair","Header"]";s:10:"menu_order";i:117;s:16:"popularity_index";i:356;s:11:"trend_index";i:49;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:430;a:19:{s:4:"tmpl";i:973;s:2:"id";i:13214;s:5:"title";s:32:"Interior Design &#8211; Projects";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/portfolio_s.jpg";s:12:"tmpl_created";i:1586148672;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/interior-design-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:117;s:16:"popularity_index";i:367;s:11:"trend_index";i:323;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:431;a:19:{s:4:"tmpl";i:641;s:2:"id";i:7686;s:5:"title";s:12:"Blog Posts 1";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2018/03/blog_posts.png";s:12:"tmpl_created";i:1521558047;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/blog-posts-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:26:"["Archive","Blog","posts"]";s:10:"menu_order";i:118;s:16:"popularity_index";i:131;s:11:"trend_index";i:152;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:432;a:19:{s:4:"tmpl";i:974;s:2:"id";i:13229;s:5:"title";s:31:"Interior Design &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/04/Contact-Us.png";s:12:"tmpl_created";i:1586148677;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/interior-design-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:118;s:16:"popularity_index";i:395;s:11:"trend_index";i:337;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:433;a:19:{s:4:"tmpl";i:959;s:2:"id";i:12948;s:5:"title";s:29:"Photography &#8211; Home Page";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/02/Home_s.png";s:12:"tmpl_created";i:1582093442;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/photography-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:119;s:16:"popularity_index";i:241;s:11:"trend_index";i:201;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:434;a:19:{s:4:"tmpl";i:960;s:2:"id";i:12798;s:5:"title";s:25:"Photography &#8211; About";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/About_s.png";s:12:"tmpl_created";i:1582093446;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/photography-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:120;s:16:"popularity_index";i:499;s:11:"trend_index";i:374;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:435;a:19:{s:4:"tmpl";i:484;s:2:"id";i:5283;s:5:"title";s:9:"Clients 1";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_2.png";s:12:"tmpl_created";i:1520443478;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/clients-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:120;s:16:"popularity_index";i:294;s:11:"trend_index";i:202;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:436;a:19:{s:4:"tmpl";i:961;s:2:"id";i:12868;s:5:"title";s:27:"Photography &#8211; Contact";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/02/Contact_s.png";s:12:"tmpl_created";i:1582093450;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/photography-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:121;s:16:"popularity_index";i:531;s:11:"trend_index";i:350;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:437;a:19:{s:4:"tmpl";i:962;s:2:"id";i:13056;s:5:"title";s:28:"Photography &#8211; Wildlife";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/02/Wildlife_s.png";s:12:"tmpl_created";i:1582093454;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/photography-wildlife/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:122;s:16:"popularity_index";i:579;s:11:"trend_index";i:656;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:438;a:19:{s:4:"tmpl";i:487;s:2:"id";i:5306;s:5:"title";s:10:"Clients 10";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_3.png";s:12:"tmpl_created";i:1520443484;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:122;s:16:"popularity_index";i:657;s:11:"trend_index";i:581;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:439;a:19:{s:4:"tmpl";i:963;s:2:"id";i:12922;s:5:"title";s:37:"Photography &#8211; Glowing Jellyfish";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/02/Jellyfish_S.png";s:12:"tmpl_created";i:1582093457;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/photography-glowing-jellyfish/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:123;s:16:"popularity_index";i:628;s:11:"trend_index";i:532;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:440;a:19:{s:4:"tmpl";i:964;s:2:"id";i:12875;s:5:"title";s:36:"Photography &#8211; Fluttering Birds";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/Birds_s.png";s:12:"tmpl_created";i:1582093461;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/photography-fluttering-birds/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:124;s:16:"popularity_index";i:693;s:11:"trend_index";i:766;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:441;a:19:{s:4:"tmpl";i:965;s:2:"id";i:12962;s:5:"title";s:26:"Photography &#8211; Nature";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/02/Nature_s.png";s:12:"tmpl_created";i:1582093465;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/photography-nature/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:125;s:16:"popularity_index";i:592;s:11:"trend_index";i:778;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:442;a:19:{s:4:"tmpl";i:491;s:2:"id";i:5341;s:5:"title";s:10:"Clients 11";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_4.png";s:12:"tmpl_created";i:1520443491;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:125;s:16:"popularity_index";i:603;s:11:"trend_index";i:633;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:443;a:19:{s:4:"tmpl";i:966;s:2:"id";i:12833;s:5:"title";s:38:"Photography &#8211; Blossoming Flowers";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/02/Flowers_s.png";s:12:"tmpl_created";i:1582093469;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/photography-blossoming-flowers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:126;s:16:"popularity_index";i:597;s:11:"trend_index";i:750;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:444;a:19:{s:4:"tmpl";i:488;s:2:"id";i:5315;s:5:"title";s:10:"Clients 12";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4-1.png";s:12:"tmpl_created";i:1520443486;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:126;s:16:"popularity_index";i:485;s:11:"trend_index";i:263;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:445;a:19:{s:4:"tmpl";i:967;s:2:"id";i:12898;s:5:"title";s:36:"Photography &#8211; Forest Mushrooms";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/02/Mushrooms_s.png";s:12:"tmpl_created";i:1582093473;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/photography-forest-mushrooms/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:127;s:16:"popularity_index";i:667;s:11:"trend_index";i:649;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:446;a:19:{s:4:"tmpl";i:968;s:2:"id";i:12994;s:5:"title";s:24:"Photography &#8211; Pets";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/02/Pets_s.png";s:12:"tmpl_created";i:1582093477;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/photography-pets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:128;s:16:"popularity_index";i:612;s:11:"trend_index";i:508;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:447;a:19:{s:4:"tmpl";i:969;s:2:"id";i:12805;s:5:"title";s:37:"Photography &#8211; B&amp;W Portraits";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/02/Black_s.png";s:12:"tmpl_created";i:1582093481;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/photography-bw-portraits/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:129;s:16:"popularity_index";i:695;s:11:"trend_index";i:735;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:448;a:19:{s:4:"tmpl";i:490;s:2:"id";i:5333;s:5:"title";s:10:"Clients 13";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_6.png";s:12:"tmpl_created";i:1520443489;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:129;s:16:"popularity_index";i:234;s:11:"trend_index";i:128;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:449;a:19:{s:4:"tmpl";i:970;s:2:"id";i:13031;s:5:"title";s:33:"Photography &#8211; Vivid Parrots";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/02/Parrots_s.png";s:12:"tmpl_created";i:1582093484;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/photography-vivid-parrots/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:130;s:16:"popularity_index";i:660;s:11:"trend_index";i:643;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:450;a:19:{s:4:"tmpl";i:496;s:2:"id";i:5389;s:5:"title";s:10:"Clients 14";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_9.png";s:12:"tmpl_created";i:1520443501;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:130;s:16:"popularity_index";i:407;s:11:"trend_index";i:307;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:451;a:19:{s:4:"tmpl";i:940;s:2:"id";i:12621;s:5:"title";s:26:"Magazine &#8211; Home Page";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/01/Home_s.png";s:12:"tmpl_created";i:1579060604;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/magazine-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:131;s:16:"popularity_index";i:167;s:11:"trend_index";i:121;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:452;a:19:{s:4:"tmpl";i:936;s:2:"id";i:12352;s:5:"title";s:24:"Travel &#8211; Home Page";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/12/Home_s.png";s:12:"tmpl_created";i:1575960464;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/travel-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:132;s:16:"popularity_index";i:291;s:11:"trend_index";i:194;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:453;a:19:{s:4:"tmpl";i:486;s:2:"id";i:5298;s:5:"title";s:10:"Clients 15";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_3.png";s:12:"tmpl_created";i:1520443482;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:132;s:16:"popularity_index";i:465;s:11:"trend_index";i:520;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:454;a:19:{s:4:"tmpl";i:932;s:2:"id";i:12400;s:5:"title";s:20:"Travel &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2019/12/About.png";s:12:"tmpl_created";i:1575960441;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/travel-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:133;s:16:"popularity_index";i:444;s:11:"trend_index";i:445;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:455;a:19:{s:4:"tmpl";i:938;s:2:"id";i:12479;s:5:"title";s:20:"Travel &#8211; Tours";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/12/Tours_s.png";s:12:"tmpl_created";i:1575960474;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/travel-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:134;s:16:"popularity_index";i:539;s:11:"trend_index";i:726;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:456;a:19:{s:4:"tmpl";i:495;s:2:"id";i:5381;s:5:"title";s:10:"Clients 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_9.png";s:12:"tmpl_created";i:1520443499;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/clients-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:134;s:16:"popularity_index";i:198;s:11:"trend_index";i:168;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:457;a:19:{s:4:"tmpl";i:937;s:2:"id";i:12466;s:5:"title";s:27:"Travel &#8211; Testimonials";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/12/Testimonials.png";s:12:"tmpl_created";i:1575960469;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/travel-testimonials/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:135;s:16:"popularity_index";i:527;s:11:"trend_index";i:481;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:458;a:19:{s:4:"tmpl";i:935;s:2:"id";i:12443;s:5:"title";s:22:"Travel &#8211; Gallery";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/12/Gallery.png";s:12:"tmpl_created";i:1575960459;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/travel-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:136;s:16:"popularity_index";i:467;s:11:"trend_index";i:501;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:459;a:19:{s:4:"tmpl";i:934;s:2:"id";i:12431;s:5:"title";s:18:"Travel &#8211; FAQ";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2019/12/FAQ.png";s:12:"tmpl_created";i:1575960453;s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/travel-faq/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:137;s:16:"popularity_index";i:501;s:11:"trend_index";i:387;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:460;a:19:{s:4:"tmpl";i:493;s:2:"id";i:5357;s:5:"title";s:9:"Clients 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_7.png";s:12:"tmpl_created";i:1520443495;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/clients-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:137;s:16:"popularity_index";i:341;s:11:"trend_index";i:232;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:461;a:19:{s:4:"tmpl";i:933;s:2:"id";i:12421;s:5:"title";s:27:"Travel &#8211; Contact Page";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/12/Contsct-Us.png";s:12:"tmpl_created";i:1575960445;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/travel-contact-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:138;s:16:"popularity_index";i:571;s:11:"trend_index";i:536;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:462;a:19:{s:4:"tmpl";i:892;s:2:"id";i:11763;s:5:"title";s:27:"Portfolio &#8211; Home Page";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Homepage_small.png";s:12:"tmpl_created";i:1569428959;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/portfolio-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:139;s:16:"popularity_index";i:280;s:11:"trend_index";i:241;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:463;a:19:{s:4:"tmpl";i:485;s:2:"id";i:5290;s:5:"title";s:9:"Clients 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_2.png";s:12:"tmpl_created";i:1520443480;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/clients-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:139;s:16:"popularity_index";i:545;s:11:"trend_index";i:502;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:464;a:19:{s:4:"tmpl";i:891;s:2:"id";i:11781;s:5:"title";s:23:"Portfolio &#8211; About";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/09/About_small.png";s:12:"tmpl_created";i:1569428955;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/portfolio-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:140;s:16:"popularity_index";i:349;s:11:"trend_index";i:290;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:465;a:19:{s:4:"tmpl";i:482;s:2:"id";i:5266;s:5:"title";s:9:"Clients 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_white_1.png";s:12:"tmpl_created";i:1520443474;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:140;s:16:"popularity_index";i:95;s:11:"trend_index";i:134;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:466;a:19:{s:4:"tmpl";i:890;s:2:"id";i:11793;s:5:"title";s:26:"Portfolio &#8211; Projects";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Projects_small.png";s:12:"tmpl_created";i:1569428951;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/portfolio-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:141;s:16:"popularity_index";i:448;s:11:"trend_index";i:467;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:467;a:19:{s:4:"tmpl";i:889;s:2:"id";i:11800;s:5:"title";s:25:"Portfolio &#8211; Contact";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/09/Contact_small.png";s:12:"tmpl_created";i:1569428946;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/portfolio-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:142;s:16:"popularity_index";i:494;s:11:"trend_index";i:449;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:468;a:19:{s:4:"tmpl";i:866;s:2:"id";i:11163;s:5:"title";s:32:"Digital Agency &#8211; Home Page";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/07/Home_small.png";s:12:"tmpl_created";i:1564641877;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/digital-agency-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:143;s:16:"popularity_index";i:57;s:11:"trend_index";i:32;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:469;a:19:{s:4:"tmpl";i:483;s:2:"id";i:5275;s:5:"title";s:9:"Clients 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/clients_black_1.png";s:12:"tmpl_created";i:1520443476;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:143;s:16:"popularity_index";i:334;s:11:"trend_index";i:321;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:470;a:19:{s:4:"tmpl";i:492;s:2:"id";i:5349;s:5:"title";s:9:"Clients 7";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_7.png";s:12:"tmpl_created";i:1520443493;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:144;s:16:"popularity_index";i:233;s:11:"trend_index";i:92;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:471;a:19:{s:4:"tmpl";i:916;s:2:"id";i:12143;s:5:"title";s:22:"Law Firm &#8211; About";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2019/11/about.png";s:12:"tmpl_created";i:1572847069;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/law-firm-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:146;s:16:"popularity_index";i:350;s:11:"trend_index";i:344;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:472;a:19:{s:4:"tmpl";i:489;s:2:"id";i:5324;s:5:"title";s:9:"Clients 8";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5-1.png";s:12:"tmpl_created";i:1520443488;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:146;s:16:"popularity_index";i:526;s:11:"trend_index";i:381;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:473;a:19:{s:4:"tmpl";i:920;s:2:"id";i:12091;s:5:"title";s:21:"Law Firm &#8211; Team";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2019/11/team.png";s:12:"tmpl_created";i:1572847113;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/law-firm-team/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:147;s:16:"popularity_index";i:318;s:11:"trend_index";i:314;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:474;a:19:{s:4:"tmpl";i:869;s:2:"id";i:11129;s:5:"title";s:28:"Digital Agency &#8211; About";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/07/About_small.png";s:12:"tmpl_created";i:1564641889;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:148;s:16:"popularity_index";i:182;s:11:"trend_index";i:166;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:475;a:19:{s:4:"tmpl";i:880;s:2:"id";i:11572;s:5:"title";s:19:"Gym &#8211; Trainer";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Trainer_Small.png";s:12:"tmpl_created";i:1567392934;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:149;s:16:"popularity_index";i:521;s:11:"trend_index";i:590;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:476;a:19:{s:4:"tmpl";i:494;s:2:"id";i:5368;s:5:"title";s:9:"Clients 9";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_8.png";s:12:"tmpl_created";i:1520443497;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/clients-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"clients";s:4:"tags";s:11:"["Clients"]";s:10:"menu_order";i:149;s:16:"popularity_index";i:253;s:11:"trend_index";i:273;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:477;a:19:{s:4:"tmpl";i:917;s:2:"id";i:12133;s:5:"title";s:24:"Law Firm &#8211; Careers";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2019/11/careers.png";s:12:"tmpl_created";i:1572847078;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-careers/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:151;s:16:"popularity_index";i:583;s:11:"trend_index";i:640;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:478;a:19:{s:4:"tmpl";i:425;s:2:"id";i:4436;s:5:"title";s:11:"Contact  16";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_black_2.png";s:12:"tmpl_created";i:1520443293;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:151;s:16:"popularity_index";i:161;s:11:"trend_index";i:68;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:479;a:19:{s:4:"tmpl";i:915;s:2:"id";i:12155;s:5:"title";s:26:"Law Firm &#8211; Home Page";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2019/11/home.png";s:12:"tmpl_created";i:1572847054;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/law-firm-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:152;s:16:"popularity_index";i:193;s:11:"trend_index";i:110;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:480;a:19:{s:4:"tmpl";i:423;s:2:"id";i:4420;s:5:"title";s:9:"Contact 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_black_1.png";s:12:"tmpl_created";i:1520443289;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/contact-1-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:152;s:16:"popularity_index";i:196;s:11:"trend_index";i:127;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:481;a:19:{s:4:"tmpl";i:921;s:2:"id";i:12080;s:5:"title";s:24:"Law Firm &#8211; Partner";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/11/partner-1.png";s:12:"tmpl_created";i:1572847120;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-partner/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:153;s:16:"popularity_index";i:556;s:11:"trend_index";i:471;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:482;a:19:{s:4:"tmpl";i:534;s:2:"id";i:5836;s:5:"title";s:10:"Contact 10";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_2.png";s:12:"tmpl_created";i:1520443597;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:154;s:16:"popularity_index";i:114;s:11:"trend_index";i:76;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:483;a:19:{s:4:"tmpl";i:865;s:2:"id";i:11074;s:5:"title";s:31:"Digital Agency &#8211; Services";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/07/Services_small.png";s:12:"tmpl_created";i:1564641872;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/digital-agency-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:154;s:16:"popularity_index";i:163;s:11:"trend_index";i:170;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:484;a:19:{s:4:"tmpl";i:879;s:2:"id";i:11506;s:5:"title";s:19:"Gym &#8211; Classes";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Classes_Small.png";s:12:"tmpl_created";i:1567392930;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:155;s:16:"popularity_index";i:514;s:11:"trend_index";i:554;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:485;a:19:{s:4:"tmpl";i:535;s:2:"id";i:5844;s:5:"title";s:10:"Contact 11";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_2.png";s:12:"tmpl_created";i:1520443599;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:156;s:16:"popularity_index";i:289;s:11:"trend_index";i:313;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:486;a:19:{s:4:"tmpl";i:922;s:2:"id";i:12044;s:5:"title";s:24:"Law Firm &#8211; Contact";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/11/contsct_us.png";s:12:"tmpl_created";i:1572847130;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:157;s:16:"popularity_index";i:437;s:11:"trend_index";i:304;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:487;a:19:{s:4:"tmpl";i:430;s:2:"id";i:4476;s:5:"title";s:10:"Contact 15";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_4.png";s:12:"tmpl_created";i:1520443303;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:157;s:16:"popularity_index";i:229;s:11:"trend_index";i:187;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:488;a:19:{s:4:"tmpl";i:918;s:2:"id";i:12124;s:5:"title";s:25:"Law Firm &#8211; Services";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2019/11/services.png";s:12:"tmpl_created";i:1572847096;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/law-firm-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:158;s:16:"popularity_index";i:433;s:11:"trend_index";i:296;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:489;a:19:{s:4:"tmpl";i:864;s:2:"id";i:11056;s:5:"title";s:35:"Digital Agency &#8211; Social Media";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2019/07/Social-Media_small.png";s:12:"tmpl_created";i:1564641867;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/digital-agency-social-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:159;s:16:"popularity_index";i:297;s:11:"trend_index";i:361;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:490;a:19:{s:4:"tmpl";i:476;s:2:"id";i:5214;s:5:"title";s:10:"Contact 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_2.png";s:12:"tmpl_created";i:1520443462;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/contact-16-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:159;s:16:"popularity_index";i:194;s:11:"trend_index";i:106;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:491;a:19:{s:4:"tmpl";i:878;s:2:"id";i:11536;s:5:"title";s:19:"Gym &#8211; Fitness";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Fitness_Small.png";s:12:"tmpl_created";i:1567392927;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:160;s:16:"popularity_index";i:621;s:11:"trend_index";i:674;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:492;a:19:{s:4:"tmpl";i:882;s:2:"id";i:11545;s:5:"title";s:21:"Gym &#8211; Home Page";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/08/Home_Small.png";s:12:"tmpl_created";i:1567392943;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/gym-home-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:161;s:16:"popularity_index";i:310;s:11:"trend_index";i:229;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:493;a:19:{s:4:"tmpl";i:919;s:2:"id";i:12116;s:5:"title";s:24:"Law Firm &#8211; Service";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/11/family_law.png";s:12:"tmpl_created";i:1572847105;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/law-firm-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:162;s:16:"popularity_index";i:489;s:11:"trend_index";i:339;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:494;a:19:{s:4:"tmpl";i:478;s:2:"id";i:5230;s:5:"title";s:10:"Contact 17";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_3.png";s:12:"tmpl_created";i:1520443466;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:162;s:16:"popularity_index";i:339;s:11:"trend_index";i:335;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:495;a:19:{s:4:"tmpl";i:868;s:2:"id";i:11094;s:5:"title";s:30:"Digital Agency &#8211; Clients";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/07/Clients_small.png";s:12:"tmpl_created";i:1564641885;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/digital-agency-clients/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:163;s:16:"popularity_index";i:424;s:11:"trend_index";i:424;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:496;a:19:{s:4:"tmpl";i:481;s:2:"id";i:5257;s:5:"title";s:10:"Contact 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_5.png";s:12:"tmpl_created";i:1520443472;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/contact-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:163;s:16:"popularity_index";i:438;s:11:"trend_index";i:490;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:497;a:19:{s:4:"tmpl";i:881;s:2:"id";i:11478;s:5:"title";s:17:"Gym &#8211; About";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/08/About_Small.png";s:12:"tmpl_created";i:1567392939;s:6:"author";s:9:"Elementor";s:3:"url";s:108:"https://library.elementor.com/gym-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:164;s:16:"popularity_index";i:481;s:11:"trend_index";i:579;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:498;a:19:{s:4:"tmpl";i:532;s:2:"id";i:5820;s:5:"title";s:9:"Contact 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_white_1.png";s:12:"tmpl_created";i:1520443593;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:166;s:16:"popularity_index";i:183;s:11:"trend_index";i:357;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:499;a:19:{s:4:"tmpl";i:877;s:2:"id";i:11563;s:5:"title";s:19:"Gym &#8211; Pricing";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Pricing_Small.png";s:12:"tmpl_created";i:1567392923;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-pricing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:166;s:16:"popularity_index";i:577;s:11:"trend_index";i:736;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:500;a:19:{s:4:"tmpl";i:422;s:2:"id";i:4411;s:5:"title";s:9:"Contact 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_1.png";s:12:"tmpl_created";i:1520443287;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/contact-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:167;s:16:"popularity_index";i:113;s:11:"trend_index";i:217;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:501;a:19:{s:4:"tmpl";i:867;s:2:"id";i:11034;s:5:"title";s:30:"Digital Agency &#8211; Contact";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2019/07/Contsct-Us_small.png";s:12:"tmpl_created";i:1564641881;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/contact-digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:168;s:16:"popularity_index";i:191;s:11:"trend_index";i:156;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:502;a:19:{s:4:"tmpl";i:533;s:2:"id";i:5828;s:5:"title";s:9:"Contact 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/contact_black_1.png";s:12:"tmpl_created";i:1520443595;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:170;s:16:"popularity_index";i:312;s:11:"trend_index";i:495;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:503;a:19:{s:4:"tmpl";i:876;s:2:"id";i:11528;s:5:"title";s:19:"Gym &#8211; Contact";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/08/Contact_Small.png";s:12:"tmpl_created";i:1567392917;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/gym-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:4:"page";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:171;s:16:"popularity_index";i:505;s:11:"trend_index";i:624;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:504;a:19:{s:4:"tmpl";i:424;s:2:"id";i:4428;s:5:"title";s:9:"Contact 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_2.png";s:12:"tmpl_created";i:1520443291;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:171;s:16:"popularity_index";i:118;s:11:"trend_index";i:131;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:505;a:19:{s:4:"tmpl";i:426;s:2:"id";i:4444;s:5:"title";s:9:"Contact 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_1.png";s:12:"tmpl_created";i:1520443295;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:174;s:16:"popularity_index";i:84;s:11:"trend_index";i:93;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:506;a:19:{s:4:"tmpl";i:432;s:2:"id";i:4492;s:5:"title";s:9:"Contact 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/02/map_white_3.png";s:12:"tmpl_created";i:1520443307;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/contact-5-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:176;s:16:"popularity_index";i:37;s:11:"trend_index";i:31;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:507;a:19:{s:4:"tmpl";i:427;s:2:"id";i:4452;s:5:"title";s:9:"Contact 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_1.png";s:12:"tmpl_created";i:1520443296;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:178;s:16:"popularity_index";i:139;s:11:"trend_index";i:150;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:508;a:19:{s:4:"tmpl";i:429;s:2:"id";i:4468;s:5:"title";s:9:"Contact 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_3.png";s:12:"tmpl_created";i:1520443301;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:179;s:16:"popularity_index";i:127;s:11:"trend_index";i:72;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:509;a:19:{s:4:"tmpl";i:431;s:2:"id";i:4484;s:5:"title";s:9:"Contact 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_black_3.png";s:12:"tmpl_created";i:1520443305;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"contact";s:4:"tags";s:18:"["Contact","Form"]";s:10:"menu_order";i:182;s:16:"popularity_index";i:328;s:11:"trend_index";i:260;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:510;a:19:{s:4:"tmpl";i:428;s:2:"id";i:4460;s:5:"title";s:9:"Contact 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/contact_white_2.png";s:12:"tmpl_created";i:1520443298;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/contact-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:7:"contact";s:4:"tags";s:11:"["Contact"]";s:10:"menu_order";i:184;s:16:"popularity_index";i:99;s:11:"trend_index";i:80;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:511;a:19:{s:4:"tmpl";i:613;s:2:"id";i:5558;s:5:"title";s:5:"CTA 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_2.png";s:12:"tmpl_created";i:1520520684;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:185;s:16:"popularity_index";i:129;s:11:"trend_index";i:69;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:512;a:19:{s:4:"tmpl";i:634;s:2:"id";i:5939;s:5:"title";s:6:"CTA 10";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_13-1.png";s:12:"tmpl_created";i:1520520760;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:187;s:16:"popularity_index";i:190;s:11:"trend_index";i:118;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:513;a:19:{s:4:"tmpl";i:633;s:2:"id";i:5930;s:5:"title";s:6:"CTA 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_15.png";s:12:"tmpl_created";i:1520520758;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:190;s:16:"popularity_index";i:76;s:11:"trend_index";i:84;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:514;a:19:{s:4:"tmpl";i:632;s:2:"id";i:5921;s:5:"title";s:6:"CTA 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_14.png";s:12:"tmpl_created";i:1520520757;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:192;s:16:"popularity_index";i:278;s:11:"trend_index";i:234;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:515;a:19:{s:4:"tmpl";i:618;s:2:"id";i:5607;s:5:"title";s:6:"CTA 13";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_5.png";s:12:"tmpl_created";i:1520520695;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:194;s:16:"popularity_index";i:42;s:11:"trend_index";i:11;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:516;a:19:{s:4:"tmpl";i:574;s:2:"id";i:6017;s:5:"title";s:6:"CTA 14";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_14.png";s:12:"tmpl_created";i:1520520331;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:196;s:16:"popularity_index";i:152;s:11:"trend_index";i:122;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:517;a:19:{s:4:"tmpl";i:628;s:2:"id";i:5885;s:5:"title";s:6:"CTA 15";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_11.png";s:12:"tmpl_created";i:1520520751;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:197;s:16:"popularity_index";i:274;s:11:"trend_index";i:256;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:518;a:19:{s:4:"tmpl";i:627;s:2:"id";i:5877;s:5:"title";s:6:"CTA 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_10.png";s:12:"tmpl_created";i:1520520749;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:200;s:16:"popularity_index";i:564;s:11:"trend_index";i:677;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:519;a:19:{s:4:"tmpl";i:625;s:2:"id";i:5860;s:5:"title";s:6:"CTA 17";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_9.png";s:12:"tmpl_created";i:1520520746;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:201;s:16:"popularity_index";i:120;s:11:"trend_index";i:63;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:520;a:19:{s:4:"tmpl";i:626;s:2:"id";i:5869;s:5:"title";s:6:"CTA 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_10.png";s:12:"tmpl_created";i:1520520747;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:204;s:16:"popularity_index";i:345;s:11:"trend_index";i:486;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:521;a:19:{s:4:"tmpl";i:611;s:2:"id";i:5542;s:5:"title";s:6:"CTA 19";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_1.png";s:12:"tmpl_created";i:1520520681;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:205;s:16:"popularity_index";i:169;s:11:"trend_index";i:270;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:522;a:19:{s:4:"tmpl";i:614;s:2:"id";i:5567;s:5:"title";s:5:"CTA 2";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_2.png";s:12:"tmpl_created";i:1520520685;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:207;s:16:"popularity_index";i:143;s:11:"trend_index";i:225;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:523;a:19:{s:4:"tmpl";i:629;s:2:"id";i:5893;s:5:"title";s:6:"CTA 21";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_12.png";s:12:"tmpl_created";i:1520520752;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:210;s:16:"popularity_index";i:259;s:11:"trend_index";i:457;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:524;a:19:{s:4:"tmpl";i:619;s:2:"id";i:5634;s:5:"title";s:6:"CTA 24";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_6.png";s:12:"tmpl_created";i:1520520699;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:212;s:16:"popularity_index";i:188;s:11:"trend_index";i:255;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:525;a:19:{s:4:"tmpl";i:620;s:2:"id";i:5642;s:5:"title";s:6:"CTA 25";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_6.png";s:12:"tmpl_created";i:1520520701;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:214;s:16:"popularity_index";i:226;s:11:"trend_index";i:262;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:526;a:19:{s:4:"tmpl";i:615;s:2:"id";i:5583;s:5:"title";s:6:"CTA 26";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_3.png";s:12:"tmpl_created";i:1520520689;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:216;s:16:"popularity_index";i:117;s:11:"trend_index";i:117;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:527;a:19:{s:4:"tmpl";i:630;s:2:"id";i:5904;s:5:"title";s:6:"CTA 27";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_13.png";s:12:"tmpl_created";i:1520520754;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:217;s:16:"popularity_index";i:528;s:11:"trend_index";i:517;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:528;a:19:{s:4:"tmpl";i:631;s:2:"id";i:5912;s:5:"title";s:6:"CTA 28";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_11.png";s:12:"tmpl_created";i:1520520755;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:219;s:16:"popularity_index";i:665;s:11:"trend_index";i:702;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:529;a:19:{s:4:"tmpl";i:473;s:2:"id";i:5189;s:5:"title";s:6:"CTA 29";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_1.png";s:12:"tmpl_created";i:1520443456;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:221;s:16:"popularity_index";i:472;s:11:"trend_index";i:631;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:530;a:19:{s:4:"tmpl";i:623;s:2:"id";i:5667;s:5:"title";s:5:"CTA 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_8.png";s:12:"tmpl_created";i:1520520705;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:222;s:16:"popularity_index";i:171;s:11:"trend_index";i:250;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:531;a:19:{s:4:"tmpl";i:474;s:2:"id";i:5198;s:5:"title";s:6:"CTA 30";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_1.png";s:12:"tmpl_created";i:1520443458;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:225;s:16:"popularity_index";i:572;s:11:"trend_index";i:511;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:532;a:19:{s:4:"tmpl";i:475;s:2:"id";i:5206;s:5:"title";s:6:"CTA 31";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_2.png";s:12:"tmpl_created";i:1520443459;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:226;s:16:"popularity_index";i:593;s:11:"trend_index";i:611;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:533;a:19:{s:4:"tmpl";i:480;s:2:"id";i:5249;s:5:"title";s:6:"CTA 32";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_black_4.png";s:12:"tmpl_created";i:1520443470;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-32/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:14:"call to action";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:228;s:16:"popularity_index";i:512;s:11:"trend_index";i:409;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:534;a:19:{s:4:"tmpl";i:612;s:2:"id";i:5550;s:5:"title";s:6:"CTA 33";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_1.png";s:12:"tmpl_created";i:1520520682;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-33/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:231;s:16:"popularity_index";i:260;s:11:"trend_index";i:562;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:535;a:19:{s:4:"tmpl";i:536;s:2:"id";i:5852;s:5:"title";s:6:"CTA 34";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2018/03/form_1.png";s:12:"tmpl_created";i:1520443600;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/cta-34/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:8:"["Form"]";s:10:"menu_order";i:232;s:16:"popularity_index";i:563;s:11:"trend_index";i:828;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:536;a:19:{s:4:"tmpl";i:624;s:2:"id";i:5675;s:5:"title";s:5:"CTA 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_8.png";s:12:"tmpl_created";i:1520520707;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:235;s:16:"popularity_index";i:391;s:11:"trend_index";i:484;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:537;a:19:{s:4:"tmpl";i:616;s:2:"id";i:5591;s:5:"title";s:5:"CTA 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_4.png";s:12:"tmpl_created";i:1520520691;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:237;s:16:"popularity_index";i:133;s:11:"trend_index";i:130;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:538;a:19:{s:4:"tmpl";i:617;s:2:"id";i:5599;s:5:"title";s:5:"CTA 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_4.png";s:12:"tmpl_created";i:1520520693;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:239;s:16:"popularity_index";i:252;s:11:"trend_index";i:362;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:539;a:19:{s:4:"tmpl";i:514;s:2:"id";i:5575;s:5:"title";s:5:"CTA 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_3.png";s:12:"tmpl_created";i:1520443543;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:240;s:16:"popularity_index";i:13;s:11:"trend_index";i:586;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:540;a:19:{s:4:"tmpl";i:622;s:2:"id";i:5658;s:5:"title";s:5:"CTA 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_black_7.png";s:12:"tmpl_created";i:1520520704;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:243;s:16:"popularity_index";i:187;s:11:"trend_index";i:235;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:541;a:19:{s:4:"tmpl";i:621;s:2:"id";i:5650;s:5:"title";s:5:"CTA 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_7.png";s:12:"tmpl_created";i:1520520702;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/cta-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:14:"call to action";s:4:"tags";s:7:"["cta"]";s:10:"menu_order";i:244;s:16:"popularity_index";i:94;s:11:"trend_index";i:148;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:542;a:19:{s:4:"tmpl";i:1061;s:2:"id";i:15407;s:5:"title";s:24:"Dance Studio &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/10/404.jpg";s:12:"tmpl_created";i:1603181958;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/dance-studio-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:22:"["404","Dance Studio"]";s:10:"menu_order";i:246;s:16:"popularity_index";i:783;s:11:"trend_index";i:710;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:543;a:19:{s:4:"tmpl";i:1062;s:2:"id";i:15400;s:5:"title";s:27:"Dance Studio &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/10/Footer.jpg";s:12:"tmpl_created";i:1603181989;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/dance-studio-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:25:"["Dance Studio","Footer"]";s:10:"menu_order";i:247;s:16:"popularity_index";i:586;s:11:"trend_index";i:243;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:544;a:19:{s:4:"tmpl";i:1063;s:2:"id";i:15391;s:5:"title";s:27:"Dance Studio &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/10/Header.jpg";s:12:"tmpl_created";i:1603182011;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/dance-studio-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:25:"["Dance Studio","Header"]";s:10:"menu_order";i:248;s:16:"popularity_index";i:352;s:11:"trend_index";i:67;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:545;a:19:{s:4:"tmpl";i:874;s:2:"id";i:11192;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/07/Footer_small.jpg";s:12:"tmpl_created";i:1564642399;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:39:"["Digital Agency","Footer","Marketing"]";s:10:"menu_order";i:250;s:16:"popularity_index";i:172;s:11:"trend_index";i:105;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:546;a:19:{s:4:"tmpl";i:873;s:2:"id";i:11198;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2020/06/Header-digital-marketing-agency.png";s:12:"tmpl_created";i:1564642395;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:39:"["Digital Agency","Header","Marketing"]";s:10:"menu_order";i:251;s:16:"popularity_index";i:34;s:11:"trend_index";i:10;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:547;a:19:{s:4:"tmpl";i:872;s:2:"id";i:11204;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/07/404_small.jpg";s:12:"tmpl_created";i:1564642389;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:36:"["404","Digital Agency","Marketing"]";s:10:"menu_order";i:253;s:16:"popularity_index";i:301;s:11:"trend_index";i:239;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:548;a:19:{s:4:"tmpl";i:871;s:2:"id";i:11220;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/08/Archive_small1.png";s:12:"tmpl_created";i:1564642385;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/digital-agency-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:255;s:16:"popularity_index";i:116;s:11:"trend_index";i:73;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:549;a:19:{s:4:"tmpl";i:870;s:2:"id";i:11231;s:5:"title";s:14:"Digital Agency";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2019/07/Post_small1.png";s:12:"tmpl_created";i:1564642380;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/digital-agency/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:30:"["Digital Agency","Marketing"]";s:10:"menu_order";i:257;s:16:"popularity_index";i:145;s:11:"trend_index";i:71;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:550;a:19:{s:4:"tmpl";i:520;s:2:"id";i:5711;s:5:"title";s:5:"FAQ 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_2.png";s:12:"tmpl_created";i:1520443571;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:260;s:16:"popularity_index";i:200;s:11:"trend_index";i:231;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:551;a:19:{s:4:"tmpl";i:523;s:2:"id";i:5737;s:5:"title";s:6:"FAQ 10";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_4.png";s:12:"tmpl_created";i:1520443576;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/faq-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:261;s:16:"popularity_index";i:155;s:11:"trend_index";i:112;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:552;a:19:{s:4:"tmpl";i:524;s:2:"id";i:5746;s:5:"title";s:6:"FAQ 11";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_4.png";s:12:"tmpl_created";i:1520443578;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/faq-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:264;s:16:"popularity_index";i:212;s:11:"trend_index";i:305;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:553;a:19:{s:4:"tmpl";i:519;s:2:"id";i:5703;s:5:"title";s:6:"FAQ 13";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_2.png";s:12:"tmpl_created";i:1520443569;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/faq-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:265;s:16:"popularity_index";i:29;s:11:"trend_index";i:38;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:554;a:19:{s:4:"tmpl";i:521;s:2:"id";i:5719;s:5:"title";s:5:"FAQ 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_3.png";s:12:"tmpl_created";i:1520443573;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:267;s:16:"popularity_index";i:125;s:11:"trend_index";i:251;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:555;a:19:{s:4:"tmpl";i:522;s:2:"id";i:5729;s:5:"title";s:5:"FAQ 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_3.png";s:12:"tmpl_created";i:1520443575;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:269;s:16:"popularity_index";i:319;s:11:"trend_index";i:327;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:556;a:19:{s:4:"tmpl";i:525;s:2:"id";i:5755;s:5:"title";s:5:"FAQ 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_5.png";s:12:"tmpl_created";i:1520443580;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:271;s:16:"popularity_index";i:112;s:11:"trend_index";i:180;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:557;a:19:{s:4:"tmpl";i:526;s:2:"id";i:5764;s:5:"title";s:5:"FAQ 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_5.png";s:12:"tmpl_created";i:1520443582;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:273;s:16:"popularity_index";i:338;s:11:"trend_index";i:474;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:558;a:19:{s:4:"tmpl";i:517;s:2:"id";i:5684;s:5:"title";s:5:"FAQ 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_white_1.png";s:12:"tmpl_created";i:1520443565;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:274;s:16:"popularity_index";i:74;s:11:"trend_index";i:193;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:559;a:19:{s:4:"tmpl";i:518;s:2:"id";i:5693;s:5:"title";s:5:"FAQ 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/faq_black_1.png";s:12:"tmpl_created";i:1520443567;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/faq-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:3:"faq";s:4:"tags";s:7:"["Faq"]";s:10:"menu_order";i:276;s:16:"popularity_index";i:224;s:11:"trend_index";i:515;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:560;a:19:{s:4:"tmpl";i:548;s:2:"id";i:6053;s:5:"title";s:10:"Features 1";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_5.png";s:12:"tmpl_created";i:1520443645;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:277;s:16:"popularity_index";i:179;s:11:"trend_index";i:463;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:561;a:19:{s:4:"tmpl";i:542;s:2:"id";i:5991;s:5:"title";s:11:"Features 10";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_4.png";s:12:"tmpl_created";i:1520443632;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/features-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:279;s:16:"popularity_index";i:135;s:11:"trend_index";i:265;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:562;a:19:{s:4:"tmpl";i:547;s:2:"id";i:6044;s:5:"title";s:11:"Features 11";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_5.png";s:12:"tmpl_created";i:1520443643;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/features-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:280;s:16:"popularity_index";i:70;s:11:"trend_index";i:163;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:563;a:19:{s:4:"tmpl";i:566;s:2:"id";i:6212;s:5:"title";s:11:"Features 12";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_7.png";s:12:"tmpl_created";i:1520443684;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/features-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:281;s:16:"popularity_index";i:81;s:11:"trend_index";i:98;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:564;a:19:{s:4:"tmpl";i:567;s:2:"id";i:6220;s:5:"title";s:10:"Features 2";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_8.png";s:12:"tmpl_created";i:1520443685;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:282;s:16:"popularity_index";i:88;s:11:"trend_index";i:189;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:565;a:19:{s:4:"tmpl";i:541;s:2:"id";i:5983;s:5:"title";s:10:"Features 3";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_3.png";s:12:"tmpl_created";i:1520443630;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:2:"[]";s:10:"menu_order";i:283;s:16:"popularity_index";i:231;s:11:"trend_index";i:351;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:566;a:19:{s:4:"tmpl";i:540;s:2:"id";i:5974;s:5:"title";s:10:"Features 4";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_3.png";s:12:"tmpl_created";i:1520443629;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:286;s:16:"popularity_index";i:69;s:11:"trend_index";i:181;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:567;a:19:{s:4:"tmpl";i:516;s:2:"id";i:5624;s:5:"title";s:10:"Features 5";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_black_1.png";s:12:"tmpl_created";i:1520443553;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:287;s:16:"popularity_index";i:93;s:11:"trend_index";i:352;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:568;a:19:{s:4:"tmpl";i:515;s:2:"id";i:5615;s:5:"title";s:10:"Features 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/cta_white_5.png";s:12:"tmpl_created";i:1520443551;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:290;s:16:"popularity_index";i:41;s:11:"trend_index";i:119;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:569;a:19:{s:4:"tmpl";i:539;s:2:"id";i:5963;s:5:"title";s:10:"Features 7";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_2.png";s:12:"tmpl_created";i:1520443626;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:291;s:16:"popularity_index";i:67;s:11:"trend_index";i:133;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:570;a:19:{s:4:"tmpl";i:565;s:2:"id";i:6204;s:5:"title";s:10:"Features 8";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_6.png";s:12:"tmpl_created";i:1520443681;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:292;s:16:"popularity_index";i:217;s:11:"trend_index";i:223;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:571;a:19:{s:4:"tmpl";i:564;s:2:"id";i:6196;s:5:"title";s:10:"Features 9";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/features_white_6.png";s:12:"tmpl_created";i:1520443680;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/features-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"features";s:4:"tags";s:12:"["Features"]";s:10:"menu_order";i:294;s:16:"popularity_index";i:106;s:11:"trend_index";i:113;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:572;a:19:{s:4:"tmpl";i:1033;s:2:"id";i:15033;s:5:"title";s:28:"Flooring Company &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/08/404.png";s:12:"tmpl_created";i:1597739459;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/flooring-company-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:45:"["404","Flooring company","Flooring website"]";s:10:"menu_order";i:296;s:16:"popularity_index";i:655;s:11:"trend_index";i:671;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:573;a:19:{s:4:"tmpl";i:1032;s:2:"id";i:15042;s:5:"title";s:32:"Flooring Company &#8211; Archive";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/08/Blog.png";s:12:"tmpl_created";i:1597739084;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/flooring-company-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:297;s:16:"popularity_index";i:320;s:11:"trend_index";i:275;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:574;a:19:{s:4:"tmpl";i:1031;s:2:"id";i:15017;s:5:"title";s:31:"Flooring Company &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/08/Footer.png";s:12:"tmpl_created";i:1597738933;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/flooring-company-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:48:"["Flooring company","Flooring website","Footer"]";s:10:"menu_order";i:299;s:16:"popularity_index";i:323;s:11:"trend_index";i:192;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:575;a:19:{s:4:"tmpl";i:1030;s:2:"id";i:15007;s:5:"title";s:31:"Flooring Company &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/08/Header.png";s:12:"tmpl_created";i:1597738896;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/flooring-company-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:48:"["Flooring company","Flooring website","Header"]";s:10:"menu_order";i:302;s:16:"popularity_index";i:459;s:11:"trend_index";i:333;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:576;a:19:{s:4:"tmpl";i:1029;s:2:"id";i:15052;s:5:"title";s:36:"Flooring Company &#8211; Single post";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/08/Single.png";s:12:"tmpl_created";i:1597738858;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/blocks/flooring-company-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:39:"["Flooring company","Flooring website"]";s:10:"menu_order";i:303;s:16:"popularity_index";i:392;s:11:"trend_index";i:226;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:577;a:19:{s:4:"tmpl";i:651;s:2:"id";i:7837;s:5:"title";s:9:"footer 01";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.14.jpg";s:12:"tmpl_created";i:1524582852;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:305;s:16:"popularity_index";i:495;s:11:"trend_index";i:539;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:578;a:19:{s:4:"tmpl";i:647;s:2:"id";i:7937;s:5:"title";s:10:"footer 010";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.5.jpg";s:12:"tmpl_created";i:1524582665;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-010/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:308;s:16:"popularity_index";i:185;s:11:"trend_index";i:115;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:579;a:19:{s:4:"tmpl";i:646;s:2:"id";i:7950;s:5:"title";s:10:"footer 011";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.4.jpg";s:12:"tmpl_created";i:1524582631;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-011/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:310;s:16:"popularity_index";i:244;s:11:"trend_index";i:203;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:580;a:19:{s:4:"tmpl";i:645;s:2:"id";i:7959;s:5:"title";s:10:"footer 012";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.3.jpg";s:12:"tmpl_created";i:1524582605;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-012/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:311;s:16:"popularity_index";i:177;s:11:"trend_index";i:140;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:581;a:19:{s:4:"tmpl";i:644;s:2:"id";i:7982;s:5:"title";s:10:"footer 013";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.2.jpg";s:12:"tmpl_created";i:1524582468;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-013/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:314;s:16:"popularity_index";i:209;s:11:"trend_index";i:212;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:582;a:19:{s:4:"tmpl";i:643;s:2:"id";i:7997;s:5:"title";s:10:"footer 014";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.1.jpg";s:12:"tmpl_created";i:1524582343;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/footer-014/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:316;s:16:"popularity_index";i:64;s:11:"trend_index";i:41;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:583;a:19:{s:4:"tmpl";i:693;s:2:"id";i:9119;s:5:"title";s:10:"footer 015";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/Footer_GetStarted_350.png";s:12:"tmpl_created";i:1532428138;s:6:"author";s:9:"Elementor";s:3:"url";s:110:"https://library.elementor.com/blocks/demo/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:317;s:16:"popularity_index";i:240;s:11:"trend_index";i:154;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:584;a:19:{s:4:"tmpl";i:652;s:2:"id";i:7852;s:5:"title";s:9:"footer 02";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.13.jpg";s:12:"tmpl_created";i:1524582875;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:320;s:16:"popularity_index";i:199;s:11:"trend_index";i:96;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:585;a:19:{s:4:"tmpl";i:653;s:2:"id";i:7862;s:5:"title";s:9:"footer 03";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.12.jpg";s:12:"tmpl_created";i:1524582903;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:321;s:16:"popularity_index";i:137;s:11:"trend_index";i:91;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:586;a:19:{s:4:"tmpl";i:654;s:2:"id";i:7871;s:5:"title";s:9:"footer 04";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.11.jpg";s:12:"tmpl_created";i:1524582927;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:323;s:16:"popularity_index";i:97;s:11:"trend_index";i:55;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:587;a:19:{s:4:"tmpl";i:655;s:2:"id";i:7884;s:5:"title";s:9:"footer 05";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.10.jpg";s:12:"tmpl_created";i:1524582944;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:325;s:16:"popularity_index";i:92;s:11:"trend_index";i:109;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:588;a:19:{s:4:"tmpl";i:656;s:2:"id";i:7892;s:5:"title";s:9:"footer 06";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.9.jpg";s:12:"tmpl_created";i:1524583015;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:326;s:16:"popularity_index";i:132;s:11:"trend_index";i:146;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:589;a:19:{s:4:"tmpl";i:650;s:2:"id";i:7904;s:5:"title";s:9:"footer 07";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.8.jpg";s:12:"tmpl_created";i:1524582814;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:328;s:16:"popularity_index";i:203;s:11:"trend_index";i:186;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:590;a:19:{s:4:"tmpl";i:649;s:2:"id";i:7917;s:5:"title";s:9:"footer 08";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.7.jpg";s:12:"tmpl_created";i:1524582788;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:329;s:16:"popularity_index";i:89;s:11:"trend_index";i:144;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:591;a:19:{s:4:"tmpl";i:648;s:2:"id";i:7927;s:5:"title";s:9:"footer 09";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/footer350.6.jpg";s:12:"tmpl_created";i:1524582691;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/footer-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:2:"[]";s:10:"menu_order";i:331;s:16:"popularity_index";i:178;s:11:"trend_index";i:100;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:592;a:19:{s:4:"tmpl";i:642;s:2:"id";i:4676;s:5:"title";s:8:"Footer 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/footer_7.png";s:12:"tmpl_created";i:1522014215;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/footer_7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["Footer"]";s:10:"menu_order";i:338;s:16:"popularity_index";i:237;s:11:"trend_index";i:346;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:593;a:19:{s:4:"tmpl";i:637;s:2:"id";i:7627;s:5:"title";s:8:"Footer 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_1.png";s:12:"tmpl_created";i:1521547332;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/footer-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["Footer"]";s:10:"menu_order";i:340;s:16:"popularity_index";i:100;s:11:"trend_index";i:83;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:594;a:19:{s:4:"tmpl";i:638;s:2:"id";i:7638;s:5:"title";s:8:"Footer 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/footer_hero_2.png";s:12:"tmpl_created";i:1521547502;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/footer-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:10:"["Footer"]";s:10:"menu_order";i:342;s:16:"popularity_index";i:124;s:11:"trend_index";i:147;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:595;a:19:{s:4:"tmpl";i:888;s:2:"id";i:11424;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/08/404_Small.png";s:12:"tmpl_created";i:1567393309;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:13:"["404","Gym"]";s:10:"menu_order";i:344;s:16:"popularity_index";i:679;s:11:"trend_index";i:769;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:596;a:19:{s:4:"tmpl";i:887;s:2:"id";i:11435;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/08/Archiv_Small.png";s:12:"tmpl_created";i:1567393296;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:346;s:16:"popularity_index";i:441;s:11:"trend_index";i:507;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:597;a:19:{s:4:"tmpl";i:886;s:2:"id";i:11445;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/08/Post_Small.png";s:12:"tmpl_created";i:1567393229;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:7:"["Gym"]";s:10:"menu_order";i:349;s:16:"popularity_index";i:452;s:11:"trend_index";i:479;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:598;a:19:{s:4:"tmpl";i:885;s:2:"id";i:11453;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/08/Footer_Small.png";s:12:"tmpl_created";i:1567393224;s:6:"author";s:9:"Elementor";s:3:"url";s:111:"https://library.elementor.com/blocks/gym-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:16:"["Footer","Gym"]";s:10:"menu_order";i:351;s:16:"popularity_index";i:270;s:11:"trend_index";i:331;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:599;a:19:{s:4:"tmpl";i:884;s:2:"id";i:11461;s:5:"title";s:3:"GYM";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2020/06/Header-gym-and-fitness.png";s:12:"tmpl_created";i:1567393219;s:6:"author";s:9:"Elementor";s:3:"url";s:109:"https://library.elementor.com/blocks/gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:16:"["Gym","Header"]";s:10:"menu_order";i:352;s:16:"popularity_index";i:201;s:11:"trend_index";i:135;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:600;a:19:{s:4:"tmpl";i:635;s:2:"id";i:7596;s:5:"title";s:8:"Header 1";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.12.jpg";s:12:"tmpl_created";i:1521546999;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:10:"["Header"]";s:10:"menu_order";i:354;s:16:"popularity_index";i:33;s:11:"trend_index";i:17;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:601;a:19:{s:4:"tmpl";i:663;s:2:"id";i:7801;s:5:"title";s:9:"header 10";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.9.jpg";s:12:"tmpl_created";i:1524583659;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:356;s:16:"popularity_index";i:51;s:11:"trend_index";i:14;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:602;a:19:{s:4:"tmpl";i:658;s:2:"id";i:7812;s:5:"title";s:9:"header 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.10.jpg";s:12:"tmpl_created";i:1524583298;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:358;s:16:"popularity_index";i:96;s:11:"trend_index";i:103;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:603;a:19:{s:4:"tmpl";i:657;s:2:"id";i:7825;s:5:"title";s:9:"header 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/header350.11.jpg";s:12:"tmpl_created";i:1524583273;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:360;s:16:"popularity_index";i:63;s:11:"trend_index";i:75;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:604;a:19:{s:4:"tmpl";i:694;s:2:"id";i:9127;s:5:"title";s:9:"header 13";s:9:"thumbnail";s:86:"https://library.elementor.com/wp-content/uploads/2018/07/Header_get_started_1200V3.png";s:12:"tmpl_created";i:1532428699;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/header-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:362;s:16:"popularity_index";i:61;s:11:"trend_index";i:58;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:605;a:19:{s:4:"tmpl";i:636;s:2:"id";i:7615;s:5:"title";s:8:"Header 2";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.1.jpg";s:12:"tmpl_created";i:1521547237;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:10:"["Header"]";s:10:"menu_order";i:365;s:16:"popularity_index";i:30;s:11:"trend_index";i:33;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:606;a:19:{s:4:"tmpl";i:665;s:2:"id";i:7713;s:5:"title";s:8:"header 3";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.2.jpg";s:12:"tmpl_created";i:1524584780;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:367;s:16:"popularity_index";i:43;s:11:"trend_index";i:28;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:607;a:19:{s:4:"tmpl";i:659;s:2:"id";i:7724;s:5:"title";s:8:"header 4";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.3.jpg";s:12:"tmpl_created";i:1524583367;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:369;s:16:"popularity_index";i:24;s:11:"trend_index";i:13;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:608;a:19:{s:4:"tmpl";i:660;s:2:"id";i:7734;s:5:"title";s:8:"header 5";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.4.jpg";s:12:"tmpl_created";i:1524583436;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:371;s:16:"popularity_index";i:36;s:11:"trend_index";i:18;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:609;a:19:{s:4:"tmpl";i:666;s:2:"id";i:7744;s:5:"title";s:8:"Header 6";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.5.jpg";s:12:"tmpl_created";i:1524584784;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:372;s:16:"popularity_index";i:65;s:11:"trend_index";i:94;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:610;a:19:{s:4:"tmpl";i:664;s:2:"id";i:7754;s:5:"title";s:8:"header 7";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.6.jpg";s:12:"tmpl_created";i:1524583712;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:375;s:16:"popularity_index";i:111;s:11:"trend_index";i:143;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:611;a:19:{s:4:"tmpl";i:661;s:2:"id";i:7771;s:5:"title";s:8:"header 8";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.7.jpg";s:12:"tmpl_created";i:1524583540;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:376;s:16:"popularity_index";i:91;s:11:"trend_index";i:60;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:612;a:19:{s:4:"tmpl";i:662;s:2:"id";i:7787;s:5:"title";s:8:"header 9";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/header350.8.jpg";s:12:"tmpl_created";i:1524583598;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/header-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:2:"[]";s:10:"menu_order";i:379;s:16:"popularity_index";i:102;s:11:"trend_index";i:78;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:613;a:19:{s:4:"tmpl";i:572;s:2:"id";i:6266;s:5:"title";s:6:"Hero 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_4.png";s:12:"tmpl_created";i:1520443695;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:380;s:16:"popularity_index";i:52;s:11:"trend_index";i:35;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:614;a:19:{s:4:"tmpl";i:528;s:2:"id";i:5783;s:5:"title";s:7:"Hero 10";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_2.png";s:12:"tmpl_created";i:1520443586;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/hero-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:383;s:16:"popularity_index";i:365;s:11:"trend_index";i:567;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:615;a:19:{s:4:"tmpl";i:527;s:2:"id";i:5773;s:5:"title";s:7:"Hero 11";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_1.png";s:12:"tmpl_created";i:1520443584;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/hero-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:384;s:16:"popularity_index";i:39;s:11:"trend_index";i:179;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:616;a:19:{s:4:"tmpl";i:479;s:2:"id";i:5238;s:5:"title";s:7:"Hero 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/form_white_4.png";s:12:"tmpl_created";i:1520443468;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/hero-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:386;s:16:"popularity_index";i:611;s:11:"trend_index";i:555;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:617;a:19:{s:4:"tmpl";i:573;s:2:"id";i:6274;s:5:"title";s:6:"Hero 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_5.png";s:12:"tmpl_created";i:1520443698;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:389;s:16:"popularity_index";i:87;s:11:"trend_index";i:88;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:618;a:19:{s:4:"tmpl";i:569;s:2:"id";i:6239;s:5:"title";s:6:"Hero 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_1.png";s:12:"tmpl_created";i:1520443689;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:391;s:16:"popularity_index";i:23;s:11:"trend_index";i:34;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:619;a:19:{s:4:"tmpl";i:571;s:2:"id";i:6258;s:5:"title";s:6:"Hero 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_3.png";s:12:"tmpl_created";i:1520443693;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:393;s:16:"popularity_index";i:479;s:11:"trend_index";i:470;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:620;a:19:{s:4:"tmpl";i:570;s:2:"id";i:6249;s:5:"title";s:6:"Hero 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_black_2.png";s:12:"tmpl_created";i:1520443691;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:395;s:16:"popularity_index";i:56;s:11:"trend_index";i:85;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:621;a:19:{s:4:"tmpl";i:568;s:2:"id";i:6230;s:5:"title";s:6:"Hero 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/heroo_white_1.png";s:12:"tmpl_created";i:1520443687;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:396;s:16:"popularity_index";i:406;s:11:"trend_index";i:542;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:622;a:19:{s:4:"tmpl";i:530;s:2:"id";i:5801;s:5:"title";s:6:"Hero 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_4.png";s:12:"tmpl_created";i:1520443589;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:8:"["hero"]";s:10:"menu_order";i:398;s:16:"popularity_index";i:15;s:11:"trend_index";i:37;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:623;a:19:{s:4:"tmpl";i:531;s:2:"id";i:5811;s:5:"title";s:6:"Hero 8";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_5.png";s:12:"tmpl_created";i:1520443591;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:400;s:16:"popularity_index";i:105;s:11:"trend_index";i:86;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:624;a:19:{s:4:"tmpl";i:529;s:2:"id";i:5792;s:5:"title";s:6:"Hero 9";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/03/header_3.png";s:12:"tmpl_created";i:1520443588;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/hero-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"hero";s:4:"tags";s:2:"[]";s:10:"menu_order";i:403;s:16:"popularity_index";i:225;s:11:"trend_index";i:244;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:625;a:19:{s:4:"tmpl";i:978;s:2:"id";i:13251;s:5:"title";s:27:"Interior Design &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/04/404.png";s:12:"tmpl_created";i:1586148737;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/interior-design-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:405;s:16:"popularity_index";i:730;s:11:"trend_index";i:795;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:626;a:19:{s:4:"tmpl";i:979;s:2:"id";i:13244;s:5:"title";s:30:"Interior Design &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/04/Footer.png";s:12:"tmpl_created";i:1586148742;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/interior-design-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:39:"["Business","Footer","Interior Design"]";s:10:"menu_order";i:406;s:16:"popularity_index";i:322;s:11:"trend_index";i:178;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:627;a:19:{s:4:"tmpl";i:980;s:2:"id";i:13236;s:5:"title";s:30:"Interior Design &#8211; Header";s:9:"thumbnail";s:83:"https://library.elementor.com/wp-content/uploads/2020/06/Header-interior-design.png";s:12:"tmpl_created";i:1586148746;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/interior-design-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:39:"["Business","Header","Interior Design"]";s:10:"menu_order";i:408;s:16:"popularity_index";i:146;s:11:"trend_index";i:64;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:628;a:19:{s:4:"tmpl";i:977;s:2:"id";i:13259;s:5:"title";s:36:"Interior Design &#8211; News Archive";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/Archiv-Blog.png";s:12:"tmpl_created";i:1586148733;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/blocks/interior-design-news-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:410;s:16:"popularity_index";i:436;s:11:"trend_index";i:132;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:629;a:19:{s:4:"tmpl";i:976;s:2:"id";i:13267;s:5:"title";s:35:"Interior Design &#8211; Single News";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/04/Post.png";s:12:"tmpl_created";i:1586148728;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/blocks/interior-design-single-news/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:413;s:16:"popularity_index";i:402;s:11:"trend_index";i:108;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:630;a:19:{s:4:"tmpl";i:975;s:2:"id";i:13274;s:5:"title";s:38:"Interior Design &#8211; Single Project";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/04/Single-Project-.png";s:12:"tmpl_created";i:1586148723;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/blocks/interior-design-single-project/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:30:"["Business","Interior Design"]";s:10:"menu_order";i:414;s:16:"popularity_index";i:601;s:11:"trend_index";i:324;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:631;a:19:{s:4:"tmpl";i:1011;s:2:"id";i:14058;s:5:"title";s:36:"Japanese restaurant &#8211; 404 page";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/06/404-Page.jpg";s:12:"tmpl_created";i:1592290211;s:6:"author";s:9:"Elementor";s:3:"url";s:134:"https://library.elementor.com/blocks/japanese-restaurant-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:38:"["404","Food","Japanese","Restaurant"]";s:10:"menu_order";i:416;s:16:"popularity_index";i:724;s:11:"trend_index";i:647;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:632;a:19:{s:4:"tmpl";i:1012;s:2:"id";i:14050;s:5:"title";s:34:"Japanese restaurant &#8211; Footer";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/06/Footer-Small.jpg";s:12:"tmpl_created";i:1592290247;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/japanese-restaurant-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:41:"["Food","Footer","Japanese","Restaurant"]";s:10:"menu_order";i:419;s:16:"popularity_index";i:317;s:11:"trend_index";i:238;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:633;a:19:{s:4:"tmpl";i:1013;s:2:"id";i:14042;s:5:"title";s:34:"Japanese Restaurant &#8211; Header";s:9:"thumbnail";s:87:"https://library.elementor.com/wp-content/uploads/2020/06/japanese-restaurant-header.jpg";s:12:"tmpl_created";i:1592290277;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/japanese-restaurant-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:41:"["Food","Header","Japanese","Restaurant"]";s:10:"menu_order";i:421;s:16:"popularity_index";i:411;s:11:"trend_index";i:274;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:634;a:19:{s:4:"tmpl";i:914;s:2:"id";i:12164;s:5:"title";s:20:"Law Firm &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2019/11/404.png";s:12:"tmpl_created";i:1572846979;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/law-firm-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:24:"["404","Law","Law Firm"]";s:10:"menu_order";i:422;s:16:"popularity_index";i:704;s:11:"trend_index";i:716;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:635;a:19:{s:4:"tmpl";i:913;s:2:"id";i:12170;s:5:"title";s:23:"Law Firm &#8211; Archiv";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/11/archiv.png";s:12:"tmpl_created";i:1572846967;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/law-firm-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:424;s:16:"popularity_index";i:431;s:11:"trend_index";i:294;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:636;a:19:{s:4:"tmpl";i:912;s:2:"id";i:12179;s:5:"title";s:23:"Law Firm &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/11/footer.png";s:12:"tmpl_created";i:1572846958;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/law-firm-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:27:"["Footer","Law","Law Firm"]";s:10:"menu_order";i:425;s:16:"popularity_index";i:388;s:11:"trend_index";i:240;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:637;a:19:{s:4:"tmpl";i:911;s:2:"id";i:12194;s:5:"title";s:23:"Law Firm &#8211; Header";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/06/Header-law-firm.png";s:12:"tmpl_created";i:1572846935;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/law-firm-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:27:"["Header","Law","Law Firm"]";s:10:"menu_order";i:427;s:16:"popularity_index";i:80;s:11:"trend_index";i:39;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:638;a:19:{s:4:"tmpl";i:910;s:2:"id";i:12203;s:5:"title";s:30:"Law Firm &#8211; Search Archiv";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/11/search_result.png";s:12:"tmpl_created";i:1572846925;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/law-firm-search-archiv/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:430;s:16:"popularity_index";i:493;s:11:"trend_index";i:433;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:639;a:19:{s:4:"tmpl";i:909;s:2:"id";i:12212;s:5:"title";s:28:"Law Firm &#8211; Single Post";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2019/11/single.png";s:12:"tmpl_created";i:1572846914;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/law-firm-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:18:"["Law","Law Firm"]";s:10:"menu_order";i:432;s:16:"popularity_index";i:326;s:11:"trend_index";i:214;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:640;a:19:{s:4:"tmpl";i:1022;s:2:"id";i:14772;s:5:"title";s:35:"Luxury Real Estate &#8211; 404 page";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/07/404.png";s:12:"tmpl_created";i:1595315728;s:6:"author";s:9:"Elementor";s:3:"url";s:133:"https://library.elementor.com/blocks/luxury-real-estate-404-page/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:34:"["404","Real estate","Realestate"]";s:10:"menu_order";i:433;s:16:"popularity_index";i:759;s:11:"trend_index";i:720;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:641;a:19:{s:4:"tmpl";i:1023;s:2:"id";i:14779;s:5:"title";s:33:"Luxury Real Estate &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/07/Footer.png";s:12:"tmpl_created";i:1595315743;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/blocks/luxury-real-estate-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:37:"["Footer","Real estate","Realestate"]";s:10:"menu_order";i:434;s:16:"popularity_index";i:536;s:11:"trend_index";i:505;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:642;a:19:{s:4:"tmpl";i:1024;s:2:"id";i:14790;s:5:"title";s:33:"Luxury Real Estate &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/07/Header.png";s:12:"tmpl_created";i:1595315760;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/blocks/luxury-real-estate-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:37:"["Header","Real estate","Realestate"]";s:10:"menu_order";i:436;s:16:"popularity_index";i:101;s:11:"trend_index";i:157;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:643;a:19:{s:4:"tmpl";i:1026;s:2:"id";i:14809;s:5:"title";s:45:"Luxury Real Estate &#8211; Properties Archive";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2020/07/Properties.png";s:12:"tmpl_created";i:1595315826;s:6:"author";s:9:"Elementor";s:3:"url";s:143:"https://library.elementor.com/blocks/luxury-real-estate-properties-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:438;s:16:"popularity_index";i:414;s:11:"trend_index";i:420;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:644;a:19:{s:4:"tmpl";i:1027;s:2:"id";i:14816;s:5:"title";s:47:"Luxury Real Estate &#8211; Property single post";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2020/07/Single-Property-.png";s:12:"tmpl_created";i:1595315847;s:6:"author";s:9:"Elementor";s:3:"url";s:145:"https://library.elementor.com/blocks/luxury-real-estate-property-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:441;s:16:"popularity_index";i:541;s:11:"trend_index";i:665;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:645;a:19:{s:4:"tmpl";i:1025;s:2:"id";i:14799;s:5:"title";s:38:"Luxury Real Estate &#8211; single post";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/07/Post.png";s:12:"tmpl_created";i:1595315792;s:6:"author";s:9:"Elementor";s:3:"url";s:136:"https://library.elementor.com/blocks/luxury-real-estate-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:28:"["Real estate","Realestate"]";s:10:"menu_order";i:442;s:16:"popularity_index";i:369;s:11:"trend_index";i:441;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:646;a:19:{s:4:"tmpl";i:950;s:2:"id";i:12635;s:5:"title";s:20:"Magazine &#8211; 404";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/01/404_s.png";s:12:"tmpl_created";i:1579060746;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/magazine-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:25:"["404","Blog","Magazine"]";s:10:"menu_order";i:445;s:16:"popularity_index";i:645;s:11:"trend_index";i:734;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:647;a:19:{s:4:"tmpl";i:949;s:2:"id";i:12643;s:5:"title";s:24:"Magazine &#8211; Archiv1";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/01/Archiv1_s.png";s:12:"tmpl_created";i:1579060737;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/magazine-archiv1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:447;s:16:"popularity_index";i:346;s:11:"trend_index";i:272;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:648;a:19:{s:4:"tmpl";i:946;s:2:"id";i:12669;s:5:"title";s:23:"Magazine &#8211; Footer";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/01/Footer_s.png";s:12:"tmpl_created";i:1579060715;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/magazine-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:28:"["Blog","Footer","Magazine"]";s:10:"menu_order";i:448;s:16:"popularity_index";i:442;s:11:"trend_index";i:349;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:649;a:19:{s:4:"tmpl";i:945;s:2:"id";i:12678;s:5:"title";s:23:"Magazine &#8211; Header";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2020/06/Header-magazine.png";s:12:"tmpl_created";i:1579060701;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/magazine-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:28:"["Blog","Header","Magazine"]";s:10:"menu_order";i:450;s:16:"popularity_index";i:295;s:11:"trend_index";i:197;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:650;a:19:{s:4:"tmpl";i:947;s:2:"id";i:12661;s:5:"title";s:23:"Magazine &#8211; Search";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/01/Search_s.png";s:12:"tmpl_created";i:1579060722;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/magazine-search/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:452;s:16:"popularity_index";i:396;s:11:"trend_index";i:509;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:651;a:19:{s:4:"tmpl";i:944;s:2:"id";i:12688;s:5:"title";s:30:"Magazine &#8211; Single Post 1";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post2_s.png";s:12:"tmpl_created";i:1579060692;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/magazine-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:453;s:16:"popularity_index";i:342;s:11:"trend_index";i:175;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:652;a:19:{s:4:"tmpl";i:943;s:2:"id";i:12699;s:5:"title";s:30:"Magazine &#8211; Single Post 2";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post3_s.png";s:12:"tmpl_created";i:1579060680;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/magazine-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:454;s:16:"popularity_index";i:348;s:11:"trend_index";i:129;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:653;a:19:{s:4:"tmpl";i:942;s:2:"id";i:12707;s:5:"title";s:30:"Magazine &#8211; Single Post 3";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post1_s.png";s:12:"tmpl_created";i:1579060669;s:6:"author";s:9:"Elementor";s:3:"url";s:128:"https://library.elementor.com/blocks/magazine-single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:457;s:16:"popularity_index";i:476;s:11:"trend_index";i:246;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:654;a:19:{s:4:"tmpl";i:941;s:2:"id";i:12716;s:5:"title";s:30:"Magazine &#8211; Single Post 3";s:9:"thumbnail";s:68:"https://library.elementor.com/wp-content/uploads/2020/01/Post4_s.png";s:12:"tmpl_created";i:1579060659;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/magazine-single-post-3-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:459;s:16:"popularity_index";i:513;s:11:"trend_index";i:489;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:655;a:19:{s:4:"tmpl";i:948;s:2:"id";i:12652;s:5:"title";s:17:"Magazine- Archiv2";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2020/01/Archiv2_s.png";s:12:"tmpl_created";i:1579060730;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/magazine-archiv2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:19:"["Blog","Magazine"]";s:10:"menu_order";i:461;s:16:"popularity_index";i:525;s:11:"trend_index";i:585;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:656;a:19:{s:4:"tmpl";i:990;s:2:"id";i:13361;s:5:"title";s:25:"Online Course &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/04/404.jpg";s:12:"tmpl_created";i:1587474710;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/online-course-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:35:"["404","Course Online","Education"]";s:10:"menu_order";i:462;s:16:"popularity_index";i:682;s:11:"trend_index";i:498;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:657;a:19:{s:4:"tmpl";i:987;s:2:"id";i:13387;s:5:"title";s:32:"Online Course &#8211; End Lesson";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-End-.jpg";s:12:"tmpl_created";i:1587474682;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/online-course-end-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:464;s:16:"popularity_index";i:653;s:11:"trend_index";i:408;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:658;a:19:{s:4:"tmpl";i:989;s:2:"id";i:13369;s:5:"title";s:28:"Online Course &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/04/Footer.jpg";s:12:"tmpl_created";i:1587474701;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/online-course-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:38:"["Course Online","Education","Footer"]";s:10:"menu_order";i:466;s:16:"popularity_index";i:389;s:11:"trend_index";i:308;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:659;a:19:{s:4:"tmpl";i:988;s:2:"id";i:13378;s:5:"title";s:28:"Online Course &#8211; Header";s:9:"thumbnail";s:92:"https://library.elementor.com/wp-content/uploads/2020/06/Header-education-online-courses.jpg";s:12:"tmpl_created";i:1587474693;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/online-course-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:38:"["Course Online","Education","Header"]";s:10:"menu_order";i:469;s:16:"popularity_index";i:492;s:11:"trend_index";i:519;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:660;a:19:{s:4:"tmpl";i:986;s:2:"id";i:13395;s:5:"title";s:34:"Online Course &#8211; Start Lesson";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/04/Lesson-Start.jpg";s:12:"tmpl_created";i:1587474673;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/online-course-start-lesson/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:29:"["Course Online","Education"]";s:10:"menu_order";i:471;s:16:"popularity_index";i:672;s:11:"trend_index";i:578;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:661;a:19:{s:4:"tmpl";i:953;s:2:"id";i:13089;s:5:"title";s:23:"Photography &#8211; 404";s:9:"thumbnail";s:66:"https://library.elementor.com/wp-content/uploads/2020/02/404_s.png";s:12:"tmpl_created";i:1582091623;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/photography-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:33:"["404","Photography","Portfolio"]";s:10:"menu_order";i:473;s:16:"popularity_index";i:702;s:11:"trend_index";i:706;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:662;a:19:{s:4:"tmpl";i:954;s:2:"id";i:13096;s:5:"title";s:32:"Photography &#8211; Archiv Media";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/02/Archiv_s.png";s:12:"tmpl_created";i:1582091742;s:6:"author";s:9:"Elementor";s:3:"url";s:130:"https://library.elementor.com/blocks/photography-archiv-media/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:475;s:16:"popularity_index";i:631;s:11:"trend_index";i:405;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:663;a:19:{s:4:"tmpl";i:955;s:2:"id";i:13103;s:5:"title";s:26:"Photography &#8211; Footer";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2020/02/Footer_s.png";s:12:"tmpl_created";i:1582091903;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/photography-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:36:"["Footer","Photography","Portfolio"]";s:10:"menu_order";i:477;s:16:"popularity_index";i:422;s:11:"trend_index";i:230;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:664;a:19:{s:4:"tmpl";i:957;s:2:"id";i:13112;s:5:"title";s:26:"Photography &#8211; Header";s:9:"thumbnail";s:89:"https://library.elementor.com/wp-content/uploads/2020/06/Header-photography-portfolio.png";s:12:"tmpl_created";i:1582092483;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/photography-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:36:"["Header","Photography","Portfolio"]";s:10:"menu_order";i:478;s:16:"popularity_index";i:325;s:11:"trend_index";i:205;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:665;a:19:{s:4:"tmpl";i:956;s:2:"id";i:13120;s:5:"title";s:31:"Photography &#8211; Single Post";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/02/Post_s.png";s:12:"tmpl_created";i:1582092351;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/photography-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:27:"["Photography","Portfolio"]";s:10:"menu_order";i:480;s:16:"popularity_index";i:671;s:11:"trend_index";i:645;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:666;a:19:{s:4:"tmpl";i:901;s:2:"id";i:11807;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:70:"https://library.elementor.com/wp-content/uploads/2019/09/404_small.png";s:12:"tmpl_created";i:1569430070;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:40:"["404","Creative Portfolio","Portfolio"]";s:10:"menu_order";i:483;s:16:"popularity_index";i:480;s:11:"trend_index";i:497;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:667;a:19:{s:4:"tmpl";i:900;s:2:"id";i:11832;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/09/Footer_small.png";s:12:"tmpl_created";i:1569430019;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:43:"["Creative Portfolio","Footer","Portfolio"]";s:10:"menu_order";i:484;s:16:"popularity_index";i:246;s:11:"trend_index";i:102;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:668;a:19:{s:4:"tmpl";i:898;s:2:"id";i:11847;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2019/09/Archiv_small.png";s:12:"tmpl_created";i:1569430010;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:487;s:16:"popularity_index";i:336;s:11:"trend_index";i:455;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:669;a:19:{s:4:"tmpl";i:897;s:2:"id";i:11854;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:71:"https://library.elementor.com/wp-content/uploads/2019/09/Post_small.png";s:12:"tmpl_created";i:1569429983;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:489;s:16:"popularity_index";i:482;s:11:"trend_index";i:609;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:670;a:19:{s:4:"tmpl";i:904;s:2:"id";i:11890;s:5:"title";s:9:"Portfolio";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2020/06/Header-design-portfolio.png";s:12:"tmpl_created";i:1571907344;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:43:"["Creative Portfolio","Header","Portfolio"]";s:10:"menu_order";i:491;s:16:"popularity_index";i:306;s:11:"trend_index";i:364;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:671;a:19:{s:4:"tmpl";i:896;s:2:"id";i:11861;s:5:"title";s:27:"Portfolio &#8211; Project 1";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project1_small.png";s:12:"tmpl_created";i:1569429975;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/portfolio-project-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:493;s:16:"popularity_index";i:643;s:11:"trend_index";i:764;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:672;a:19:{s:4:"tmpl";i:895;s:2:"id";i:11870;s:5:"title";s:27:"Portfolio &#8211; Project 2";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png";s:12:"tmpl_created";i:1569429964;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/portfolio-project-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:495;s:16:"popularity_index";i:662;s:11:"trend_index";i:816;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:673;a:19:{s:4:"tmpl";i:903;s:2:"id";i:11897;s:5:"title";s:27:"Portfolio &#8211; Project 2";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project2_small.png";s:12:"tmpl_created";i:1569494236;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/blocks/portfolio-project-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:496;s:16:"popularity_index";i:733;s:11:"trend_index";i:744;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:674;a:19:{s:4:"tmpl";i:894;s:2:"id";i:11877;s:5:"title";s:27:"Portfolio &#8211; Project 3";s:9:"thumbnail";s:75:"https://library.elementor.com/wp-content/uploads/2019/09/Project3_small.png";s:12:"tmpl_created";i:1569429954;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/portfolio-project-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Creative Portfolio","Portfolio"]";s:10:"menu_order";i:498;s:16:"popularity_index";i:692;s:11:"trend_index";i:0;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:675;a:19:{s:4:"tmpl";i:597;s:2:"id";i:5019;s:5:"title";s:11:"Portfolio 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_1.png";s:12:"tmpl_created";i:1520520580;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:500;s:16:"popularity_index";i:170;s:11:"trend_index";i:236;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:676;a:19:{s:4:"tmpl";i:609;s:2:"id";i:5141;s:5:"title";s:12:"Portfolio 10";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_10.png";s:12:"tmpl_created";i:1520520601;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:503;s:16:"popularity_index";i:416;s:11:"trend_index";i:478;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:677;a:19:{s:4:"tmpl";i:598;s:2:"id";i:5027;s:5:"title";s:12:"Portfolio 11";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_2.png";s:12:"tmpl_created";i:1520520581;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:504;s:16:"popularity_index";i:304;s:11:"trend_index";i:421;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:678;a:19:{s:4:"tmpl";i:599;s:2:"id";i:5037;s:5:"title";s:12:"Portfolio 12";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_3.png";s:12:"tmpl_created";i:1520520583;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:507;s:16:"popularity_index";i:279;s:11:"trend_index";i:399;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:679;a:19:{s:4:"tmpl";i:600;s:2:"id";i:5057;s:5:"title";s:12:"Portfolio 13";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_4.png";s:12:"tmpl_created";i:1520520586;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:509;s:16:"popularity_index";i:239;s:11:"trend_index";i:288;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:680;a:19:{s:4:"tmpl";i:601;s:2:"id";i:5071;s:5:"title";s:12:"Portfolio 14";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_5.png";s:12:"tmpl_created";i:1520520588;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:511;s:16:"popularity_index";i:276;s:11:"trend_index";i:329;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:681;a:19:{s:4:"tmpl";i:603;s:2:"id";i:5090;s:5:"title";s:12:"Portfolio 15";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_6.png";s:12:"tmpl_created";i:1520520591;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:513;s:16:"popularity_index";i:186;s:11:"trend_index";i:283;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:682;a:19:{s:4:"tmpl";i:604;s:2:"id";i:5098;s:5:"title";s:12:"Portfolio 16";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_7.png";s:12:"tmpl_created";i:1520520593;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:515;s:16:"popularity_index";i:156;s:11:"trend_index";i:211;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:683;a:19:{s:4:"tmpl";i:606;s:2:"id";i:5115;s:5:"title";s:12:"Portfolio 17";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_8.png";s:12:"tmpl_created";i:1520520596;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:517;s:16:"popularity_index";i:19;s:11:"trend_index";i:22;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:684;a:19:{s:4:"tmpl";i:608;s:2:"id";i:5133;s:5:"title";s:12:"Portfolio 18";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_9.png";s:12:"tmpl_created";i:1520520599;s:6:"author";s:9:"Elementor";s:3:"url";s:118:"https://library.elementor.com/blocks/portfolio-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:519;s:16:"popularity_index";i:180;s:11:"trend_index";i:280;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:685;a:19:{s:4:"tmpl";i:610;s:2:"id";i:5149;s:5:"title";s:11:"Portfolio 2";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_10.png";s:12:"tmpl_created";i:1520520602;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:521;s:16:"popularity_index";i:413;s:11:"trend_index";i:635;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:686;a:19:{s:4:"tmpl";i:468;s:2:"id";i:5045;s:5:"title";s:11:"Portfolio 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_2.png";s:12:"tmpl_created";i:1520443423;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:523;s:16:"popularity_index";i:636;s:11:"trend_index";i:608;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:687;a:19:{s:4:"tmpl";i:602;s:2:"id";i:5082;s:5:"title";s:11:"Portfolio 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_4.png";s:12:"tmpl_created";i:1520520589;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:524;s:16:"popularity_index";i:558;s:11:"trend_index";i:654;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:688;a:19:{s:4:"tmpl";i:605;s:2:"id";i:5107;s:5:"title";s:11:"Portfolio 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_7.png";s:12:"tmpl_created";i:1520520594;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:527;s:16:"popularity_index";i:380;s:11:"trend_index";i:347;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:689;a:19:{s:4:"tmpl";i:607;s:2:"id";i:5125;s:5:"title";s:11:"Portfolio 6";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_black_8.png";s:12:"tmpl_created";i:1520520597;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:529;s:16:"popularity_index";i:236;s:11:"trend_index";i:386;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:690;a:19:{s:4:"tmpl";i:596;s:2:"id";i:5007;s:5:"title";s:11:"Portfolio 7";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/portfolio_white_1.png";s:12:"tmpl_created";i:1520520578;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/portfolio-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:9:"portfolio";s:4:"tags";s:13:"["Portfolio"]";s:10:"menu_order";i:530;s:16:"popularity_index";i:44;s:11:"trend_index";i:183;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:691;a:19:{s:4:"tmpl";i:434;s:2:"id";i:4509;s:5:"title";s:9:"Pricing 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_1.png";s:12:"tmpl_created";i:1520443310;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:532;s:16:"popularity_index";i:703;s:11:"trend_index";i:641;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:692;a:19:{s:4:"tmpl";i:439;s:2:"id";i:4553;s:5:"title";s:10:"Pricing 10";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_4.png";s:12:"tmpl_created";i:1520443319;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/pricing-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:534;s:16:"popularity_index";i:511;s:11:"trend_index";i:506;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:693;a:19:{s:4:"tmpl";i:441;s:2:"id";i:4572;s:5:"title";s:10:"Pricing 11";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_5.png";s:12:"tmpl_created";i:1520443324;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/pricing-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:537;s:16:"popularity_index";i:308;s:11:"trend_index";i:248;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:694;a:19:{s:4:"tmpl";i:442;s:2:"id";i:4580;s:5:"title";s:10:"Pricing 12";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_6.png";s:12:"tmpl_created";i:1520443326;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/pricing-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:539;s:16:"popularity_index";i:576;s:11:"trend_index";i:526;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:695;a:19:{s:4:"tmpl";i:444;s:2:"id";i:4597;s:5:"title";s:10:"Pricing 13";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_7.png";s:12:"tmpl_created";i:1520443330;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/pricing-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:540;s:16:"popularity_index";i:613;s:11:"trend_index";i:450;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:696;a:19:{s:4:"tmpl";i:446;s:2:"id";i:4613;s:5:"title";s:10:"Pricing 14";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_8.png";s:12:"tmpl_created";i:1520443334;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/pricing-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:543;s:16:"popularity_index";i:581;s:11:"trend_index";i:568;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:697;a:19:{s:4:"tmpl";i:436;s:2:"id";i:4529;s:5:"title";s:9:"Pricing 2";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_2.png";s:12:"tmpl_created";i:1520443314;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:545;s:16:"popularity_index";i:609;s:11:"trend_index";i:613;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:698;a:19:{s:4:"tmpl";i:438;s:2:"id";i:4545;s:5:"title";s:9:"Pricing 3";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_3.png";s:12:"tmpl_created";i:1520443317;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:547;s:16:"popularity_index";i:707;s:11:"trend_index";i:825;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:699;a:19:{s:4:"tmpl";i:440;s:2:"id";i:4562;s:5:"title";s:9:"Pricing 4";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_4.png";s:12:"tmpl_created";i:1520443322;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:549;s:16:"popularity_index";i:697;s:11:"trend_index";i:821;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:700;a:19:{s:4:"tmpl";i:443;s:2:"id";i:4589;s:5:"title";s:9:"Pricing 5";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_6.png";s:12:"tmpl_created";i:1520443327;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:551;s:16:"popularity_index";i:716;s:11:"trend_index";i:639;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:701;a:19:{s:4:"tmpl";i:445;s:2:"id";i:4605;s:5:"title";s:9:"Pricing 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_black_7.png";s:12:"tmpl_created";i:1520443332;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:553;s:16:"popularity_index";i:738;s:11:"trend_index";i:773;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:702;a:19:{s:4:"tmpl";i:433;s:2:"id";i:4500;s:5:"title";s:9:"Pricing 7";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_1.png";s:12:"tmpl_created";i:1520443308;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:554;s:16:"popularity_index";i:500;s:11:"trend_index";i:451;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:703;a:19:{s:4:"tmpl";i:435;s:2:"id";i:4521;s:5:"title";s:9:"Pricing 8";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_2.png";s:12:"tmpl_created";i:1520443312;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:557;s:16:"popularity_index";i:311;s:11:"trend_index";i:372;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:704;a:19:{s:4:"tmpl";i:437;s:2:"id";i:4537;s:5:"title";s:9:"Pricing 9";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/02/price_white_3.png";s:12:"tmpl_created";i:1520443315;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/pricing-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"pricing";s:4:"tags";s:11:"["Pricing"]";s:10:"menu_order";i:559;s:16:"popularity_index";i:589;s:11:"trend_index";i:841;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:705;a:19:{s:4:"tmpl";i:1046;s:2:"id";i:15204;s:5:"title";s:24:"Psychologist &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/09/404.jpg";s:12:"tmpl_created";i:1600161419;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/psychologist-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:40:"["404","Psychologist","Psychotherapist"]";s:10:"menu_order";i:564;s:16:"popularity_index";i:574;s:11:"trend_index";i:493;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:706;a:19:{s:4:"tmpl";i:1047;s:2:"id";i:15212;s:5:"title";s:28:"Psychologist &#8211; Archive";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2020/09/Blog.jpg";s:12:"tmpl_created";i:1600162340;s:6:"author";s:9:"Elementor";s:3:"url";s:126:"https://library.elementor.com/blocks/psychologist-archive/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:565;s:16:"popularity_index";i:379;s:11:"trend_index";i:358;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:707;a:19:{s:4:"tmpl";i:1048;s:2:"id";i:15219;s:5:"title";s:27:"Psychologist &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/09/Footer.jpg";s:12:"tmpl_created";i:1600163069;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/psychologist-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:43:"["Footer","Psychologist","Psychotherapist"]";s:10:"menu_order";i:566;s:16:"popularity_index";i:599;s:11:"trend_index";i:500;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:708;a:19:{s:4:"tmpl";i:701;s:2:"id";i:9239;s:5:"title";s:17:"product archive 1";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-1.png";s:12:"tmpl_created";i:1532953482;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/product-archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:15:"product archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:566;s:16:"popularity_index";i:60;s:11:"trend_index";i:25;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:709;a:19:{s:4:"tmpl";i:1049;s:2:"id";i:15230;s:5:"title";s:27:"Psychologist &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/09/Header.png";s:12:"tmpl_created";i:1600163444;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/psychologist-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:43:"["Header","Psychologist","Psychotherapist"]";s:10:"menu_order";i:567;s:16:"popularity_index";i:429;s:11:"trend_index";i:423;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:710;a:19:{s:4:"tmpl";i:702;s:2:"id";i:9247;s:5:"title";s:17:"product archive 2";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-2.png";s:12:"tmpl_created";i:1532953793;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/product-archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:15:"product archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:567;s:16:"popularity_index";i:71;s:11:"trend_index";i:30;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:711;a:19:{s:4:"tmpl";i:1050;s:2:"id";i:15240;s:5:"title";s:34:"Psychologist &#8211; single post 1";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2020/09/Single-Post.png";s:12:"tmpl_created";i:1600164087;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/psychologist-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:568;s:16:"popularity_index";i:562;s:11:"trend_index";i:570;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:712;a:19:{s:4:"tmpl";i:703;s:2:"id";i:9254;s:5:"title";s:17:"product archive 3";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/product-archive-350-3.png";s:12:"tmpl_created";i:1532954032;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/product-archive-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:15:"product archive";s:4:"tags";s:2:"[]";s:10:"menu_order";i:568;s:16:"popularity_index";i:73;s:11:"trend_index";i:44;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:713;a:19:{s:4:"tmpl";i:1051;s:2:"id";i:15251;s:5:"title";s:34:"Psychologist &#8211; single post 2";s:9:"thumbnail";s:80:"https://library.elementor.com/wp-content/uploads/2020/09/Single-Service-Page.png";s:12:"tmpl_created";i:1600165179;s:6:"author";s:9:"Elementor";s:3:"url";s:132:"https://library.elementor.com/blocks/psychologist-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:34:"["Psychologist","Psychotherapist"]";s:10:"menu_order";i:569;s:16:"popularity_index";i:507;s:11:"trend_index";i:368;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:714;a:19:{s:4:"tmpl";i:412;s:2:"id";i:4313;s:5:"title";s:11:"Services 13";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_8.png";s:12:"tmpl_created";i:1520443268;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:570;s:16:"popularity_index";i:115;s:11:"trend_index";i:53;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:715;a:19:{s:4:"tmpl";i:413;s:2:"id";i:4324;s:5:"title";s:11:"Services 14";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_9.png";s:12:"tmpl_created";i:1520443270;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:571;s:16:"popularity_index";i:277;s:11:"trend_index";i:138;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:716;a:19:{s:4:"tmpl";i:418;s:2:"id";i:4368;s:5:"title";s:11:"Services 16";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_13.png";s:12:"tmpl_created";i:1520443279;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:572;s:16:"popularity_index";i:62;s:11:"trend_index";i:59;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:717;a:19:{s:4:"tmpl";i:420;s:2:"id";i:4391;s:5:"title";s:11:"Services 17";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_14.png";s:12:"tmpl_created";i:1520443283;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:573;s:16:"popularity_index";i:153;s:11:"trend_index";i:120;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:718;a:19:{s:4:"tmpl";i:403;s:2:"id";i:4235;s:5:"title";s:11:"Services 18";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_2.png";s:12:"tmpl_created";i:1520443251;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:574;s:16:"popularity_index";i:273;s:11:"trend_index";i:172;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:719;a:19:{s:4:"tmpl";i:417;s:2:"id";i:4357;s:5:"title";s:11:"Services 20";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_12.png";s:12:"tmpl_created";i:1520443277;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:575;s:16:"popularity_index";i:45;s:11:"trend_index";i:45;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:720;a:19:{s:4:"tmpl";i:415;s:2:"id";i:4341;s:5:"title";s:11:"Services 21";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_11.png";s:12:"tmpl_created";i:1520443274;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:576;s:16:"popularity_index";i:142;s:11:"trend_index";i:114;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:721;a:19:{s:4:"tmpl";i:414;s:2:"id";i:4332;s:5:"title";s:11:"Services 22";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_10.png";s:12:"tmpl_created";i:1520443272;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:577;s:16:"popularity_index";i:138;s:11:"trend_index";i:149;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:722;a:19:{s:4:"tmpl";i:401;s:2:"id";i:4212;s:5:"title";s:11:"Services 23";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_1.png";s:12:"tmpl_created";i:1520443248;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:578;s:16:"popularity_index";i:136;s:11:"trend_index";i:302;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:723;a:19:{s:4:"tmpl";i:408;s:2:"id";i:4276;s:5:"title";s:11:"Services 24";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_4.png";s:12:"tmpl_created";i:1520443261;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:579;s:16:"popularity_index";i:353;s:11:"trend_index";i:514;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:724;a:19:{s:4:"tmpl";i:406;s:2:"id";i:4260;s:5:"title";s:11:"Services 25";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_3.png";s:12:"tmpl_created";i:1520443257;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-25/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:580;s:16:"popularity_index";i:184;s:11:"trend_index";i:209;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:725;a:19:{s:4:"tmpl";i:404;s:2:"id";i:4244;s:5:"title";s:11:"Services 26";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_2.png";s:12:"tmpl_created";i:1520443253;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:581;s:16:"popularity_index";i:544;s:11:"trend_index";i:596;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:726;a:19:{s:4:"tmpl";i:421;s:2:"id";i:4400;s:5:"title";s:11:"Services 27";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_13.png";s:12:"tmpl_created";i:1520443285;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:582;s:16:"popularity_index";i:286;s:11:"trend_index";i:438;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:727;a:19:{s:4:"tmpl";i:419;s:2:"id";i:4376;s:5:"title";s:11:"Services 28";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_12.png";s:12:"tmpl_created";i:1520443281;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-28/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:583;s:16:"popularity_index";i:151;s:11:"trend_index";i:249;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:728;a:19:{s:4:"tmpl";i:416;s:2:"id";i:4349;s:5:"title";s:11:"Services 29";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_11.png";s:12:"tmpl_created";i:1520443275;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:584;s:16:"popularity_index";i:330;s:11:"trend_index";i:483;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:729;a:19:{s:4:"tmpl";i:402;s:2:"id";i:4227;s:5:"title";s:11:"Services 30";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_black_1.png";s:12:"tmpl_created";i:1520443250;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-30/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:585;s:16:"popularity_index";i:351;s:11:"trend_index";i:553;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:730;a:19:{s:4:"tmpl";i:560;s:2:"id";i:6162;s:5:"title";s:11:"Services 31";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_1.png";s:12:"tmpl_created";i:1520443668;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/services-31/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:586;s:16:"popularity_index";i:372;s:11:"trend_index";i:550;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:731;a:19:{s:4:"tmpl";i:411;s:2:"id";i:4302;s:5:"title";s:10:"Services 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_7.png";s:12:"tmpl_created";i:1520443266;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:587;s:16:"popularity_index";i:58;s:11:"trend_index";i:97;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:732;a:19:{s:4:"tmpl";i:410;s:2:"id";i:4293;s:5:"title";s:10:"Services 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_6.png";s:12:"tmpl_created";i:1520443265;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/services-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:588;s:16:"popularity_index";i:288;s:11:"trend_index";i:269;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:733;a:19:{s:4:"tmpl";i:409;s:2:"id";i:4284;s:5:"title";s:10:"Services 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_5.png";s:12:"tmpl_created";i:1520443263;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/services-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:589;s:16:"popularity_index";i:27;s:11:"trend_index";i:21;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:734;a:19:{s:4:"tmpl";i:407;s:2:"id";i:4268;s:5:"title";s:10:"Services 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_4.png";s:12:"tmpl_created";i:1520443259;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/services-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:590;s:16:"popularity_index";i:173;s:11:"trend_index";i:213;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:735;a:19:{s:4:"tmpl";i:405;s:2:"id";i:4252;s:5:"title";s:10:"Services 9";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/02/Service_white_3.png";s:12:"tmpl_created";i:1520443255;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/services-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:8:"services";s:4:"tags";s:12:"["Services"]";s:10:"menu_order";i:591;s:16:"popularity_index";i:46;s:11:"trend_index";i:99;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:736;a:19:{s:4:"tmpl";i:677;s:2:"id";i:8676;s:5:"title";s:13:"single page 1";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.6.jpg";s:12:"tmpl_created";i:1527682423;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:592;s:16:"popularity_index";i:285;s:11:"trend_index";i:145;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:737;a:19:{s:4:"tmpl";i:678;s:2:"id";i:8678;s:5:"title";s:13:"single page 2";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.2.jpg";s:12:"tmpl_created";i:1527682780;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:593;s:16:"popularity_index";i:140;s:11:"trend_index";i:82;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:738;a:19:{s:4:"tmpl";i:679;s:2:"id";i:8679;s:5:"title";s:13:"single page 3";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.3.jpg";s:12:"tmpl_created";i:1527682847;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:594;s:16:"popularity_index";i:122;s:11:"trend_index";i:23;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:739;a:19:{s:4:"tmpl";i:680;s:2:"id";i:8680;s:5:"title";s:13:"single page 4";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.1.jpg";s:12:"tmpl_created";i:1527682896;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:595;s:16:"popularity_index";i:373;s:11:"trend_index";i:190;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:740;a:19:{s:4:"tmpl";i:681;s:2:"id";i:8681;s:5:"title";s:13:"single page 5";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.5.jpg";s:12:"tmpl_created";i:1527682969;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:596;s:16:"popularity_index";i:287;s:11:"trend_index";i:218;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:741;a:19:{s:4:"tmpl";i:682;s:2:"id";i:8682;s:5:"title";s:13:"single page 6";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.4.jpg";s:12:"tmpl_created";i:1527683026;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:597;s:16:"popularity_index";i:412;s:11:"trend_index";i:227;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:742;a:19:{s:4:"tmpl";i:683;s:2:"id";i:8703;s:5:"title";s:13:"single page 7";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2018/05/S_P350.7.jpg";s:12:"tmpl_created";i:1527683072;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-page-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single page";s:4:"tags";s:2:"[]";s:10:"menu_order";i:598;s:16:"popularity_index";i:401;s:11:"trend_index";i:316;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:743;a:19:{s:4:"tmpl";i:640;s:2:"id";i:7650;s:5:"title";s:13:"Single Post 1";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/single_post_1_v2.jpg";s:12:"tmpl_created";i:1521557736;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:24:"["Blog","Post","Single"]";s:10:"menu_order";i:599;s:16:"popularity_index";i:119;s:11:"trend_index";i:266;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:744;a:19:{s:4:"tmpl";i:639;s:2:"id";i:7663;s:5:"title";s:13:"Single Post 2";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/single_post_2_v2.jpg";s:12:"tmpl_created";i:1521547761;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:24:"["Blog","Post","Single"]";s:10:"menu_order";i:600;s:16:"popularity_index";i:50;s:11:"trend_index";i:139;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:745;a:19:{s:4:"tmpl";i:705;s:2:"id";i:9296;s:5:"title";s:13:"Single Post 3";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2018/09/3002.jpg";s:12:"tmpl_created";i:1537440673;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:2:"[]";s:10:"menu_order";i:601;s:16:"popularity_index";i:213;s:11:"trend_index";i:204;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:746;a:19:{s:4:"tmpl";i:704;s:2:"id";i:9301;s:5:"title";s:13:"Single Post 4";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2018/09/3003.jpg";s:12:"tmpl_created";i:1537440661;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:2:"[]";s:10:"menu_order";i:602;s:16:"popularity_index";i:248;s:11:"trend_index";i:336;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:747;a:19:{s:4:"tmpl";i:706;s:2:"id";i:9313;s:5:"title";s:13:"Single Post 5";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2018/09/3001.jpg";s:12:"tmpl_created";i:1537440798;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:2:"[]";s:10:"menu_order";i:603;s:16:"popularity_index";i:197;s:11:"trend_index";i:177;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:748;a:19:{s:4:"tmpl";i:707;s:2:"id";i:9343;s:5:"title";s:13:"Single Post 6";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2018/09/3004.jpg";s:12:"tmpl_created";i:1537443531;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:2:"[]";s:10:"menu_order";i:604;s:16:"popularity_index";i:228;s:11:"trend_index";i:279;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:749;a:19:{s:4:"tmpl";i:708;s:2:"id";i:9349;s:5:"title";s:13:"Single Post 7";s:9:"thumbnail";s:65:"https://library.elementor.com/wp-content/uploads/2018/09/3005.jpg";s:12:"tmpl_created";i:1537443903;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/single-post-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:2:"[]";s:10:"menu_order";i:605;s:16:"popularity_index";i:158;s:11:"trend_index";i:253;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:750;a:19:{s:4:"tmpl";i:555;s:2:"id";i:6114;s:5:"title";s:7:"Stats 1";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_6.png";s:12:"tmpl_created";i:1520443659;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";i:610;s:16:"popularity_index";i:434;s:11:"trend_index";i:692;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:751;a:19:{s:4:"tmpl";i:562;s:2:"id";i:6178;s:5:"title";s:8:"Stats 10";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_2.png";s:12:"tmpl_created";i:1520443676;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/stats-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:611;s:16:"popularity_index";i:435;s:11:"trend_index";i:755;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:752;a:19:{s:4:"tmpl";i:561;s:2:"id";i:6170;s:5:"title";s:8:"Stats 11";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_2.png";s:12:"tmpl_created";i:1520443670;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/stats-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:612;s:16:"popularity_index";i:366;s:11:"trend_index";i:552;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:753;a:19:{s:4:"tmpl";i:697;s:2:"id";i:9174;s:5:"title";s:17:"single product 01";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/07/single_product01_350.png";s:12:"tmpl_created";i:1532950125;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/single-product-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";i:612;s:16:"popularity_index";i:31;s:11:"trend_index";i:6;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:754;a:19:{s:4:"tmpl";i:563;s:2:"id";i:6186;s:5:"title";s:8:"Stats 12";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_white_3.png";s:12:"tmpl_created";i:1520443678;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/stats-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:613;s:16:"popularity_index";i:569;s:11:"trend_index";i:811;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:755;a:19:{s:4:"tmpl";i:698;s:2:"id";i:9178;s:5:"title";s:17:"single product 02";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2018/07/single_product02_350new.png";s:12:"tmpl_created";i:1532951997;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/single-product-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";i:613;s:16:"popularity_index";i:66;s:11:"trend_index";i:42;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:756;a:19:{s:4:"tmpl";i:550;s:2:"id";i:6071;s:5:"title";s:8:"Stats 13";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_3.png";s:12:"tmpl_created";i:1520443649;s:6:"author";s:9:"Elementor";s:3:"url";s:114:"https://library.elementor.com/blocks/stats-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";i:614;s:16:"popularity_index";i:168;s:11:"trend_index";i:328;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:757;a:19:{s:4:"tmpl";i:699;s:2:"id";i:9180;s:5:"title";s:17:"single product 03";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/07/single_product03_350.png";s:12:"tmpl_created";i:1532952302;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/single-product-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";i:614;s:16:"popularity_index";i:108;s:11:"trend_index";i:66;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:758;a:19:{s:4:"tmpl";i:554;s:2:"id";i:6106;s:5:"title";s:7:"Stats 2";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_6.png";s:12:"tmpl_created";i:1520443657;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";i:615;s:16:"popularity_index";i:361;s:11:"trend_index";i:784;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:759;a:19:{s:4:"tmpl";i:700;s:2:"id";i:9182;s:5:"title";s:17:"single product 04";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/07/single_product040_350.png";s:12:"tmpl_created";i:1532952606;s:6:"author";s:9:"Elementor";s:3:"url";s:123:"https://library.elementor.com/blocks/single-product-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:17:"essential-oct2023";s:7:"subtype";s:14:"single product";s:4:"tags";s:2:"[]";s:10:"menu_order";i:615;s:16:"popularity_index";i:123;s:11:"trend_index";i:81;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:760;a:19:{s:4:"tmpl";i:551;s:2:"id";i:6079;s:5:"title";s:7:"Stats 3";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_4.png";s:12:"tmpl_created";i:1520443651;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";i:616;s:16:"popularity_index";i:284;s:11:"trend_index";i:385;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:761;a:19:{s:4:"tmpl";i:552;s:2:"id";i:6089;s:5:"title";s:7:"Stats 4";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_5.png";s:12:"tmpl_created";i:1520443653;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:617;s:16:"popularity_index";i:205;s:11:"trend_index";i:452;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:762;a:19:{s:4:"tmpl";i:549;s:2:"id";i:6063;s:5:"title";s:7:"Stats 5";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_2.png";s:12:"tmpl_created";i:1520443647;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";i:618;s:16:"popularity_index";i:181;s:11:"trend_index";i:419;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:763;a:19:{s:4:"tmpl";i:553;s:2:"id";i:6097;s:5:"title";s:7:"Stats 6";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_2.png";s:12:"tmpl_created";i:1520443655;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:11:"["numbers"]";s:10:"menu_order";i:619;s:16:"popularity_index";i:264;s:11:"trend_index";i:492;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:764;a:19:{s:4:"tmpl";i:538;s:2:"id";i:5956;s:5:"title";s:7:"Stats 7";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_black_1.png";s:12:"tmpl_created";i:1520443623;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:620;s:16:"popularity_index";i:532;s:11:"trend_index";i:541;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:765;a:19:{s:4:"tmpl";i:537;s:2:"id";i:5947;s:5:"title";s:7:"Stats 8";s:9:"thumbnail";s:76:"https://library.elementor.com/wp-content/uploads/2018/03/numbers_white_1.png";s:12:"tmpl_created";i:1520443621;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-8/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:621;s:16:"popularity_index";i:368;s:11:"trend_index";i:531;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:766;a:19:{s:4:"tmpl";i:559;s:2:"id";i:6152;s:5:"title";s:7:"Stats 9";s:9:"thumbnail";s:77:"https://library.elementor.com/wp-content/uploads/2018/03/progress_black_1.png";s:12:"tmpl_created";i:1520443666;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/stats-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:5:"stats";s:4:"tags";s:9:"["Stats"]";s:10:"menu_order";i:622;s:16:"popularity_index";i:272;s:11:"trend_index";i:557;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:767;a:19:{s:4:"tmpl";i:469;s:2:"id";i:5157;s:5:"title";s:11:"Subscribe 1";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_1.png";s:12:"tmpl_created";i:1520443448;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/subscribe-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["Form","Subscribe"]";s:10:"menu_order";i:623;s:16:"popularity_index";i:340;s:11:"trend_index";i:293;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:768;a:19:{s:4:"tmpl";i:472;s:2:"id";i:5181;s:5:"title";s:11:"Subscribe 2";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_2.png";s:12:"tmpl_created";i:1520443454;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/subscribe-2-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["Form","Subscribe"]";s:10:"menu_order";i:624;s:16:"popularity_index";i:451;s:11:"trend_index";i:340;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:769;a:19:{s:4:"tmpl";i:470;s:2:"id";i:5165;s:5:"title";s:11:"Subscribe 3";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_1.png";s:12:"tmpl_created";i:1520443450;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/subscribe-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["Form","Subscribe"]";s:10:"menu_order";i:625;s:16:"popularity_index";i:520;s:11:"trend_index";i:620;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:770;a:19:{s:4:"tmpl";i:477;s:2:"id";i:5222;s:5:"title";s:11:"Subscribe 4";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_black_3.png";s:12:"tmpl_created";i:1520443464;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/subscribe-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["Form","Subscribe"]";s:10:"menu_order";i:626;s:16:"popularity_index";i:397;s:11:"trend_index";i:427;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:771;a:19:{s:4:"tmpl";i:471;s:2:"id";i:5173;s:5:"title";s:11:"Subscribe 5";s:9:"thumbnail";s:78:"https://library.elementor.com/wp-content/uploads/2018/03/subscribe_white_2.png";s:12:"tmpl_created";i:1520443452;s:6:"author";s:9:"Elementor";s:3:"url";s:117:"https://library.elementor.com/blocks/subscribe-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:9:"subscribe";s:4:"tags";s:20:"["Form","Subscribe"]";s:10:"menu_order";i:627;s:16:"popularity_index";i:261;s:11:"trend_index";i:237;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:772;a:19:{s:4:"tmpl";i:465;s:2:"id";i:4801;s:5:"title";s:7:"Team 11";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_8.png";s:12:"tmpl_created";i:1520443369;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:628;s:16:"popularity_index";i:332;s:11:"trend_index";i:188;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:773;a:19:{s:4:"tmpl";i:462;s:2:"id";i:4770;s:5:"title";s:7:"Team 12";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_6.png";s:12:"tmpl_created";i:1520443364;s:6:"author";s:9:"Elementor";s:3:"url";s:115:"https://library.elementor.com/blocks/team-12-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:629;s:16:"popularity_index";i:432;s:11:"trend_index";i:488;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:774;a:19:{s:4:"tmpl";i:458;s:2:"id";i:4727;s:5:"title";s:7:"Team 13";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_2.png";s:12:"tmpl_created";i:1520443356;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:630;s:16:"popularity_index";i:375;s:11:"trend_index";i:345;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:775;a:19:{s:4:"tmpl";i:543;s:2:"id";i:5999;s:5:"title";s:7:"Team 14";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_10.png";s:12:"tmpl_created";i:1520443634;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:631;s:16:"popularity_index";i:110;s:11:"trend_index";i:318;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:776;a:19:{s:4:"tmpl";i:455;s:2:"id";i:4698;s:5:"title";s:7:"Team 15";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_1.png";s:12:"tmpl_created";i:1520443350;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:632;s:16:"popularity_index";i:449;s:11:"trend_index";i:410;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:777;a:19:{s:4:"tmpl";i:463;s:2:"id";i:4781;s:5:"title";s:7:"Team 16";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_7.png";s:12:"tmpl_created";i:1520443365;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:633;s:16:"popularity_index";i:267;s:11:"trend_index";i:330;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:778;a:19:{s:4:"tmpl";i:558;s:2:"id";i:6144;s:5:"title";s:7:"Team 17";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_11.png";s:12:"tmpl_created";i:1520443664;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:634;s:16:"popularity_index";i:166;s:11:"trend_index";i:365;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:779;a:19:{s:4:"tmpl";i:464;s:2:"id";i:4793;s:5:"title";s:7:"Team 18";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_8.png";s:12:"tmpl_created";i:1520443367;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:635;s:16:"popularity_index";i:207;s:11:"trend_index";i:173;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:780;a:19:{s:4:"tmpl";i:466;s:2:"id";i:4809;s:5:"title";s:7:"Team 19";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_9.png";s:12:"tmpl_created";i:1520443371;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:636;s:16:"popularity_index";i:300;s:11:"trend_index";i:465;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:781;a:19:{s:4:"tmpl";i:459;s:2:"id";i:4736;s:5:"title";s:7:"Team 20";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_4.png";s:12:"tmpl_created";i:1520443358;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:637;s:16:"popularity_index";i:144;s:11:"trend_index";i:159;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:782;a:19:{s:4:"tmpl";i:467;s:2:"id";i:4818;s:5:"title";s:7:"Team 21";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_9.png";s:12:"tmpl_created";i:1520443373;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:638;s:16:"popularity_index";i:515;s:11:"trend_index";i:606;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:783;a:19:{s:4:"tmpl";i:461;s:2:"id";i:4759;s:5:"title";s:7:"Team 22";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_5.png";s:12:"tmpl_created";i:1520443362;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:639;s:16:"popularity_index";i:299;s:11:"trend_index";i:376;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:784;a:19:{s:4:"tmpl";i:460;s:2:"id";i:4746;s:5:"title";s:7:"Team 23";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_black_4.png";s:12:"tmpl_created";i:1520443360;s:6:"author";s:9:"Elementor";s:3:"url";s:113:"https://library.elementor.com/blocks/team-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:640;s:16:"popularity_index";i:282;s:11:"trend_index";i:378;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:785;a:19:{s:4:"tmpl";i:457;s:2:"id";i:4718;s:5:"title";s:6:"Team 4";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_3.png";s:12:"tmpl_created";i:1520443354;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/team-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:641;s:16:"popularity_index";i:192;s:11:"trend_index";i:359;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:786;a:19:{s:4:"tmpl";i:456;s:2:"id";i:4706;s:5:"title";s:6:"Team 5";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_2.png";s:12:"tmpl_created";i:1520443352;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/team-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:642;s:16:"popularity_index";i:149;s:11:"trend_index";i:299;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:787;a:19:{s:4:"tmpl";i:544;s:2:"id";i:6008;s:5:"title";s:6:"Team 6";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_10.png";s:12:"tmpl_created";i:1520443636;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/team-6/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:643;s:16:"popularity_index";i:75;s:11:"trend_index";i:277;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:788;a:19:{s:4:"tmpl";i:454;s:2:"id";i:4690;s:5:"title";s:6:"Team 7";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2018/03/team_white_1.png";s:12:"tmpl_created";i:1520443348;s:6:"author";s:9:"Elementor";s:3:"url";s:112:"https://library.elementor.com/blocks/team-7/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:4:"team";s:4:"tags";s:8:"["Team"]";s:10:"menu_order";i:644;s:16:"popularity_index";i:243;s:11:"trend_index";i:402;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:789;a:19:{s:4:"tmpl";i:586;s:2:"id";i:4921;s:5:"title";s:14:"Testimonial 10";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_5.png";s:12:"tmpl_created";i:1520520562;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:645;s:16:"popularity_index";i:219;s:11:"trend_index";i:198;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:790;a:19:{s:4:"tmpl";i:582;s:2:"id";i:4889;s:5:"title";s:14:"Testimonial 11";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/customers-2.jpg";s:12:"tmpl_created";i:1520520556;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:646;s:16:"popularity_index";i:557;s:11:"trend_index";i:522;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:791;a:19:{s:4:"tmpl";i:580;s:2:"id";i:4871;s:5:"title";s:14:"Testimonial 12";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_3.png";s:12:"tmpl_created";i:1520520552;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:647;s:16:"popularity_index";i:262;s:11:"trend_index";i:391;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:792;a:19:{s:4:"tmpl";i:578;s:2:"id";i:4854;s:5:"title";s:14:"Testimonial 13";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_2.png";s:12:"tmpl_created";i:1520520549;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:648;s:16:"popularity_index";i:637;s:11:"trend_index";i:741;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:793;a:19:{s:4:"tmpl";i:595;s:2:"id";i:4995;s:5:"title";s:14:"Testimonial 14";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_12.png";s:12:"tmpl_created";i:1520520577;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:649;s:16:"popularity_index";i:400;s:11:"trend_index";i:411;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:794;a:19:{s:4:"tmpl";i:593;s:2:"id";i:4979;s:5:"title";s:14:"Testimonial 15";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_10.png";s:12:"tmpl_created";i:1520520573;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:650;s:16:"popularity_index";i:568;s:11:"trend_index";i:544;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:795;a:19:{s:4:"tmpl";i:576;s:2:"id";i:4835;s:5:"title";s:14:"Testimonial 16";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_1.png";s:12:"tmpl_created";i:1520520546;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:651;s:16:"popularity_index";i:399;s:11:"trend_index";i:401;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:796;a:19:{s:4:"tmpl";i:594;s:2:"id";i:4987;s:5:"title";s:14:"Testimonial 17";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_12-1.png";s:12:"tmpl_created";i:1520520575;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:652;s:16:"popularity_index";i:159;s:11:"trend_index";i:199;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:797;a:19:{s:4:"tmpl";i:577;s:2:"id";i:4843;s:5:"title";s:14:"Testimonial 18";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_2.png";s:12:"tmpl_created";i:1520520548;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:653;s:16:"popularity_index";i:457;s:11:"trend_index";i:780;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:798;a:19:{s:4:"tmpl";i:579;s:2:"id";i:4863;s:5:"title";s:14:"Testimonial 19";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_3.png";s:12:"tmpl_created";i:1520520551;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:654;s:16:"popularity_index";i:245;s:11:"trend_index";i:599;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:799;a:19:{s:4:"tmpl";i:581;s:2:"id";i:4880;s:5:"title";s:14:"Testimonial 20";s:9:"thumbnail";s:72:"https://library.elementor.com/wp-content/uploads/2018/03/customers-1.jpg";s:12:"tmpl_created";i:1520520554;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-20/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:655;s:16:"popularity_index";i:446;s:11:"trend_index";i:653;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:800;a:19:{s:4:"tmpl";i:583;s:2:"id";i:4897;s:5:"title";s:14:"Testimonial 21";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_5.png";s:12:"tmpl_created";i:1520520557;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-21/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:656;s:16:"popularity_index";i:78;s:11:"trend_index";i:289;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:801;a:19:{s:4:"tmpl";i:584;s:2:"id";i:4905;s:5:"title";s:14:"Testimonial 22";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_6.png";s:12:"tmpl_created";i:1520520559;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-22/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:657;s:16:"popularity_index";i:121;s:11:"trend_index";i:221;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:802;a:19:{s:4:"tmpl";i:585;s:2:"id";i:4913;s:5:"title";s:14:"Testimonial 23";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_7.png";s:12:"tmpl_created";i:1520520561;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-23/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:658;s:16:"popularity_index";i:247;s:11:"trend_index";i:566;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:803;a:19:{s:4:"tmpl";i:575;s:2:"id";i:4826;s:5:"title";s:14:"Testimonial 24";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_1.png";s:12:"tmpl_created";i:1520520544;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/testimonial-24-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:659;s:16:"popularity_index";i:256;s:11:"trend_index";i:395;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:804;a:19:{s:4:"tmpl";i:587;s:2:"id";i:4929;s:5:"title";s:14:"Testimonial 24";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_8.png";s:12:"tmpl_created";i:1520520564;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-24/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:660;s:16:"popularity_index";i:49;s:11:"trend_index";i:206;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:805;a:19:{s:4:"tmpl";i:591;s:2:"id";i:4963;s:5:"title";s:14:"Testimonial 25";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_10.png";s:12:"tmpl_created";i:1520520570;s:6:"author";s:9:"Elementor";s:3:"url";s:122:"https://library.elementor.com/blocks/testimonial-25-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:661;s:16:"popularity_index";i:417;s:11:"trend_index";i:546;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:806;a:19:{s:4:"tmpl";i:592;s:2:"id";i:4971;s:5:"title";s:14:"Testimonial 26";s:9:"thumbnail";s:82:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_11.png";s:12:"tmpl_created";i:1520520572;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-26/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:662;s:16:"popularity_index";i:649;s:11:"trend_index";i:718;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:807;a:19:{s:4:"tmpl";i:589;s:2:"id";i:4947;s:5:"title";s:14:"Testimonial 27";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_white_9.png";s:12:"tmpl_created";i:1520520567;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-27/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:663;s:16:"popularity_index";i:221;s:11:"trend_index";i:496;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:808;a:19:{s:4:"tmpl";i:590;s:2:"id";i:4955;s:5:"title";s:14:"Testimonial 29";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_9.png";s:12:"tmpl_created";i:1520520569;s:6:"author";s:9:"Elementor";s:3:"url";s:120:"https://library.elementor.com/blocks/testimonial-29/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:664;s:16:"popularity_index";i:378;s:11:"trend_index";i:695;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:809;a:19:{s:4:"tmpl";i:588;s:2:"id";i:4939;s:5:"title";s:13:"Testimonial 9";s:9:"thumbnail";s:81:"https://library.elementor.com/wp-content/uploads/2018/03/testimonials_black_8.png";s:12:"tmpl_created";i:1520520565;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/testimonial-9/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:4:"free";s:7:"subtype";s:12:"testimonials";s:4:"tags";s:15:"["Testimonial"]";s:10:"menu_order";i:665;s:16:"popularity_index";i:103;s:11:"trend_index";i:341;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"0";s:12:"access_level";i:0;}i:810;a:19:{s:4:"tmpl";i:928;s:2:"id";i:12509;s:5:"title";s:18:"Travel &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2019/12/404.png";s:12:"tmpl_created";i:1575960378;s:6:"author";s:9:"Elementor";s:3:"url";s:116:"https://library.elementor.com/blocks/travel-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:24:"["404","Tours","Travel"]";s:10:"menu_order";i:666;s:16:"popularity_index";i:747;s:11:"trend_index";i:712;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:811;a:19:{s:4:"tmpl";i:929;s:2:"id";i:12516;s:5:"title";s:27:"Travel &#8211; Archive Blog";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2019/12/Archiv_s.png";s:12:"tmpl_created";i:1575960387;s:6:"author";s:9:"Elementor";s:3:"url";s:125:"https://library.elementor.com/blocks/travel-archive-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:667;s:16:"popularity_index";i:496;s:11:"trend_index";i:487;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:812;a:19:{s:4:"tmpl";i:927;s:2:"id";i:12500;s:5:"title";s:21:"Travel &#8211; Header";s:9:"thumbnail";s:84:"https://library.elementor.com/wp-content/uploads/2020/06/Header-travel-and-tours.png";s:12:"tmpl_created";i:1575960371;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/travel-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:27:"["Header","Tours","Travel"]";s:10:"menu_order";i:668;s:16:"popularity_index";i:443;s:11:"trend_index";i:434;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:813;a:19:{s:4:"tmpl";i:930;s:2:"id";i:12524;s:5:"title";s:26:"Travel &#8211; Single Post";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/12/Single_Post_s.png";s:12:"tmpl_created";i:1575960397;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/travel-single-post/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:669;s:16:"popularity_index";i:591;s:11:"trend_index";i:663;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:814;a:19:{s:4:"tmpl";i:931;s:2:"id";i:12531;s:5:"title";s:31:"Travel &#8211; Single Post Tour";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2019/12/Single_Tour_s.png";s:12:"tmpl_created";i:1575960404;s:6:"author";s:9:"Elementor";s:3:"url";s:129:"https://library.elementor.com/blocks/travel-single-post-tour/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:18:"["Tours","Travel"]";s:10:"menu_order";i:670;s:16:"popularity_index";i:630;s:11:"trend_index";i:548;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:815;a:19:{s:4:"tmpl";i:926;s:2:"id";i:12492;s:5:"title";s:14:"Travel -Footer";s:9:"thumbnail";s:69:"https://library.elementor.com/wp-content/uploads/2019/12/Footer_s.png";s:12:"tmpl_created";i:1575960358;s:6:"author";s:9:"Elementor";s:3:"url";s:119:"https://library.elementor.com/blocks/travel-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:27:"["Footer","Tours","Travel"]";s:10:"menu_order";i:671;s:16:"popularity_index";i:453;s:11:"trend_index";i:322;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:816;a:19:{s:4:"tmpl";i:1068;s:2:"id";i:15498;s:5:"title";s:23:"Travel Blog &#8211; 404";s:9:"thumbnail";s:64:"https://library.elementor.com/wp-content/uploads/2020/11/404.jpg";s:12:"tmpl_created";i:1606215636;s:6:"author";s:9:"Elementor";s:3:"url";s:121:"https://library.elementor.com/blocks/travel-blog-404/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:8:"404 page";s:4:"tags";s:23:"["404","Blog","Travel"]";s:10:"menu_order";i:672;s:16:"popularity_index";i:749;s:11:"trend_index";i:759;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:817;a:19:{s:4:"tmpl";i:1069;s:2:"id";i:15508;s:5:"title";s:29:"Travel Blog &#8211; Archive 1";s:9:"thumbnail";s:74:"https://library.elementor.com/wp-content/uploads/2020/11/Archive-1-350.jpg";s:12:"tmpl_created";i:1606215649;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/blocks/travel-blog-archive-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:673;s:16:"popularity_index";i:659;s:11:"trend_index";i:468;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:818;a:19:{s:4:"tmpl";i:1070;s:2:"id";i:15518;s:5:"title";s:29:"Travel Blog &#8211; Archive 2";s:9:"thumbnail";s:79:"https://library.elementor.com/wp-content/uploads/2020/11/Archive-2-350-Copy.jpg";s:12:"tmpl_created";i:1606215663;s:6:"author";s:9:"Elementor";s:3:"url";s:127:"https://library.elementor.com/blocks/travel-blog-archive-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:7:"archive";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:674;s:16:"popularity_index";i:688;s:11:"trend_index";i:431;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:819;a:19:{s:4:"tmpl";i:1071;s:2:"id";i:15528;s:5:"title";s:26:"Travel Blog &#8211; Footer";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/11/Footer.jpg";s:12:"tmpl_created";i:1606215673;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/travel-blog-footer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"footer";s:4:"tags";s:26:"["Blog","Footer","Travel"]";s:10:"menu_order";i:675;s:16:"popularity_index";i:656;s:11:"trend_index";i:377;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:820;a:19:{s:4:"tmpl";i:1067;s:2:"id";i:15536;s:5:"title";s:26:"Travel Blog &#8211; Header";s:9:"thumbnail";s:67:"https://library.elementor.com/wp-content/uploads/2020/11/Header.jpg";s:12:"tmpl_created";i:1606215625;s:6:"author";s:9:"Elementor";s:3:"url";s:124:"https://library.elementor.com/blocks/travel-blog-header/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:6:"header";s:4:"tags";s:26:"["Blog","Header","Travel"]";s:10:"menu_order";i:676;s:16:"popularity_index";i:584;s:11:"trend_index";i:228;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"0";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:821;a:19:{s:4:"tmpl";i:1072;s:2:"id";i:15545;s:5:"title";s:33:"Travel Blog &#8211; Single Post 1";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/11/Single-1-350.jpg";s:12:"tmpl_created";i:1606215684;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/blocks/travel-blog-single-post-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:677;s:16:"popularity_index";i:669;s:11:"trend_index";i:482;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}i:822;a:19:{s:4:"tmpl";i:1066;s:2:"id";i:15556;s:5:"title";s:33:"Travel Blog &#8211; Single Post 2";s:9:"thumbnail";s:73:"https://library.elementor.com/wp-content/uploads/2020/11/Single-2-350.jpg";s:12:"tmpl_created";i:1606215613;s:6:"author";s:9:"Elementor";s:3:"url";s:131:"https://library.elementor.com/blocks/travel-blog-single-post-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview";s:4:"type";s:5:"block";s:11:"access_tier";s:9:"essential";s:7:"subtype";s:11:"single post";s:4:"tags";s:17:"["Blog","Travel"]";s:10:"menu_order";i:678;s:16:"popularity_index";i:652;s:11:"trend_index";i:454;s:18:"editor_layout_type";s:0:"";s:15:"minimum_version";s:5:"0.0.0";s:17:"has_page_settings";s:1:"1";s:6:"is_pro";s:1:"1";s:12:"access_level";i:1;}}}','no');
INSERT INTO `wp_options` VALUES (179,'elementor_remote_info_feed_data','a:3:{i:0;a:5:{s:5:"title";s:81:"Introducing Platinum Support: Your Ultimate Solution for Superior Website Support";s:7:"excerpt";s:149:"Introducing Platinum Support: Elevate your Elementor experience with dedicated expert assistance, faster response times, and 24/7 real human support.";s:7:"created";i:1723108567;s:5:"badge";s:3:"NEW";s:3:"url";s:128:"https://elementor.com/blog/introducing-platinum-support/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}i:1;a:5:{s:5:"title";s:64:"Image Optimizer 1.5: Introducing AVIF Compression and Conversion";s:7:"excerpt";s:165:"Upgrade to Image Optimizer v1.5 and experience the power of AVIF, the next-gen image format that delivers better compression, smaller file sizes, and higher quality.";s:7:"created";i:1722327900;s:5:"badge";s:3:"NEW";s:3:"url";s:116:"https://elementor.com/blog/introducing-avif/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}i:2;a:5:{s:5:"title";s:57:"New Off-Canvas Widget & Element Caching in Elementor 3.22";s:7:"excerpt";s:147:"Build Interactive Layouts with the Off-Canvas Widget and Give Your Websites a Major Performance Improvement by Activating Element Caching and More!";s:7:"created";i:1718720040;s:5:"badge";s:3:"NEW";s:3:"url";s:140:"https://elementor.com/blog/elementor-322-off-canvas-element-caching/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed";}}','off');
INSERT INTO `wp_options` VALUES (182,'dismissed-oceanwp_plugin_notice','1','yes');
INSERT INTO `wp_options` VALUES (189,'WPLANG','fr_FR','yes');
INSERT INTO `wp_options` VALUES (190,'new_admin_email','dev-email@wpengine.local','yes');
INSERT INTO `wp_options` VALUES (207,'nav_menu_options','a:2:{i:0;b:0;s:8:"auto_add";a:0:{}}','yes');
INSERT INTO `wp_options` VALUES (224,'_transient_health-check-site-status-result','{"good":18,"recommended":2,"critical":0}','yes');
INSERT INTO `wp_options` VALUES (245,'elementor_log','a:42:{s:32:"ec8fe65068b61652220cd505fb7f9618";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-18 11:18:41";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-18 11:18:41";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"872851aa712094585122d00b025e7895";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-18 11:18:41";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-18 11:18:41";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"017bf3e8ed0650679b5aaf2902ff5dd7";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-18 11:18:41";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-18 11:18:41";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"cd2e73471511c4f54234d8e43b4b89c4";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-18 11:18:41";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.21.8";s:2:"to";s:6:"3.22.1";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-18 11:18:41";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.21.8";s:2:"to";s:6:"3.22.1";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}s:32:"22c67d37922a6a9073590f7911385480";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-18 11:18:41";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.21.8";s:2:"to";s:6:"3.22.1";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-18 11:18:41";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.21.8";s:2:"to";s:6:"3.22.1";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"6eef824c4894f871acb045c5efe1610c";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2024-06-19 11:18:31";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:33:"this.store.find(...) is undefined";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:16;s:14:"\0*\0times_dates";a:16:{i:0;s:19:"2024-06-19 11:18:31";i:1;s:19:"2024-06-19 11:18:31";i:2;s:19:"2024-06-20 14:47:24";i:3;s:19:"2024-06-20 14:47:25";i:4;s:19:"2024-06-20 14:47:25";i:5;s:19:"2024-06-20 14:47:25";i:6;s:19:"2024-06-20 14:47:25";i:7;s:19:"2024-06-20 14:47:25";i:8;s:19:"2024-06-21 10:38:55";i:9;s:19:"2024-06-21 10:38:55";i:10;s:19:"2024-06-21 10:38:57";i:11;s:19:"2024-06-21 10:38:57";i:12;s:19:"2024-06-21 10:38:57";i:13;s:19:"2024-06-21 10:38:57";i:14;s:19:"2024-06-21 10:38:57";i:15;s:19:"2024-06-21 10:38:57";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1718795911";s:7:"message";s:33:"this.store.find(...) is undefined";s:3:"url";s:95:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.22.1";s:4:"line";s:1:"3";s:6:"column";s:6:"825593";}s:7:"\0*\0file";s:95:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.22.1";s:7:"\0*\0line";s:1:"3";s:9:"\0*\0column";s:6:"825593";}s:32:"e2c8f11f936bd2803815a5b7cce6afb1";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2024-06-19 13:04:37";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:37:"this.getColorRepresentation() is null";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1147;s:14:"\0*\0times_dates";a:42:{i:0;s:19:"2024-06-24 23:26:06";i:1;s:19:"2024-06-24 23:26:31";i:2;s:19:"2024-06-24 23:26:31";i:3;s:19:"2024-06-24 23:26:32";i:4;s:19:"2024-06-24 23:26:36";i:5;s:19:"2024-06-24 23:26:36";i:6;s:19:"2024-06-24 23:26:36";i:7;s:19:"2024-06-24 23:26:36";i:8;s:19:"2024-06-24 23:26:36";i:9;s:19:"2024-06-24 23:26:36";i:10;s:19:"2024-06-24 23:27:22";i:11;s:19:"2024-06-24 23:27:22";i:12;s:19:"2024-06-24 23:29:33";i:13;s:19:"2024-06-24 23:29:33";i:14;s:19:"2024-06-24 23:29:33";i:15;s:19:"2024-06-24 23:29:33";i:16;s:19:"2024-06-24 23:29:37";i:17;s:19:"2024-06-24 23:29:37";i:18;s:19:"2024-06-24 23:29:37";i:19;s:19:"2024-06-24 23:29:37";i:20;s:19:"2024-06-24 23:29:42";i:21;s:19:"2024-06-24 23:29:45";i:22;s:19:"2024-06-24 23:30:12";i:23;s:19:"2024-06-24 23:30:12";i:24;s:19:"2024-06-24 23:30:12";i:25;s:19:"2024-06-24 23:30:12";i:26;s:19:"2024-06-24 23:30:12";i:27;s:19:"2024-06-24 23:30:12";i:28;s:19:"2024-06-24 23:31:05";i:29;s:19:"2024-06-24 23:31:05";i:30;s:19:"2024-06-24 23:31:05";i:31;s:19:"2024-06-24 23:31:05";i:32;s:19:"2024-06-24 23:31:05";i:33;s:19:"2024-06-24 23:31:05";i:34;s:19:"2024-06-24 23:31:27";i:35;s:19:"2024-06-24 23:31:27";i:36;s:19:"2024-06-24 23:31:27";i:37;s:19:"2024-06-24 23:31:27";i:38;s:19:"2024-06-24 23:31:28";i:39;s:19:"2024-06-24 23:32:15";i:40;s:19:"2024-06-24 23:32:15";i:41;s:19:"2024-06-24 23:32:15";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1718802277";s:7:"message";s:37:"this.getColorRepresentation() is null";s:3:"url";s:100:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0";s:4:"line";s:1:"2";s:6:"column";s:5:"17898";}s:7:"\0*\0file";s:100:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.5.0";s:7:"\0*\0line";s:1:"2";s:9:"\0*\0column";s:5:"17898";}s:32:"3ac077e5dfab6439852a2fbe0350b40e";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2024-06-19 17:55:01";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:29:"this.placeholder is undefined";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:4;s:14:"\0*\0times_dates";a:4:{i:0;s:19:"2024-06-19 17:55:01";i:1;s:19:"2024-06-19 17:55:10";i:2;s:19:"2024-06-19 17:55:11";i:3;s:19:"2024-06-19 17:55:11";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1718819701";s:7:"message";s:29:"this.placeholder is undefined";s:3:"url";s:121:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/lib/e-select2/js/e-select2.full.min.js?ver=4.0.6-rc.1";s:4:"line";s:1:"1";s:6:"column";s:5:"20470";}s:7:"\0*\0file";s:121:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/lib/e-select2/js/e-select2.full.min.js?ver=4.0.6-rc.1";s:7:"\0*\0line";s:1:"1";s:9:"\0*\0column";s:5:"20470";}s:32:"a3a8e473a6f2bb1234debdde02dfc238";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2024-06-20 14:27:07";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:24:"this.swiper is undefined";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:2;s:14:"\0*\0times_dates";a:2:{i:0;s:19:"2024-06-20 14:27:07";i:1;s:19:"2024-06-20 14:27:13";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1718893627";s:7:"message";s:24:"this.swiper is undefined";s:3:"url";s:105:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/frontend-modules.min.js?ver=3.22.1";s:4:"line";s:1:"2";s:6:"column";s:5:"10663";}s:7:"\0*\0file";s:105:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/frontend-modules.min.js?ver=3.22.1";s:7:"\0*\0line";s:1:"2";s:9:"\0*\0column";s:5:"10663";}s:32:"fc0306d9c5939125f4a469fd04281a4f";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2024-06-20 14:56:49";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:28:"I.attributes.id is undefined";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:94;s:14:"\0*\0times_dates";a:42:{i:0;s:19:"2024-06-20 17:24:22";i:1;s:19:"2024-06-20 17:24:22";i:2;s:19:"2024-06-20 17:24:22";i:3;s:19:"2024-06-20 17:24:22";i:4;s:19:"2024-06-20 17:24:22";i:5;s:19:"2024-06-20 17:24:22";i:6;s:19:"2024-06-20 17:24:22";i:7;s:19:"2024-06-20 17:24:22";i:8;s:19:"2024-06-20 17:24:22";i:9;s:19:"2024-06-20 17:24:22";i:10;s:19:"2024-06-20 17:24:22";i:11;s:19:"2024-06-20 17:41:45";i:12;s:19:"2024-06-20 17:41:45";i:13;s:19:"2024-06-20 17:41:45";i:14;s:19:"2024-06-20 17:41:45";i:15;s:19:"2024-06-20 17:41:45";i:16;s:19:"2024-06-20 17:41:45";i:17;s:19:"2024-06-20 17:41:45";i:18;s:19:"2024-06-20 17:41:45";i:19;s:19:"2024-06-20 17:41:45";i:20;s:19:"2024-06-20 17:41:45";i:21;s:19:"2024-06-20 17:41:45";i:22;s:19:"2024-06-20 17:41:45";i:23;s:19:"2024-06-20 18:16:23";i:24;s:19:"2024-06-20 18:16:23";i:25;s:19:"2024-06-20 18:16:23";i:26;s:19:"2024-06-20 18:16:23";i:27;s:19:"2024-06-20 18:16:23";i:28;s:19:"2024-06-20 18:16:23";i:29;s:19:"2024-06-20 18:16:23";i:30;s:19:"2024-06-20 18:16:23";i:31;s:19:"2024-06-20 18:16:23";i:32;s:19:"2024-06-20 18:16:23";i:33;s:19:"2024-06-20 18:16:23";i:34;s:19:"2024-06-20 18:16:23";i:35;s:19:"2024-06-20 18:16:23";i:36;s:19:"2024-06-20 18:17:06";i:37;s:19:"2024-06-20 18:17:06";i:38;s:19:"2024-06-21 10:51:49";i:39;s:19:"2024-06-21 10:51:54";i:40;s:19:"2024-06-21 10:51:58";i:41;s:19:"2024-06-21 10:52:07";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1718895409";s:7:"message";s:28:"I.attributes.id is undefined";s:3:"url";s:105:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/ai-media-library.min.js?ver=3.22.1";s:4:"line";s:1:"3";s:6:"column";s:6:"338841";}s:7:"\0*\0file";s:105:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/ai-media-library.min.js?ver=3.22.1";s:7:"\0*\0line";s:1:"3";s:9:"\0*\0column";s:6:"338841";}s:32:"c0e926da16fa1006f9e31b096489fd9c";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-24 21:54:12";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-24 21:54:12";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"4fc109154e9f024c6fd10bd13faa61d9";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-24 21:54:12";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-24 21:54:12";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"09d1fe8ed8fa8e5f5d217d24597f2180";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-24 21:54:12";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-24 21:54:12";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"12e874e5fb445e73a58a5bf604265569";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-24 21:54:12";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.1";s:2:"to";s:6:"3.22.2";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-24 21:54:12";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.1";s:2:"to";s:6:"3.22.2";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}s:32:"69857ac2b4886380230db37e2a94e360";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-24 21:54:12";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.1";s:2:"to";s:6:"3.22.2";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-24 21:54:12";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.1";s:2:"to";s:6:"3.22.2";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"c64e155f8bc4802c968cd4d472390420";O:30:"Elementor\\Core\\Logger\\Items\\JS":10:{s:7:"\0*\0date";s:19:"2024-06-24 23:53:39";s:7:"\0*\0type";s:5:"error";s:10:"\0*\0message";s:9:"V is null";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-24 23:53:39";}s:7:"\0*\0args";a:6:{s:4:"type";s:5:"error";s:9:"timestamp";s:10:"1719273219";s:7:"message";s:9:"V is null";s:3:"url";s:95:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.22.2";s:4:"line";s:1:"3";s:6:"column";s:7:"1176311";}s:7:"\0*\0file";s:95:"http://ferme-de-chassagne.local/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.22.2";s:7:"\0*\0line";s:1:"3";s:9:"\0*\0column";s:7:"1176311";}s:32:"4d295e015fb3583bf99dd9746a8b5caf";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-28 08:46:59";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-28 08:46:59";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"71017273f2745446c22e52ad73eed3e0";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-28 08:46:59";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-28 08:46:59";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"91fafba442327f378cc09debc2cd9ebb";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-28 08:46:59";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-28 08:46:59";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"ae15ef3c4dda5ad8db658303524c2610";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-28 08:46:59";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.2";s:2:"to";s:6:"3.22.3";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-28 08:46:59";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.2";s:2:"to";s:6:"3.22.3";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}s:32:"b80bb992240e2f79647b064b4f49fe4b";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-06-28 08:46:59";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.2";s:2:"to";s:6:"3.22.3";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-06-28 08:46:59";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.2";s:2:"to";s:6:"3.22.3";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"9960effe241a8e28395ff6f3c5da9318";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-15 18:34:38";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.3";s:2:"to";s:6:"3.23.1";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-15 18:34:38";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.3";s:2:"to";s:6:"3.23.1";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"caf814086c915d51fd4728117299d248";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-15 18:34:40";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-15 18:34:40";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"90a5f7250b37c97b344c8173f3f58e6c";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-15 18:34:40";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-15 18:34:40";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"7a8d455e34e0c44e512a6aef45719b7f";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-15 18:34:40";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-15 18:34:40";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"92ac88aba36bff610547d4242bff883e";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-15 18:34:40";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.3";s:2:"to";s:6:"3.23.1";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-15 18:34:40";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.22.3";s:2:"to";s:6:"3.23.1";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}s:32:"25995eebd4b48b0585fadcfb859dd31d";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-24 14:45:43";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.1";s:2:"to";s:6:"3.23.2";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-24 14:45:43";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.1";s:2:"to";s:6:"3.23.2";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"10b5e23d63dc204529c58b2a2019ff5b";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-24 14:45:46";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-24 14:45:46";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"28a348bcbd5210691b9cbb3c865b5961";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-24 14:45:46";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-24 14:45:46";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"2fa4c669dd343bc526165bd8883818bf";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-24 14:45:47";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-24 14:45:47";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"6cf07192cf3fb21926bb21d4c663536f";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-07-24 14:45:47";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.1";s:2:"to";s:6:"3.23.2";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-07-24 14:45:47";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.1";s:2:"to";s:6:"3.23.2";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}s:32:"4a0fdfabe62d1689111b1cdced3a5437";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:55";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:55";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"8af66534846fb101c68338d9e8acf199";O:31:"Elementor\\Core\\Logger\\Items\\PHP":9:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:55";s:7:"\0*\0type";s:7:"warning";s:10:"\0*\0message";s:135:"unlink(C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public/wp-content/uploads/elementor/css/post-9.css): No such file or directory";s:7:"\0*\0meta";a:1:{s:5:"trace";a:1:{i:0;a:3:{s:8:"function";s:8:"shutdown";s:5:"class";s:29:"Elementor\\Core\\Logger\\Manager";s:4:"type";s:2:"->";}}}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:55";}s:7:"\0*\0args";a:5:{s:4:"type";s:7:"warning";s:7:"message";s:135:"unlink(C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public/wp-content/uploads/elementor/css/post-9.css): No such file or directory";s:4:"file";s:108:"C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public\\wp-content\\plugins\\elementor\\core\\files\\manager.php";s:4:"line";i:112;s:5:"trace";b:1;}s:7:"\0*\0file";s:108:"C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public\\wp-content\\plugins\\elementor\\core\\files\\manager.php";s:7:"\0*\0line";i:112;}s:32:"870199b13c7f22614ddee0d65241d804";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:56";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:56";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"d87a0c608ce9d2293b69a90183e1ab91";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:56";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:2;s:14:"\0*\0times_dates";a:2:{i:0;s:19:"2024-08-20 09:21:56";i:1;s:19:"2024-08-20 09:21:56";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"2baeae3de24d675c9ce7999eeeaff6dd";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:56";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:2;s:14:"\0*\0times_dates";a:2:{i:0;s:19:"2024-08-20 09:21:56";i:1;s:19:"2024-08-20 09:21:56";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"c802620aef0be22faa653f2c311cfb1d";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:56";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:56";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}s:32:"c4e42c54f816602434e7490b28e7f063";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:57";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:47:"Elementor data updater process has been queued.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:57";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:7:"message";s:47:"Elementor data updater process has been queued.";s:4:"type";s:4:"info";}}s:32:"95c99800ebe0ef24f359b3e16e3e6f7b";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:57";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:36:"elementor::elementor_updater Started";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:57";}s:7:"\0*\0args";a:2:{s:7:"message";s:36:"elementor::elementor_updater Started";s:4:"type";s:4:"info";}}s:32:"ea5aa99a5f990d553e42596f18017d78";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:57";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:57";}s:7:"\0*\0args";a:2:{s:7:"message";s:44:"Elementor/Upgrades - _on_each_version Start ";s:4:"type";s:4:"info";}}s:32:"47dec51529db6db148112c16be127c9d";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:57";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:7:"\0*\0meta";a:0:{}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:57";}s:7:"\0*\0args";a:2:{s:7:"message";s:46:"Elementor/Upgrades - _on_each_version Finished";s:4:"type";s:4:"info";}}s:32:"58219f68dce38397f5061f27f15314a0";O:32:"Elementor\\Core\\Logger\\Items\\Base":7:{s:7:"\0*\0date";s:19:"2024-08-20 09:21:57";s:7:"\0*\0type";s:4:"info";s:10:"\0*\0message";s:50:"Elementor data updater process has been completed.";s:7:"\0*\0meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:8:"\0*\0times";i:1;s:14:"\0*\0times_dates";a:1:{i:0;s:19:"2024-08-20 09:21:57";}s:7:"\0*\0args";a:3:{s:4:"meta";a:3:{s:6:"plugin";s:9:"Elementor";s:4:"from";s:6:"3.23.2";s:2:"to";s:6:"3.23.4";}s:7:"message";s:50:"Elementor data updater process has been completed.";s:4:"type";s:4:"info";}}}','off');
INSERT INTO `wp_options` VALUES (285,'_elementor_notifications_data','a:2:{s:7:"timeout";i:1721312108;s:5:"value";s:8545:"[{"id":"element-caching-3.22","title":"Accelerate Loading Times with Element Caching","description":"Ensure a smooth and engaging experience for visitors by activating Element Caching.","topic":"New in Elementor 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/performance-caching.png","chipTags":["Performance"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-element-caching-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"element-caching-3.22","title":"Accelerate Loading Times with Element Caching","description":"Ensure a smooth and engaging experience for visitors by activating Element Caching.","topic":"New in Elementor 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/performance-caching.png","chipTags":["Performance"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-element-caching-blog\\/","readMoreText":"Learn More"},{"id":"off-canvas-3.22","title":"Build Interactive Layouts with the New Off-Canvas Widget","description":"Tigger containers from a connected link to allow them to slide into view anywhere on the page.","topic":"New in Elementor Pro 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-off-canvas-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"off-canvas-3.22","title":"Build Interactive Layouts with the New Off-Canvas Widget","description":"Tigger containers from a connected link to allow them to slide into view anywhere on the page.","topic":"New in Elementor Pro 3.22","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/off-canvas.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-off-canvas-blog\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-off-canvas\\/\\/"},{"id":"ai-personal-assistant-styling","title":"AI Copilot Now Inherits Global Styling","description":"Copilot now uses your site\'s style for fonts & colors when generating a container layout for even faster web creation backed by the power of AI. Enjoy a seamless design experience.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/copilot-ai.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/ai-notification-personal-assistant-global-styling-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"introduction_meta","meta":"ai_get_started"}]],"cta":"Start Free Trial","ctaLink":"https:\\/\\/go.elementor.com\\/ai-notification-personal-assistant-global-styling\\/"},{"id":"ai-personal-assistant-styling","title":"AI Copilot Now Inherits Global Styling","description":"Copilot now uses your site\'s style for fonts & colors when generating a container layout for even faster web creation backed by the power of AI. Enjoy a seamless design experience.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/copilot-ai.png","chipTags":["New Feature"],"cta":"Start Free Trial","link":"https:\\/\\/go.elementor.com\\/ai-notification-personal-assistant-global-styling-blog\\/","readMoreText":"Learn More","ctaLink":"https:\\/\\/go.elementor.com\\/ai-notification-personal-assistant-global-styling\\/"},{"id":"5-star-rating-prompt","title":"Love the New Features? Let Us Know with 5 Stars!","description":"Help spread the word by telling the world what you love about Elementor.","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png","cta":"Leave a Review","ctaLink":"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/"},{"id":"loop-taxonomy-query-3.21","title":"Create Engaging Listings for Categories and Tags","description":"Design beautiful Loop Grids & Carousels to consistently display your dynamic content.","topic":"Version Pro 3.21","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/loop-taxonomy-query-3.21.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-taxonomy-query-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"loop-taxonomy-query-3.21","title":"Create Engaging Listings for Categories and Tags","description":"Design beautiful Loop Grids & Carousels to consistently display your dynamic content.","topic":"Version Pro 3.21","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/loop-taxonomy-query-3.21.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-taxonomy-query-blog\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-taxonomy-query\\/"},{"id":"ai-personal-assistant-3.21","title":"Meet Your Personal AI Assistant","description":"Copilot suggests container layouts, blending your personal style with industry best practices.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ai-personal-assistant-3.21.png","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/ai-notification-personal-assistant-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"introduction_meta","meta":"ai_get_started"}]],"cta":"Start Free Trial","ctaLink":"https:\\/\\/go.elementor.com\\/ai-notification-personal-assistant\\/"},{"id":"ai-personal-assistant-3.21","title":"Meet Your Personal AI Assistant","description":"Copilot suggests container layouts, blending your personal style with industry best practices.","topic":"Elementor AI","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ai-personal-assistant-3.21.png","chipTags":["New Feature"],"cta":"Start Free Trial","ctaLink":"https:\\/\\/go.elementor.com\\/ai-notification-web-based-container\\/"},{"id":"image-optimizer-3.19","title":"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.","description":"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.","topic":"Image Optimizer Plugin by Elementor","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png","chipTags":["New plugin"],"cta":"Get the Image Optimizer","ctaLink":"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/","conditions":[[{"type":"plugin","operator":"!=","plugin":"image-optimization\\/image-optimization.php"}]]},{"id":"display-conditions-dynamic-content-3.20","title":"Display Conditions for Dynamic Content","description":"Transform your single post and page templates into dynamic designs that fit their content by setting display conditions based on Dynamic Tags, including native WordPress Custom Fields.","topic":"Version Pro 3.20","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/dynamic-content-pro-3.20.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-display-conditions-blog\\/","readMoreText":"Learn More","conditions":[[{"type":"plugin","plugin":"elementor-pro\\/elementor-pro.php"}]]},{"id":"display-conditions-dynamic-content-3.20","title":"Display Content on Your Terms: Decide When, Where, and by Who the Content is Viewed","description":"Tailor the content on your page to visitors based on various rules to create a powerful experience.","topic":"Version Pro 3.20","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/display-conditions-3.20.png","chipPlan":"Pro","chipTags":["New Feature"],"link":"https:\\/\\/go.elementor.com\\/go-pro-notification-display-conditions-blog\\/","readMoreText":"Learn More","cta":"Upgrade","ctaLink":"https:\\/\\/go.elementor.com\\/go-pro-notification-dispaly-conditions\\/"},{"id":"elementor-add-ons","title":"Exciting Add-Ons & Plugins to Enhance Elementor Websites","description":"Uncover a treasure trove of tools from Elementor and others, put together to boost your website\'s capabilities and enhance its overall appeal.","topic":"Elementor Add-Ons","imageSrc":"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/elementor-add-ons.png","cta":"Check it out","ctaLink":"https:\\/\\/go.elementor.com\\/wp-dash-notification-addons\\/"}]";}','off');
INSERT INTO `wp_options` VALUES (291,'_elementor_home_screen_data','a:2:{s:7:"timeout";i:1718823072;s:5:"value";s:8404:"{"top":{"title_small":"Hi!","title":"Unleash your imagination with Elementor","description":"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.","button_create_page_title":"Create a Page","button_watch_title":"Watch a guide","button_watch_url":"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s","youtube_embed_id":"le72grP_Q6k?si=g2akyWNODL6usu6u"},"top_with_licences":[{"license":["free"],"title_small":"Hi!","title":"Unleash your imagination with Elementor","description":"Start building your website with Elementor\'s no code drag & drop editor.","button_create_page_title":"Create a Page","button_watch_title":"Watch a guide","button_watch_url":"https:\\/\\/www.youtube.com\\/watch?v=le72grP_Q6k&t=1s","youtube_embed_id":"le72grP_Q6k?si=g2akyWNODL6usu6u"},{"license":["pro"],"title_small":"Hi!","title":"Unleash your imagination with Elementor","description":"Now you\'ve got all the tools to start creating professional, high-performing websites - and that journey begins by creating your first page.","button_create_page_title":"Create a Page","button_watch_title":"Watch a guide","button_watch_url":"https:\\/\\/www.youtube.com\\/watch?v=QdkDGrS8ZZs","youtube_embed_id":"QdkDGrS8ZZs?si=s_VjZCQR6Fh1jgB5"}],"get_started":[{"license":["free"],"header":{"title":"Jumpstart your web-creation","description":"These quick actions will get your site airborne with a customized design."},"repeater":[{"title":"Site Settings","title_small":"Customize","url":"","is_relative_url":false,"title_small_color":"text.tertiary","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg"},{"title":"Site Logo","title_small":"Customize","url":"","is_relative_url":false,"title_small_color":"text.tertiary","tab_id":"settings-site-identity","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg"},{"title":"Global Colors","title_small":"Customize","url":"","is_relative_url":false,"title_small_color":"text.tertiary","tab_id":"global-colors","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg"},{"title":"Global Fonts","title_small":"Customize","url":"","is_relative_url":false,"title_small_color":"text.tertiary","tab_id":"global-typography","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg"},{"title":"Theme Builder","title_small":"Customize","url":"admin.php?page=elementor-app","is_relative_url":false,"title_small_color":"text.tertiary","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg"},{"title":"Popups","title_small":"Customize","url":"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup","is_relative_url":true,"title_small_color":"text.tertiary","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg"},{"title":"Custom Icons","title_small":"Customize","url":"admin.php?page=elementor_custom_icons","is_relative_url":false,"title_small_color":"text.tertiary","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg"},{"title":"Custom Fonts","title_small":"Customize","url":"admin.php?page=elementor_custom_fonts","is_relative_url":true,"image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg","title_small_color":"text.tertiary"}]},{"license":["pro"],"header":{"title":"Jumpstart your web-creation","description":"These quick actions will get your site airborne with a customized design."},"repeater":[{"title":"Site Settings","title_small":"Customize","url":"","is_relative_url":false,"image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-settings.svg"},{"title":"Site Logo","title_small":"Customize","url":"","is_relative_url":false,"tab_id":"settings-site-identity","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/site-logo.svg"},{"title":"Global Colors","title_small":"Customize","url":"","is_relative_url":false,"tab_id":"global-colors","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-colors.svg"},{"title":"Global Fonts","title_small":"Customize","url":"","is_relative_url":false,"tab_id":"global-typography","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/global-fonts.svg"},{"title":"Theme Builder","title_small":"Customize","url":"admin.php?page=elementor-app","is_relative_url":false,"image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/theme-builder.svg"},{"title":"Popups","title_small":"Customize","url":"edit.php?post_type=elementor_library&tabs_group=popup&elementor_library_type=popup","is_relative_url":true,"image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/popups.svg"},{"title":"Custom Icons","title_small":"Customize","url":"admin.php?page=elementor_custom_icons","is_relative_url":false,"image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-icons.svg"},{"title":"Custom Fonts","title_small":"Customize","url":"admin.php?page=elementor_custom_fonts","is_relative_url":true,"image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/custom-fonts.svg"}]}],"add_ons":{"header":{"title":"Expand your design toolkit","description":"These plugins, add-ons, and tools, have been selected to streamline your workflow and maximize your creativity."},"repeater":[{"file_path":"image-optimization\\/image-optimization.php","title":"Image Optimizer","url":"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-io\\/","description":"Check out this incredibly useful plugin that will compress and optimize your images, giving you leaner, faster websites.","button_label":"Install","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/image-optimizer.svg","type":"wporg"},{"title":"Elementor AI","url":"https:\\/\\/go.elementor.com\\/wp-dash-apps-author-uri-elementor-ai\\/","description":"Boost creativity with Elementor AI. Craft & enhance copy, create custom CSS & Code, and generate images to elevate your website.","button_label":"Let\'s go","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/elementor.svg","type":"link","condition":{"key":"introduction_meta","value":"ai_get_started"}}],"footer":{"label":"Explore more add-ons","file_path":"wp-admin\\/admin.php?page=elementor-apps"}},"sidebar_upgrade":[{"license":["free"],"show":"true","header":{"title":"Bring your vision to life","description":"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg"},"cta":{"label":"Upgrade Now","url":"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg"},"repeater":[{"title":"Popup Builder"},{"title":"Custom Code & CSS"},{"title":"E-commerce Features"},{"title":"Collaborative Notes"},{"title":"Form Submission"},{"title":"Form Integrations"},{"title":"Custom Attributes"},{"title":"Role Manager"}]},{"license":["pro"],"show":"false","header":{"title":"Bring your vision to life","description":"Get complete design flexibility for your website with Elementor Pro\\u2019s advanced tools and premium features.","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/update-sidebar.svg"},"cta":{"label":"Upgrade Now","url":"https:\\/\\/go.elementor.com\\/go-pro-home-sidebar-upgrade\\/","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-crown.svg"},"repeater":[{"title":"Popup Builder"},{"title":"Custom Code & CSS"},{"title":"E-commerce Features"},{"title":"Collaborative Notes"},{"title":"Form Submission"},{"title":"Form Integrations"},{"title":"Custom Attributes"},{"title":"Role Manager"}]}],"external_links":[{"label":"Help Center","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-question-mark.svg","url":"https:\\/\\/elementor.com\\/help\\/"},{"label":"Youtube","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-youtube.svg","url":"https:\\/\\/www.youtube.com\\/@Elementor"},{"label":"Facebook Community","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-community.svg","url":"https:\\/\\/www.facebook.com\\/groups\\/Elementors"},{"label":"Blog","image":"https:\\/\\/assets.elementor.com\\/home-screen\\/v1\\/images\\/icon-academic-hat.svg","url":"https:\\/\\/elementor.com\\/blog\\/"}]}";}','no');
INSERT INTO `wp_options` VALUES (296,'ocean-extra-version','2.2.9','yes');
INSERT INTO `wp_options` VALUES (297,'fs_active_plugins','O:8:"stdClass":3:{s:7:"plugins";a:1:{s:29:"ocean-extra/includes/freemius";O:8:"stdClass":4:{s:7:"version";s:5:"2.7.2";s:4:"type";s:6:"plugin";s:9:"timestamp";i:1718788599;s:11:"plugin_path";s:27:"ocean-extra/ocean-extra.php";}}s:7:"abspath";s:57:"C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public/";s:6:"newest";O:8:"stdClass":5:{s:11:"plugin_path";s:27:"ocean-extra/ocean-extra.php";s:8:"sdk_path";s:29:"ocean-extra/includes/freemius";s:7:"version";s:5:"2.7.2";s:13:"in_activation";b:0;s:9:"timestamp";i:1718788599;}}','yes');
INSERT INTO `wp_options` VALUES (298,'fs_debug_mode','','yes');
INSERT INTO `wp_options` VALUES (299,'fs_accounts','a:6:{s:21:"id_slug_type_path_map";a:1:{i:3752;a:3:{s:4:"slug";s:7:"oceanwp";s:4:"type";s:5:"theme";s:4:"path";s:21:"oceanwp/functions.php";}}s:10:"theme_data";a:1:{s:7:"oceanwp";a:18:{s:19:"last_load_timestamp";i:1724145663;s:16:"plugin_main_file";O:8:"stdClass":1:{s:4:"path";s:21:"oceanwp/functions.php";}s:20:"is_network_activated";b:0;s:17:"install_timestamp";i:1718788599;s:17:"was_plugin_loaded";b:1;s:16:"sdk_last_version";N;s:11:"sdk_version";s:5:"2.7.2";s:16:"sdk_upgrade_mode";b:1;s:18:"sdk_downgrade_mode";b:0;s:19:"plugin_last_version";s:5:"3.5.8";s:14:"plugin_version";s:5:"3.5.9";s:19:"plugin_upgrade_mode";b:1;s:21:"plugin_downgrade_mode";b:0;s:17:"connectivity_test";a:6:{s:12:"is_connected";N;s:4:"host";s:24:"ferme-de-chassagne.local";s:9:"server_ip";s:9:"127.0.0.1";s:9:"is_active";b:1;s:9:"timestamp";i:1718788599;s:7:"version";s:5:"3.5.7";}s:15:"prev_is_premium";b:0;s:18:"sticky_optin_added";b:1;s:12:"is_anonymous";a:3:{s:2:"is";b:1;s:9:"timestamp";i:1721832623;s:7:"version";s:5:"3.5.7";}s:21:"is_plugin_new_install";b:0;}}s:13:"file_slug_map";a:1:{s:7:"oceanwp";s:7:"oceanwp";}s:6:"themes";a:1:{s:7:"oceanwp";O:9:"FS_Plugin":24:{s:2:"id";s:4:"3752";s:7:"updated";N;s:7:"created";N;s:22:"\0FS_Entity\0_is_updated";b:1;s:10:"public_key";s:32:"pk_043077b34f20f5e11334af3c12493";s:10:"secret_key";N;s:16:"parent_plugin_id";N;s:5:"title";s:7:"OceanWP";s:4:"slug";s:7:"oceanwp";s:12:"premium_slug";s:15:"oceanwp-premium";s:4:"type";s:5:"theme";s:20:"affiliate_moderation";b:0;s:19:"is_wp_org_compliant";b:1;s:22:"premium_releases_count";N;s:4:"file";s:7:"oceanwp";s:7:"version";s:5:"3.5.9";s:11:"auto_update";N;s:4:"info";N;s:10:"is_premium";b:0;s:14:"premium_suffix";s:9:"(Premium)";s:7:"is_live";b:1;s:9:"bundle_id";s:4:"3767";s:17:"bundle_public_key";s:32:"pk_c334eb1ae413deac41e30bf00b9dc";s:17:"opt_in_moderation";N;}}s:13:"admin_notices";a:1:{s:13:"oceanwp:theme";a:0:{}}s:9:"unique_id";s:32:"4ef421d20fedfe945f59691e16145b03";}','yes');
INSERT INTO `wp_options` VALUES (300,'widget_ocean_about_me','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (301,'widget_ocean_contact_info','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (302,'widget_ocean_custom_links','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (303,'widget_ocean_custom_menu','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (304,'widget_ocean_facebook','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (305,'widget_ocean_flickr','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (306,'widget_ocean_mailchimp','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (307,'widget_ocean_recent_posts','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (308,'widget_ocean_social','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (309,'widget_ocean_social_share','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (310,'widget_ocean_tags','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (311,'widget_ocean_twitter','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (312,'widget_ocean_video','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (313,'widget_ocean_custom_header_logo','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (314,'widget_ocean_custom_header_nav','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (315,'ocean_extra_installed_time','1718788599','yes');
INSERT INTO `wp_options` VALUES (316,'owp_dismiss_sticky_notice','1','yes');
INSERT INTO `wp_options` VALUES (318,'ocean_notifications','a:3:{s:6:"update";i:1724145854;s:13:"notifications";a:0:{}s:7:"blocked";a:0:{}}','yes');
INSERT INTO `wp_options` VALUES (332,'hfe_plugin_is_activated','yes','yes');
INSERT INTO `wp_options` VALUES (333,'_hfe_db_version','1.6.37','yes');
INSERT INTO `wp_options` VALUES (334,'bsf_analytics_installed_time','1718789081','no');
INSERT INTO `wp_options` VALUES (337,'_elementor_editor_upgrade_notice_dismissed','1720285964','yes');
INSERT INTO `wp_options` VALUES (357,'site_logo','840','yes');
INSERT INTO `wp_options` VALUES (369,'elementor_unfiltered_files_upload','1','yes');
INSERT INTO `wp_options` VALUES (378,'elements_plus_settings','a:2:{s:8:"api_maps";s:0:"";s:13:"checkbox_icon";i:1;}','yes');
INSERT INTO `wp_options` VALUES (542,'googlelanguagetranslator_active','1','yes');
INSERT INTO `wp_options` VALUES (543,'googlelanguagetranslator_language','fr','yes');
INSERT INTO `wp_options` VALUES (544,'googlelanguagetranslator_flags','1','yes');
INSERT INTO `wp_options` VALUES (545,'language_display_settings','a:4:{s:2:"en";s:1:"1";s:2:"fr";s:1:"1";s:2:"de";s:1:"1";s:2:"es";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (546,'googlelanguagetranslator_translatebox','yes','yes');
INSERT INTO `wp_options` VALUES (547,'googlelanguagetranslator_display','Vertical','yes');
INSERT INTO `wp_options` VALUES (548,'googlelanguagetranslator_toolbar','No','yes');
INSERT INTO `wp_options` VALUES (549,'googlelanguagetranslator_showbranding','No','yes');
INSERT INTO `wp_options` VALUES (550,'googlelanguagetranslator_flags_alignment','flags_left','yes');
INSERT INTO `wp_options` VALUES (551,'googlelanguagetranslator_analytics','','yes');
INSERT INTO `wp_options` VALUES (552,'googlelanguagetranslator_analytics_id','','yes');
INSERT INTO `wp_options` VALUES (553,'googlelanguagetranslator_css','','yes');
INSERT INTO `wp_options` VALUES (554,'googlelanguagetranslator_multilanguage','','yes');
INSERT INTO `wp_options` VALUES (555,'googlelanguagetranslator_floating_widget','yes','yes');
INSERT INTO `wp_options` VALUES (556,'googlelanguagetranslator_flag_size','18','yes');
INSERT INTO `wp_options` VALUES (557,'googlelanguagetranslator_flags_order','','yes');
INSERT INTO `wp_options` VALUES (558,'googlelanguagetranslator_english_flag_choice','us_flag','yes');
INSERT INTO `wp_options` VALUES (559,'googlelanguagetranslator_spanish_flag_choice','spanish_flag','yes');
INSERT INTO `wp_options` VALUES (560,'googlelanguagetranslator_portuguese_flag_choice','portuguese_flag','yes');
INSERT INTO `wp_options` VALUES (561,'googlelanguagetranslator_floating_widget_text','Langue','yes');
INSERT INTO `wp_options` VALUES (562,'googlelanguagetranslator_floating_widget_text_allow_translation','','yes');
INSERT INTO `wp_options` VALUES (563,'widget_glt_widget','a:1:{s:12:"_multiwidget";i:1;}','yes');
INSERT INTO `wp_options` VALUES (564,'glt_admin_notice','a:3:{s:16:"glt_announcement";a:2:{s:5:"start";s:9:"6/24/2024";s:3:"int";i:0;}s:15:"two_week_review";a:2:{s:5:"start";s:9:"6/29/2024";s:3:"int";i:5;}s:12:"upgrade_tips";a:2:{s:5:"start";s:9:"6/26/2024";s:3:"int";i:2;}}','yes');
INSERT INTO `wp_options` VALUES (565,'googlelanguagetranslator_seo_active','','yes');
INSERT INTO `wp_options` VALUES (566,'googlelanguagetranslator_url_structure','sub_domain','yes');
INSERT INTO `wp_options` VALUES (567,'googlelanguagetranslator_url_translation_active','','yes');
INSERT INTO `wp_options` VALUES (568,'googlelanguagetranslator_hreflang_tags_active','','yes');
INSERT INTO `wp_options` VALUES (569,'glt_language_switcher_width','100%','yes');
INSERT INTO `wp_options` VALUES (570,'glt_language_switcher_text_color','#32373c','yes');
INSERT INTO `wp_options` VALUES (571,'glt_language_switcher_bg_color','','yes');
INSERT INTO `wp_options` VALUES (572,'glt_floating_widget_position','bottom_left','yes');
INSERT INTO `wp_options` VALUES (573,'glt_floating_widget_text_color','#8b0000','yes');
INSERT INTO `wp_options` VALUES (574,'glt_floating_widget_bg_color','#ffffff','yes');
INSERT INTO `wp_options` VALUES (586,'updraftplus_version','1.24.4','yes');
INSERT INTO `wp_options` VALUES (587,'updraftplus_tour_cancelled_on','intro','yes');
INSERT INTO `wp_options` VALUES (592,'yoast_migrations_free','a:1:{s:7:"version";s:4:"23.3";}','yes');
INSERT INTO `wp_options` VALUES (593,'wpseo','a:108:{s:8:"tracking";b:0;s:16:"toggled_tracking";b:0;s:22:"license_server_version";b:0;s:15:"ms_defaults_set";b:0;s:40:"ignore_search_engines_discouraged_notice";b:0;s:19:"indexing_first_time";b:1;s:16:"indexing_started";b:0;s:15:"indexing_reason";s:26:"permalink_settings_changed";s:29:"indexables_indexing_completed";b:0;s:13:"index_now_key";s:0:"";s:7:"version";s:4:"23.3";s:16:"previous_version";s:4:"23.0";s:20:"disableadvanced_meta";b:1;s:30:"enable_headless_rest_endpoints";b:1;s:17:"ryte_indexability";b:0;s:11:"baiduverify";s:0:"";s:12:"googleverify";s:0:"";s:8:"msverify";s:0:"";s:12:"yandexverify";s:0:"";s:9:"site_type";s:0:"";s:20:"has_multiple_authors";s:0:"";s:16:"environment_type";s:0:"";s:23:"content_analysis_active";b:1;s:23:"keyword_analysis_active";b:1;s:34:"inclusive_language_analysis_active";b:0;s:21:"enable_admin_bar_menu";b:1;s:26:"enable_cornerstone_content";b:1;s:18:"enable_xml_sitemap";b:1;s:24:"enable_text_link_counter";b:1;s:16:"enable_index_now";b:1;s:19:"enable_ai_generator";b:1;s:22:"ai_enabled_pre_default";b:0;s:22:"show_onboarding_notice";b:1;s:18:"first_activated_on";i:1719265248;s:13:"myyoast-oauth";b:0;s:26:"semrush_integration_active";b:1;s:14:"semrush_tokens";a:0:{}s:20:"semrush_country_code";s:2:"us";s:19:"permalink_structure";s:12:"/%postname%/";s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:18:"dynamic_permalinks";b:0;s:17:"category_base_url";s:0:"";s:12:"tag_base_url";s:0:"";s:21:"custom_taxonomy_slugs";a:2:{s:22:"elementor_library_type";s:22:"elementor_library_type";s:26:"elementor_library_category";s:26:"elementor_library_category";}s:29:"enable_enhanced_slack_sharing";b:1;s:25:"zapier_integration_active";b:0;s:19:"zapier_subscription";a:0:{}s:14:"zapier_api_key";s:0:"";s:23:"enable_metabox_insights";b:1;s:23:"enable_link_suggestions";b:1;s:26:"algolia_integration_active";b:0;s:14:"import_cursors";a:0:{}s:13:"workouts_data";a:1:{s:13:"configuration";a:1:{s:13:"finishedSteps";a:0:{}}}s:28:"configuration_finished_steps";a:3:{i:0;s:18:"siteRepresentation";i:1;s:14:"socialProfiles";i:2;s:19:"personalPreferences";}s:36:"dismiss_configuration_workout_notice";b:0;s:34:"dismiss_premium_deactivated_notice";b:0;s:19:"importing_completed";a:0:{}s:26:"wincher_integration_active";b:1;s:14:"wincher_tokens";a:0:{}s:36:"wincher_automatically_add_keyphrases";b:0;s:18:"wincher_website_id";s:0:"";s:18:"first_time_install";b:0;s:34:"should_redirect_after_install_free";b:0;s:34:"activation_redirect_timestamp_free";i:1719265249;s:18:"remove_feed_global";b:0;s:27:"remove_feed_global_comments";b:0;s:25:"remove_feed_post_comments";b:0;s:19:"remove_feed_authors";b:0;s:22:"remove_feed_categories";b:0;s:16:"remove_feed_tags";b:0;s:29:"remove_feed_custom_taxonomies";b:0;s:22:"remove_feed_post_types";b:0;s:18:"remove_feed_search";b:0;s:21:"remove_atom_rdf_feeds";b:0;s:17:"remove_shortlinks";b:0;s:21:"remove_rest_api_links";b:0;s:20:"remove_rsd_wlw_links";b:0;s:19:"remove_oembed_links";b:0;s:16:"remove_generator";b:0;s:20:"remove_emoji_scripts";b:0;s:24:"remove_powered_by_header";b:0;s:22:"remove_pingback_header";b:0;s:28:"clean_campaign_tracking_urls";b:0;s:16:"clean_permalinks";b:0;s:32:"clean_permalinks_extra_variables";s:0:"";s:14:"search_cleanup";b:0;s:20:"search_cleanup_emoji";b:0;s:23:"search_cleanup_patterns";b:0;s:22:"search_character_limit";i:50;s:20:"deny_search_crawling";b:0;s:21:"deny_wp_json_crawling";b:0;s:20:"deny_adsbot_crawling";b:0;s:19:"deny_ccbot_crawling";b:0;s:29:"deny_google_extended_crawling";b:0;s:20:"deny_gptbot_crawling";b:0;s:27:"redirect_search_pretty_urls";b:0;s:29:"least_readability_ignore_list";a:0:{}s:27:"least_seo_score_ignore_list";a:0:{}s:23:"most_linked_ignore_list";a:0:{}s:24:"least_linked_ignore_list";a:0:{}s:28:"indexables_page_reading_list";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:"indexables_overview_state";s:21:"dashboard-not-visited";s:28:"last_known_public_post_types";a:5:{i:0;s:4:"post";i:1;s:4:"page";i:2;s:14:"e-landing-page";i:3;s:15:"oceanwp_library";i:4;s:12:"elementor-hf";}s:28:"last_known_public_taxonomies";a:3:{i:0;s:8:"category";i:1;s:8:"post_tag";i:2;s:11:"post_format";}s:23:"last_known_no_unindexed";a:1:{s:40:"wpseo_total_unindexed_post_type_archives";i:1719268335;}s:14:"new_post_types";a:0:{}s:14:"new_taxonomies";a:0:{}s:34:"show_new_content_type_notification";b:0;}','yes');
INSERT INTO `wp_options` VALUES (594,'wpseo_titles','a:173:{s:17:"forcerewritetitle";b:0;s:9:"separator";s:7:"sc-dash";s:16:"title-home-wpseo";s:42:"%%sitename%% %%page%% %%sep%% %%sitedesc%%";s:18:"title-author-wpseo";s:50:"%%name%%, auteur/autrice sur %%sitename%% %%page%%";s:19:"title-archive-wpseo";s:38:"%%date%% %%page%% %%sep%% %%sitename%%";s:18:"title-search-wpseo";s:65:"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%";s:15:"title-404-wpseo";s:38:"Page non trouvée %%sep%% %%sitename%%";s:25:"social-title-author-wpseo";s:8:"%%name%%";s:26:"social-title-archive-wpseo";s:8:"%%date%%";s:31:"social-description-author-wpseo";s:0:"";s:32:"social-description-archive-wpseo";s:0:"";s:29:"social-image-url-author-wpseo";s:0:"";s:30:"social-image-url-archive-wpseo";s:0:"";s:28:"social-image-id-author-wpseo";i:0;s:29:"social-image-id-archive-wpseo";i:0;s:19:"metadesc-home-wpseo";s:0:"";s:21:"metadesc-author-wpseo";s:0:"";s:22:"metadesc-archive-wpseo";s:0:"";s:9:"rssbefore";s:0:"";s:8:"rssafter";s:64:"L’article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.";s:20:"noindex-author-wpseo";b:0;s:28:"noindex-author-noposts-wpseo";b:1;s:21:"noindex-archive-wpseo";b:1;s:14:"disable-author";b:0;s:12:"disable-date";b:0;s:19:"disable-post_format";b:0;s:18:"disable-attachment";b:1;s:20:"breadcrumbs-404crumb";s:30:"Erreur 404 : Page introuvable";s:29:"breadcrumbs-display-blog-page";b:1;s:20:"breadcrumbs-boldlast";b:0;s:25:"breadcrumbs-archiveprefix";s:13:"Archives pour";s:18:"breadcrumbs-enable";b:1;s:16:"breadcrumbs-home";s:7:"Accueil";s:18:"breadcrumbs-prefix";s:0:"";s:24:"breadcrumbs-searchprefix";s:18:"Vous avez cherché";s:15:"breadcrumbs-sep";s:2:"»";s:12:"website_name";s:18:"Ferme de Chassagne";s:11:"person_name";s:0:"";s:11:"person_logo";s:0:"";s:22:"alternate_website_name";s:0:"";s:12:"company_logo";s:0:"";s:12:"company_name";s:18:"Ferme de Chassagne";s:22:"company_alternate_name";s:0:"";s:17:"company_or_person";s:7:"company";s:25:"company_or_person_user_id";i:0;s:17:"stripcategorybase";b:0;s:26:"open_graph_frontpage_title";s:12:"%%sitename%%";s:25:"open_graph_frontpage_desc";s:0:"";s:26:"open_graph_frontpage_image";s:0:"";s:24:"publishing_principles_id";i:0;s:25:"ownership_funding_info_id";i:0;s:29:"actionable_feedback_policy_id";i:0;s:21:"corrections_policy_id";i:0;s:16:"ethics_policy_id";i:0;s:19:"diversity_policy_id";i:0;s:28:"diversity_staffing_report_id";i:0;s:15:"org-description";s:0:"";s:9:"org-email";s:0:"";s:9:"org-phone";s:0:"";s:14:"org-legal-name";s:0:"";s:17:"org-founding-date";s:0:"";s:20:"org-number-employees";s:0:"";s:10:"org-vat-id";s:0:"";s:10:"org-tax-id";s:0:"";s:7:"org-iso";s:0:"";s:8:"org-duns";s:0:"";s:11:"org-leicode";s:0:"";s:9:"org-naics";s:0:"";s:10:"title-post";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:13:"metadesc-post";s:0:"";s:12:"noindex-post";b:0;s:23:"display-metabox-pt-post";b:1;s:23:"post_types-post-maintax";i:0;s:21:"schema-page-type-post";s:7:"WebPage";s:24:"schema-article-type-post";s:7:"Article";s:17:"social-title-post";s:9:"%%title%%";s:23:"social-description-post";s:0:"";s:21:"social-image-url-post";s:0:"";s:20:"social-image-id-post";i:0;s:10:"title-page";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:13:"metadesc-page";s:0:"";s:12:"noindex-page";b:0;s:23:"display-metabox-pt-page";b:1;s:23:"post_types-page-maintax";i:0;s:21:"schema-page-type-page";s:7:"WebPage";s:24:"schema-article-type-page";s:4:"None";s:17:"social-title-page";s:9:"%%title%%";s:23:"social-description-page";s:0:"";s:21:"social-image-url-page";s:0:"";s:20:"social-image-id-page";i:0;s:16:"title-attachment";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:19:"metadesc-attachment";s:0:"";s:18:"noindex-attachment";b:0;s:29:"display-metabox-pt-attachment";b:1;s:29:"post_types-attachment-maintax";i:0;s:27:"schema-page-type-attachment";s:7:"WebPage";s:30:"schema-article-type-attachment";s:4:"None";s:18:"title-tax-category";s:57:"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%";s:21:"metadesc-tax-category";s:0:"";s:28:"display-metabox-tax-category";b:1;s:20:"noindex-tax-category";b:0;s:25:"social-title-tax-category";s:27:"Archives des %%term_title%%";s:31:"social-description-tax-category";s:0:"";s:29:"social-image-url-tax-category";s:0:"";s:28:"social-image-id-tax-category";i:0;s:26:"taxonomy-category-ptparent";i:0;s:18:"title-tax-post_tag";s:57:"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%";s:21:"metadesc-tax-post_tag";s:0:"";s:28:"display-metabox-tax-post_tag";b:1;s:20:"noindex-tax-post_tag";b:0;s:25:"social-title-tax-post_tag";s:27:"Archives des %%term_title%%";s:31:"social-description-tax-post_tag";s:0:"";s:29:"social-image-url-tax-post_tag";s:0:"";s:28:"social-image-id-tax-post_tag";i:0;s:26:"taxonomy-post_tag-ptparent";i:0;s:21:"title-tax-post_format";s:57:"Archives des %%term_title%% %%page%% %%sep%% %%sitename%%";s:24:"metadesc-tax-post_format";s:0:"";s:31:"display-metabox-tax-post_format";b:1;s:23:"noindex-tax-post_format";b:1;s:28:"social-title-tax-post_format";s:27:"Archives des %%term_title%%";s:34:"social-description-tax-post_format";s:0:"";s:32:"social-image-url-tax-post_format";s:0:"";s:31:"social-image-id-tax-post_format";i:0;s:29:"taxonomy-post_format-ptparent";i:0;s:20:"title-e-landing-page";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:23:"metadesc-e-landing-page";s:0:"";s:22:"noindex-e-landing-page";b:0;s:33:"display-metabox-pt-e-landing-page";b:1;s:33:"post_types-e-landing-page-maintax";i:0;s:31:"schema-page-type-e-landing-page";s:7:"WebPage";s:34:"schema-article-type-e-landing-page";s:4:"None";s:27:"social-title-e-landing-page";s:9:"%%title%%";s:33:"social-description-e-landing-page";s:0:"";s:31:"social-image-url-e-landing-page";s:0:"";s:30:"social-image-id-e-landing-page";i:0;s:23:"title-elementor_library";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:26:"metadesc-elementor_library";s:0:"";s:25:"noindex-elementor_library";b:0;s:36:"display-metabox-pt-elementor_library";b:1;s:36:"post_types-elementor_library-maintax";i:0;s:34:"schema-page-type-elementor_library";s:7:"WebPage";s:37:"schema-article-type-elementor_library";s:4:"None";s:30:"social-title-elementor_library";s:9:"%%title%%";s:36:"social-description-elementor_library";s:0:"";s:34:"social-image-url-elementor_library";s:0:"";s:33:"social-image-id-elementor_library";i:0;s:21:"title-oceanwp_library";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:24:"metadesc-oceanwp_library";s:0:"";s:23:"noindex-oceanwp_library";b:0;s:34:"display-metabox-pt-oceanwp_library";b:1;s:34:"post_types-oceanwp_library-maintax";i:0;s:32:"schema-page-type-oceanwp_library";s:7:"WebPage";s:35:"schema-article-type-oceanwp_library";s:4:"None";s:28:"social-title-oceanwp_library";s:9:"%%title%%";s:34:"social-description-oceanwp_library";s:0:"";s:32:"social-image-url-oceanwp_library";s:0:"";s:31:"social-image-id-oceanwp_library";i:0;s:18:"title-elementor-hf";s:39:"%%title%% %%page%% %%sep%% %%sitename%%";s:21:"metadesc-elementor-hf";s:0:"";s:20:"noindex-elementor-hf";b:0;s:31:"display-metabox-pt-elementor-hf";b:1;s:31:"post_types-elementor-hf-maintax";i:0;s:29:"schema-page-type-elementor-hf";s:7:"WebPage";s:32:"schema-article-type-elementor-hf";s:4:"None";s:25:"social-title-elementor-hf";s:9:"%%title%%";s:31:"social-description-elementor-hf";s:0:"";s:29:"social-image-url-elementor-hf";s:0:"";s:28:"social-image-id-elementor-hf";i:0;s:14:"person_logo_id";i:0;s:15:"company_logo_id";i:0;s:17:"company_logo_meta";b:0;s:16:"person_logo_meta";b:0;s:29:"open_graph_frontpage_image_id";i:0;}','yes');
INSERT INTO `wp_options` VALUES (595,'wpseo_social','a:20:{s:13:"facebook_site";s:55:"https://www.facebook.com/fermedechassagne/?locale=fr_FR";s:13:"instagram_url";s:0:"";s:12:"linkedin_url";s:0:"";s:11:"myspace_url";s:0:"";s:16:"og_default_image";s:0:"";s:19:"og_default_image_id";s:0:"";s:18:"og_frontpage_title";s:0:"";s:17:"og_frontpage_desc";s:0:"";s:18:"og_frontpage_image";s:0:"";s:21:"og_frontpage_image_id";s:0:"";s:9:"opengraph";b:1;s:13:"pinterest_url";s:0:"";s:15:"pinterestverify";s:0:"";s:7:"twitter";b:1;s:12:"twitter_site";s:0:"";s:17:"twitter_card_type";s:19:"summary_large_image";s:11:"youtube_url";s:0:"";s:13:"wikipedia_url";s:0:"";s:17:"other_social_urls";a:2:{i:0;s:53:"https://www.instagram.com/ferme_de_chassagne/?ref=159";i:1;s:78:"https://www.linkedin.com/company/les-fermes-de-chassagne/?originalSubdomain=fr";}s:12:"mastodon_url";s:0:"";}','yes');
INSERT INTO `wp_options` VALUES (603,'updraft_updraftvault','a:2:{s:7:"version";i:1;s:8:"settings";a:1:{s:34:"s-0ecc8c4212c0031d0cd43863234a5559";a:3:{s:5:"token";s:0:"";s:5:"email";s:0:"";s:5:"quota";i:-1;}}}','yes');
INSERT INTO `wp_options` VALUES (604,'updraft_dropbox','a:2:{s:7:"version";i:1;s:8:"settings";a:1:{s:34:"s-727307f31718ceb3bbba4c72586e5928";a:4:{s:6:"appkey";s:0:"";s:6:"secret";s:0:"";s:6:"folder";s:0:"";s:15:"tk_access_token";s:0:"";}}}','yes');
INSERT INTO `wp_options` VALUES (605,'updraft_s3','a:2:{s:7:"version";s:1:"1";s:8:"settings";a:1:{s:34:"s-a2187ed776dffa2128e022810bfc2059";a:3:{s:9:"accesskey";s:0:"";s:9:"secretkey";s:0:"";s:4:"path";s:0:"";}}}','yes');
INSERT INTO `wp_options` VALUES (606,'updraft_cloudfiles','a:2:{s:7:"version";s:1:"1";s:8:"settings";a:1:{s:34:"s-cb4cb4384dcf086e1581c3e02a22c10f";a:5:{s:7:"authurl";s:35:"https://auth.api.rackspacecloud.com";s:6:"region";s:3:"DFW";s:4:"user";s:0:"";s:6:"apikey";s:0:"";s:4:"path";s:0:"";}}}','yes');
INSERT INTO `wp_options` VALUES (607,'updraft_googledrive','a:2:{s:7:"version";i:1;s:8:"settings";a:1:{s:34:"s-063a6c70d50d8864c0585cc06285388d";a:9:{s:8:"clientid";s:0:"";s:6:"secret";s:0:"";s:5:"token";s:0:"";s:6:"folder";s:11:"UpdraftPlus";s:7:"user_id";s:64:"1ab8df3c4745cfec2ad95a538e693238773adba34b8e0e0e5a7cb9a4d1f0762b";s:16:"tmp_access_token";a:4:{s:12:"access_token";s:218:"ya29.a0AXooCgsmGMxWLOPLExYCb0jhLtVNOER4xFuJxpdY3EcL8xZ3OMC0bBxr4T16pufa_JvGOEcAUdMN4a2jeIStQ91Fx5KH2fLL8GrdrwtsCBjVekh22tXhkj6czJ_YMtQzCTzPYU1qeFoihdLacKXPK5SzmTSV78-TjT33aCgYKATQSARMSFQHGX2MiLKnOpkZ7juSjzwe_ZVcXGQ0171";s:7:"created";i:1719564202;s:10:"expires_in";i:3599;s:13:"refresh_token";s:0:"";}s:9:"ownername";s:7:"Mathias";s:10:"owneremail";s:28:"mathias.canrobert@outlook.fr";s:10:"expires_in";i:1719567771;}}}','yes');
INSERT INTO `wp_options` VALUES (608,'updraft_onedrive','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (609,'updraft_ftp','a:2:{s:7:"version";s:1:"1";s:8:"settings";a:1:{s:34:"s-11ead82782783009f970479ded79caae";a:5:{s:4:"host";s:0:"";s:4:"user";s:0:"";s:4:"pass";s:0:"";s:4:"path";s:0:"";s:7:"passive";s:1:"1";}}}','yes');
INSERT INTO `wp_options` VALUES (610,'updraft_azure','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (611,'updraft_sftp','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (612,'updraft_googlecloud','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (613,'updraft_backblaze','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (614,'updraft_webdav','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (615,'updraft_s3generic','a:2:{s:7:"version";s:1:"1";s:8:"settings";a:1:{s:34:"s-e993cb02d1b82ee9c4e6ef5fea544f38";a:6:{s:9:"accesskey";s:0:"";s:9:"secretkey";s:0:"";s:4:"path";s:0:"";s:8:"endpoint";s:0:"";s:19:"bucket_access_style";s:10:"path_style";s:17:"signature_version";s:2:"v4";}}}','yes');
INSERT INTO `wp_options` VALUES (616,'updraft_pcloud','a:1:{s:7:"version";s:1:"1";}','yes');
INSERT INTO `wp_options` VALUES (617,'updraft_openstack','a:2:{s:7:"version";s:1:"1";s:8:"settings";a:1:{s:34:"s-98c3a4f0f541788ef61c26bdd3de543b";a:6:{s:7:"authurl";s:0:"";s:6:"tenant";s:0:"";s:6:"region";s:0:"";s:4:"user";s:0:"";s:8:"password";s:0:"";s:4:"path";s:0:"";}}}','yes');
INSERT INTO `wp_options` VALUES (618,'updraft_dreamobjects','a:2:{s:7:"version";s:1:"1";s:8:"settings";a:1:{s:34:"s-eb8d0df0c00531a11d648a53e913efef";a:4:{s:9:"accesskey";s:0:"";s:9:"secretkey";s:0:"";s:4:"path";s:0:"";s:8:"endpoint";s:26:"objects-us-east-1.dream.io";}}}','yes');
INSERT INTO `wp_options` VALUES (619,'updraftplus-addons_siteid','9b7a3892a02ad01c2ae788c3d9d4f9d5','no');
INSERT INTO `wp_options` VALUES (620,'updraft_retain_extrarules','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (621,'updraft_email','','yes');
INSERT INTO `wp_options` VALUES (622,'updraft_report_warningsonly','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (623,'updraft_report_wholebackup','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (624,'updraft_extradbs','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (625,'updraft_include_more_path','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (626,'auto_update_plugins','a:0:{}','no');
INSERT INTO `wp_options` VALUES (627,'updraft_interval','monthly','yes');
INSERT INTO `wp_options` VALUES (628,'updraft_retain','1','yes');
INSERT INTO `wp_options` VALUES (631,'updraft_interval_database','monthly','yes');
INSERT INTO `wp_options` VALUES (632,'updraft_retain_db','1','yes');
INSERT INTO `wp_options` VALUES (633,'updraft_include_plugins','1','yes');
INSERT INTO `wp_options` VALUES (634,'updraft_include_themes','1','yes');
INSERT INTO `wp_options` VALUES (635,'updraft_include_uploads','1','yes');
INSERT INTO `wp_options` VALUES (636,'updraft_include_uploads_exclude','backup*,*backups,backwpup*,wp-clone,snapshots','yes');
INSERT INTO `wp_options` VALUES (637,'updraft_include_mu-plugins','1','yes');
INSERT INTO `wp_options` VALUES (638,'updraft_include_others','1','yes');
INSERT INTO `wp_options` VALUES (639,'updraft_include_others_exclude','upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log','yes');
INSERT INTO `wp_options` VALUES (640,'updraft_split_every','400','yes');
INSERT INTO `wp_options` VALUES (641,'updraft_delete_local','1','yes');
INSERT INTO `wp_options` VALUES (642,'updraft_dir','updraft','yes');
INSERT INTO `wp_options` VALUES (643,'updraft_service','','yes');
INSERT INTO `wp_options` VALUES (644,'updraft_debug_mode','0','yes');
INSERT INTO `wp_options` VALUES (645,'updraft_ssl_useservercerts','0','yes');
INSERT INTO `wp_options` VALUES (646,'updraft_ssl_disableverify','0','yes');
INSERT INTO `wp_options` VALUES (647,'updraft_ssl_nossl','0','yes');
INSERT INTO `wp_options` VALUES (649,'updraft_lastmessage','La sauvegarde a réussi et est maintenant terminée (Juil 29 17:07:55)','on');
INSERT INTO `wp_options` VALUES (650,'updraftplus_unlocked_fd','1','no');
INSERT INTO `wp_options` VALUES (651,'updraftplus_last_lock_time_fd','2024-07-29 17:05:56','no');
INSERT INTO `wp_options` VALUES (652,'updraftplus_semaphore_fd','0','no');
INSERT INTO `wp_options` VALUES (653,'updraft_last_scheduled_fd','1722272756','yes');
INSERT INTO `wp_options` VALUES (656,'dismissed_general_notices_until','1726523129','yes');
INSERT INTO `wp_options` VALUES (657,'updraft_backup_history','a:1:{i:1722272756;a:22:{s:7:"plugins";a:1:{i:0;s:68:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-plugins.zip";}s:12:"plugins-size";i:36468926;s:6:"themes";a:1:{i:0;s:67:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-themes.zip";}s:11:"themes-size";i:9185941;s:7:"uploads";a:2:{i:0;s:68:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-uploads.zip";i:1;s:69:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-uploads2.zip";}s:12:"uploads-size";i:407165564;s:13:"uploads1-size";i:229018343;s:10:"mu-plugins";a:1:{i:0;s:71:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-mu-plugins.zip";}s:15:"mu-plugins-size";i:120;s:6:"others";a:1:{i:0;s:67:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-others.zip";}s:11:"others-size";i:2482232;s:2:"db";s:62:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-db.gz";s:7:"db-size";i:1137184;s:9:"checksums";a:2:{s:4:"sha1";a:7:{s:8:"plugins0";s:40:"5968bc7a14190027c32140cc84e5cfec2b67efb6";s:7:"themes0";s:40:"d68916ba4c93600bd89ce31f4dae360f6eeb1093";s:8:"uploads0";s:40:"0737e4dcb94f4250ffa76d26bf8485e24dcb4622";s:8:"uploads1";s:40:"521e32d0da345f4dd6945af9340658e8a299f651";s:11:"mu-plugins0";s:40:"3322c4823a3729dcdfe0b8c9dea05ee1d81ac2f9";s:7:"others0";s:40:"cdbc0d19fd94fa6b7e1ab57f47656496c4b07019";s:3:"db0";s:40:"bdae335276b668bf22890c89d87e64da38e55f8a";}s:6:"sha256";a:7:{s:8:"plugins0";s:64:"3122a5434bb9f9a06e8c61ce7fba7e5cab4bb15717cdf4a4bbd5c1777e71a3a3";s:7:"themes0";s:64:"ccb26f7fa996f47ce724a9cd06e1c10713df96d19d7212553376419a8485e32e";s:8:"uploads0";s:64:"1dcd76f5fa8c0ec5d3ad0958202b4f990a912accbfc9eb44febe3836cf517f0b";s:8:"uploads1";s:64:"b12d2199ffad9a5395f7fd08cf1bce2a9ecbc59e11f0bb1f79af902014d2431f";s:11:"mu-plugins0";s:64:"76a0d333c459148957af2bbaa0ec309ef9dba2ffc7f7e47597db6f9198f88e02";s:7:"others0";s:64:"da645382b0564befc7b172e8e9ef738fabd40c0a35f13d9d1b532db87b176999";s:3:"db0";s:64:"627910179cd1fe583c66d1b470fd1f495081f2b8b7df7eebb374de6ddd12a7df";}}s:5:"nonce";s:12:"a73dd38a73a8";s:7:"service";a:0:{}s:20:"service_instance_ids";a:0:{}s:11:"always_keep";b:0;s:19:"files_enumerated_at";a:5:{s:7:"plugins";i:1722272756;s:6:"themes";i:1722272850;s:7:"uploads";i:1722272863;s:10:"mu-plugins";i:1722272872;s:6:"others";i:1722272872;}s:18:"created_by_version";s:6:"1.24.4";s:21:"last_saved_by_version";s:6:"1.24.4";s:12:"is_multisite";b:0;}}','off');
INSERT INTO `wp_options` VALUES (658,'updraft_last_backup','a:6:{s:26:"nonincremental_backup_time";i:1722272756;s:11:"backup_time";i:1722272756;s:12:"backup_array";a:14:{s:7:"plugins";a:1:{i:0;s:68:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-plugins.zip";}s:12:"plugins-size";i:36468926;s:6:"themes";a:1:{i:0;s:67:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-themes.zip";}s:11:"themes-size";i:9185941;s:7:"uploads";a:2:{i:0;s:68:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-uploads.zip";i:1;s:69:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-uploads2.zip";}s:12:"uploads-size";i:407165564;s:13:"uploads1-size";i:229018343;s:10:"mu-plugins";a:1:{i:0;s:71:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-mu-plugins.zip";}s:15:"mu-plugins-size";i:120;s:6:"others";a:1:{i:0;s:67:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-others.zip";}s:11:"others-size";i:2482232;s:2:"db";s:62:"backup_2024-07-29-1705_Camping_de_Chassagne_a73dd38a73a8-db.gz";s:7:"db-size";i:1137184;s:9:"checksums";a:2:{s:4:"sha1";a:7:{s:8:"plugins0";s:40:"5968bc7a14190027c32140cc84e5cfec2b67efb6";s:7:"themes0";s:40:"d68916ba4c93600bd89ce31f4dae360f6eeb1093";s:8:"uploads0";s:40:"0737e4dcb94f4250ffa76d26bf8485e24dcb4622";s:8:"uploads1";s:40:"521e32d0da345f4dd6945af9340658e8a299f651";s:11:"mu-plugins0";s:40:"3322c4823a3729dcdfe0b8c9dea05ee1d81ac2f9";s:7:"others0";s:40:"cdbc0d19fd94fa6b7e1ab57f47656496c4b07019";s:3:"db0";s:40:"bdae335276b668bf22890c89d87e64da38e55f8a";}s:6:"sha256";a:7:{s:8:"plugins0";s:64:"3122a5434bb9f9a06e8c61ce7fba7e5cab4bb15717cdf4a4bbd5c1777e71a3a3";s:7:"themes0";s:64:"ccb26f7fa996f47ce724a9cd06e1c10713df96d19d7212553376419a8485e32e";s:8:"uploads0";s:64:"1dcd76f5fa8c0ec5d3ad0958202b4f990a912accbfc9eb44febe3836cf517f0b";s:8:"uploads1";s:64:"b12d2199ffad9a5395f7fd08cf1bce2a9ecbc59e11f0bb1f79af902014d2431f";s:11:"mu-plugins0";s:64:"76a0d333c459148957af2bbaa0ec309ef9dba2ffc7f7e47597db6f9198f88e02";s:7:"others0";s:64:"da645382b0564befc7b172e8e9ef738fabd40c0a35f13d9d1b532db87b176999";s:3:"db0";s:64:"627910179cd1fe583c66d1b470fd1f495081f2b8b7df7eebb374de6ddd12a7df";}}}s:7:"success";i:1;s:6:"errors";a:0:{}s:12:"backup_nonce";s:12:"a73dd38a73a8";}','on');
INSERT INTO `wp_options` VALUES (679,'_transient_cky_banners_transient_prefix','0.25815200 1719266084','yes');
INSERT INTO `wp_options` VALUES (680,'cky_missing_tables','a:0:{}','yes');
INSERT INTO `wp_options` VALUES (682,'wt_cli_version','3.2.4','yes');
INSERT INTO `wp_options` VALUES (683,'cky_cookie_consent_lite_db_version','3.2.4','yes');
INSERT INTO `wp_options` VALUES (684,'cky_banner_template','a:1:{s:2:"en";a:2:{s:4:"html";s:9553:"<div class="cky-overlay cky-hide"></div><div class="cky-btn-revisit-wrapper cky-revisit-hide" data-cky-tag="revisit-consent" data-tooltip="Consent Preferences" style="background-color:#0056a7"> <button class="cky-btn-revisit" aria-label="Consent Preferences"> <img src="http://ferme-de-chassagne.local/wp-content/plugins/cookie-law-info/lite/frontend/images/revisit.svg" alt="Revisit consent button"> </button></div><div class="cky-consent-container cky-hide" tabindex="0"> <div class="cky-consent-bar" data-cky-tag="notice" style="background-color:#FFFFFF;border-color:#f4f4f4;color:#212121">  <div class="cky-notice"> <p class="cky-title" role="heading" aria-level="1" data-cky-tag="title" style="color:#212121">We value your privacy</p><div class="cky-notice-group"> <div class="cky-notice-des" data-cky-tag="description" style="color:#212121"> <p>We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking "Accept All", you consent to our use of cookies.</p> </div><div class="cky-notice-btn-wrapper" data-cky-tag="notice-buttons"> <button class="cky-btn cky-btn-customize" aria-label="Customize" data-cky-tag="settings-button" style="color:#1863dc;background-color:transparent;border-color:#1863dc">Customize</button> <button class="cky-btn cky-btn-reject" aria-label="Reject All" data-cky-tag="reject-button" style="color:#1863dc;background-color:transparent;border-color:#1863dc">Reject All</button> <button class="cky-btn cky-btn-accept" aria-label="Accept All" data-cky-tag="accept-button" style="color:#FFFFFF;background-color:#1863dc;border-color:#1863dc">Accept All</button>  </div></div></div></div></div><div class="cky-modal" tabindex="0"> <div class="cky-preference-center" data-cky-tag="detail" style="color:#212121;background-color:#FFFFFF;border-color:#F4F4F4"> <div class="cky-preference-header"> <span class="cky-preference-title" role="heading" aria-level="1" data-cky-tag="detail-title" style="color:#212121">Customize Consent Preferences</span> <button class="cky-btn-close" aria-label="[cky_preference_close_label]" data-cky-tag="detail-close"> <img src="http://ferme-de-chassagne.local/wp-content/plugins/cookie-law-info/lite/frontend/images/close.svg" alt="Close"> </button> </div><div class="cky-preference-body-wrapper"> <div class="cky-preference-content-wrapper" data-cky-tag="detail-description" style="color:#212121"> <p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.</p><p>The cookies that are categorized as "Necessary" are stored on your browser as they are essential for enabling the basic functionalities of the site. </p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.</p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.</p> </div><div class="cky-accordion-wrapper" data-cky-tag="detail-categories"> <div class="cky-accordion" id="ckyDetailCategorynecessary"> <div class="cky-accordion-item"> <div class="cky-accordion-chevron"><i class="cky-chevron-right"></i></div> <div class="cky-accordion-header-wrapper"> <div class="cky-accordion-header"><button class="cky-accordion-btn" aria-label="Necessary" data-cky-tag="detail-category-title" style="color:#212121">Necessary</button><span class="cky-always-active">Always Active</span> <div class="cky-switch" data-cky-tag="detail-category-toggle"><input type="checkbox" id="ckySwitchnecessary"></div> </div> <div class="cky-accordion-header-des" data-cky-tag="detail-category-description" style="color:#212121"> <p>Necessary cookies are required to enable the basic features of this site, such as providing secure log-in or adjusting your consent preferences. These cookies do not store any personally identifiable data.</p></div> </div> </div> <div class="cky-accordion-body"> <div class="cky-audit-table" data-cky-tag="audit-table" style="color:#212121;background-color:#f4f4f4;border-color:#ebebeb"><p class="cky-empty-cookies-text">No cookies to display.</p></div> </div> </div><div class="cky-accordion" id="ckyDetailCategoryfunctional"> <div class="cky-accordion-item"> <div class="cky-accordion-chevron"><i class="cky-chevron-right"></i></div> <div class="cky-accordion-header-wrapper"> <div class="cky-accordion-header"><button class="cky-accordion-btn" aria-label="Functional" data-cky-tag="detail-category-title" style="color:#212121">Functional</button><span class="cky-always-active">Always Active</span> <div class="cky-switch" data-cky-tag="detail-category-toggle"><input type="checkbox" id="ckySwitchfunctional"></div> </div> <div class="cky-accordion-header-des" data-cky-tag="detail-category-description" style="color:#212121"> <p>Functional cookies help perform certain functionalities like sharing the content of the website on social media platforms, collecting feedback, and other third-party features.</p></div> </div> </div> <div class="cky-accordion-body"> <div class="cky-audit-table" data-cky-tag="audit-table" style="color:#212121;background-color:#f4f4f4;border-color:#ebebeb"><p class="cky-empty-cookies-text">No cookies to display.</p></div> </div> </div><div class="cky-accordion" id="ckyDetailCategoryanalytics"> <div class="cky-accordion-item"> <div class="cky-accordion-chevron"><i class="cky-chevron-right"></i></div> <div class="cky-accordion-header-wrapper"> <div class="cky-accordion-header"><button class="cky-accordion-btn" aria-label="Analytics" data-cky-tag="detail-category-title" style="color:#212121">Analytics</button><span class="cky-always-active">Always Active</span> <div class="cky-switch" data-cky-tag="detail-category-toggle"><input type="checkbox" id="ckySwitchanalytics"></div> </div> <div class="cky-accordion-header-des" data-cky-tag="detail-category-description" style="color:#212121"> <p>Analytical cookies are used to understand how visitors interact with the website. These cookies help provide information on metrics such as the number of visitors, bounce rate, traffic source, etc.</p></div> </div> </div> <div class="cky-accordion-body"> <div class="cky-audit-table" data-cky-tag="audit-table" style="color:#212121;background-color:#f4f4f4;border-color:#ebebeb"><p class="cky-empty-cookies-text">No cookies to display.</p></div> </div> </div><div class="cky-accordion" id="ckyDetailCategoryperformance"> <div class="cky-accordion-item"> <div class="cky-accordion-chevron"><i class="cky-chevron-right"></i></div> <div class="cky-accordion-header-wrapper"> <div class="cky-accordion-header"><button class="cky-accordion-btn" aria-label="Performance" data-cky-tag="detail-category-title" style="color:#212121">Performance</button><span class="cky-always-active">Always Active</span> <div class="cky-switch" data-cky-tag="detail-category-toggle"><input type="checkbox" id="ckySwitchperformance"></div> </div> <div class="cky-accordion-header-des" data-cky-tag="detail-category-description" style="color:#212121"> <p>Performance cookies are used to understand and analyze the key performance indexes of the website which helps in delivering a better user experience for the visitors.</p></div> </div> </div> <div class="cky-accordion-body"> <div class="cky-audit-table" data-cky-tag="audit-table" style="color:#212121;background-color:#f4f4f4;border-color:#ebebeb"><p class="cky-empty-cookies-text">No cookies to display.</p></div> </div> </div><div class="cky-accordion" id="ckyDetailCategoryadvertisement"> <div class="cky-accordion-item"> <div class="cky-accordion-chevron"><i class="cky-chevron-right"></i></div> <div class="cky-accordion-header-wrapper"> <div class="cky-accordion-header"><button class="cky-accordion-btn" aria-label="Advertisement" data-cky-tag="detail-category-title" style="color:#212121">Advertisement</button><span class="cky-always-active">Always Active</span> <div class="cky-switch" data-cky-tag="detail-category-toggle"><input type="checkbox" id="ckySwitchadvertisement"></div> </div> <div class="cky-accordion-header-des" data-cky-tag="detail-category-description" style="color:#212121"> <p>Advertisement cookies are used to provide visitors with customized advertisements based on the pages you visited previously and to analyze the effectiveness of the ad campaigns.</p></div> </div> </div> <div class="cky-accordion-body"> <div class="cky-audit-table" data-cky-tag="audit-table" style="color:#212121;background-color:#f4f4f4;border-color:#ebebeb"><p class="cky-empty-cookies-text">No cookies to display.</p></div> </div> </div> </div></div><div class="cky-footer-wrapper"> <span class="cky-footer-shadow"></span> <div class="cky-prefrence-btn-wrapper" data-cky-tag="detail-buttons"> <button class="cky-btn cky-btn-reject" aria-label="Reject All" data-cky-tag="detail-reject-button" style="color:#1863dc;background-color:transparent;border-color:#1863dc"> Reject All </button> <button class="cky-btn cky-btn-preferences" aria-label="Save My Preferences" data-cky-tag="detail-save-button" style="color:#1863dc;background-color:transparent;border-color:#1863dc"> Save My Preferences </button> <button class="cky-btn cky-btn-accept" aria-label="Accept All" data-cky-tag="detail-accept-button" style="color:#ffffff;background-color:#1863dc;border-color:#1863dc"> Accept All </button> </div></div></div></div>";s:6:"styles";s:19870:".cky-overlay{background: #000000; opacity: 0.4; position: fixed; top: 0; left: 0; width: 100%; height: 100%; z-index: 99999999;}.cky-hide{display: none;}.cky-btn-revisit-wrapper{display: flex; align-items: center; justify-content: center; background: #0056a7; width: 45px; height: 45px; border-radius: 50%; position: fixed; z-index: 999999; cursor: pointer;}.cky-revisit-bottom-left{bottom: 15px; left: 15px;}.cky-revisit-bottom-right{bottom: 15px; right: 15px;}.cky-btn-revisit-wrapper .cky-btn-revisit{display: flex; align-items: center; justify-content: center; background: none; border: none; cursor: pointer; position: relative; margin: 0; padding: 0;}.cky-btn-revisit-wrapper .cky-btn-revisit img{max-width: fit-content; margin: 0; height: 30px; width: 30px;}.cky-revisit-bottom-left:hover::before{content: attr(data-tooltip); position: absolute; background: #4e4b66; color: #ffffff; left: calc(100% + 7px); font-size: 12px; line-height: 16px; width: max-content; padding: 4px 8px; border-radius: 4px;}.cky-revisit-bottom-left:hover::after{position: absolute; content: ""; border: 5px solid transparent; left: calc(100% + 2px); border-left-width: 0; border-right-color: #4e4b66;}.cky-revisit-bottom-right:hover::before{content: attr(data-tooltip); position: absolute; background: #4e4b66; color: #ffffff; right: calc(100% + 7px); font-size: 12px; line-height: 16px; width: max-content; padding: 4px 8px; border-radius: 4px;}.cky-revisit-bottom-right:hover::after{position: absolute; content: ""; border: 5px solid transparent; right: calc(100% + 2px); border-right-width: 0; border-left-color: #4e4b66;}.cky-revisit-hide{display: none;}.cky-consent-container{position: fixed; width: 440px; box-sizing: border-box; z-index: 9999999; border-radius: 6px;}.cky-consent-container .cky-consent-bar{background: #ffffff; border: 1px solid; padding: 20px 26px; box-shadow: 0 -1px 10px 0 #acabab4d; border-radius: 6px;}.cky-box-bottom-left{bottom: 40px; left: 40px;}.cky-box-bottom-right{bottom: 40px; right: 40px;}.cky-box-top-left{top: 40px; left: 40px;}.cky-box-top-right{top: 40px; right: 40px;}.cky-custom-brand-logo-wrapper .cky-custom-brand-logo{width: 100px; height: auto; margin: 0 0 12px 0;}.cky-notice .cky-title{color: #212121; font-weight: 700; font-size: 18px; line-height: 24px; margin: 0 0 12px 0;}.cky-notice-des *,.cky-preference-content-wrapper *,.cky-accordion-header-des *,.cky-gpc-wrapper .cky-gpc-desc *{font-size: 14px;}.cky-notice-des{color: #212121; font-size: 14px; line-height: 24px; font-weight: 400;}.cky-notice-des img{height: 25px; width: 25px;}.cky-consent-bar .cky-notice-des p,.cky-gpc-wrapper .cky-gpc-desc p,.cky-preference-body-wrapper .cky-preference-content-wrapper p,.cky-accordion-header-wrapper .cky-accordion-header-des p,.cky-cookie-des-table li div:last-child p{color: inherit; margin-top: 0; overflow-wrap: break-word;}.cky-notice-des P:last-child,.cky-preference-content-wrapper p:last-child,.cky-cookie-des-table li div:last-child p:last-child,.cky-gpc-wrapper .cky-gpc-desc p:last-child{margin-bottom: 0;}.cky-notice-des a.cky-policy,.cky-notice-des button.cky-policy{font-size: 14px; color: #1863dc; white-space: nowrap; cursor: pointer; background: transparent; border: 1px solid; text-decoration: underline;}.cky-notice-des button.cky-policy{padding: 0;}.cky-notice-des a.cky-policy:focus-visible,.cky-notice-des button.cky-policy:focus-visible,.cky-preference-content-wrapper .cky-show-desc-btn:focus-visible,.cky-accordion-header .cky-accordion-btn:focus-visible,.cky-preference-header .cky-btn-close:focus-visible,.cky-switch input[type="checkbox"]:focus-visible,.cky-footer-wrapper a:focus-visible,.cky-btn:focus-visible{outline: 2px solid #1863dc; outline-offset: 2px;}.cky-btn:focus:not(:focus-visible),.cky-accordion-header .cky-accordion-btn:focus:not(:focus-visible),.cky-preference-content-wrapper .cky-show-desc-btn:focus:not(:focus-visible),.cky-btn-revisit-wrapper .cky-btn-revisit:focus:not(:focus-visible),.cky-preference-header .cky-btn-close:focus:not(:focus-visible),.cky-consent-bar .cky-banner-btn-close:focus:not(:focus-visible){outline: 0;}button.cky-show-desc-btn:not(:hover):not(:active){color: #1863dc; background: transparent;}button.cky-accordion-btn:not(:hover):not(:active),button.cky-banner-btn-close:not(:hover):not(:active),button.cky-btn-revisit:not(:hover):not(:active),button.cky-btn-close:not(:hover):not(:active){background: transparent;}.cky-consent-bar button:hover,.cky-modal.cky-modal-open button:hover,.cky-consent-bar button:focus,.cky-modal.cky-modal-open button:focus{text-decoration: none;}.cky-notice-btn-wrapper{display: flex; justify-content: flex-start; align-items: center; flex-wrap: wrap; margin-top: 16px;}.cky-notice-btn-wrapper .cky-btn{text-shadow: none; box-shadow: none;}.cky-btn{flex: auto; max-width: 100%; font-size: 14px; font-family: inherit; line-height: 24px; padding: 8px; font-weight: 500; margin: 0 8px 0 0; border-radius: 2px; cursor: pointer; text-align: center; text-transform: none; min-height: 0;}.cky-btn:hover{opacity: 0.8;}.cky-btn-customize{color: #1863dc; background: transparent; border: 2px solid #1863dc;}.cky-btn-reject{color: #1863dc; background: transparent; border: 2px solid #1863dc;}.cky-btn-accept{background: #1863dc; color: #ffffff; border: 2px solid #1863dc;}.cky-btn:last-child{margin-right: 0;}@media (max-width: 576px){.cky-box-bottom-left{bottom: 0; left: 0;}.cky-box-bottom-right{bottom: 0; right: 0;}.cky-box-top-left{top: 0; left: 0;}.cky-box-top-right{top: 0; right: 0;}}@media (max-width: 440px){.cky-box-bottom-left, .cky-box-bottom-right, .cky-box-top-left, .cky-box-top-right{width: 100%; max-width: 100%;}.cky-consent-container .cky-consent-bar{padding: 20px 0;}.cky-custom-brand-logo-wrapper, .cky-notice .cky-title, .cky-notice-des, .cky-notice-btn-wrapper{padding: 0 24px;}.cky-notice-des{max-height: 40vh; overflow-y: scroll;}.cky-notice-btn-wrapper{flex-direction: column; margin-top: 0;}.cky-btn{width: 100%; margin: 10px 0 0 0;}.cky-notice-btn-wrapper .cky-btn-customize{order: 2;}.cky-notice-btn-wrapper .cky-btn-reject{order: 3;}.cky-notice-btn-wrapper .cky-btn-accept{order: 1; margin-top: 16px;}}@media (max-width: 352px){.cky-notice .cky-title{font-size: 16px;}.cky-notice-des *{font-size: 12px;}.cky-notice-des, .cky-btn{font-size: 12px;}}.cky-modal.cky-modal-open{display: flex; visibility: visible; -webkit-transform: translate(-50%, -50%); -moz-transform: translate(-50%, -50%); -ms-transform: translate(-50%, -50%); -o-transform: translate(-50%, -50%); transform: translate(-50%, -50%); top: 50%; left: 50%; transition: all 1s ease;}.cky-modal{box-shadow: 0 32px 68px rgba(0, 0, 0, 0.3); margin: 0 auto; position: fixed; max-width: 100%; background: #ffffff; top: 50%; box-sizing: border-box; border-radius: 6px; z-index: 999999999; color: #212121; -webkit-transform: translate(-50%, 100%); -moz-transform: translate(-50%, 100%); -ms-transform: translate(-50%, 100%); -o-transform: translate(-50%, 100%); transform: translate(-50%, 100%); visibility: hidden; transition: all 0s ease;}.cky-preference-center{max-height: 79vh; overflow: hidden; width: 845px; overflow: hidden; flex: 1 1 0; display: flex; flex-direction: column; border-radius: 6px;}.cky-preference-header{display: flex; align-items: center; justify-content: space-between; padding: 22px 24px; border-bottom: 1px solid;}.cky-preference-header .cky-preference-title{font-size: 18px; font-weight: 700; line-height: 24px;}.cky-preference-header .cky-btn-close{margin: 0; cursor: pointer; vertical-align: middle; padding: 0; background: none; border: none; width: auto; height: auto; min-height: 0; line-height: 0; text-shadow: none; box-shadow: none;}.cky-preference-header .cky-btn-close img{margin: 0; height: 10px; width: 10px;}.cky-preference-body-wrapper{padding: 0 24px; flex: 1; overflow: auto; box-sizing: border-box;}.cky-preference-content-wrapper,.cky-gpc-wrapper .cky-gpc-desc{font-size: 14px; line-height: 24px; font-weight: 400; padding: 12px 0;}.cky-preference-content-wrapper{border-bottom: 1px solid;}.cky-preference-content-wrapper img{height: 25px; width: 25px;}.cky-preference-content-wrapper .cky-show-desc-btn{font-size: 14px; font-family: inherit; color: #1863dc; text-decoration: none; line-height: 24px; padding: 0; margin: 0; white-space: nowrap; cursor: pointer; background: transparent; border-color: transparent; text-transform: none; min-height: 0; text-shadow: none; box-shadow: none;}.cky-accordion-wrapper{margin-bottom: 10px;}.cky-accordion{border-bottom: 1px solid;}.cky-accordion:last-child{border-bottom: none;}.cky-accordion .cky-accordion-item{display: flex; margin-top: 10px;}.cky-accordion .cky-accordion-body{display: none;}.cky-accordion.cky-accordion-active .cky-accordion-body{display: block; padding: 0 22px; margin-bottom: 16px;}.cky-accordion-header-wrapper{cursor: pointer; width: 100%;}.cky-accordion-item .cky-accordion-header{display: flex; justify-content: space-between; align-items: center;}.cky-accordion-header .cky-accordion-btn{font-size: 16px; font-family: inherit; color: #212121; line-height: 24px; background: none; border: none; font-weight: 700; padding: 0; margin: 0; cursor: pointer; text-transform: none; min-height: 0; text-shadow: none; box-shadow: none;}.cky-accordion-header .cky-always-active{color: #008000; font-weight: 600; line-height: 24px; font-size: 14px;}.cky-accordion-header-des{font-size: 14px; line-height: 24px; margin: 10px 0 16px 0;}.cky-accordion-chevron{margin-right: 22px; position: relative; cursor: pointer;}.cky-accordion-chevron-hide{display: none;}.cky-accordion .cky-accordion-chevron i::before{content: ""; position: absolute; border-right: 1.4px solid; border-bottom: 1.4px solid; border-color: inherit; height: 6px; width: 6px; -webkit-transform: rotate(-45deg); -moz-transform: rotate(-45deg); -ms-transform: rotate(-45deg); -o-transform: rotate(-45deg); transform: rotate(-45deg); transition: all 0.2s ease-in-out; top: 8px;}.cky-accordion.cky-accordion-active .cky-accordion-chevron i::before{-webkit-transform: rotate(45deg); -moz-transform: rotate(45deg); -ms-transform: rotate(45deg); -o-transform: rotate(45deg); transform: rotate(45deg);}.cky-audit-table{background: #f4f4f4; border-radius: 6px;}.cky-audit-table .cky-empty-cookies-text{color: inherit; font-size: 12px; line-height: 24px; margin: 0; padding: 10px;}.cky-audit-table .cky-cookie-des-table{font-size: 12px; line-height: 24px; font-weight: normal; padding: 15px 10px; border-bottom: 1px solid; border-bottom-color: inherit; margin: 0;}.cky-audit-table .cky-cookie-des-table:last-child{border-bottom: none;}.cky-audit-table .cky-cookie-des-table li{list-style-type: none; display: flex; padding: 3px 0;}.cky-audit-table .cky-cookie-des-table li:first-child{padding-top: 0;}.cky-cookie-des-table li div:first-child{width: 100px; font-weight: 600; word-break: break-word; word-wrap: break-word;}.cky-cookie-des-table li div:last-child{flex: 1; word-break: break-word; word-wrap: break-word; margin-left: 8px;}.cky-footer-shadow{display: block; width: 100%; height: 40px; background: linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, #ffffff 100%); position: absolute; bottom: calc(100% - 1px);}.cky-footer-wrapper{position: relative;}.cky-prefrence-btn-wrapper{display: flex; flex-wrap: wrap; align-items: center; justify-content: center; padding: 22px 24px; border-top: 1px solid;}.cky-prefrence-btn-wrapper .cky-btn{flex: auto; max-width: 100%; text-shadow: none; box-shadow: none;}.cky-btn-preferences{color: #1863dc; background: transparent; border: 2px solid #1863dc;}.cky-preference-header,.cky-preference-body-wrapper,.cky-preference-content-wrapper,.cky-accordion-wrapper,.cky-accordion,.cky-accordion-wrapper,.cky-footer-wrapper,.cky-prefrence-btn-wrapper{border-color: inherit;}@media (max-width: 845px){.cky-modal{max-width: calc(100% - 16px);}}@media (max-width: 576px){.cky-modal{max-width: 100%;}.cky-preference-center{max-height: 100vh;}.cky-prefrence-btn-wrapper{flex-direction: column;}.cky-accordion.cky-accordion-active .cky-accordion-body{padding-right: 0;}.cky-prefrence-btn-wrapper .cky-btn{width: 100%; margin: 10px 0 0 0;}.cky-prefrence-btn-wrapper .cky-btn-reject{order: 3;}.cky-prefrence-btn-wrapper .cky-btn-accept{order: 1; margin-top: 0;}.cky-prefrence-btn-wrapper .cky-btn-preferences{order: 2;}}@media (max-width: 425px){.cky-accordion-chevron{margin-right: 15px;}.cky-notice-btn-wrapper{margin-top: 0;}.cky-accordion.cky-accordion-active .cky-accordion-body{padding: 0 15px;}}@media (max-width: 352px){.cky-preference-header .cky-preference-title{font-size: 16px;}.cky-preference-header{padding: 16px 24px;}.cky-preference-content-wrapper *, .cky-accordion-header-des *{font-size: 12px;}.cky-preference-content-wrapper, .cky-preference-content-wrapper .cky-show-more, .cky-accordion-header .cky-always-active, .cky-accordion-header-des, .cky-preference-content-wrapper .cky-show-desc-btn, .cky-notice-des a.cky-policy{font-size: 12px;}.cky-accordion-header .cky-accordion-btn{font-size: 14px;}}.cky-switch{display: flex;}.cky-switch input[type="checkbox"]{position: relative; width: 44px; height: 24px; margin: 0; background: #d0d5d2; -webkit-appearance: none; border-radius: 50px; cursor: pointer; outline: 0; border: none; top: 0;}.cky-switch input[type="checkbox"]:checked{background: #1863dc;}.cky-switch input[type="checkbox"]:before{position: absolute; content: ""; height: 20px; width: 20px; left: 2px; bottom: 2px; border-radius: 50%; background-color: white; -webkit-transition: 0.4s; transition: 0.4s; margin: 0;}.cky-switch input[type="checkbox"]:after{display: none;}.cky-switch input[type="checkbox"]:checked:before{-webkit-transform: translateX(20px); -ms-transform: translateX(20px); transform: translateX(20px);}@media (max-width: 425px){.cky-switch input[type="checkbox"]{width: 38px; height: 21px;}.cky-switch input[type="checkbox"]:before{height: 17px; width: 17px;}.cky-switch input[type="checkbox"]:checked:before{-webkit-transform: translateX(17px); -ms-transform: translateX(17px); transform: translateX(17px);}}.cky-consent-bar .cky-banner-btn-close{position: absolute; right: 9px; top: 5px; background: none; border: none; cursor: pointer; padding: 0; margin: 0; min-height: 0; line-height: 0; height: auto; width: auto; text-shadow: none; box-shadow: none;}.cky-consent-bar .cky-banner-btn-close img{height: 9px; width: 9px; margin: 0;}.cky-notice-group{font-size: 14px; line-height: 24px; font-weight: 400; color: #212121;}.cky-notice-btn-wrapper .cky-btn-do-not-sell{font-size: 14px; line-height: 24px; padding: 6px 0; margin: 0; font-weight: 500; background: none; border-radius: 2px; border: none; cursor: pointer; text-align: left; color: #1863dc; background: transparent; border-color: transparent; box-shadow: none; text-shadow: none;}.cky-consent-bar .cky-banner-btn-close:focus-visible,.cky-notice-btn-wrapper .cky-btn-do-not-sell:focus-visible,.cky-opt-out-btn-wrapper .cky-btn:focus-visible,.cky-opt-out-checkbox-wrapper input[type="checkbox"].cky-opt-out-checkbox:focus-visible{outline: 2px solid #1863dc; outline-offset: 2px;}@media (max-width: 440px){.cky-consent-container{width: 100%;}}@media (max-width: 352px){.cky-notice-des a.cky-policy, .cky-notice-btn-wrapper .cky-btn-do-not-sell{font-size: 12px;}}.cky-opt-out-wrapper{padding: 12px 0;}.cky-opt-out-wrapper .cky-opt-out-checkbox-wrapper{display: flex; align-items: center;}.cky-opt-out-checkbox-wrapper .cky-opt-out-checkbox-label{font-size: 16px; font-weight: 700; line-height: 24px; margin: 0 0 0 12px; cursor: pointer;}.cky-opt-out-checkbox-wrapper input[type="checkbox"].cky-opt-out-checkbox{background-color: #ffffff; border: 1px solid black; width: 20px; height: 18.5px; margin: 0; -webkit-appearance: none; position: relative; display: flex; align-items: center; justify-content: center; border-radius: 2px; cursor: pointer;}.cky-opt-out-checkbox-wrapper input[type="checkbox"].cky-opt-out-checkbox:checked{background-color: #1863dc; border: none;}.cky-opt-out-checkbox-wrapper input[type="checkbox"].cky-opt-out-checkbox:checked::after{left: 6px; bottom: 4px; width: 7px; height: 13px; border: solid #ffffff; border-width: 0 3px 3px 0; border-radius: 2px; -webkit-transform: rotate(45deg); -ms-transform: rotate(45deg); transform: rotate(45deg); content: ""; position: absolute; box-sizing: border-box;}.cky-opt-out-checkbox-wrapper.cky-disabled .cky-opt-out-checkbox-label,.cky-opt-out-checkbox-wrapper.cky-disabled input[type="checkbox"].cky-opt-out-checkbox{cursor: no-drop;}.cky-gpc-wrapper{margin: 0 0 0 32px;}.cky-footer-wrapper .cky-opt-out-btn-wrapper{display: flex; flex-wrap: wrap; align-items: center; justify-content: center; padding: 22px 24px;}.cky-opt-out-btn-wrapper .cky-btn{flex: auto; max-width: 100%; text-shadow: none; box-shadow: none;}.cky-opt-out-btn-wrapper .cky-btn-cancel{border: 1px solid #dedfe0; background: transparent; color: #858585;}.cky-opt-out-btn-wrapper .cky-btn-confirm{background: #1863dc; color: #ffffff; border: 1px solid #1863dc;}@media (max-width: 352px){.cky-opt-out-checkbox-wrapper .cky-opt-out-checkbox-label{font-size: 14px;}.cky-gpc-wrapper .cky-gpc-desc, .cky-gpc-wrapper .cky-gpc-desc *{font-size: 12px;}.cky-opt-out-checkbox-wrapper input[type="checkbox"].cky-opt-out-checkbox{width: 16px; height: 16px;}.cky-opt-out-checkbox-wrapper input[type="checkbox"].cky-opt-out-checkbox:checked::after{left: 5px; bottom: 4px; width: 3px; height: 9px;}.cky-gpc-wrapper{margin: 0 0 0 28px;}}.video-placeholder-youtube{background-size: 100% 100%; background-position: center; background-repeat: no-repeat; background-color: #b2b0b059; position: relative; display: flex; align-items: center; justify-content: center; max-width: 100%;}.video-placeholder-text-youtube{text-align: center; align-items: center; padding: 10px 16px; background-color: #000000cc; color: #ffffff; border: 1px solid; border-radius: 2px; cursor: pointer;}.video-placeholder-normal{background-image: url("/wp-content/plugins/cookie-law-info/lite/frontend/images/placeholder.svg"); background-size: 80px; background-position: center; background-repeat: no-repeat; background-color: #b2b0b059; position: relative; display: flex; align-items: flex-end; justify-content: center; max-width: 100%;}.video-placeholder-text-normal{align-items: center; padding: 10px 16px; text-align: center; border: 1px solid; border-radius: 2px; cursor: pointer;}.cky-rtl{direction: rtl; text-align: right;}.cky-rtl .cky-banner-btn-close{left: 9px; right: auto;}.cky-rtl .cky-notice-btn-wrapper .cky-btn:last-child{margin-right: 8px;}.cky-rtl .cky-notice-btn-wrapper .cky-btn:first-child{margin-right: 0;}.cky-rtl .cky-notice-btn-wrapper{margin-left: 0; margin-right: 15px;}.cky-rtl .cky-prefrence-btn-wrapper .cky-btn{margin-right: 8px;}.cky-rtl .cky-prefrence-btn-wrapper .cky-btn:first-child{margin-right: 0;}.cky-rtl .cky-accordion .cky-accordion-chevron i::before{border: none; border-left: 1.4px solid; border-top: 1.4px solid; left: 12px;}.cky-rtl .cky-accordion.cky-accordion-active .cky-accordion-chevron i::before{-webkit-transform: rotate(-135deg); -moz-transform: rotate(-135deg); -ms-transform: rotate(-135deg); -o-transform: rotate(-135deg); transform: rotate(-135deg);}@media (max-width: 768px){.cky-rtl .cky-notice-btn-wrapper{margin-right: 0;}}@media (max-width: 576px){.cky-rtl .cky-notice-btn-wrapper .cky-btn:last-child{margin-right: 0;}.cky-rtl .cky-prefrence-btn-wrapper .cky-btn{margin-right: 0;}.cky-rtl .cky-accordion.cky-accordion-active .cky-accordion-body{padding: 0 22px 0 0;}}@media (max-width: 425px){.cky-rtl .cky-accordion.cky-accordion-active .cky-accordion-body{padding: 0 15px 0 0;}}.cky-rtl .cky-opt-out-btn-wrapper .cky-btn{margin-right: 12px;}.cky-rtl .cky-opt-out-btn-wrapper .cky-btn:first-child{margin-right: 0;}.cky-rtl .cky-opt-out-checkbox-wrapper .cky-opt-out-checkbox-label{margin: 0 12px 0 0;}";}}','yes');
INSERT INTO `wp_options` VALUES (685,'cky_banners_table_version','3.2.4','yes');
INSERT INTO `wp_options` VALUES (686,'_transient_cky_banner_template_transient_prefix','0.51012900 1719266084','yes');
INSERT INTO `wp_options` VALUES (687,'_transient_cky_cookies_transient_prefix','0.58207200 1719266084','yes');
INSERT INTO `wp_options` VALUES (688,'_transient_cky_categories_transient_prefix','0.58666900 1719266084','yes');
INSERT INTO `wp_options` VALUES (689,'cky_cookie_category_table_version','3.2.4','yes');
INSERT INTO `wp_options` VALUES (690,'cky_cookie_table_version','3.2.4','yes');
INSERT INTO `wp_options` VALUES (691,'cky_settings','a:6:{s:4:"site";a:2:{s:3:"url";s:31:"http://ferme-de-chassagne.local";s:9:"installed";i:1719266086;}s:3:"api";a:1:{s:5:"token";s:0:"";}s:7:"account";a:6:{s:5:"email";s:0:"";s:6:"domain";s:0:"";s:9:"connected";b:0;s:4:"plan";s:4:"free";s:10:"website_id";s:0:"";s:11:"website_key";s:0:"";}s:12:"consent_logs";a:1:{s:6:"status";b:1;}s:9:"languages";a:2:{s:8:"selected";a:1:{i:0;s:2:"en";}s:7:"default";s:2:"en";}s:10:"onboarding";a:1:{s:4:"step";i:2;}}','yes');
INSERT INTO `wp_options` VALUES (705,'_transient_cky_transient_0.25815200 1719266084_all','a:2:{i:1;O:8:"stdClass":7:{s:9:"banner_id";i:1;s:4:"name";s:4:"GDPR";s:4:"slug";s:6:"gdpr-1";s:8:"settings";a:4:{s:8:"settings";a:12:{s:2:"id";s:8:"banner-1";s:4:"type";s:3:"box";s:20:"preferenceCenterType";s:5:"popup";s:8:"position";s:11:"bottom-left";s:9:"versionID";s:5:"6.0.0";s:13:"applicableLaw";s:4:"gdpr";s:9:"languages";a:2:{s:7:"default";s:2:"en";s:8:"selected";a:1:{i:0;s:2:"en";}}s:13:"templateGroup";s:7:"default";s:10:"customHtml";a:1:{s:6:"status";b:0;}s:5:"theme";s:5:"light";s:13:"consentExpiry";a:2:{s:6:"status";b:1;s:5:"value";s:3:"365";}s:7:"ruleSet";a:1:{i:0;a:2:{s:4:"code";s:3:"ALL";s:7:"regions";a:0:{}}}}s:10:"behaviours";a:5:{s:20:"reloadBannerOnAccept";a:1:{s:6:"status";b:0;}s:22:"loadAnalyticsByDefault";a:1:{s:6:"status";b:0;}s:10:"animations";a:2:{s:6:"onLoad";s:7:"animate";s:6:"onHide";s:6:"sticky";}s:15:"legacyFunctions";a:5:{s:6:"accept";a:2:{s:6:"action";s:11:"acceptClose";s:6:"newTab";b:0;}s:6:"reject";a:2:{s:6:"action";s:11:"rejectClose";s:6:"newTab";b:0;}s:4:"idle";a:2:{s:6:"action";s:11:"acceptClose";s:5:"delay";s:4:"1000";}s:10:"navigation";a:1:{s:6:"action";s:11:"acceptClose";}s:10:"pageScroll";a:1:{s:6:"action";s:11:"acceptClose";}}s:10:"respectGPC";a:1:{s:6:"status";b:0;}}s:6:"config";a:7:{s:6:"notice";a:5:{s:6:"status";b:1;s:3:"tag";s:6:"notice";s:4:"type";s:9:"container";s:6:"styles";a:2:{s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#f4f4f4";}s:8:"elements";a:5:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:5:"title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:11:"description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:9:"brandLogo";a:3:{s:6:"status";b:0;s:3:"tag";s:10:"brand-logo";s:4:"meta";a:1:{s:3:"url";s:1:"#";}}s:7:"buttons";a:4:{s:6:"status";b:1;s:3:"tag";s:14:"notice-buttons";s:4:"type";s:9:"container";s:8:"elements";a:5:{s:6:"accept";a:4:{s:6:"status";b:1;s:3:"tag";s:13:"accept-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#FFFFFF";s:16:"background-color";s:7:"#1863DC";s:12:"border-color";s:7:"#1863DC";}}s:6:"reject";a:4:{s:6:"status";b:1;s:3:"tag";s:13:"reject-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}s:8:"settings";a:4:{s:6:"status";b:1;s:3:"tag";s:15:"settings-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}s:8:"readMore";a:5:{s:6:"status";b:0;s:3:"tag";s:15:"readmore-button";s:4:"type";s:4:"link";s:4:"meta";a:2:{s:8:"noFollow";b:1;s:6:"newTab";b:1;}s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:11:"transparent";}}s:9:"donotSell";a:4:{s:6:"status";b:0;s:3:"tag";s:16:"donotsell-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:11:"transparent";}}}}s:11:"closeButton";a:2:{s:6:"status";b:0;s:3:"tag";s:12:"close-button";}}}s:15:"categoryPreview";a:4:{s:6:"status";b:0;s:4:"type";s:9:"container";s:3:"tag";s:23:"detail-category-preview";s:8:"elements";a:3:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:29:"detail-category-preview-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:6:"toggle";a:4:{s:6:"status";b:1;s:3:"tag";s:30:"detail-category-preview-toggle";s:4:"type";s:6:"toggle";s:6:"states";a:2:{s:6:"active";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#1863DC";}}s:8:"inactive";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#D0D5D2";}}}}s:7:"buttons";a:3:{s:6:"status";b:1;s:3:"tag";s:31:"detail-category-preview-buttons";s:8:"elements";a:1:{s:4:"save";a:4:{s:6:"status";b:1;s:3:"tag";s:35:"detail-category-preview-save-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}}}}}s:16:"preferenceCenter";a:5:{s:6:"status";b:1;s:3:"tag";s:6:"detail";s:4:"type";s:9:"container";s:6:"styles";a:3:{s:5:"color";s:7:"#212121";s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#f4f4f4";}s:8:"elements";a:6:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:12:"detail-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:18:"detail-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"closeButton";a:3:{s:6:"status";b:1;s:4:"type";s:6:"button";s:3:"tag";s:12:"detail-close";}s:10:"categories";a:4:{s:6:"status";b:1;s:3:"tag";s:17:"detail-categories";s:4:"type";s:9:"container";s:8:"elements";a:3:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:21:"detail-category-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:27:"detail-category-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:6:"toggle";a:4:{s:6:"status";b:1;s:3:"tag";s:22:"detail-category-toggle";s:4:"type";s:6:"toggle";s:6:"states";a:2:{s:6:"active";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#1863DC";}}s:8:"inactive";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#D0D5D2";}}}}}}s:7:"buttons";a:4:{s:6:"status";b:1;s:3:"tag";s:14:"detail-buttons";s:4:"type";s:9:"container";s:8:"elements";a:3:{s:6:"accept";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"detail-accept-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#FFFFFF";s:16:"background-color";s:7:"#1863DC";s:12:"border-color";s:7:"#1863DC";}}s:6:"reject";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"detail-reject-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}s:4:"save";a:4:{s:6:"status";b:1;s:3:"tag";s:18:"detail-save-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}}}s:9:"poweredBy";a:3:{s:6:"status";b:1;s:3:"tag";s:17:"detail-powered-by";s:6:"styles";a:2:{s:16:"background-color";s:7:"#EDEDED";s:5:"color";s:7:"#293C5B";}}}}s:11:"optoutPopup";a:5:{s:6:"status";b:0;s:3:"tag";s:12:"optout-popup";s:4:"type";s:9:"container";s:6:"styles";a:3:{s:5:"color";s:7:"#212121";s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#F4F4F4";}s:8:"elements";a:7:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:12:"optout-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:18:"optout-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:9:"optOption";a:4:{s:6:"status";b:1;s:3:"tag";s:13:"optout-option";s:4:"type";s:9:"container";s:8:"elements";a:2:{s:6:"toggle";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"optout-option-toggle";s:4:"type";s:6:"toggle";s:6:"states";a:2:{s:6:"active";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#1863dc";}}s:8:"inactive";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#FFFFFF";}}}}s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:19:"optout-option-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}}}s:9:"gpcOption";a:4:{s:4:"type";s:9:"container";s:3:"tag";s:17:"optout-gpc-option";s:6:"status";b:0;s:8:"elements";a:1:{s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:29:"optout-gpc-option-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}}}s:9:"poweredBy";a:3:{s:6:"status";b:1;s:3:"tag";s:17:"optout-powered-by";s:6:"styles";a:2:{s:16:"background-color";s:7:"#EDEDED";s:5:"color";s:7:"#293C5B";}}s:7:"buttons";a:4:{s:6:"status";b:1;s:3:"tag";s:14:"optout-buttons";s:4:"type";s:9:"container";s:8:"elements";a:2:{s:7:"confirm";a:4:{s:6:"status";b:1;s:3:"tag";s:21:"optout-confirm-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#f4f4f4";s:16:"background-color";s:7:"#1863dc";s:12:"border-color";s:7:"#1863dc";}}s:6:"cancel";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"optout-cancel-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#858585";s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#dedfe0";}}}}s:11:"closeButton";a:3:{s:6:"status";b:1;s:3:"tag";s:12:"optout-close";s:4:"type";s:6:"button";}}}s:10:"auditTable";a:5:{s:6:"status";b:1;s:3:"tag";s:11:"audit-table";s:4:"type";s:5:"table";s:4:"meta";a:1:{s:7:"headers";a:3:{i:0;s:2:"id";i:1;s:8:"duration";i:2;s:11:"description";}}s:6:"styles";a:3:{s:5:"color";s:7:"#212121";s:16:"background-color";s:7:"#f4f4f4";s:12:"border-color";s:7:"#ebebeb";}}s:14:"revisitConsent";a:6:{s:6:"status";b:1;s:3:"tag";s:15:"revisit-consent";s:8:"position";s:11:"bottom-left";s:4:"meta";a:1:{s:3:"url";s:1:"#";}s:6:"styles";a:1:{s:16:"background-color";s:7:"#0056A7";}s:8:"elements";a:1:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:21:"revisit-consent-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#0056a7";}}}}s:16:"videoPlaceholder";a:4:{s:6:"status";b:1;s:3:"tag";s:17:"video-placeholder";s:6:"styles";a:2:{s:16:"background-color";s:7:"#000000";s:12:"border-color";s:7:"#000000";}s:8:"elements";a:1:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:17:"placeholder-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#ffffff";}}}}}s:4:"meta";a:2:{s:9:"customCSS";s:0:"";s:10:"customHTML";s:0:"";}}s:8:"contents";a:1:{s:2:"en";a:7:{s:6:"notice";a:1:{s:8:"elements";a:5:{s:5:"title";s:21:"We value your privacy";s:11:"description";s:179:"<p>We use cookies to enhance your browsing experience, serve personalized ads or content, and analyze our traffic. By clicking "Accept All", you consent to our use of cookies.</p>";s:11:"privacyLink";s:0:"";s:7:"buttons";a:1:{s:8:"elements";a:5:{s:6:"accept";s:10:"Accept All";s:6:"reject";s:10:"Reject All";s:8:"settings";s:9:"Customize";s:8:"readMore";s:13:"Cookie Policy";s:9:"donotSell";s:44:"Do Not Sell or Share My Personal Information";}}s:11:"closeButton";s:5:"Close";}}s:15:"categoryPreview";a:1:{s:8:"elements";a:1:{s:7:"buttons";a:1:{s:8:"elements";a:1:{s:4:"save";s:19:"Save My Preferences";}}}}s:16:"preferenceCenter";a:1:{s:8:"elements";a:7:{s:5:"title";s:29:"Customize Consent Preferences";s:11:"description";s:717:"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.</p><p>The cookies that are categorized as "Necessary" are stored on your browser as they are essential for enabling the basic functionalities of the site. </p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.</p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.</p>";s:8:"showMore";s:9:"Show more";s:8:"showLess";s:9:"Show less";s:8:"category";a:1:{s:8:"elements";a:3:{s:13:"alwaysEnabled";s:13:"Always Active";s:6:"enable";s:6:"Enable";s:7:"disable";s:7:"Disable";}}s:7:"buttons";a:1:{s:8:"elements";a:3:{s:6:"accept";s:10:"Accept All";s:4:"save";s:19:"Save My Preferences";s:6:"reject";s:10:"Reject All";}}s:11:"closeButton";s:5:"Close";}}s:11:"optoutPopup";a:1:{s:8:"elements";a:8:{s:5:"title";s:19:"Opt-out Preferences";s:11:"description";s:480:"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking "Do Not Sell or Share My Personal Information" and clicking the "Save My Preferences" button. Once you opt out, you can opt in again at any time by unchecking "Do Not Sell or Share My Personal Information" and clicking the "Save My Preferences" button.</p>";s:9:"optOption";a:1:{s:8:"elements";a:3:{s:5:"title";s:44:"Do Not Sell or Share My Personal Information";s:6:"enable";s:6:"Enable";s:7:"disable";s:7:"Disable";}}s:9:"gpcOption";a:1:{s:8:"elements";a:1:{s:11:"description";s:188:"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control</b> signal from your browser and, therefore, you cannot change this setting.</p>";}}s:8:"showLess";s:9:"Show less";s:8:"showMore";s:9:"Show more";s:7:"buttons";a:1:{s:8:"elements";a:2:{s:6:"cancel";s:6:"Cancel";s:7:"confirm";s:19:"Save My Preferences";}}s:11:"closeButton";s:5:"Close";}}s:14:"revisitConsent";a:1:{s:8:"elements";a:1:{s:5:"title";s:19:"Consent Preferences";}}s:10:"auditTable";a:1:{s:8:"elements";a:2:{s:7:"headers";a:1:{s:8:"elements";a:3:{s:2:"id";s:6:"Cookie";s:8:"duration";s:8:"Duration";s:11:"description";s:11:"Description";}}s:7:"message";s:22:"No cookies to display.";}}s:16:"videoPlaceholder";a:1:{s:8:"elements";a:1:{s:5:"title";s:44:"Please accept cookies to access this content";}}}}s:14:"banner_default";i:1;s:6:"status";i:1;}i:2;O:8:"stdClass":7:{s:9:"banner_id";i:2;s:4:"name";s:4:"CCPA";s:4:"slug";s:6:"ccpa-2";s:8:"settings";a:4:{s:8:"settings";a:12:{s:2:"id";s:8:"banner-1";s:4:"type";s:3:"box";s:20:"preferenceCenterType";s:5:"popup";s:8:"position";s:11:"bottom-left";s:9:"versionID";s:5:"6.0.0";s:13:"applicableLaw";s:4:"ccpa";s:9:"languages";a:2:{s:7:"default";s:2:"en";s:8:"selected";a:1:{i:0;s:2:"en";}}s:13:"templateGroup";s:7:"default";s:10:"customHtml";a:1:{s:6:"status";b:0;}s:5:"theme";s:5:"light";s:13:"consentExpiry";a:2:{s:6:"status";b:1;s:5:"value";s:3:"365";}s:7:"ruleSet";a:1:{i:0;a:2:{s:4:"code";s:3:"ALL";s:7:"regions";a:0:{}}}}s:10:"behaviours";a:5:{s:20:"reloadBannerOnAccept";a:1:{s:6:"status";b:0;}s:22:"loadAnalyticsByDefault";a:1:{s:6:"status";b:0;}s:10:"animations";a:2:{s:6:"onLoad";s:7:"animate";s:6:"onHide";s:6:"sticky";}s:15:"legacyFunctions";a:5:{s:6:"accept";a:2:{s:6:"action";s:11:"acceptClose";s:6:"newTab";b:0;}s:6:"reject";a:2:{s:6:"action";s:11:"rejectClose";s:6:"newTab";b:0;}s:4:"idle";a:2:{s:6:"action";s:11:"acceptClose";s:5:"delay";s:4:"1000";}s:10:"navigation";a:1:{s:6:"action";s:11:"acceptClose";}s:10:"pageScroll";a:1:{s:6:"action";s:11:"acceptClose";}}s:10:"respectGPC";a:1:{s:6:"status";b:0;}}s:6:"config";a:7:{s:6:"notice";a:5:{s:6:"status";b:1;s:3:"tag";s:6:"notice";s:4:"type";s:9:"container";s:6:"styles";a:2:{s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#f4f4f4";}s:8:"elements";a:5:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:5:"title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:11:"description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:9:"brandLogo";a:3:{s:6:"status";b:0;s:3:"tag";s:10:"brand-logo";s:4:"meta";a:1:{s:3:"url";s:1:"#";}}s:7:"buttons";a:4:{s:6:"status";b:1;s:3:"tag";s:14:"notice-buttons";s:4:"type";s:9:"container";s:8:"elements";a:5:{s:6:"accept";a:4:{s:6:"status";b:0;s:3:"tag";s:13:"accept-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#FFFFFF";s:16:"background-color";s:7:"#1863DC";s:12:"border-color";s:7:"#1863DC";}}s:6:"reject";a:4:{s:6:"status";b:0;s:3:"tag";s:13:"reject-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}s:8:"settings";a:4:{s:6:"status";b:0;s:3:"tag";s:15:"settings-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}s:8:"readMore";a:5:{s:6:"status";b:0;s:3:"tag";s:15:"readmore-button";s:4:"type";s:4:"link";s:4:"meta";a:2:{s:8:"noFollow";b:1;s:6:"newTab";b:1;}s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:11:"transparent";}}s:9:"donotSell";a:4:{s:6:"status";b:1;s:3:"tag";s:16:"donotsell-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:11:"transparent";}}}}s:11:"closeButton";a:2:{s:6:"status";b:1;s:3:"tag";s:12:"close-button";}}}s:15:"categoryPreview";a:4:{s:6:"status";b:0;s:4:"type";s:9:"container";s:3:"tag";s:23:"detail-category-preview";s:8:"elements";a:3:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:29:"detail-category-preview-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:6:"toggle";a:4:{s:6:"status";b:1;s:3:"tag";s:30:"detail-category-preview-toggle";s:4:"type";s:6:"toggle";s:6:"states";a:2:{s:6:"active";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#1863DC";}}s:8:"inactive";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#D0D5D2";}}}}s:7:"buttons";a:3:{s:6:"status";b:1;s:3:"tag";s:31:"detail-category-preview-buttons";s:8:"elements";a:1:{s:4:"save";a:4:{s:6:"status";b:1;s:3:"tag";s:35:"detail-category-preview-save-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}}}}}s:16:"preferenceCenter";a:5:{s:6:"status";b:0;s:3:"tag";s:6:"detail";s:4:"type";s:9:"container";s:6:"styles";a:3:{s:5:"color";s:7:"#212121";s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#f4f4f4";}s:8:"elements";a:6:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:12:"detail-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:18:"detail-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"closeButton";a:3:{s:6:"status";b:1;s:4:"type";s:6:"button";s:3:"tag";s:12:"detail-close";}s:10:"categories";a:4:{s:6:"status";b:1;s:3:"tag";s:17:"detail-categories";s:4:"type";s:9:"container";s:8:"elements";a:3:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:21:"detail-category-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:27:"detail-category-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:6:"toggle";a:4:{s:6:"status";b:1;s:3:"tag";s:22:"detail-category-toggle";s:4:"type";s:6:"toggle";s:6:"states";a:2:{s:6:"active";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#1863DC";}}s:8:"inactive";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#D0D5D2";}}}}}}s:7:"buttons";a:4:{s:6:"status";b:1;s:3:"tag";s:14:"detail-buttons";s:4:"type";s:9:"container";s:8:"elements";a:3:{s:6:"accept";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"detail-accept-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#FFFFFF";s:16:"background-color";s:7:"#1863DC";s:12:"border-color";s:7:"#1863DC";}}s:6:"reject";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"detail-reject-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}s:4:"save";a:4:{s:6:"status";b:1;s:3:"tag";s:18:"detail-save-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#1863DC";s:16:"background-color";s:11:"transparent";s:12:"border-color";s:7:"#1863DC";}}}}s:9:"poweredBy";a:3:{s:6:"status";b:1;s:3:"tag";s:17:"detail-powered-by";s:6:"styles";a:2:{s:16:"background-color";s:7:"#EDEDED";s:5:"color";s:7:"#293C5B";}}}}s:11:"optoutPopup";a:5:{s:6:"status";b:1;s:3:"tag";s:12:"optout-popup";s:4:"type";s:9:"container";s:6:"styles";a:3:{s:5:"color";s:7:"#212121";s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#F4F4F4";}s:8:"elements";a:7:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:12:"optout-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:18:"optout-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}s:9:"optOption";a:4:{s:6:"status";b:1;s:3:"tag";s:13:"optout-option";s:4:"type";s:9:"container";s:8:"elements";a:2:{s:6:"toggle";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"optout-option-toggle";s:4:"type";s:6:"toggle";s:6:"states";a:2:{s:6:"active";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#1863dc";}}s:8:"inactive";a:1:{s:6:"styles";a:1:{s:16:"background-color";s:7:"#FFFFFF";}}}}s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:19:"optout-option-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}}}s:9:"gpcOption";a:4:{s:4:"type";s:9:"container";s:3:"tag";s:17:"optout-gpc-option";s:6:"status";b:0;s:8:"elements";a:1:{s:11:"description";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:29:"optout-gpc-option-description";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#212121";}}}}s:9:"poweredBy";a:3:{s:6:"status";b:1;s:3:"tag";s:17:"optout-powered-by";s:6:"styles";a:2:{s:16:"background-color";s:7:"#EDEDED";s:5:"color";s:7:"#293C5B";}}s:7:"buttons";a:4:{s:6:"status";b:1;s:3:"tag";s:14:"optout-buttons";s:4:"type";s:9:"container";s:8:"elements";a:2:{s:7:"confirm";a:4:{s:6:"status";b:1;s:3:"tag";s:21:"optout-confirm-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#f4f4f4";s:16:"background-color";s:7:"#1863dc";s:12:"border-color";s:7:"#1863dc";}}s:6:"cancel";a:4:{s:6:"status";b:1;s:3:"tag";s:20:"optout-cancel-button";s:4:"type";s:6:"button";s:6:"styles";a:3:{s:5:"color";s:7:"#858585";s:16:"background-color";s:7:"#FFFFFF";s:12:"border-color";s:7:"#dedfe0";}}}}s:11:"closeButton";a:3:{s:6:"status";b:1;s:3:"tag";s:12:"optout-close";s:4:"type";s:6:"button";}}}s:10:"auditTable";a:5:{s:6:"status";b:0;s:3:"tag";s:11:"audit-table";s:4:"type";s:5:"table";s:4:"meta";a:1:{s:7:"headers";a:3:{i:0;s:2:"id";i:1;s:8:"duration";i:2;s:11:"description";}}s:6:"styles";a:3:{s:5:"color";s:7:"#212121";s:16:"background-color";s:7:"#f4f4f4";s:12:"border-color";s:7:"#ebebeb";}}s:14:"revisitConsent";a:6:{s:6:"status";b:1;s:3:"tag";s:15:"revisit-consent";s:8:"position";s:11:"bottom-left";s:4:"meta";a:1:{s:3:"url";s:1:"#";}s:6:"styles";a:1:{s:16:"background-color";s:7:"#0056A7";}s:8:"elements";a:1:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:21:"revisit-consent-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#0056a7";}}}}s:16:"videoPlaceholder";a:4:{s:6:"status";b:1;s:3:"tag";s:17:"video-placeholder";s:6:"styles";a:2:{s:16:"background-color";s:7:"#000000";s:12:"border-color";s:7:"#000000";}s:8:"elements";a:1:{s:5:"title";a:4:{s:4:"type";s:4:"text";s:3:"tag";s:17:"placeholder-title";s:6:"status";b:1;s:6:"styles";a:1:{s:5:"color";s:7:"#ffffff";}}}}}s:4:"meta";a:2:{s:9:"customCSS";s:0:"";s:10:"customHTML";s:0:"";}}s:8:"contents";a:1:{s:2:"en";a:7:{s:6:"notice";a:1:{s:8:"elements";a:5:{s:5:"title";s:21:"We value your privacy";s:11:"description";s:196:"<p>This website or its third-party tools process personal data. You can opt out of the sale of your personal information by clicking on the "Do Not Sell or Share My Personal Information" link.</p>";s:11:"privacyLink";s:0:"";s:7:"buttons";a:1:{s:8:"elements";a:5:{s:6:"accept";s:10:"Accept All";s:6:"reject";s:10:"Reject All";s:8:"settings";s:9:"Customize";s:8:"readMore";s:13:"Cookie Policy";s:9:"donotSell";s:44:"Do Not Sell or Share My Personal Information";}}s:11:"closeButton";s:5:"Close";}}s:15:"categoryPreview";a:1:{s:8:"elements";a:1:{s:7:"buttons";a:1:{s:8:"elements";a:1:{s:4:"save";s:19:"Save My Preferences";}}}}s:16:"preferenceCenter";a:1:{s:8:"elements";a:7:{s:5:"title";s:29:"Customize Consent Preferences";s:11:"description";s:717:"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.</p><p>The cookies that are categorized as "Necessary" are stored on your browser as they are essential for enabling the basic functionalities of the site. </p><p>We also use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.</p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.</p>";s:8:"showMore";s:9:"Show more";s:8:"showLess";s:9:"Show less";s:8:"category";a:1:{s:8:"elements";a:3:{s:13:"alwaysEnabled";s:13:"Always Active";s:6:"enable";s:6:"Enable";s:7:"disable";s:7:"Disable";}}s:7:"buttons";a:1:{s:8:"elements";a:3:{s:6:"accept";s:10:"Accept All";s:4:"save";s:19:"Save My Preferences";s:6:"reject";s:10:"Reject All";}}s:11:"closeButton";s:5:"Close";}}s:11:"optoutPopup";a:1:{s:8:"elements";a:8:{s:5:"title";s:19:"Opt-out Preferences";s:11:"description";s:480:"<p>We use third-party cookies that help us analyze how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking "Do Not Sell or Share My Personal Information" and clicking the "Save My Preferences" button. Once you opt out, you can opt in again at any time by unchecking "Do Not Sell or Share My Personal Information" and clicking the "Save My Preferences" button.</p>";s:9:"optOption";a:1:{s:8:"elements";a:3:{s:5:"title";s:44:"Do Not Sell or Share My Personal Information";s:6:"enable";s:6:"Enable";s:7:"disable";s:7:"Disable";}}s:9:"gpcOption";a:1:{s:8:"elements";a:1:{s:11:"description";s:188:"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control</b> signal from your browser and, therefore, you cannot change this setting.</p>";}}s:8:"showLess";s:9:"Show less";s:8:"showMore";s:9:"Show more";s:7:"buttons";a:1:{s:8:"elements";a:2:{s:6:"cancel";s:6:"Cancel";s:7:"confirm";s:19:"Save My Preferences";}}s:11:"closeButton";s:5:"Close";}}s:14:"revisitConsent";a:1:{s:8:"elements";a:1:{s:5:"title";s:19:"Consent Preferences";}}s:10:"auditTable";a:1:{s:8:"elements";a:2:{s:7:"headers";a:1:{s:8:"elements";a:3:{s:2:"id";s:6:"Cookie";s:8:"duration";s:8:"Duration";s:11:"description";s:11:"Description";}}s:7:"message";s:22:"No cookies to display.";}}s:16:"videoPlaceholder";a:1:{s:8:"elements";a:1:{s:5:"title";s:44:"Please accept cookies to access this content";}}}}s:14:"banner_default";i:0;s:6:"status";i:0;}}','yes');
INSERT INTO `wp_options` VALUES (706,'_transient_cky_transient_0.58666900 1719266084_all','a:5:{i:1;O:8:"stdClass":12:{s:11:"category_id";i:1;s:4:"name";a:1:{s:2:"en";s:9:"Necessary";}s:4:"slug";s:9:"necessary";s:11:"description";a:1:{s:2:"en";s:212:"<p>Necessary cookies are required to enable the basic features of this site, such as providing secure log-in or adjusting your consent preferences. These cookies do not store any personally identifiable data.</p>";}s:13:"prior_consent";i:1;s:8:"priority";i:0;s:10:"visibility";i:1;s:18:"sell_personal_data";i:1;s:4:"meta";a:0:{}s:12:"date_created";s:19:"0000-00-00 00:00:00";s:13:"date_modified";s:19:"2024-06-24 21:54:44";s:7:"cookies";a:0:{}}i:2;O:8:"stdClass":12:{s:11:"category_id";i:2;s:4:"name";a:1:{s:2:"en";s:10:"Functional";}s:4:"slug";s:10:"functional";s:11:"description";a:1:{s:2:"en";s:182:"<p>Functional cookies help perform certain functionalities like sharing the content of the website on social media platforms, collecting feedback, and other third-party features.</p>";}s:13:"prior_consent";i:0;s:8:"priority";i:0;s:10:"visibility";i:1;s:18:"sell_personal_data";i:1;s:4:"meta";a:0:{}s:12:"date_created";s:19:"0000-00-00 00:00:00";s:13:"date_modified";s:19:"2024-06-24 21:54:44";s:7:"cookies";a:0:{}}i:3;O:8:"stdClass":12:{s:11:"category_id";i:3;s:4:"name";a:1:{s:2:"en";s:9:"Analytics";}s:4:"slug";s:9:"analytics";s:11:"description";a:1:{s:2:"en";s:204:"<p>Analytical cookies are used to understand how visitors interact with the website. These cookies help provide information on metrics such as the number of visitors, bounce rate, traffic source, etc.</p>";}s:13:"prior_consent";i:0;s:8:"priority";i:0;s:10:"visibility";i:1;s:18:"sell_personal_data";i:1;s:4:"meta";a:0:{}s:12:"date_created";s:19:"0000-00-00 00:00:00";s:13:"date_modified";s:19:"2024-06-24 21:54:44";s:7:"cookies";a:0:{}}i:4;O:8:"stdClass":12:{s:11:"category_id";i:4;s:4:"name";a:1:{s:2:"en";s:11:"Performance";}s:4:"slug";s:11:"performance";s:11:"description";a:1:{s:2:"en";s:173:"<p>Performance cookies are used to understand and analyze the key performance indexes of the website which helps in delivering a better user experience for the visitors.</p>";}s:13:"prior_consent";i:0;s:8:"priority";i:0;s:10:"visibility";i:1;s:18:"sell_personal_data";i:1;s:4:"meta";a:0:{}s:12:"date_created";s:19:"0000-00-00 00:00:00";s:13:"date_modified";s:19:"2024-06-24 21:54:44";s:7:"cookies";a:0:{}}i:5;O:8:"stdClass":12:{s:11:"category_id";i:5;s:4:"name";a:1:{s:2:"en";s:13:"Advertisement";}s:4:"slug";s:13:"advertisement";s:11:"description";a:1:{s:2:"en";s:184:"<p>Advertisement cookies are used to provide visitors with customized advertisements based on the pages you visited previously and to analyze the effectiveness of the ad campaigns.</p>";}s:13:"prior_consent";i:0;s:8:"priority";i:0;s:10:"visibility";i:1;s:18:"sell_personal_data";i:1;s:4:"meta";a:0:{}s:12:"date_created";s:19:"0000-00-00 00:00:00";s:13:"date_modified";s:19:"2024-06-24 21:54:44";s:7:"cookies";a:0:{}}}','yes');
INSERT INTO `wp_options` VALUES (707,'cky_connect_expand','a:1:{s:6:"status";b:0;}','yes');
INSERT INTO `wp_options` VALUES (708,'elementor_allow_tracking','no','yes');
INSERT INTO `wp_options` VALUES (709,'elementor_tracker_notice','1','yes');
INSERT INTO `wp_options` VALUES (710,'updraftplus_dismissedautobackup','1726523938','yes');
INSERT INTO `wp_options` VALUES (1185,'auto_core_update_notified','a:4:{s:4:"type";s:7:"success";s:5:"email";s:24:"dev-email@wpengine.local";s:7:"version";s:3:"6.6";s:9:"timestamp";i:1721299898;}','no');
INSERT INTO `wp_options` VALUES (1246,'GTranslate','a:39:{s:11:"pro_version";s:0:"";s:18:"enterprise_version";s:0:"";s:16:"wrapper_selector";s:19:".gtranslate_wrapper";s:14:"custom_domains";s:0:"";s:19:"custom_domains_data";s:0:"";s:15:"url_translation";s:0:"";s:17:"add_hreflang_tags";s:0:"";s:17:"email_translation";s:0:"";s:23:"email_translation_debug";s:0:"";s:12:"show_in_menu";s:0:"";s:26:"floating_language_selector";s:11:"bottom_left";s:21:"native_language_names";s:0:"";s:10:"enable_cdn";s:0:"";s:23:"detect_browser_language";s:0:"";s:12:"add_new_line";i:1;s:21:"select_language_label";s:15:"Select Language";s:10:"custom_css";s:0:"";s:16:"default_language";s:2:"fr";s:11:"widget_look";s:5:"float";s:9:"flag_size";i:24;s:10:"flag_style";s:2:"2d";s:10:"globe_size";i:60;s:11:"globe_color";s:7:"#66aaff";s:10:"incl_langs";a:10:{i:0;s:2:"ar";i:1;s:5:"zh-CN";i:2;s:2:"nl";i:3;s:2:"en";i:4;s:2:"fr";i:5;s:2:"de";i:6;s:2:"it";i:7;s:2:"pt";i:8;s:2:"ru";i:9;s:2:"es";}s:11:"fincl_langs";a:4:{i:0;s:2:"en";i:1;s:2:"fr";i:2;s:2:"de";i:3;s:2:"es";}s:9:"alt_flags";a:0:{}s:19:"switcher_text_color";s:7:"#666666";s:20:"switcher_arrow_color";s:7:"#666666";s:21:"switcher_border_color";s:7:"#cccccc";s:25:"switcher_background_color";s:7:"#ffffff";s:32:"switcher_background_shadow_color";s:7:"#efefef";s:31:"switcher_background_hover_color";s:7:"#f0f0f0";s:19:"dropdown_text_color";s:7:"#000000";s:20:"dropdown_hover_color";s:7:"#ffffff";s:25:"dropdown_background_color";s:7:"#eeeeee";s:29:"float_switcher_open_direction";s:3:"top";s:23:"switcher_open_direction";s:3:"top";s:14:"language_codes";s:320:"af,sq,am,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,ny,zh-CN,zh-TW,co,hr,cs,da,nl,en,eo,et,tl,fi,fr,fy,gl,ka,de,el,gu,ht,ha,haw,iw,hi,hmn,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,ku,ky,lo,la,lv,lt,lb,mk,mg,ms,ml,mt,mi,mr,mn,my,ne,no,ps,fa,pl,pt,pa,ro,ru,sm,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tg,ta,te,th,tr,uk,ur,uz,vi,cy,xh,yi,yo,zu";s:15:"language_codes2";s:320:"af,sq,am,ar,hy,az,eu,be,bn,bs,bg,ca,ceb,ny,zh-CN,zh-TW,co,hr,cs,da,nl,en,eo,et,tl,fi,fr,fy,gl,ka,de,el,gu,ht,ha,haw,iw,hi,hmn,hu,is,ig,id,ga,it,ja,jw,kn,kk,km,ko,ku,ky,lo,la,lv,lt,lb,mk,mg,ms,ml,mt,mi,mr,mn,my,ne,no,ps,fa,pl,pt,pa,ro,ru,sm,gd,sr,st,sn,sd,si,sk,sl,so,es,su,sw,sv,tg,ta,te,th,tr,uk,ur,uz,vi,cy,xh,yi,yo,zu";}','auto');
INSERT INTO `wp_options` VALUES (1247,'widget_gtranslate','a:1:{s:12:"_multiwidget";i:1;}','auto');
INSERT INTO `wp_options` VALUES (1248,'gtranslate_admin_notice','a:3:{s:42:"deactivate_plugin_googlelanguagetranslator";a:2:{s:5:"start";s:9:"7/18/2024";s:3:"int";i:0;}s:15:"two_week_review";a:2:{s:5:"start";s:9:"7/23/2024";s:3:"int";i:5;}s:12:"upgrade_tips";a:2:{s:5:"start";s:9:"7/20/2024";s:3:"int";i:2;}}','auto');
INSERT INTO `wp_options` VALUES (1251,'ocean_extra_dismiss_rating_notice','1','auto');
INSERT INTO `wp_options` VALUES (1379,'wpvivid_email_setting','a:3:{s:7:"send_to";a:0:{}s:6:"always";b:1;s:12:"email_enable";b:0;}','off');
INSERT INTO `wp_options` VALUES (1380,'wpvivid_compress_setting','a:7:{s:13:"compress_type";s:3:"zip";s:13:"max_file_size";i:200;s:11:"no_compress";b:1;s:13:"use_temp_file";i:1;s:13:"use_temp_size";i:16;s:17:"exclude_file_size";i:0;s:24:"subpackage_plugin_upload";b:0;}','off');
INSERT INTO `wp_options` VALUES (1381,'wpvivid_local_setting','a:2:{s:4:"path";s:14:"wpvividbackups";s:10:"save_local";i:1;}','off');
INSERT INTO `wp_options` VALUES (1382,'wpvivid_upload_setting','a:1:{s:15:"remote_selected";a:0:{}}','off');
INSERT INTO `wp_options` VALUES (1383,'wpvivid_common_setting','a:10:{s:18:"max_execution_time";i:180;s:17:"log_save_location";s:26:"wpvividbackups\\wpvivid_log";s:16:"max_backup_count";i:3;s:14:"show_admin_bar";b:1;s:14:"domain_include";b:1;s:15:"estimate_backup";b:1;s:16:"max_resume_count";i:6;s:12:"memory_limit";s:4:"256M";s:20:"restore_memory_limit";s:4:"512M";s:12:"migrate_size";s:4:"2048";}','off');
INSERT INTO `wp_options` VALUES (1384,'wpvivid_init','init','auto');
INSERT INTO `wp_options` VALUES (1385,'wpvivid_backup_list','a:0:{}','off');
INSERT INTO `wp_options` VALUES (1386,'wpvivid_remote_init','init','auto');
INSERT INTO `wp_options` VALUES (1388,'wpvivid_check_htaccess_rule_free','1','auto');
INSERT INTO `wp_options` VALUES (1389,'wpvivid_need_review','not','off');
INSERT INTO `wp_options` VALUES (1391,'clean_task','a:1:{i:0;b:0;}','off');
INSERT INTO `wp_options` VALUES (1394,'wpvivid_backup_success_count','2','off');
INSERT INTO `wp_options` VALUES (1395,'wpvivid_backup_reports','a:2:{s:21:"wpvivid-66a1219788400";a:3:{s:7:"task_id";s:21:"wpvivid-66a1219788400";s:11:"backup_time";i:1721835927;s:6:"status";s:34:"The last backup message not found.";}s:21:"wpvivid-66a121ef4f40e";a:3:{s:7:"task_id";s:21:"wpvivid-66a121ef4f40e";s:11:"backup_time";i:1721836015;s:6:"status";s:34:"The last backup message not found.";}}','auto');
INSERT INTO `wp_options` VALUES (1396,'wpvivid_last_msg','a:8:{s:2:"id";s:21:"wpvivid-66a121ef4f40e";s:4:"type";s:6:"Manual";s:7:"options";a:22:{s:7:"ismerge";s:1:"1";s:4:"lock";s:1:"0";s:12:"backup_files";s:8:"files+db";s:5:"local";s:1:"1";s:6:"remote";s:1:"0";s:4:"type";s:6:"Manual";s:10:"save_local";i:1;s:13:"backup_prefix";s:24:"ferme-de-chassagne.local";s:11:"file_prefix";s:63:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46";s:13:"log_file_name";s:28:"wpvivid-66a121ef4f40e_backup";s:13:"log_file_path";s:131:"C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public/wp-content\\wpvividbackups\\wpvivid_log\\wpvivid-66a121ef4f40e_backup_log.txt";s:6:"prefix";s:63:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46";s:3:"dir";s:82:"C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public/wp-content/wpvividbackups";s:10:"backup_dir";s:14:"wpvividbackups";s:14:"exclude-tables";a:6:{i:0;s:14:"wp_wpvivid_log";i:1;s:28:"wp_wpvivid_increment_big_ids";i:2;s:18:"wp_wpvivid_options";i:3;s:22:"wp_wpvivid_record_task";i:4;s:19:"wp_wpvivid_merge_db";i:5;s:20:"wp_wpvivid_merge_ids";}s:14:"include-tables";a:0:{}s:13:"exclude_files";a:14:{i:0;s:114:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/plugins\\/wpvivid\\-backuprestore#";i:1;s:102:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/plugins\\/wp\\-cerber#";i:2;s:94:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/plugins\\/\\.#";i:3;s:112:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/plugins\\/wpvivid\\-backup\\-pro#";i:4;s:108:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/plugins\\/wpvividdashboard#";i:5;s:90:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/updraft#";i:6;s:90:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/upgrade#";i:7;s:88:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/cache#";i:8;s:88:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/cache#";i:9;s:98:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/wpvivid_uploads#";i:10;s:98:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/WPvivid_Uploads#";i:11;s:90:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/wpvivid#";i:12;s:97:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/wpvividbackups#";i:13;s:107:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-content\\/wpvivid_uploads\\\\Isolate#";}s:13:"include_files";a:3:{i:0;s:79:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-admin#";i:1;s:82:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/wp\\-includes#";i:2;s:77:"#^C\\:\\/Users\\/mathi\\/Local Sites\\/ferme\\-de\\-chassagne\\/app\\/public\\/lotties#";}s:15:"include_plugins";a:0:{}s:14:"include_themes";a:0:{}s:14:"backup_options";a:1:{s:8:"compress";a:1:{s:13:"compress_type";s:3:"zip";}}s:14:"remote_options";b:0;}s:6:"status";a:7:{s:15:"task_start_time";i:1721836015;s:13:"task_end_time";i:1721836059;s:10:"start_time";i:1721836015;s:8:"run_time";i:1721836059;s:7:"timeout";i:1721836058;s:3:"str";s:7:"running";s:12:"resume_count";i:0;}s:7:"setting";a:12:{s:17:"db_connect_method";s:4:"wpdb";s:12:"memory_limit";s:4:"256M";s:18:"max_execution_time";i:180;s:23:"compress_file_use_cache";b:0;s:19:"compress_file_count";i:500;s:13:"max_file_size";i:200;s:17:"max_sql_file_size";i:200;s:17:"exclude_file_size";i:0;s:16:"max_resume_count";i:6;s:10:"zip_method";s:10:"ziparchive";s:8:"is_merge";b:1;s:10:"save_local";b:0;}s:4:"data";a:3:{s:5:"doing";s:6:"backup";s:6:"backup";a:3:{s:5:"doing";s:12:"backup_merge";s:8:"progress";i:100;s:7:"sub_job";a:7:{s:9:"backup_db";a:2:{s:8:"progress";s:30:"Backing up backup_db finished.";s:8:"job_data";a:0:{}}s:13:"backup_themes";a:2:{s:8:"progress";s:34:"Backing up backup_themes finished.";s:8:"job_data";a:0:{}}s:13:"backup_plugin";a:2:{s:8:"progress";s:34:"Backing up backup_plugin finished.";s:8:"job_data";a:0:{}}s:14:"backup_uploads";a:2:{s:8:"progress";s:35:"Backing up backup_uploads finished.";s:8:"job_data";a:0:{}}s:14:"backup_content";a:2:{s:8:"progress";s:35:"Backing up backup_content finished.";s:8:"job_data";a:0:{}}s:11:"backup_core";a:2:{s:8:"progress";s:32:"Backing up backup_core finished.";s:8:"job_data";a:0:{}}s:12:"backup_merge";a:2:{s:8:"progress";s:33:"Backing up backup_merge finished.";s:8:"job_data";a:0:{}}}}s:6:"upload";a:5:{s:5:"doing";s:0:"";s:8:"finished";i:0;s:8:"progress";i:0;s:8:"job_data";a:0:{}s:7:"sub_job";a:0:{}}}s:4:"jobs";a:7:{i:0;a:8:{s:11:"backup_type";s:9:"backup_db";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:16:"mysql_file_index";i:2;s:8:"sub_jobs";a:21:{s:14:"wp_cky_cookies";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:14:"wp_cky_cookies";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:11:"wp_e_events";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_e_events";s:4:"size";i:16384;s:4:"rows";s:1:"0";}s:24:"wp_cky_cookie_categories";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:24:"wp_cky_cookie_categories";s:4:"size";i:32768;s:4:"rows";s:1:"5";}s:8:"wp_links";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_links";s:4:"size";i:32768;s:4:"rows";s:1:"0";}s:21:"wp_term_relationships";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:21:"wp_term_relationships";s:4:"size";i:32768;s:4:"rows";s:1:"8";}s:19:"wp_yoast_migrations";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:19:"wp_yoast_migrations";s:4:"size";i:32768;s:4:"rows";s:2:"24";}s:14:"wp_cky_banners";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:14:"wp_cky_banners";s:4:"size";i:49152;s:4:"rows";s:1:"2";}s:14:"wp_commentmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:14:"wp_commentmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}s:16:"wp_term_taxonomy";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:16:"wp_term_taxonomy";s:4:"size";i:49152;s:4:"rows";s:1:"2";}s:11:"wp_termmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_termmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}s:8:"wp_terms";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_terms";s:4:"size";i:49152;s:4:"rows";s:1:"2";}s:11:"wp_usermeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_usermeta";s:4:"size";i:49152;s:4:"rows";s:2:"25";}s:21:"wp_yoast_primary_term";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:21:"wp_yoast_primary_term";s:4:"size";i:49152;s:4:"rows";s:1:"0";}s:18:"wp_yoast_seo_links";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:18:"wp_yoast_seo_links";s:4:"size";i:49152;s:4:"rows";s:2:"84";}s:8:"wp_users";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_users";s:4:"size";i:65536;s:4:"rows";s:1:"0";}s:28:"wp_yoast_indexable_hierarchy";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:28:"wp_yoast_indexable_hierarchy";s:4:"size";i:65536;s:4:"rows";s:1:"4";}s:11:"wp_comments";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_comments";s:4:"size";i:98304;s:4:"rows";s:1:"0";}s:18:"wp_yoast_indexable";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:18:"wp_yoast_indexable";s:4:"size";i:114688;s:4:"rows";s:1:"9";}s:10:"wp_options";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:10:"wp_options";s:4:"size";i:3244032;s:4:"rows";s:3:"322";}s:8:"wp_posts";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:8:"wp_posts";s:4:"size";i:6946816;s:4:"rows";s:3:"503";}s:11:"wp_postmeta";a:6:{s:5:"index";i:0;s:8:"finished";i:0;s:7:"created";i:0;s:4:"name";s:11:"wp_postmeta";s:4:"size";i:14483456;s:4:"rows";s:4:"4083";}}s:16:"mysql_dump_files";a:1:{i:0;s:75:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46.part001.sql";}s:8:"zip_file";a:1:{s:77:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_db.zip";a:2:{s:8:"filename";s:77:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_db.zip";s:8:"finished";i:1;}}}i:1;a:6:{s:11:"backup_type";s:13:"backup_themes";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:1022;s:8:"zip_file";a:1:{s:81:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_themes.zip";a:2:{s:8:"filename";s:81:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_themes.zip";s:8:"finished";i:1;}}}i:2;a:6:{s:11:"backup_type";s:13:"backup_plugin";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:5969;s:8:"zip_file";a:1:{s:81:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_plugin.zip";a:2:{s:8:"filename";s:81:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_plugin.zip";s:8:"finished";i:1;}}}i:3;a:6:{s:11:"backup_type";s:14:"backup_uploads";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:4;s:5:"index";i:1080;s:8:"zip_file";a:4:{s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part001.zip";a:3:{s:8:"filename";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part001.zip";s:8:"finished";i:1;s:4:"json";a:5:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";}}s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part002.zip";a:3:{s:8:"filename";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part002.zip";s:8:"finished";i:1;s:4:"json";a:5:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";}}s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part003.zip";a:3:{s:8:"filename";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part003.zip";s:8:"finished";i:1;s:4:"json";a:5:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";}}s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part004.zip";a:3:{s:8:"filename";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part004.zip";s:8:"finished";i:1;s:4:"json";a:5:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";}}}}i:4;a:6:{s:11:"backup_type";s:14:"backup_content";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:199;s:8:"zip_file";a:1:{s:82:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_content.zip";a:2:{s:8:"filename";s:82:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_content.zip";s:8:"finished";i:1;}}}i:5;a:6:{s:11:"backup_type";s:11:"backup_core";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:1;s:5:"index";i:2679;s:8:"zip_file";a:1:{s:79:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_core.zip";a:2:{s:8:"filename";s:79:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_core.zip";s:8:"finished";i:1;}}}i:6;a:7:{s:11:"backup_type";s:12:"backup_merge";s:8:"finished";i:1;s:8:"progress";i:0;s:10:"file_index";i:5;s:10:"child_file";a:3:{s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part004.zip";a:6:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part004.zip";}s:82:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_content.zip";a:6:{s:9:"file_type";s:10:"wp-content";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_content.part001.zip";}s:79:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_core.zip";a:6:{s:9:"file_type";s:7:"wp-core";s:12:"include_path";a:2:{i:0;s:11:"wp-includes";i:1;s:8:"wp-admin";}s:7:"wp_core";i:1;s:9:"root_flag";s:4:"root";s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:4:"file";s:87:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_core.part001.zip";}}s:5:"index";i:9;s:8:"zip_file";a:5:{s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part001.zip";a:3:{s:8:"filename";s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part001.zip";s:8:"finished";i:1;s:4:"json";a:7:{s:9:"has_child";i:1;s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:10:"child_file";a:3:{s:77:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_db.zip";a:11:{s:5:"files";a:1:{i:0;s:77:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_db.sql";}s:6:"tables";a:21:{i:0;a:3:{s:4:"name";s:14:"wp_cky_cookies";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:1;a:3:{s:4:"name";s:11:"wp_e_events";s:4:"size";i:16384;s:4:"rows";s:1:"0";}i:2;a:3:{s:4:"name";s:24:"wp_cky_cookie_categories";s:4:"size";i:32768;s:4:"rows";s:1:"5";}i:3;a:3:{s:4:"name";s:8:"wp_links";s:4:"size";i:32768;s:4:"rows";s:1:"0";}i:4;a:3:{s:4:"name";s:21:"wp_term_relationships";s:4:"size";i:32768;s:4:"rows";s:1:"8";}i:5;a:3:{s:4:"name";s:19:"wp_yoast_migrations";s:4:"size";i:32768;s:4:"rows";s:2:"24";}i:6;a:3:{s:4:"name";s:14:"wp_cky_banners";s:4:"size";i:49152;s:4:"rows";s:1:"2";}i:7;a:3:{s:4:"name";s:14:"wp_commentmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}i:8;a:3:{s:4:"name";s:16:"wp_term_taxonomy";s:4:"size";i:49152;s:4:"rows";s:1:"2";}i:9;a:3:{s:4:"name";s:11:"wp_termmeta";s:4:"size";i:49152;s:4:"rows";s:1:"0";}i:10;a:3:{s:4:"name";s:8:"wp_terms";s:4:"size";i:49152;s:4:"rows";s:1:"2";}i:11;a:3:{s:4:"name";s:11:"wp_usermeta";s:4:"size";i:49152;s:4:"rows";s:2:"25";}i:12;a:3:{s:4:"name";s:21:"wp_yoast_primary_term";s:4:"size";i:49152;s:4:"rows";s:1:"0";}i:13;a:3:{s:4:"name";s:18:"wp_yoast_seo_links";s:4:"size";i:49152;s:4:"rows";s:2:"84";}i:14;a:3:{s:4:"name";s:8:"wp_users";s:4:"size";i:65536;s:4:"rows";s:1:"0";}i:15;a:3:{s:4:"name";s:28:"wp_yoast_indexable_hierarchy";s:4:"size";i:65536;s:4:"rows";s:1:"4";}i:16;a:3:{s:4:"name";s:11:"wp_comments";s:4:"size";i:98304;s:4:"rows";s:1:"0";}i:17;a:3:{s:4:"name";s:18:"wp_yoast_indexable";s:4:"size";i:114688;s:4:"rows";s:1:"9";}i:18;a:3:{s:4:"name";s:10:"wp_options";s:4:"size";i:3244032;s:4:"rows";s:3:"322";}i:19;a:3:{s:4:"name";s:8:"wp_posts";s:4:"size";i:6946816;s:4:"rows";s:3:"503";}i:20;a:3:{s:4:"name";s:11:"wp_postmeta";s:4:"size";i:14483456;s:4:"rows";s:4:"4083";}}s:7:"dump_db";i:1;s:9:"file_type";s:9:"databases";s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:14:"find_zero_date";i:1;s:4:"file";s:85:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_db.part001.zip";}s:81:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_themes.zip";a:7:{s:9:"file_type";s:6:"themes";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:6:"themes";a:1:{s:7:"oceanwp";a:1:{s:4:"slug";s:7:"oceanwp";}}s:4:"file";s:89:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_themes.part001.zip";}s:81:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_plugin.zip";a:7:{s:9:"file_type";s:6:"plugin";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:6:"plugin";a:11:{s:15:"cookie-law-info";a:1:{s:4:"slug";s:15:"cookie-law-info";}s:9:"elementor";a:1:{s:4:"slug";s:9:"elementor";}s:23:"header-footer-elementor";a:1:{s:4:"slug";s:23:"header-footer-elementor";}s:13:"elements-plus";a:1:{s:4:"slug";s:13:"elements-plus";}s:26:"google-language-translator";a:1:{s:4:"slug";s:26:"google-language-translator";}s:10:"gtranslate";a:1:{s:4:"slug";s:10:"gtranslate";}s:15:"litespeed-cache";a:1:{s:4:"slug";s:15:"litespeed-cache";}s:11:"ocean-extra";a:1:{s:4:"slug";s:11:"ocean-extra";}s:11:"updraftplus";a:1:{s:4:"slug";s:11:"updraftplus";}s:16:"wp-fastest-cache";a:1:{s:4:"slug";s:16:"wp-fastest-cache";}s:13:"wordpress-seo";a:1:{s:4:"slug";s:13:"wordpress-seo";}}s:4:"file";s:89:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_plugin.part001.zip";}}}}s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part002.zip";a:3:{s:8:"filename";s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part002.zip";s:8:"finished";i:1;s:4:"json";a:7:{s:9:"has_child";i:1;s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:10:"child_file";a:1:{s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part001.zip";a:6:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part001.zip";}}}}s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part003.zip";a:3:{s:8:"filename";s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part003.zip";s:8:"finished";i:1;s:4:"json";a:7:{s:9:"has_child";i:1;s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:10:"child_file";a:1:{s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part002.zip";a:6:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part002.zip";}}}}s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part004.zip";a:3:{s:8:"filename";s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part004.zip";s:8:"finished";i:1;s:4:"json";a:7:{s:9:"has_child";i:1;s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:10:"child_file";a:1:{s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part003.zip";a:6:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part003.zip";}}}}s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part005.zip";a:3:{s:8:"filename";s:86:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_all.part005.zip";s:8:"finished";i:1;s:4:"json";a:7:{s:9:"has_child";i:1;s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:9:"root_flag";s:6:"custom";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:10:"child_file";a:3:{s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part004.zip";a:6:{s:9:"file_type";s:6:"upload";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_uploads.part004.zip";}s:82:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_content.zip";a:6:{s:9:"file_type";s:10:"wp-content";s:9:"root_flag";s:10:"wp-content";s:11:"php_version";s:6:"8.1.23";s:13:"mysql_version";s:6:"8.0.16";s:10:"wp_version";s:5:"6.6.1";s:4:"file";s:90:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_content.part001.zip";}s:79:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_core.zip";a:6:{s:9:"file_type";s:7:"wp-core";s:12:"include_path";a:2:{i:0;s:11:"wp-includes";i:1;s:8:"wp-admin";}s:7:"wp_core";i:1;s:9:"root_flag";s:4:"root";s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:4:"file";s:87:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46_backup_core.part001.zip";}}}}}}}s:12:"dump_setting";a:14:{s:8:"database";s:5:"local";s:4:"host";s:9:"localhost";s:4:"user";s:4:"root";s:4:"pass";s:4:"root";s:8:"site_url";s:31:"http://ferme-de-chassagne.local";s:8:"home_url";s:31:"http://ferme-de-chassagne.local";s:11:"content_url";s:42:"http://ferme-de-chassagne.local/wp-content";s:6:"prefix";s:3:"wp_";s:17:"db_connect_method";s:4:"wpdb";s:11:"file_prefix";s:63:"ferme-de-chassagne.local_wpvivid-66a121ef4f40e_2024-07-24-15-46";s:4:"path";s:82:"C:\\Users\\mathi\\Local Sites\\ferme-de-chassagne\\app\\public/wp-content/wpvividbackups";s:13:"max_file_size";i:209715200;s:14:"exclude-tables";a:6:{i:0;s:14:"wp_wpvivid_log";i:1;s:28:"wp_wpvivid_increment_big_ids";i:2;s:18:"wp_wpvivid_options";i:3;s:22:"wp_wpvivid_record_task";i:4;s:19:"wp_wpvivid_merge_db";i:5;s:20:"wp_wpvivid_merge_ids";}s:14:"include-tables";a:0:{}}}','auto');
INSERT INTO `wp_options` VALUES (1413,'updraft_combine_jobs_around','1724449418','on');
INSERT INTO `wp_options` VALUES (1438,'_site_transient_timeout_theme_roots','1724147471','off');
INSERT INTO `wp_options` VALUES (1439,'_site_transient_theme_roots','a:1:{s:7:"oceanwp";s:7:"/themes";}','off');
INSERT INTO `wp_options` VALUES (1442,'_site_transient_update_core','O:8:"stdClass":4:{s:7:"updates";a:1:{i:0;O:8:"stdClass":10:{s:8:"response";s:6:"latest";s:8:"download";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.1.zip";s:6:"locale";s:5:"fr_FR";s:8:"packages";O:8:"stdClass":5:{s:4:"full";s:65:"https://downloads.wordpress.org/release/fr_FR/wordpress-6.6.1.zip";s:10:"no_content";s:0:"";s:11:"new_bundled";s:0:"";s:7:"partial";s:0:"";s:8:"rollback";s:0:"";}s:7:"current";s:5:"6.6.1";s:7:"version";s:5:"6.6.1";s:11:"php_version";s:5:"7.0.0";s:13:"mysql_version";s:3:"5.0";s:11:"new_bundled";s:3:"6.4";s:15:"partial_version";s:0:"";}}s:12:"last_checked";i:1724145851;s:15:"version_checked";s:5:"6.6.1";s:12:"translations";a:0:{}}','off');
INSERT INTO `wp_options` VALUES (1445,'_site_transient_timeout_php_check_18f908370f4cb169b20964c7203d6110','1724750476','off');
INSERT INTO `wp_options` VALUES (1446,'_site_transient_php_check_18f908370f4cb169b20964c7203d6110','a:5:{s:19:"recommended_version";s:3:"7.4";s:15:"minimum_version";s:6:"7.2.24";s:12:"is_supported";b:1;s:9:"is_secure";b:1;s:13:"is_acceptable";b:1;}','off');
INSERT INTO `wp_options` VALUES (1447,'_transient_timeout_elementor_remote_info_api_data_3.23.2','1724188877','off');
INSERT INTO `wp_options` VALUES (1448,'_transient_elementor_remote_info_api_data_3.23.2','a:4:{s:9:"timestamp";s:10:"1724143793";s:14:"upgrade_notice";a:3:{s:7:"version";s:5:"2.0.0";s:7:"message";s:0:"";s:11:"update_link";s:0:"";}s:11:"pro_widgets";a:82:{i:0;a:4:{s:4:"name";s:6:"search";s:5:"title";s:6:"Search";s:4:"icon";s:17:"eicon-site-search";s:10:"categories";s:16:"["pro-elements"]";}i:1;a:4:{s:4:"name";s:5:"posts";s:5:"title";s:5:"Posts";s:4:"icon";s:15:"eicon-post-list";s:10:"categories";s:16:"["pro-elements"]";}i:2;a:4:{s:4:"name";s:9:"portfolio";s:5:"title";s:9:"Portfolio";s:4:"icon";s:18:"eicon-gallery-grid";s:10:"categories";s:16:"["pro-elements"]";}i:3;a:4:{s:4:"name";s:17:"link-in-bio-var-2";s:5:"title";s:7:"Classic";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:4;a:4:{s:4:"name";s:9:"mega-menu";s:5:"title";s:4:"Menu";s:4:"icon";s:15:"eicon-mega-menu";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:5;a:4:{s:4:"name";s:17:"link-in-bio-var-3";s:5:"title";s:8:"Showcase";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:6;a:4:{s:4:"name";s:4:"form";s:5:"title";s:4:"Form";s:4:"icon";s:21:"eicon-form-horizontal";s:10:"categories";s:16:"["pro-elements"]";}i:7;a:4:{s:4:"name";s:17:"link-in-bio-var-4";s:5:"title";s:5:"Links";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:8;a:4:{s:4:"name";s:9:"loop-grid";s:5:"title";s:9:"Loop Grid";s:4:"icon";s:18:"eicon-loop-builder";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:9;a:4:{s:4:"name";s:17:"link-in-bio-var-5";s:5:"title";s:8:"Services";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:10;a:4:{s:4:"name";s:13:"loop-carousel";s:5:"title";s:13:"Loop Carousel";s:4:"icon";s:19:"eicon-carousel-loop";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:11;a:4:{s:4:"name";s:17:"link-in-bio-var-6";s:5:"title";s:9:"Portfolio";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:12;a:4:{s:4:"name";s:7:"gallery";s:5:"title";s:7:"Gallery";s:4:"icon";s:23:"eicon-gallery-justified";s:10:"categories";s:16:"["pro-elements"]";}i:13;a:4:{s:4:"name";s:17:"link-in-bio-var-7";s:5:"title";s:13:"Business Card";s:4:"icon";s:19:"eicon-site-identity";s:10:"categories";s:15:"["link-in-bio"]";}i:14;a:4:{s:4:"name";s:17:"animated-headline";s:5:"title";s:17:"Animated Headline";s:4:"icon";s:23:"eicon-animated-headline";s:10:"categories";s:16:"["pro-elements"]";}i:15;a:4:{s:4:"name";s:10:"price-list";s:5:"title";s:10:"Price List";s:4:"icon";s:16:"eicon-price-list";s:10:"categories";s:16:"["pro-elements"]";}i:16;a:4:{s:4:"name";s:11:"price-table";s:5:"title";s:11:"Price Table";s:4:"icon";s:17:"eicon-price-table";s:10:"categories";s:16:"["pro-elements"]";}i:17;a:4:{s:4:"name";s:8:"flip-box";s:5:"title";s:8:"Flip Box";s:4:"icon";s:14:"eicon-flip-box";s:10:"categories";s:16:"["pro-elements"]";}i:18;a:4:{s:4:"name";s:14:"call-to-action";s:5:"title";s:14:"Call to Action";s:4:"icon";s:20:"eicon-image-rollover";s:10:"categories";s:16:"["pro-elements"]";}i:19;a:4:{s:4:"name";s:14:"media-carousel";s:5:"title";s:14:"Media Carousel";s:4:"icon";s:20:"eicon-media-carousel";s:10:"categories";s:16:"["pro-elements"]";}i:20;a:4:{s:4:"name";s:15:"nested-carousel";s:5:"title";s:8:"Carousel";s:4:"icon";s:21:"eicon-nested-carousel";s:10:"categories";s:16:"["pro-elements"]";}i:21;a:4:{s:4:"name";s:10:"off-canvas";s:5:"title";s:10:"Off-Canvas";s:4:"icon";s:16:"eicon-off-canvas";s:10:"categories";s:16:"["pro-elements"]";}i:22;a:4:{s:4:"name";s:9:"countdown";s:5:"title";s:9:"Countdown";s:4:"icon";s:15:"eicon-countdown";s:10:"categories";s:16:"["pro-elements"]";}i:23;a:4:{s:4:"name";s:13:"share-buttons";s:5:"title";s:13:"Share Buttons";s:4:"icon";s:11:"eicon-share";s:10:"categories";s:16:"["pro-elements"]";}i:24;a:4:{s:4:"name";s:10:"blockquote";s:5:"title";s:10:"Blockquote";s:4:"icon";s:16:"eicon-blockquote";s:10:"categories";s:16:"["pro-elements"]";}i:25;a:4:{s:4:"name";s:6:"lottie";s:5:"title";s:6:"Lottie";s:4:"icon";s:12:"eicon-lottie";s:10:"categories";s:16:"["pro-elements"]";}i:26;a:4:{s:4:"name";s:7:"hotspot";s:5:"title";s:7:"Hotspot";s:4:"icon";s:19:"eicon-image-hotspot";s:10:"categories";s:16:"["pro-elements"]";}i:27;a:4:{s:4:"name";s:13:"paypal-button";s:5:"title";s:13:"PayPal Button";s:4:"icon";s:19:"eicon-paypal-button";s:10:"categories";s:16:"["pro-elements"]";}i:28;a:4:{s:4:"name";s:14:"code-highlight";s:5:"title";s:14:"Code Highlight";s:4:"icon";s:20:"eicon-code-highlight";s:10:"categories";s:16:"["pro-elements"]";}i:29;a:4:{s:4:"name";s:14:"video-playlist";s:5:"title";s:14:"Video Playlist";s:4:"icon";s:20:"eicon-video-playlist";s:10:"categories";s:16:"["pro-elements"]";}i:30;a:4:{s:4:"name";s:8:"template";s:5:"title";s:8:"Template";s:4:"icon";s:19:"eicon-document-file";s:10:"categories";s:16:"["pro-elements"]";}i:31;a:4:{s:4:"name";s:13:"stripe-button";s:5:"title";s:13:"Stripe Button";s:4:"icon";s:19:"eicon-stripe-button";s:10:"categories";s:16:"["pro-elements"]";}i:32;a:4:{s:4:"name";s:16:"progress-tracker";s:5:"title";s:16:"Progress Tracker";s:4:"icon";s:22:"eicon-progress-tracker";s:10:"categories";s:40:"["pro-elements","theme-elements-single"]";}i:33;a:4:{s:4:"name";s:8:"nav-menu";s:5:"title";s:8:"Nav Menu";s:4:"icon";s:14:"eicon-nav-menu";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:34;a:4:{s:4:"name";s:17:"table-of-contents";s:5:"title";s:17:"Table of Contents";s:4:"icon";s:23:"eicon-table-of-contents";s:10:"categories";s:33:"["pro-elements","theme-elements"]";}i:35;a:4:{s:4:"name";s:5:"login";s:5:"title";s:5:"Login";s:4:"icon";s:15:"eicon-lock-user";s:10:"categories";s:16:"["pro-elements"]";}i:36;a:4:{s:4:"name";s:6:"slides";s:5:"title";s:6:"Slides";s:4:"icon";s:12:"eicon-slides";s:10:"categories";s:16:"["pro-elements"]";}i:37;a:4:{s:4:"name";s:20:"testimonial-carousel";s:5:"title";s:20:"Testimonial Carousel";s:4:"icon";s:26:"eicon-testimonial-carousel";s:10:"categories";s:16:"["pro-elements"]";}i:38;a:4:{s:4:"name";s:7:"reviews";s:5:"title";s:7:"Reviews";s:4:"icon";s:12:"eicon-review";s:10:"categories";s:16:"["pro-elements"]";}i:39;a:4:{s:4:"name";s:15:"facebook-button";s:5:"title";s:15:"Facebook Button";s:4:"icon";s:23:"eicon-facebook-like-box";s:10:"categories";s:16:"["pro-elements"]";}i:40;a:4:{s:4:"name";s:17:"facebook-comments";s:5:"title";s:17:"Facebook Comments";s:4:"icon";s:23:"eicon-facebook-comments";s:10:"categories";s:16:"["pro-elements"]";}i:41;a:4:{s:4:"name";s:14:"facebook-embed";s:5:"title";s:14:"Facebook Embed";s:4:"icon";s:14:"eicon-fb-embed";s:10:"categories";s:16:"["pro-elements"]";}i:42;a:4:{s:4:"name";s:13:"facebook-page";s:5:"title";s:13:"Facebook Page";s:4:"icon";s:13:"eicon-fb-feed";s:10:"categories";s:16:"["pro-elements"]";}i:43;a:4:{s:4:"name";s:15:"theme-site-logo";s:5:"title";s:9:"Site Logo";s:4:"icon";s:15:"eicon-site-logo";s:10:"categories";s:18:"["theme-elements"]";}i:44;a:4:{s:4:"name";s:16:"theme-site-title";s:5:"title";s:10:"Site Title";s:4:"icon";s:16:"eicon-site-title";s:10:"categories";s:18:"["theme-elements"]";}i:45;a:4:{s:4:"name";s:16:"theme-page-title";s:5:"title";s:10:"Page Title";s:4:"icon";s:19:"eicon-archive-title";s:10:"categories";s:18:"["theme-elements"]";}i:46;a:4:{s:4:"name";s:16:"theme-post-title";s:5:"title";s:10:"Post Title";s:4:"icon";s:16:"eicon-post-title";s:10:"categories";s:18:"["theme-elements"]";}i:47;a:4:{s:4:"name";s:18:"theme-post-excerpt";s:5:"title";s:12:"Post Excerpt";s:4:"icon";s:18:"eicon-post-excerpt";s:10:"categories";s:18:"["theme-elements"]";}i:48;a:4:{s:4:"name";s:25:"theme-post-featured-image";s:5:"title";s:14:"Featured Image";s:4:"icon";s:20:"eicon-featured-image";s:10:"categories";s:18:"["theme-elements"]";}i:49;a:4:{s:4:"name";s:19:"theme-archive-title";s:5:"title";s:13:"Archive Title";s:4:"icon";s:19:"eicon-archive-title";s:10:"categories";s:18:"["theme-elements"]";}i:50;a:4:{s:4:"name";s:13:"archive-posts";s:5:"title";s:13:"Archive Posts";s:4:"icon";s:19:"eicon-archive-posts";s:10:"categories";s:18:"["theme-elements"]";}i:51;a:4:{s:4:"name";s:10:"author-box";s:5:"title";s:10:"Author Box";s:4:"icon";s:12:"eicon-person";s:10:"categories";s:18:"["theme-elements"]";}i:52;a:4:{s:4:"name";s:13:"post-comments";s:5:"title";s:13:"Post Comments";s:4:"icon";s:14:"eicon-comments";s:10:"categories";s:18:"["theme-elements"]";}i:53;a:4:{s:4:"name";s:15:"post-navigation";s:5:"title";s:15:"Post Navigation";s:4:"icon";s:21:"eicon-post-navigation";s:10:"categories";s:18:"["theme-elements"]";}i:54;a:4:{s:4:"name";s:9:"post-info";s:5:"title";s:9:"Post Info";s:4:"icon";s:15:"eicon-post-info";s:10:"categories";s:18:"["theme-elements"]";}i:55;a:4:{s:4:"name";s:7:"sitemap";s:5:"title";s:7:"Sitemap";s:4:"icon";s:13:"eicon-sitemap";s:10:"categories";s:18:"["theme-elements"]";}i:56;a:4:{s:4:"name";s:11:"breadcrumbs";s:5:"title";s:11:"Breadcrumbs";s:4:"icon";s:11:"eicon-yoast";s:10:"categories";s:18:"["theme-elements"]";}i:57;a:4:{s:4:"name";s:21:"woocommerce-menu-cart";s:5:"title";s:9:"Menu Cart";s:4:"icon";s:10:"eicon-cart";s:10:"categories";s:41:"["theme-elements","woocommerce-elements"]";}i:58;a:4:{s:4:"name";s:19:"wc-archive-products";s:5:"title";s:16:"Archive Products";s:4:"icon";s:14:"eicon-products";s:10:"categories";s:24:"["woocommerce-elements"]";}i:59;a:4:{s:4:"name";s:31:"woocommerce-archive-description";s:5:"title";s:19:"Archive Description";s:4:"icon";s:25:"eicon-product-description";s:10:"categories";s:24:"["woocommerce-elements"]";}i:60;a:4:{s:4:"name";s:20:"woocommerce-products";s:5:"title";s:8:"Products";s:4:"icon";s:14:"eicon-products";s:10:"categories";s:24:"["woocommerce-elements"]";}i:61;a:4:{s:4:"name";s:22:"woocommerce-breadcrumb";s:5:"title";s:23:"WooCommerce Breadcrumbs";s:4:"icon";s:25:"eicon-product-breadcrumbs";s:10:"categories";s:24:"["woocommerce-elements"]";}i:62;a:4:{s:4:"name";s:14:"wc-add-to-cart";s:5:"title";s:18:"Custom Add To Cart";s:4:"icon";s:17:"eicon-woocommerce";s:10:"categories";s:24:"["woocommerce-elements"]";}i:63;a:4:{s:4:"name";s:11:"wc-elements";s:5:"title";s:17:"WooCommerce Pages";s:4:"icon";s:19:"eicon-product-pages";s:10:"categories";s:24:"["woocommerce-elements"]";}i:64;a:4:{s:4:"name";s:13:"wc-categories";s:5:"title";s:18:"Product Categories";s:4:"icon";s:24:"eicon-product-categories";s:10:"categories";s:24:"["woocommerce-elements"]";}i:65;a:4:{s:4:"name";s:25:"woocommerce-product-title";s:5:"title";s:13:"Product Title";s:4:"icon";s:19:"eicon-product-title";s:10:"categories";s:24:"["woocommerce-elements"]";}i:66;a:4:{s:4:"name";s:26:"woocommerce-product-images";s:5:"title";s:14:"Product Images";s:4:"icon";s:20:"eicon-product-images";s:10:"categories";s:24:"["woocommerce-elements"]";}i:67;a:4:{s:4:"name";s:25:"woocommerce-product-price";s:5:"title";s:13:"Product Price";s:4:"icon";s:19:"eicon-product-price";s:10:"categories";s:24:"["woocommerce-elements"]";}i:68;a:4:{s:4:"name";s:31:"woocommerce-product-add-to-cart";s:5:"title";s:11:"Add To Cart";s:4:"icon";s:25:"eicon-product-add-to-cart";s:10:"categories";s:24:"["woocommerce-elements"]";}i:69;a:4:{s:4:"name";s:26:"woocommerce-product-rating";s:5:"title";s:14:"Product Rating";s:4:"icon";s:20:"eicon-product-rating";s:10:"categories";s:24:"["woocommerce-elements"]";}i:70;a:4:{s:4:"name";s:25:"woocommerce-product-stock";s:5:"title";s:13:"Product Stock";s:4:"icon";s:19:"eicon-product-stock";s:10:"categories";s:24:"["woocommerce-elements"]";}i:71;a:4:{s:4:"name";s:24:"woocommerce-product-meta";s:5:"title";s:12:"Product Meta";s:4:"icon";s:18:"eicon-product-meta";s:10:"categories";s:24:"["woocommerce-elements"]";}i:72;a:4:{s:4:"name";s:37:"woocommerce-product-short-description";s:5:"title";s:17:"Short Description";s:4:"icon";s:25:"eicon-product-description";s:10:"categories";s:24:"["woocommerce-elements"]";}i:73;a:4:{s:4:"name";s:29:"woocommerce-product-data-tabs";s:5:"title";s:17:"Product Data Tabs";s:4:"icon";s:18:"eicon-product-tabs";s:10:"categories";s:24:"["woocommerce-elements"]";}i:74;a:4:{s:4:"name";s:42:"woocommerce-product-additional-information";s:5:"title";s:22:"Additional Information";s:4:"icon";s:19:" eicon-product-info";s:10:"categories";s:24:"["woocommerce-elements"]";}i:75;a:4:{s:4:"name";s:27:"woocommerce-product-related";s:5:"title";s:15:"Product Related";s:4:"icon";s:21:"eicon-product-related";s:10:"categories";s:24:"["woocommerce-elements"]";}i:76;a:4:{s:4:"name";s:26:"woocommerce-product-upsell";s:5:"title";s:7:"Upsells";s:4:"icon";s:20:"eicon-product-upsell";s:10:"categories";s:24:"["woocommerce-elements"]";}i:77;a:4:{s:4:"name";s:25:"woocommerce-checkout-page";s:5:"title";s:8:"Checkout";s:4:"icon";s:14:"eicon-checkout";s:10:"categories";s:24:"["woocommerce-elements"]";}i:78;a:4:{s:4:"name";s:16:"woocommerce-cart";s:5:"title";s:4:"Cart";s:4:"icon";s:14:"eicon-woo-cart";s:10:"categories";s:24:"["woocommerce-elements"]";}i:79;a:4:{s:4:"name";s:22:"woocommerce-my-account";s:5:"title";s:10:"My Account";s:4:"icon";s:16:"eicon-my-account";s:10:"categories";s:24:"["woocommerce-elements"]";}i:80;a:4:{s:4:"name";s:28:"woocommerce-purchase-summary";s:5:"title";s:16:"Purchase Summary";s:4:"icon";s:22:"eicon-purchase-summary";s:10:"categories";s:24:"["woocommerce-elements"]";}i:81;a:4:{s:4:"name";s:19:"woocommerce-notices";s:5:"title";s:19:"WooCommerce Notices";s:4:"icon";s:25:"eicon-woocommerce-notices";s:10:"categories";s:24:"["woocommerce-elements"]";}}s:17:"canary_deployment";a:2:{s:11:"plugin_info";a:11:{s:2:"id";s:23:"w.org/plugins/elementor";s:4:"slug";s:9:"elementor";s:6:"plugin";s:23:"elementor/elementor.php";s:11:"new_version";s:5:"3.6.0";s:7:"package";s:58:"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip";s:3:"url";s:40:"https://wordpress.org/plugins/elementor/";s:5:"icons";a:3:{s:2:"2x";s:62:"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768";s:2:"1x";s:54:"https://ps.w.org/elementor/assets/icon.svg?rev=1426809";s:3:"svg";s:54:"https://ps.w.org/elementor/assets/icon.svg?rev=1426809";}s:7:"banners";a:2:{s:2:"2x";s:65:"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479";s:2:"1x";s:64:"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479";}s:11:"banners_rtl";a:0:{}s:6:"tested";s:5:"6.6.1";s:12:"requires_php";s:3:"5.6";}s:10:"conditions";a:0:{}}}','off');
INSERT INTO `wp_options` VALUES (1451,'_site_transient_timeout_browser_d90c91ba47074ebc106cbdef0c8105ed','1724750481','off');
INSERT INTO `wp_options` VALUES (1452,'_site_transient_browser_d90c91ba47074ebc106cbdef0c8105ed','a:10:{s:4:"name";s:7:"Firefox";s:7:"version";s:5:"129.0";s:8:"platform";s:7:"Windows";s:10:"update_url";s:32:"https://www.mozilla.org/firefox/";s:7:"img_src";s:44:"http://s.w.org/images/browsers/firefox.png?1";s:11:"img_src_ssl";s:45:"https://s.w.org/images/browsers/firefox.png?1";s:15:"current_version";s:2:"56";s:7:"upgrade";b:0;s:8:"insecure";b:0;s:6:"mobile";b:0;}','off');
INSERT INTO `wp_options` VALUES (1453,'_transient_timeout_feed_c8dc84948ab55424f034a4ced348e013','1724188882','off');
INSERT INTO `wp_options` VALUES (1454,'_transient_feed_c8dc84948ab55424f034a4ced348e013','a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:3:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"OceanWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:19:"https://oceanwp.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:34:"Free Multi-Purpose WordPress Theme";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Aug 2024 10:55:09 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"en-US";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:30:"https://wordpress.org/?v=6.5.5";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:72:"https://oceanwp.org/wp-content/uploads/2016/10/cropped-favicon-60x60.png";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:7:"OceanWP";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:19:"https://oceanwp.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:79:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:68:"Customize WordPress in a Breeze: OceanWP 4.0.0 &amp; New Core Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:61:"https://oceanwp.org/blog/customize-wordpress-new-core-update/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:69:"https://oceanwp.org/blog/customize-wordpress-new-core-update/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 09 Aug 2024 10:42:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:12:"Announcement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"Introducing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:6:"Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=643155";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1162:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/customize-wordpress-new-core-update/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2024/08/customize-wordpress-oceanwp-core-update-featured.png" width="1200" height="700" title="Customize WordPress in a Breeze: OceanWP 4.0.0 &#38; New Core Update" alt="Customize WordPress in a Breeze: OceanWP 4.0.0 &#38; New Core Update" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Following the blockbuster hits that were the OceanWP Metabox Settings core update in 2023, as well as our epic WordPress features release in 2024, we&#8217;re back in the spotlight with...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/customize-wordpress-new-core-update/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"OceanWP Team";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:531:"<p>Following the blockbuster hits that were the OceanWP Metabox Settings core update in 2023, as well as our epic WordPress features release in 2024, we&rsquo;re back in the spotlight with a completely new core update: an overhauled Customizer that&rsquo;ll help you customize WordPress in a breeze. We ditched the old playbook and crafted a Customizer that&rsquo;s as sleek as it is powerful, with a user interface&#8230;</p>\n<p><a href="https://oceanwp.org/blog/customize-wordpress-new-core-update/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:66:"https://oceanwp.org/blog/customize-wordpress-new-core-update/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:1;a:6:{s:4:"data";s:79:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:77:"14 Plugins to Consider when Creating a Booking or Appointment Booking Website";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:71:"https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:80:"https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Fri, 14 Jun 2024 09:22:44 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:7:"Plugins";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:7:"Reviews";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=643094";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1185:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2024/06/wordpress-booking-appointment-plugins-featured.png" width="1200" height="700" title="14 Plugins to Consider when Creating a Booking or Appointment Booking Website" alt="14 Plugins to Consider when Creating a Booking or Appointment Booking Website" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Do you want customers to book your services through a WordPress site? Are you looking to add a user account functionality to your booking website? For this purpose, we have...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:23:"﻿Anastasiia Usichenko";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:506:"<p>Do you want customers to book your services through a WordPress site? Are you looking to add a user account functionality to your booking website? For this purpose, we have collected 14 of the best plugins out there to help you achieve the goal. Keep reading to find the best fit. So, let&rsquo;s determine what should be on a functional booking site. First, it is the booking engine.</p>\n<p><a href="https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:76:"https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:2;a:6:{s:4:"data";s:76:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:72:"Start a 2024 Content Creation Revolution: New OceanWP WordPress Features";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:82:"https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:90:"https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 01 Apr 2024 07:02:55 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:11:"Introducing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=642864";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1206:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2024/04/new-oceanwp-2024-premium-features-update-wordpress.jpg" width="1200" height="700" title="Start a 2024 Content Creation Revolution: New OceanWP WordPress Features" alt="Start a 2024 Content Creation Revolution: New OceanWP WordPress Features" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Remember the Purchase Notifier or Popup Builder and other features we released at the end 2023 to supercharge your eCommerce game? Get ready to be wowed again! Spring has sprung...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:12:"OceanWP Team";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:534:"<p>Remember the Purchase Notifier or Popup Builder and other features we released at the end 2023 to supercharge your eCommerce game? Get ready to be wowed again! Spring has sprung and it&rsquo;s time to freshen up your websites. To help you achieve your digital blooming goals, we came up with a whole bouquet of new content creation WordPress features. Yes! We&rsquo;re talking about new premium&#8230;</p>\n<p><a href="https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:87:"https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:3;a:6:{s:4:"data";s:76:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:33:"WordPress Black Friday Deals 2023";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:59:"https://oceanwp.org/blog/wordpress-black-friday-deals-2023/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:67:"https://oceanwp.org/blog/wordpress-black-friday-deals-2023/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 21 Nov 2023 13:26:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:10:"Promotions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=642373";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1123:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/wordpress-black-friday-deals-2023/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2023/11/oceanwp-black-friday-2023-deals-promotions-featured-image.png" width="1200" height="700" title="WordPress Black Friday Deals 2023" alt="WordPress Black Friday Deals 2023" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Black Friday, the annual US shopping extravaganza which has become a global phenomenon, has extended its reach to the world of WordPress development and website management. For WordPress developers, freelancers,...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/wordpress-black-friday-deals-2023/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:504:"<p>Black Friday, the annual US shopping extravaganza which has become a global phenomenon, has extended its reach to the world of WordPress development and website management. For WordPress developers, freelancers, agencies but site owners as well, Black Friday represents a unique opportunity to strategically leverage deals and reap significant benefits. And the best part is, the Black Friday /</p>\n<p><a href="https://oceanwp.org/blog/wordpress-black-friday-deals-2023/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:64:"https://oceanwp.org/blog/wordpress-black-friday-deals-2023/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:4;a:6:{s:4:"data";s:76:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:64:"New Custom eCommerce Features to Boost Your Sales in 2023 / 2024";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:66:"https://oceanwp.org/blog/custom-ecommerce-features-to-boost-sales/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:75:"https://oceanwp.org/blog/custom-ecommerce-features-to-boost-sales/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 21 Sep 2023 08:15:10 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:11:"Introducing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=641145";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1184:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/custom-ecommerce-features-to-boost-sales/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2023/09/boost-sales-grow-business-ecommerce-features-woocommerce-elementor-oceanwp.png" width="1200" height="700" title="New Custom eCommerce Features to Boost Your Sales in 2023 / 2024" alt="New Custom eCommerce Features to Boost Your Sales in 2023 / 2024" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">In the always-evolving world of eCommerce, having the right tools at your disposal is crucial for success. Ocean eComm Treasure Box is a treasure trove of new features designed to...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/custom-ecommerce-features-to-boost-sales/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:521:"<p>In the always&#x2d;evolving world of eCommerce, having the right tools at your disposal is crucial for success. Ocean eComm Treasure Box is a treasure trove of new features designed to help boost your sales, increase conversions and streamline operations. The latest update is not just revolving around the Metabox Settings Makeover which we announced recently. It is a testament to our commitment&#8230;</p>\n<p><a href="https://oceanwp.org/blog/custom-ecommerce-features-to-boost-sales/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:71:"https://oceanwp.org/blog/custom-ecommerce-features-to-boost-sales/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"4";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:5;a:6:{s:4:"data";s:79:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:74:"Metabox Settings Makeover: WordPress Customization Power &amp; Flexibility";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://oceanwp.org/blog/metabox-settings-makeover-wordpress-customization/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:83:"https://oceanwp.org/blog/metabox-settings-makeover-wordpress-customization/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 14 Aug 2023 05:56:59 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:12:"Announcement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:11:"Introducing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:6:"Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=640990";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1200:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/metabox-settings-makeover-wordpress-customization/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2023/08/oceanwp-metabox-settings-makeover.png" width="1200" height="700" title="Metabox Settings Makeover: WordPress Customization Power &#038; Flexibility" alt="Metabox Settings Makeover: WordPress Customization Power &#038; Flexibility" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Calling all OceanWP users, WordPress developers and designers! We have some exciting news to share. After the launch of Ocean eComm Treasure Box, the perfect WooCommerce addon for custom eCommerce...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/metabox-settings-makeover-wordpress-customization/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:513:"<p>Calling all OceanWP users, WordPress developers and designers! We have some exciting news to share. After the launch of Ocean eComm Treasure Box, the perfect WooCommerce addon for custom eCommerce websites, as well as a series of small and other not so small improvements, we&rsquo;ve cooked up something big! We have revamped our Metabox Settings and gave this feature a major makeover.</p>\n<p><a href="https://oceanwp.org/blog/metabox-settings-makeover-wordpress-customization/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:80:"https://oceanwp.org/blog/metabox-settings-makeover-wordpress-customization/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:6;a:6:{s:4:"data";s:76:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:67:"OceanWP 2023 Special Delight – Create a Custom eCommerce Website!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:73:"https://oceanwp.org/blog/oceanwp-special-create-custom-ecommerce-website/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:82:"https://oceanwp.org/blog/oceanwp-special-create-custom-ecommerce-website/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 06 Feb 2023 04:05:21 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:12:"Announcement";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=639421";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1203:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/oceanwp-special-create-custom-ecommerce-website/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2023/01/ocean-ecomm-treasure-box-custom-ecommerce-website-announcement.jpg" width="1200" height="700" title="OceanWP 2023 Special Delight &#8211; Create a Custom eCommerce Website!" alt="OceanWP 2023 Special Delight &#8211; Create a Custom eCommerce Website!" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Now it&#8217;s official! It is with great happiness that we announce that your dream custom eCommerce website with OceanWP and an in-house tool is now a reality! If you&#8217;ve been...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/oceanwp-special-create-custom-ecommerce-website/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:514:"<p>Now it&rsquo;s official! It is with great happiness that we announce that your dream custom eCommerce website with OceanWP and an in&#x2d;house tool is now a reality! If you&rsquo;ve been following our progress during 2022, you know we have been announcing a brand new premium plugin since August. In the meantime, and as it so often happens, we actually started working on two new plugins.</p>\n<p><a href="https://oceanwp.org/blog/oceanwp-special-create-custom-ecommerce-website/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:78:"https://oceanwp.org/blog/oceanwp-special-create-custom-ecommerce-website/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:7;a:6:{s:4:"data";s:79:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:50:"OceanWP Northern Star Update: Welcome Adobe Fonts!";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:74:"https://oceanwp.org/blog/oceanwp-northern-star-update-welcome-adobe-fonts/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:83:"https://oceanwp.org/blog/oceanwp-northern-star-update-welcome-adobe-fonts/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Mon, 02 Jan 2023 06:08:15 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:3:{i:0;a:5:{s:4:"data";s:11:"Introducing";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:6:"Update";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:2;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=639392";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1160:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/oceanwp-northern-star-update-welcome-adobe-fonts/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2022/12/oceanwp-northern-star-update-adobe-fonts-integration-featured-image.jpg" width="1200" height="700" title="OceanWP Northern Star Update: Welcome Adobe Fonts!" alt="OceanWP Northern Star Update: Welcome Adobe Fonts!" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Throughout history, mariners have used the Northern Star aka Polaris as a reliable beacon that would guide them home. If you believe in Santa Clause, then you know this jolly...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/oceanwp-northern-star-update-welcome-adobe-fonts/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:538:"<p>Throughout history, mariners have used the Northern Star aka Polaris as a reliable beacon that would guide them home. If you believe in Santa Clause, then you know this jolly ol&rsquo; fellow in red still uses it for navigation to ensure he&rsquo;s on the right path As for OceanWP, we&rsquo;ve chosen to name this update release Northern Star not only because of the Holidays or because the Polaris itself&#8230;</p>\n<p><a href="https://oceanwp.org/blog/oceanwp-northern-star-update-welcome-adobe-fonts/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:79:"https://oceanwp.org/blog/oceanwp-northern-star-update-welcome-adobe-fonts/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:8;a:6:{s:4:"data";s:76:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:32:"OceanWP: The Year 2022 in Review";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:61:"https://oceanwp.org/blog/oceanwp-year-2022-review-2023-plans/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:69:"https://oceanwp.org/blog/oceanwp-year-2022-review-2023-plans/#respond";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Thu, 29 Dec 2022 10:44:34 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:7:"Reviews";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=639169";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1084:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/oceanwp-year-2022-review-2023-plans/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2022/12/oceanwp-2022-review-featured-image.png" width="1200" height="700" title="OceanWP: The Year 2022 in Review" alt="OceanWP: The Year 2022 in Review" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">It&#8217;s common knowledge &#8211; here at OceanWP we don&#8217;t look back otherwise we wouldn&#8217;t be able to move forward. But, reflecting on the soon-to-be past year helps shed light on...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/oceanwp-year-2022-review-2023-plans/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:549:"<p>It&rsquo;s common knowledge &ndash; here at OceanWP we don&rsquo;t look back otherwise we wouldn&rsquo;t be able to move forward. But, reflecting on the soon&#x2d;to&#x2d;be past year helps shed light on the most significant moments and make headway towards better features and products for OceanWP WordPress theme users. That being said, in this article we&rsquo;re going to review the highlights of all features and changes that&#8230;</p>\n<p><a href="https://oceanwp.org/blog/oceanwp-year-2022-review-2023-plans/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:66:"https://oceanwp.org/blog/oceanwp-year-2022-review-2023-plans/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"0";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}i:9;a:6:{s:4:"data";s:76:"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n					\n			\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:5:{s:0:"";a:7:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:60:"WordPress BFCM 2022: Best Deals &amp; News for OceanWP Users";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:75:"https://oceanwp.org/blog/wordpress-bfcm-2022-best-deals-news-oceanwp-users/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:84:"https://oceanwp.org/blog/wordpress-bfcm-2022-best-deals-news-oceanwp-users/#comments";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 15 Nov 2022 08:27:39 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:2:{i:0;a:5:{s:4:"data";s:10:"Promotions";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}i:1;a:5:{s:4:"data";s:9:"WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:29:"https://oceanwp.org/?p=638342";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:1131:"<p style="display: block; padding: 0 0 24px; margin: 0 !important;"><a href="https://oceanwp.org/blog/wordpress-bfcm-2022-best-deals-news-oceanwp-users/" target="_blank"><img src="https://oceanwp.org/wp-content/uploads/2022/11/bfcm-featured-image.png" width="1200" height="700" title="WordPress BFCM 2022: Best Deals &#038; News for OceanWP Users" alt="WordPress BFCM 2022: Best Deals &#038; News for OceanWP Users" style="width: 100%!important;"></a></p><p style="padding: 0 26px !important; margin: 0 !important;">Holidays are coming! But, before that, Black Friday and Cyber Monday deals are in order because the only thing better than Black Friday is Black Friday every day 😉 In...<p style="margin: 0!important;padding: 26px 0 0!important;"><a href="https://oceanwp.org/blog/wordpress-bfcm-2022-best-deals-news-oceanwp-users/" target="_blank" style="display: inline-block; padding: 10px 30px; color: #ffffff; background-color: #13aff0; border-radius: 30px; font-size: 13px; font-weight: bold; line-height: 1.4; text-transform: uppercase; text-align: center; text-decoration: none; letter-spacing: 1px;">Read More</a></p></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:13:"Lior Zelering";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:535:"<p>Holidays are coming! But, before that, Black Friday and Cyber Monday deals are in order because the only thing better than Black Friday is Black Friday every day In this year&rsquo;s BFCM presentation, we&rsquo;ve gathered all season deals offered by OceanWP partners. Upgrade hosting or get the tools you need to enhance your WordPress website to the max. As always, we&rsquo;ll start with yours truly&#8230;</p>\n<p><a href="https://oceanwp.org/blog/wordpress-bfcm-2022-best-deals-news-oceanwp-users/" rel="nofollow">Source</a></p>";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:36:"http://wellformedweb.org/CommentAPI/";a:1:{s:10:"commentRss";a:1:{i:0;a:5:{s:4:"data";s:80:"https://oceanwp.org/blog/wordpress-bfcm-2022-best-deals-news-oceanwp-users/feed/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:38:"http://purl.org/rss/1.0/modules/slash/";a:1:{s:8:"comments";a:1:{i:0;a:5:{s:4:"data";s:1:"1";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}s:27:"http://www.w3.org/2005/Atom";a:1:{s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:1:{s:0:"";a:3:{s:4:"href";s:25:"https://oceanwp.org/feed/";s:3:"rel";s:4:"self";s:4:"type";s:19:"application/rss+xml";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:44:"http://purl.org/rss/1.0/modules/syndication/";a:2:{s:12:"updatePeriod";a:1:{i:0;a:5:{s:4:"data";s:9:"\n	hourly	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:15:"updateFrequency";a:1:{i:0;a:5:{s:4:"data";s:4:"\n	1	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}}}}}}}s:4:"type";i:128;s:7:"headers";O:48:"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary":1:{s:7:"\0*\0data";a:33:{s:4:"date";s:29:"Tue, 20 Aug 2024 09:21:22 GMT";s:12:"content-type";s:34:"application/rss+xml; charset=UTF-8";s:28:"access-control-allow-methods";s:18:"GET,POST, GET,POST";s:28:"access-control-allow-headers";s:56:"Content-Type, Authorization, Content-Type, Authorization";s:23:"content-security-policy";s:54:"upgrade-insecure-requests;, upgrade-insecure-requests;";s:28:"cross-origin-embedder-policy";s:66:"unsafe-none; report-to=\'default\', unsafe-none; report-to=\'default\'";s:35:"content-security-policy-report-only";s:26:"upgrade-insecure-requests;";s:40:"cross-origin-embedder-policy-report-only";s:66:"unsafe-none; report-to=\'default\', unsafe-none; report-to=\'default\'";s:26:"cross-origin-opener-policy";s:24:"unsafe-none, unsafe-none";s:38:"cross-origin-opener-policy-report-only";s:66:"unsafe-none; report-to=\'default\', unsafe-none; report-to=\'default\'";s:28:"cross-origin-resource-policy";s:26:"cross-origin, cross-origin";s:18:"permissions-policy";s:740:"accelerometer=(), autoplay=(), camera=(), cross-origin-isolated=(), display-capture=(self), encrypted-media=(), fullscreen=*, geolocation=(self), gyroscope=(), keyboard-map=(), magnetometer=(), microphone=(), midi=(), payment=*, picture-in-picture=(), publickey-credentials-get=(), screen-wake-lock=(), sync-xhr=(), usb=(), xr-spatial-tracking=(), gamepad=(), serial=(), accelerometer=(), autoplay=(), camera=(), cross-origin-isolated=(), display-capture=(self), encrypted-media=(), fullscreen=*, geolocation=(self), gyroscope=(), keyboard-map=(), magnetometer=(), microphone=(), midi=(), payment=*, picture-in-picture=(), publickey-credentials-get=(), screen-wake-lock=(), sync-xhr=(), usb=(), xr-spatial-tracking=(), gamepad=(), serial=()";s:15:"referrer-policy";s:64:"strict-origin-when-cross-origin, strict-origin-when-cross-origin";s:25:"strict-transport-security";s:34:"max-age=63072000, max-age=63072000";s:25:"x-content-security-policy";s:100:"default-src \'self\'; img-src *; media-src * data:;, default-src \'self\'; img-src *; media-src * data:;";s:22:"x-content-type-options";s:16:"nosniff, nosniff";s:15:"x-frame-options";s:22:"SAMEORIGIN, SAMEORIGIN";s:33:"x-permitted-cross-domain-policies";s:10:"none, none";s:15:"x-ua-compatible";s:7:"IE=edge";s:12:"x-robots-tag";s:7:"noindex";s:4:"link";s:56:"<https://oceanwp.org/wp-json/>; rel="https://api.w.org/"";s:13:"last-modified";s:29:"Mon, 12 Aug 2024 10:27:46 GMT";s:13:"cache-control";s:12:"max-age=3600";s:7:"expires";s:29:"Thu, 19 Sep 2024 05:19:02 GMT";s:4:"vary";s:15:"Accept-Encoding";s:15:"cf-cache-status";s:3:"HIT";s:3:"age";s:4:"1877";s:9:"report-to";s:237:"{"endpoints":[{"url":"https:\\/\\/a.nel.cloudflare.com\\/report\\/v4?s=emViW6EjjeFMPw2gBhh%2BEVxBqpryvildGvfwAPOW%2B8xVKveNdV1ZI%2Ft1%2F1q6SA0HVVTOxr4sXObFu3Ptx013zqVOzF1X0T5aH7DsvvMuhViwFpzdpxKfqvkZz9hv"}],"group":"cf-nel","max_age":604800}";s:3:"nel";s:60:"{"success_fraction":0,"report_to":"cf-nel","max_age":604800}";s:6:"server";s:10:"cloudflare";s:6:"cf-ray";s:20:"8b6150146e6e1680-MRS";s:16:"content-encoding";s:4:"gzip";s:7:"alt-svc";s:19:"h3=":443"; ma=86400";}}s:5:"build";s:14:"20211220193300";}','off');
INSERT INTO `wp_options` VALUES (1455,'_transient_timeout_feed_mod_c8dc84948ab55424f034a4ced348e013','1724188882','off');
INSERT INTO `wp_options` VALUES (1456,'_transient_feed_mod_c8dc84948ab55424f034a4ced348e013','1724145682','off');
INSERT INTO `wp_options` VALUES (1457,'_transient_timeout_owp_feed_data_2868312c075aa2ff722fc746e9d64fe4','1724188882','off');
INSERT INTO `wp_options` VALUES (1458,'_transient_owp_feed_data_2868312c075aa2ff722fc746e9d64fe4','<ul><li><a class=\'rsswidget\' href=\'https://oceanwp.org/blog/customize-wordpress-new-core-update/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>Customize WordPress in a Breeze: OceanWP 4.0.0 &amp; New Core Update</a><div class="rssSummary">Following the blockbuster hits that were the OceanWP Metabox Settings core update in 2023, as well as our epic WordPress features release in 2024, we’re back in the spotlight with...Read&hellip;</div></li><li><a class=\'rsswidget\' href=\'https://oceanwp.org/blog/wordpress-plugins-booking-appointment-website/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>14 Plugins to Consider when Creating a Booking or Appointment Booking Website</a><div class="rssSummary">Do you want customers to book your services through a WordPress site? Are you looking to add a user account functionality to your booking website? For this purpose, we have...Read&hellip;</div></li><li><a class=\'rsswidget\' href=\'https://oceanwp.org/blog/start-content-creation-revolution-new-wordpress-features/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>Start a 2024 Content Creation Revolution: New OceanWP WordPress Features</a><div class="rssSummary">Remember the Purchase Notifier or Popup Builder and other features we released at the end 2023 to supercharge your eCommerce game? Get ready to be wowed again! Spring has sprung...Read&hellip;</div></li><li><a class=\'rsswidget\' href=\'https://oceanwp.org/blog/wordpress-black-friday-deals-2023/?utm_source=wp-news-widget&utm_medium=wp-dash&utm_campaign=news-feed\' target=\'_blank\'>WordPress Black Friday Deals 2023</a><div class="rssSummary">Black Friday, the annual US shopping extravaganza which has become a global phenomenon, has extended its reach to the world of WordPress development and website management. For WordPress developers, freelancers,...Read&hellip;</div></li></ul>','off');
INSERT INTO `wp_options` VALUES (1459,'_transient_timeout_wpseo-statistics-totals','1724232085','off');
INSERT INTO `wp_options` VALUES (1460,'_transient_wpseo-statistics-totals','a:1:{i:1;a:2:{s:6:"scores";a:1:{i:0;a:4:{s:8:"seo_rank";s:2:"na";s:5:"label";s:45:"Articles <strong>sans</strong> requête cible";s:5:"count";i:1;s:4:"link";s:108:"http://ferme-de-chassagne.local/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=na";}}s:8:"division";a:5:{s:3:"bad";i:0;s:2:"ok";i:0;s:4:"good";i:0;s:2:"na";i:1;s:7:"noindex";i:0;}}}','off');
INSERT INTO `wp_options` VALUES (1461,'_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e','1724188886','off');
INSERT INTO `wp_options` VALUES (1462,'_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e','a:4:{s:9:"sandboxed";b:0;s:5:"error";N;s:8:"location";a:1:{s:2:"ip";b:0;}s:6:"events";a:0:{}}','off');
INSERT INTO `wp_options` VALUES (1463,'_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198','1724188886','off');
INSERT INTO `wp_options` VALUES (1464,'_transient_feed_0d2db5fea5a8633b56992c916819b198','a:4:{s:5:"child";a:1:{s:0:"";a:1:{s:3:"rss";a:1:{i:0;a:6:{s:4:"data";s:3:"\n\n\n";s:7:"attribs";a:1:{s:0:"";a:1:{s:7:"version";s:3:"2.0";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:1:{s:7:"channel";a:1:{i:0;a:6:{s:4:"data";s:52:"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:8:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"Actualités – WordPress.org Français";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:24:"https://fr.wordpress.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:0:"";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:13:"lastBuildDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 16 Jul 2024 17:40:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"language";a:1:{i:0;a:5:{s:4:"data";s:5:"fr-FR";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:9:"generator";a:1:{i:0;a:5:{s:4:"data";s:40:"https://wordpress.org/?v=6.7-alpha-58915";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"image";a:1:{i:0;a:6:{s:4:"data";s:11:"\n	\n	\n	\n	\n	\n";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:1:{s:0:"";a:5:{s:3:"url";a:1:{i:0;a:5:{s:4:"data";s:29:"https://s.w.org/favicon.ico?2";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:39:"Actualités – WordPress.org Français";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:24:"https://fr.wordpress.org";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:5:"width";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:6:"height";a:1:{i:0;a:5:{s:4:"data";s:2:"32";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}}}}s:4:"item";a:10:{i:0;a:6:{s:4:"data";s:57:"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";s:5:"child";a:4:{s:0:"";a:6:{s:5:"title";a:1:{i:0;a:5:{s:4:"data";s:28:"WordPress 6.6 « Dorsey »";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"link";a:1:{i:0;a:5:{s:4:"data";s:57:"https://fr.wordpress.org/2024/07/16/wordpress-6-6-dorsey/";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:7:"pubDate";a:1:{i:0;a:5:{s:4:"data";s:31:"Tue, 16 Jul 2024 17:40:31 +0000";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:8:"category";a:1:{i:0;a:5:{s:4:"data";s:31:"Nouvelles versions de WordPress";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:4:"guid";a:1:{i:0;a:5:{s:4:"data";s:32:"https://fr.wordpress.org/?p=3181";s:7:"attribs";a:1:{s:0:"";a:1:{s:11:"isPermaLink";s:5:"false";}}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}s:11:"description";a:1:{i:0;a:5:{s:4:"data";s:408:"Nous avons le plaisir de vous présenter WordPress&#160;6.6 «&#160;Dorsey&#160;», version nommée en l&#8217;honneur du légendaire leader de big band américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie. Écoutez la musique du Dorsey’s Big Band tandis que vous [&#8230;]";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:32:"http://purl.org/dc/elements/1.1/";a:1:{s:7:"creator";a:1:{i:0;a:5:{s:4:"data";s:9:"Jb Audras";s:7:"attribs";a:0:{}s:8:"xml_base";s:0:"";s:17:"xml_base_explicit";b:0;s:8:"xml_lang";s:0:"";}}}s:40:"http://purl.org/rss/1.0/modules/content/";a:1:{s:7:"encoded";a:1:{i:0;a:5:{s:4:"data";s:68929:"\n<figure class="wp-block-image size-large"><a href="https://fr.wordpress.org/files/2024/07/dorsey.png"><img fetchpriority="high" decoding="async" width="1024" height="680" src="https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png" alt="" class="wp-image-3199" srcset="https://fr.wordpress.org/files/2024/07/dorsey-1024x680.png 1024w, https://fr.wordpress.org/files/2024/07/dorsey-300x199.png 300w, https://fr.wordpress.org/files/2024/07/dorsey-768x510.png 768w, https://fr.wordpress.org/files/2024/07/dorsey-1536x1021.png 1536w, https://fr.wordpress.org/files/2024/07/dorsey-2048x1361.png 2048w" sizes="(max-width: 1024px) 100vw, 1024px" /></a></figure>\n\n\n\n<p>Nous avons le plaisir de vous présenter WordPress&nbsp;6.6 «&nbsp;Dorsey&nbsp;», version nommée en l&rsquo;honneur du légendaire <bdo lang="en" dir="ltr">leader</bdo> de <bdo lang="en" dir="ltr">big band</bdo> américain Tommy Dorsey. Reconnu pour son timbre de trombone et pour ses compositions, la musique de Dorsey envoûte son audience grâce à sa profondeur émotionnelle et son énergie.</p>\n\n\n\n<p>Écoutez la musique du <a href="https://open.spotify.com/playlist/37i9dQZF1DZ06evO2TT3Ge?si=d9872e46371c4ed7" target="_blank" rel="noreferrer noopener"><bdo lang="en" dir="ltr">Dorsey’s Big Band</bdo></a> tandis que vous découvrirez les nouvelles fonctionnalités et les améliorations de WordPress 6.6.</p>\n\n\n\n<h2 class="wp-block-heading">Bienvenue à 6.6&nbsp;!</h2>\n\n\n\n<p>WordPress 6.6 répond à la promesse d’un web meilleur en ajoutant de nouveaux outils pour améliorer le quotidien des créateurs de contenus, des sites les plus complexes aux sites «&nbsp;<bdo lang="en" dir="ltr">one page</bdo>&nbsp;». Sans jamais mettre de côté la sécurité, la stabilité ou les performances, WordPress 6.6 apporte de nouveaux outils et améliore les flux de rédaction déjà en place.</p>\n\n\n\n<p>Une nouvelle fonctionnalité de restauration pour les mises à jour automatiques des extensions vous offre quant à elle sécurité, flexibilité et sérénité.</p>\n\n\n\n<div class="wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex">\n<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="https://fr.wordpress.org/download/">Téléchargez WordPress 6.6 «&nbsp;Dorsey&nbsp;»</a></div>\n</div>\n\n\n\n<h3 class="wp-block-heading">Palettes de couleurs et ensembles de polices</h3>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-1 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:33.33%">\n<figure class="wp-block-image size-large"><img decoding="async" src="https://s.w.org/images/core/6.6/color-palettes.webp" alt="" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:66.66%">\n<p><strong>Ajout de davantage d’options de conception aux thèmes basés sur des blocs.</strong>&nbsp;Les auteur·ices de thèmes basés sur les blocs peuvent créer un nombre illimité de palettes de couleurs ou de polices personnalisées pour offrir des options graphiques plus spécifiques au sein du même thème. Ces palettes offrent des possibilités graphiques plus harmonisées, permettant une personnalisation sans modifier le style global du site, au-delà des paramètres de couleur ou de typographie.</p>\n</div>\n</div>\n\n\n\n<h3 class="wp-block-heading">Aperçu rapide des pages</h3>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-2 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:33.33%">\n<figure class="wp-block-image size-large"><img decoding="async" src="https://s.w.org/images/core/6.6/page-previews.webp" alt="" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:66.66%">\n<p><strong>Simplifiez votre flux de travail avec une nouvelle mise en page conçue pour les pages.</strong>&nbsp;Découvrez toutes vos pages et un aperçu de n’importe quelle page sélectionnée avant de la modifier via une nouvelle mise en page dans l’éditeur de site.</p>\n</div>\n</div>\n\n\n\n<h3 class="wp-block-heading">Retour en arrière pour les mises à jour automatiques d’extensions</h3>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-3 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:33.33%">\n<figure class="wp-block-image size-large"><img decoding="async" src="https://s.w.org/images/core/6.6/feature-rollbacks.webp" alt="" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:66.66%">\n<p><strong>Mettez à jour vos extensions en toute tranquillité.</strong>&nbsp;Bénéficiez de la facilité des mises à jour automatiques des extensions avec la possibilité de restauration en cas de problème, améliorant ainsi la sécurité de votre site tout en minimisant les risques d’indisponibilité potentielle de celui-ci.</p>\n</div>\n</div>\n\n\n\n<h3 class="wp-block-heading">Surcharges</h3>\n\n\n\n<div class="wp-block-columns is-layout-flex wp-container-core-columns-is-layout-4 wp-block-columns-is-layout-flex">\n<div class="wp-block-column is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:33.33%">\n<figure class="wp-block-image size-large"><img decoding="async" src="https://s.w.org/images/core/6.6/overrides.webp" alt="" /></figure>\n</div>\n\n\n\n<div class="wp-block-column is-vertically-aligned-center is-layout-flow wp-block-column-is-layout-flow" style="flex-basis:66.66%">\n<p><strong>Ajout de la possibilité de personnaliser les contenus dans les compositions synchronisées.</strong>&nbsp;Autoriser la personnalisation des éléments de contenu spécifiques dans chaque apparition d’une composition synchronisée tout en conservant un style uniformisé pour toutes les apparitions, simplifiant ainsi les futures mises à jour. Actuellement, vous pouvez définir des surcharges pour les blocs Titre, Paragraphe, Bouton et Image.</p>\n</div>\n</div>\n\n\n\n<h3 class="wp-block-heading">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.6 comprend des mises à jour importantes comme le retrait d&rsquo;appels redondants vers <code>WP_Theme_JSON</code>, la désactivation du chargement automatique pour les options les plus volumétriques, la suppression de dépendances inutiles, le chargement différé des contenus embarqués, la nouvelle directive <code>data-wp-on-async</code> et une réduction de 33 % du chargement des modèles dans l&rsquo;éditeur.</p>\n\n\n\n<h3 class="wp-block-heading">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 55 correctifs d’accessibilité et améliorations se concentrent sur des aspects fondamentaux de l’expérience WordPress, en particulier le composant de vue de données qui alimente la nouvelle expérience de modification de site et des domaines comme l’outil d’insertion qui fournit un moyen-clé d’interagir avec les blocs et les compositions.</p>\n\n\n\n<h3 class="wp-block-heading">Et bien plus encore</h3>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.6, vous pouvez consulter le site de démonstration des fonctionnalités.</p>\n\n\n\n<p><a href="https://fr.wordpress.org/download/releases/6-6/">Découvrez toutes les nouveautés</a></p>\n\n\n\n<h3 class="wp-block-heading">En savoir plus sur WordPress 6.6</h3>\n\n\n\n<p><a href="https://learn.wordpress.org/"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href="https://learn.wordpress.org/online-workshops/">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Explorez le&nbsp;<a href="https://fr.wordpress.org/2024/06/27/guide-des-changements-techniques-de-wordpress-6-6/">Guide des changements techniques de WordPress 6.6</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous aident à construire avec WordPress.</p>\n\n\n\n<p><a href="https://wordpress.org/support/wordpress-version/version-6-6/">Lisez les notes de version de WordPress 6.6</a>&nbsp;pour obtenir des informations sur l’install